/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.synctask.config;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SynctaskThreadPoolConfig {
    private static final Logger log = LoggerFactory.getLogger(SynctaskThreadPoolConfig.class);

    @Bean(value={"synctaskThreadPool"})
    public ExecutorService getSynctaskThreadPool() {
        int nThread = Runtime.getRuntime().availableProcessors() * 2 + 1;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("synctask-thread-%d").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("synctask error", e);
            }
        }).build();
        return Executors.newFixedThreadPool(nThread, threadFactory);
    }

    @Bean(value={"syncGroupMsgThreadPool"})
    public ExecutorService getSyncGroupMsgThreadPool() {
        int nThread = Runtime.getRuntime().availableProcessors() * 2 + 1;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("sync-group-msg-thread-%d").setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("sync group msg error", e);
            }
        }).build();
        return Executors.newFixedThreadPool(nThread, threadFactory);
    }
}

