/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.callback.service.impl;

import cn.kinyun.wework.sdk.api.CustomizedApi;
import cn.kinyun.wework.sdk.api.UserApi;
import cn.kinyun.wework.sdk.callback.agent.BaseAgentEvent;
import cn.kinyun.wework.sdk.callback.agent.event.Location;
import cn.kinyun.wework.sdk.callback.agent.event.TaskCardClick;
import cn.kinyun.wework.sdk.callback.agent.msg.ImageMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.LinkMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.LocationMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.TextMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.VideoMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.VoiceMsg;
import cn.kinyun.wework.sdk.callback.suite.contact.BatchJobResult;
import cn.kinyun.wework.sdk.callback.suite.contact.CreateParty;
import cn.kinyun.wework.sdk.callback.suite.contact.CreateUser;
import cn.kinyun.wework.sdk.callback.suite.contact.DeleteParty;
import cn.kinyun.wework.sdk.callback.suite.contact.DeleteUser;
import cn.kinyun.wework.sdk.callback.suite.contact.UpdateParty;
import cn.kinyun.wework.sdk.callback.suite.contact.UpdateTag;
import cn.kinyun.wework.sdk.callback.suite.contact.UpdateUser;
import cn.kinyun.wework.sdk.callback.suite.external.AddExternalContact;
import cn.kinyun.wework.sdk.callback.suite.external.AddHalfExternalContact;
import cn.kinyun.wework.sdk.callback.suite.external.CreateExternalChat;
import cn.kinyun.wework.sdk.callback.suite.external.CreateExternalTag;
import cn.kinyun.wework.sdk.callback.suite.external.DelExternalContact;
import cn.kinyun.wework.sdk.callback.suite.external.DelFollowUser;
import cn.kinyun.wework.sdk.callback.suite.external.DeleteExternalTag;
import cn.kinyun.wework.sdk.callback.suite.external.DismissExternalChat;
import cn.kinyun.wework.sdk.callback.suite.external.EditExternalContact;
import cn.kinyun.wework.sdk.callback.suite.external.MsgAuditApproved;
import cn.kinyun.wework.sdk.callback.suite.external.TransferFail;
import cn.kinyun.wework.sdk.callback.suite.external.UpdateExternalChat;
import cn.kinyun.wework.sdk.callback.suite.external.UpdateExternalTag;
import cn.kinyun.wework.sdk.entity.contact.user.UserInfo;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.kuaike.scrm.callback.service.SuiteEventService;
import com.kuaike.scrm.common.enums.WeworkCorpSyncStatus;
import com.kuaike.scrm.common.enums.WeworkUserSyncStatus;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.synctask.service.ContactSyncService;
import com.kuaike.scrm.token.service.SuiteTokenService;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class SuiteEventServiceImpl
implements SuiteEventService {
    private static final Logger log = LoggerFactory.getLogger(SuiteEventServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private UserApi userApi;
    @Autowired
    private CustomizedApi customizedApi;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private ContactSyncService contactSyncService;
    @Autowired
    private SuiteTokenService suiteTokenService;

    @Override
    public void onSubscribe(BaseAgentEvent event) {
        WeworkUser weworkUser;
        String accessToken;
        log.info("subscribe:{}", (Object)event);
        String authCorpId = event.getToUserName();
        String authUserId = event.getFromUserName();
        Long createTime = event.getCreateTime();
        Date authTime = new Date(createTime * 1000L);
        Date now = new Date();
        Long bizId = authCorpId.startsWith("wp") ? this.businessCustomerMapper.getExistIdByAuthCorpId(authCorpId) : this.businessCustomerMapper.getExistBizId(authCorpId);
        if (bizId == null) {
            log.warn("\u5546\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664. authCorpId:{}", (Object)authCorpId);
            return;
        }
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String corpId = biz.getCorpId();
        if (biz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
            log.warn("biz corpId is not synchronized. bizId={}, corpId={}, authCorpId={}, authUserId={}", new Object[]{bizId, corpId, authCorpId, authUserId});
        }
        String weworkUserId = null;
        if (authCorpId.startsWith("wp")) {
            accessToken = this.suiteTokenService.getSuiteAccessTokenByAuthCorpId(authCorpId);
            weworkUser = this.weworkUserMapper.getByAuthUserId(corpId, authUserId);
        } else {
            accessToken = this.suiteTokenService.getSuiteAccessToken(corpId);
            weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, authUserId);
            weworkUserId = authUserId;
            authUserId = this.customizedApi.getOpenUserId(accessToken, authUserId);
            if (weworkUser != null && !Objects.equals(authUserId, weworkUser.getAuthUserId())) {
                weworkUser.setAuthUserId(authUserId);
            }
        }
        if (weworkUser == null) {
            UserInfo userInfo;
            try {
                userInfo = this.userApi.get(accessToken, authUserId);
                log.info("fetch user info:{}", (Object)userInfo);
            }
            catch (WeworkException e) {
                log.error("{}, authCorpId:{}, authUserId:{}", new Object[]{e.getMessage(), authCorpId, authUserId});
                throw e;
            }
            catch (Exception e) {
                log.error("fetch user info failed, authCorpId:{}, authUserId:{}", new Object[]{authCorpId, authUserId, e});
                throw e;
            }
            weworkUser = this.newSuiteUser(bizId, corpId, userInfo, weworkUserId, authUserId);
            this.weworkUserMapper.insertSelective((Object)weworkUser);
        }
        weworkUser.setIsSuiteAuth(Integer.valueOf(1));
        weworkUser.setSuiteAuthTime(authTime);
        weworkUser.setIsDeleted(Integer.valueOf(0));
        weworkUser.setUpdateTime(now);
        log.info("wework user suite authed, authCorpId:{}, authUserId:{}", (Object)authCorpId, (Object)authUserId);
        this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
    }

    private WeworkUser newSuiteUser(Long bizId, String corpId, UserInfo userInfo, String weworkUserId, String authUserId) {
        WeworkUser record = new WeworkUser();
        record.setNum(this.idGen.getNum());
        record.setBizId(bizId);
        record.setCorpId(corpId);
        record.setAuthUserId(authUserId);
        record.setOpenUserId(authUserId);
        if (weworkUserId != null) {
            record.setWeworkUserId(userInfo.getUserId());
            record.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()));
        } else {
            record.setWeworkUserId(authUserId);
            record.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.ONLY_SUITE.getValue()));
        }
        record.setGender(Integer.valueOf(userInfo.getGender()));
        record.setStatus(Integer.valueOf(userInfo.getStatus()));
        record.setMainDepartment(userInfo.getMainDepartment());
        record.setIsSuiteAuth(Integer.valueOf(1));
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        record.setIsDeleted(Integer.valueOf(0));
        return record;
    }

    @Override
    public void onUnsubscribe(BaseAgentEvent event) {
        log.info("unsubscribe:{}", (Object)event);
        String authCorpId = event.getToUserName();
        String authUserId = event.getFromUserName();
        Long createTime = event.getCreateTime();
        Date deauthTime = new Date(createTime * 1000L);
        Date now = new Date();
        Long bizId = authCorpId.startsWith("wp") ? this.businessCustomerMapper.getExistIdByAuthCorpId(authCorpId) : this.businessCustomerMapper.getExistBizId(authCorpId);
        if (bizId == null) {
            log.warn("\u5546\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664. authCorpId:{}", (Object)authCorpId);
            return;
        }
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String corpId = biz.getCorpId();
        WeworkUser weworkUser = authCorpId.startsWith("wp") ? this.weworkUserMapper.getByAuthUserId(corpId, authUserId) : this.weworkUserMapper.queryWeworkUserInfo(corpId, authUserId);
        if (weworkUser == null) {
            log.info("wework_user not found, authCorpId:{}, authUserId:{}", (Object)authCorpId, (Object)authUserId);
            return;
        }
        weworkUser.setIsSuiteAuth(Integer.valueOf(0));
        weworkUser.setSuiteDeauthTime(deauthTime);
        weworkUser.setUpdateTime(now);
        this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
    }

    @Override
    public void onEnterAgent(BaseAgentEvent event) {
        log.info("enter_agent:{}", (Object)event);
    }

    @Override
    public void onLocation(Location event) {
        log.info("location:{}", (Object)event);
    }

    @Override
    public void onClick(BaseAgentEvent event) {
        log.info("click:{}", (Object)event);
    }

    @Override
    public void onView(BaseAgentEvent event) {
        log.info("view:{}", (Object)event);
    }

    @Override
    public void onTaskCardClick(TaskCardClick event) {
        log.info("taskcard_click:{}", (Object)event);
    }

    @Override
    public void recvText(TextMsg msg) {
        log.info("text:{}", (Object)msg);
    }

    @Override
    public void recvImage(ImageMsg msg) {
        log.info("image:{}", (Object)msg);
    }

    @Override
    public void recvVoice(VoiceMsg msg) {
        log.info("voice:{}", (Object)msg);
    }

    @Override
    public void recvVideo(VideoMsg msg) {
        log.info("video:{}", (Object)msg);
    }

    @Override
    public void recvLocation(LocationMsg msg) {
        log.info("location:{}", (Object)msg);
    }

    @Override
    public void recvLink(LinkMsg msg) {
        log.info("link:{}", (Object)msg);
    }

    @Override
    public void onCreateUser(CreateUser event) {
        log.info("create_user:{}", (Object)event);
        String authCorpId = event.getAuthCorpId();
        Long timestamp = event.getTimestamp();
        String authUserId = event.getUserId();
        this.updateSuiteUser(authCorpId, authUserId, timestamp);
    }

    @Override
    public void onUpdateUser(UpdateUser event) {
        log.info("update_user:{}", (Object)event);
        String authCorpId = event.getAuthCorpId();
        Long timestamp = event.getTimestamp();
        String authUserId = event.getUserId();
        this.updateSuiteUser(authCorpId, authUserId, timestamp);
    }

    private void updateSuiteUser(String authCorpId, String authUserId, Long timestamp) {
        UserInfo userInfo;
        WeworkUser weworkUser;
        String accessToken;
        Long bizId = authCorpId.startsWith("wp") ? this.businessCustomerMapper.getExistIdByAuthCorpId(authCorpId) : this.businessCustomerMapper.getExistBizId(authCorpId);
        if (bizId == null) {
            log.warn("\u5546\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664. authCorpId:{}", (Object)authCorpId);
            return;
        }
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        if (biz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
            log.warn("biz corpId is not synchronized, skip this step. bizId={}, authCorpId={}", (Object)bizId, (Object)authCorpId);
            return;
        }
        String corpId = biz.getCorpId();
        String weworkUserId = null;
        if (authCorpId.startsWith("wp")) {
            accessToken = this.suiteTokenService.getSuiteAccessTokenByAuthCorpId(authCorpId);
            weworkUser = this.weworkUserMapper.getByAuthUserId(corpId, authUserId);
        } else {
            accessToken = this.suiteTokenService.getSuiteAccessToken(corpId);
            weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, authUserId);
            weworkUserId = authUserId;
            authUserId = this.customizedApi.getOpenUserId(accessToken, authUserId);
            if (weworkUser != null && !Objects.equals(authUserId, weworkUser.getAuthUserId())) {
                weworkUser.setAuthUserId(authUserId);
            }
        }
        try {
            userInfo = this.userApi.get(accessToken, authUserId);
            log.info("fetch user info:{}", (Object)userInfo);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, weworkUserId:{}", new Object[]{e.getMessage(), authCorpId, authUserId});
            throw e;
        }
        catch (Exception e) {
            log.error("fetch user info failed, corpId:{}, weworkUserId:{}", new Object[]{authCorpId, authUserId, e});
            throw e;
        }
        Date authTime = new Date(timestamp * 1000L);
        if (weworkUser == null) {
            log.info("create suite wework_user. authCorpId:{}, authUserId:{}", (Object)authCorpId, (Object)authUserId);
            weworkUser = this.newSuiteUser(bizId, corpId, userInfo, weworkUserId, authUserId);
            weworkUser.setSuiteAuthTime(authTime);
            this.weworkUserMapper.insertSelective((Object)weworkUser);
        } else {
            log.warn("update suite wework_user. authCorpId:{}, authUserId:{}", (Object)authCorpId, (Object)authUserId);
            weworkUser.setGender(Integer.valueOf(userInfo.getGender()));
            weworkUser.setStatus(Integer.valueOf(userInfo.getStatus()));
            weworkUser.setMainDepartment(userInfo.getMainDepartment());
            weworkUser.setIsSuiteAuth(Integer.valueOf(1));
            weworkUser.setSuiteAuthTime(authTime);
            weworkUser.setUpdateTime(new Date());
            weworkUser.setIsDeleted(Integer.valueOf(0));
            this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
        }
    }

    @Override
    public void onDeleteUser(DeleteUser event) {
        log.info("delete_user:{}", (Object)event);
        String authCorpId = event.getAuthCorpId();
        Long timestamp = event.getTimestamp();
        String authUserId = event.getUserId();
        this.contactSyncService.deleteSuiteUser(authCorpId, authUserId, timestamp);
    }

    @Override
    public void onCreateParty(CreateParty event) {
        log.info("create_party:{}", (Object)event);
        String authCorpId = event.getAuthCorpId();
        Long timestamp = event.getTimestamp();
        this.contactSyncService.syncSuiteParty(authCorpId, timestamp);
    }

    @Override
    public void onUpdateParty(UpdateParty event) {
        log.info("update_party:{}", (Object)event);
        String authCorpId = event.getAuthCorpId();
        Long timestamp = event.getTimestamp();
        this.contactSyncService.syncSuiteParty(authCorpId, timestamp);
    }

    @Override
    public void onDeleteParty(DeleteParty event) {
        log.info("delete_party:{}", (Object)event);
        String authCorpId = event.getAuthCorpId();
        Long timestamp = event.getTimestamp();
        this.contactSyncService.syncSuiteParty(authCorpId, timestamp);
    }

    @Override
    public void onUpdateTag(UpdateTag event) {
        log.info("update_tag:{}", (Object)event);
    }

    @Override
    public void onBatchJobResult(BatchJobResult event) {
        log.info("batch_job_result:{}", (Object)event);
    }

    @Override
    public void onAddExternalContact(AddExternalContact event) {
        log.info("add_external_contact:{}", (Object)event);
    }

    @Override
    public void onAddHalfExternalContact(AddHalfExternalContact event) {
        log.info("add_half_external_contact:{}", (Object)event);
    }

    @Override
    public void onEditExternalContact(EditExternalContact event) {
        log.info("edit_external_contact:{}", (Object)event);
    }

    @Override
    public void onDelExternalContact(DelExternalContact event) {
        log.info("del_external_contact:{}", (Object)event);
    }

    @Override
    public void onDelFollowUser(DelFollowUser event) {
        log.info("del_follow_user:{}", (Object)event);
    }

    @Override
    public void onTransferFail(TransferFail event) {
        log.info("transfer_fail:{}", (Object)event);
    }

    @Override
    public void onCreateExternalChat(CreateExternalChat event) {
        log.info("create_external_chat:{}", (Object)event);
    }

    @Override
    public void onUpdateExternalChat(UpdateExternalChat event) {
        log.info("update_external_chat:{}", (Object)event);
    }

    @Override
    public void onDismissExternalChat(DismissExternalChat event) {
        log.info("dismiss_external_chat:{}", (Object)event);
    }

    @Override
    public void onCreateExternalTag(CreateExternalTag event) {
        log.info("create_external_tag:{}", (Object)event);
    }

    @Override
    public void onUpdateExternalTag(UpdateExternalTag event) {
        log.info("update_external_tag:{}", (Object)event);
    }

    @Override
    public void onDeleteExternalTag(DeleteExternalTag event) {
        log.info("delete_external_tag:{}", (Object)event);
    }

    @Override
    public void onMsgAuditApproved(MsgAuditApproved event) {
        log.info("msg_audit_approved:{}", (Object)event);
    }
}

