/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.callback.service.impl;

import cn.kinyun.wework.sdk.callback.agent.BaseAgentEvent;
import cn.kinyun.wework.sdk.callback.agent.event.Location;
import cn.kinyun.wework.sdk.callback.agent.event.TaskCardClick;
import cn.kinyun.wework.sdk.callback.agent.msg.ImageMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.LinkMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.LocationMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.TextMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.VideoMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.VoiceMsg;
import cn.kinyun.wework.sdk.callback.corp.contact.BatchJobResult;
import cn.kinyun.wework.sdk.callback.corp.contact.CreateParty;
import cn.kinyun.wework.sdk.callback.corp.contact.CreateUser;
import cn.kinyun.wework.sdk.callback.corp.contact.DeleteParty;
import cn.kinyun.wework.sdk.callback.corp.contact.DeleteUser;
import cn.kinyun.wework.sdk.callback.corp.contact.UpdateParty;
import cn.kinyun.wework.sdk.callback.corp.contact.UpdateTag;
import cn.kinyun.wework.sdk.callback.corp.contact.UpdateUser;
import cn.kinyun.wework.sdk.callback.corp.external.AddExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.AddHalfExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.CreateExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.CreateExternalTag;
import cn.kinyun.wework.sdk.callback.corp.external.DelExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.DelFollowUser;
import cn.kinyun.wework.sdk.callback.corp.external.DeleteExternalTag;
import cn.kinyun.wework.sdk.callback.corp.external.DismissExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.EditExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.MsgAuditApproved;
import cn.kinyun.wework.sdk.callback.corp.external.TransferFail;
import cn.kinyun.wework.sdk.callback.corp.external.UpdateExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.UpdateExternalTag;
import com.kuaike.scrm.callback.service.CustomizedEventService;
import com.kuaike.scrm.common.enums.WeworkCorpSyncStatus;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.synctask.service.ContactSyncService;
import com.kuaike.scrm.synctask.service.ExternalChatSyncService;
import com.kuaike.scrm.synctask.service.ExternalContactSyncService;
import com.kuaike.scrm.synctask.service.ExternalTagSyncService;
import com.kuaike.scrm.system.service.UserService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomizedEventServiceImpl
implements CustomizedEventService {
    private static final Logger log = LoggerFactory.getLogger(CustomizedEventServiceImpl.class);
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private ContactSyncService contactSyncService;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private ExternalContactSyncService externalContactSyncService;
    @Autowired
    private ExternalChatSyncService externalChatSyncService;
    @Autowired
    private ExternalTagSyncService externalTagSyncService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserMapper userMapper;

    @Override
    @Transactional
    public void onSubscribe(BaseAgentEvent event) {
        log.info("subscribe:{}", (Object)event);
        Integer agentId = event.getAgentId();
        String corpId = event.getToUserName();
        String weworkUserId = event.getFromUserName();
        Long createTime = event.getCreateTime();
        Date authTime = new Date(createTime * 1000L);
        Date now = new Date();
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("\u5546\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664. corpId:{}, userId:{}", (Object)corpId, (Object)weworkUserId);
            return;
        }
        BusinessCustomer biz = this.businessCustomerMapper.getByCorpId(corpId);
        if (biz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
            log.warn("biz corpId is not synchronized, skip this step. bizId={}, corpId={}, weworkUserId={}", new Object[]{bizId, corpId, weworkUserId});
            return;
        }
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        this.contactSyncService.subscribe(bizId, corpId, weworkUserId, accessToken);
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        weworkUser.setIsAgentAuth(Integer.valueOf(1));
        weworkUser.setAgentAuthTime(authTime);
        weworkUser.setIsDeleted(Integer.valueOf(0));
        weworkUser.setUpdateTime(now);
        this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
        User user = this.userMapper.getByWeworkUserIdAndCorpId(weworkUser.getWeworkUserId(), corpId);
        if (user == null) {
            log.info("createWeworkUser: \u6210\u5458\u8f6c\u5316\u4e3a\u7528\u6237\uff0ccorpId:{}, weworkUser:{}", (Object)corpId, (Object)weworkUser);
            this.userService.insertUser(weworkUser, false);
        }
    }

    @Override
    public void onUnsubscribe(BaseAgentEvent event) {
        log.info("unsubscribe:{}", (Object)event);
        String corpId = event.getToUserName();
        String weworkUserId = event.getFromUserName();
        Long createTime = event.getCreateTime();
        Date deauthTime = new Date(createTime * 1000L);
        Date now = new Date();
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        if (weworkUser == null) {
            log.info("wework_user not found, corpId:{}, userId:{}", (Object)corpId, (Object)weworkUserId);
            return;
        }
        weworkUser.setIsAgentAuth(Integer.valueOf(0));
        weworkUser.setAgentDeauthTime(deauthTime);
        weworkUser.setUpdateTime(now);
        this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
    }

    @Override
    public void onEnterAgent(BaseAgentEvent event) {
        log.info("enter_agent:{}", (Object)event);
    }

    @Override
    public void onLocation(Location event) {
        log.info("location:{}", (Object)event);
    }

    @Override
    public void onClick(BaseAgentEvent event) {
        log.info("click:{}", (Object)event);
    }

    @Override
    public void onView(BaseAgentEvent event) {
        log.info("view:{}", (Object)event);
    }

    @Override
    public void onTaskCardClick(TaskCardClick event) {
        log.info("taskcard_click:{}", (Object)event);
    }

    @Override
    public void recvText(TextMsg msg) {
    }

    @Override
    public void recvImage(ImageMsg msg) {
    }

    @Override
    public void recvVoice(VoiceMsg msg) {
    }

    @Override
    public void recvVideo(VideoMsg msg) {
    }

    @Override
    public void recvLocation(LocationMsg msg) {
    }

    @Override
    public void recvLink(LinkMsg msg) {
    }

    @Override
    public void onCreateUser(CreateUser event) {
        log.info("create_user:{}", (Object)event);
        String corpId = event.getToUserName();
        Long timestamp = event.getCreateTime();
        Date authTime = new Date(timestamp * 1000L);
        String weworkUserId = event.getUserId();
        this.contactSyncService.updateUser(corpId, weworkUserId, timestamp);
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        weworkUser.setIsAgentAuth(Integer.valueOf(1));
        weworkUser.setAgentAuthTime(authTime);
        weworkUser.setIsDeleted(Integer.valueOf(0));
        weworkUser.setUpdateTime(new Date());
        this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
        User user = this.userMapper.getByWeworkUserIdAndCorpId(weworkUser.getWeworkUserId(), corpId);
        if (user == null) {
            log.info("createWeworkUser: \u6210\u5458\u8f6c\u5316\u4e3a\u7528\u6237\uff0ccorpId:{}, weworkUser:{}", (Object)corpId, (Object)weworkUser);
            this.userService.insertUser(weworkUser, false);
        }
    }

    @Override
    public void onUpdateUser(UpdateUser event) {
        log.info("update_user:{}", (Object)event);
        String corpId = event.getToUserName();
        Long timestamp = event.getCreateTime();
        String weworkUserId = event.getUserId();
        String newWeworkUserId = event.getNewUserID();
        if (StringUtils.isNotBlank((CharSequence)newWeworkUserId)) {
            this.contactSyncService.updateUserId(corpId, weworkUserId, newWeworkUserId, timestamp);
            weworkUserId = newWeworkUserId;
        }
        this.contactSyncService.updateUser(corpId, weworkUserId, timestamp);
    }

    @Override
    public void onDeleteUser(DeleteUser event) {
        log.info("delete_user:{}", (Object)event);
        String corpId = event.getToUserName();
        Long timestamp = event.getCreateTime();
        String weworkUserId = event.getUserId();
        this.contactSyncService.deleteUser(corpId, weworkUserId, timestamp);
    }

    @Override
    public void onCreateParty(CreateParty event) {
        log.info("create_party:{}", (Object)event);
        String corpId = event.getToUserName();
        Long timestamp = event.getCreateTime();
        Integer id = event.getId();
        String name = event.getName();
        Integer parentId = event.getParentId();
        Integer order = event.getOrder();
        this.contactSyncService.createParty(corpId, id, name, parentId, order, timestamp);
    }

    @Override
    public void onUpdateParty(UpdateParty event) {
        log.info("update_party:{}", (Object)event);
        String corpId = event.getToUserName();
        Long timestamp = event.getCreateTime();
        Integer id = event.getId();
        String name = event.getName();
        Integer parentId = event.getParentId();
        this.contactSyncService.updateParty(corpId, id, name, parentId, timestamp);
    }

    @Override
    public void onDeleteParty(DeleteParty event) {
        log.info("delete_party:{}", (Object)event);
        String corpId = event.getToUserName();
        Long timestamp = event.getCreateTime();
        Integer id = event.getId();
        this.contactSyncService.deleteParty(corpId, id, timestamp);
    }

    @Override
    public void onUpdateTag(UpdateTag event) {
        log.info("update_tag:{}", (Object)event);
    }

    @Override
    public void onBatchJobResult(BatchJobResult event) {
        log.info("batch_job_result:{}", (Object)event);
    }

    @Override
    public void onAddExternalContact(AddExternalContact event) {
        log.info("add_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalContactSyncService.modifyExternalContact(accessToken, corpId, userId, externalUserId, timestamp, true);
    }

    @Override
    public void onAddHalfExternalContact(AddHalfExternalContact event) {
        log.info("add_half_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalContactSyncService.modifyExternalContact(accessToken, corpId, userId, externalUserId, timestamp, true);
    }

    @Override
    public void onEditExternalContact(EditExternalContact event) {
        log.info("edit_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalContactSyncService.modifyExternalContact(accessToken, corpId, userId, externalUserId, timestamp, false);
    }

    @Override
    public void onDelExternalContact(DelExternalContact event) {
        log.info("del_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        this.externalContactSyncService.delExternalContact(corpId, userId, externalUserId, timestamp);
    }

    @Override
    public void onDelFollowUser(DelFollowUser event) {
        log.info("del_follow_user:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        this.externalContactSyncService.delFollowUser(corpId, userId, externalUserId, timestamp);
    }

    @Override
    public void onTransferFail(TransferFail event) {
        log.info("transfer_fail:{}", (Object)event);
    }

    @Override
    public void onCreateExternalChat(CreateExternalChat event) {
        log.info("create_external_chat:{}", (Object)event);
        String corpId = event.getToUserName();
        String chatId = event.getChatId();
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalChatSyncService.create(accessToken, corpId, chatId);
    }

    @Override
    public void onUpdateExternalChat(UpdateExternalChat event) {
        log.info("update_external_chat:{}", (Object)event);
        String corpId = event.getToUserName();
        String chatId = event.getChatId();
        Integer quitScene = event.getQuitScene();
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalChatSyncService.modify(accessToken, corpId, chatId, quitScene);
    }

    @Override
    public void onDismissExternalChat(DismissExternalChat event) {
        log.info("dismiss_external_chat:{}", (Object)event);
        String corpId = event.getToUserName();
        String chatId = event.getChatId();
        this.externalChatSyncService.dismiss(corpId, chatId);
    }

    @Override
    public void onCreateExternalTag(CreateExternalTag event) {
        log.info("create_external_tag:{}", (Object)event);
        String corpId = event.getToUserName();
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        this.externalTagSyncService.modify(accessToken, corpId, event.getChangeType(), event.getTagType(), event.getId(), event.getCreateTime());
    }

    @Override
    public void onUpdateExternalTag(UpdateExternalTag event) {
        log.info("update_external_tag:{}", (Object)event);
        String corpId = event.getToUserName();
        String accessToken = this.customizedTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalTagSyncService.modify(accessToken, corpId, event.getChangeType(), event.getTagType(), event.getId(), event.getCreateTime());
    }

    @Override
    public void onDeleteExternalTag(DeleteExternalTag event) {
        log.info("delete_external_tag:{}", (Object)event);
        this.externalTagSyncService.delete(event.getToUserName(), event.getTagType(), event.getId(), event.getCreateTime());
    }

    @Override
    public void onMsgAuditApproved(MsgAuditApproved event) {
        log.info("msg_audit_approved:{}", (Object)event);
    }
}

