/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.callback.service.impl;

import cn.kinyun.wework.sdk.api.CustomizedApi;
import cn.kinyun.wework.sdk.api.SuiteApi;
import cn.kinyun.wework.sdk.callback.suite.auth.CancelAuth;
import cn.kinyun.wework.sdk.callback.suite.auth.ChangeAuth;
import cn.kinyun.wework.sdk.callback.suite.auth.CreateAuth;
import cn.kinyun.wework.sdk.callback.suite.auth.ResetPermanentCode;
import cn.kinyun.wework.sdk.entity.custmized.OpenUserId;
import cn.kinyun.wework.sdk.entity.custmized.OpenUserIds;
import cn.kinyun.wework.sdk.entity.suite.Agent;
import cn.kinyun.wework.sdk.entity.suite.AuthAgentInfo;
import cn.kinyun.wework.sdk.entity.suite.AuthCorpInfo;
import cn.kinyun.wework.sdk.entity.suite.AuthUserInfo;
import cn.kinyun.wework.sdk.entity.suite.PermanentCode;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.DateUtil;
import com.kuaike.scrm.callback.service.CustomizedAuthService;
import com.kuaike.scrm.callback.service.SuiteAuthService;
import com.kuaike.scrm.common.enums.BizChannel;
import com.kuaike.scrm.common.enums.WeworkCorpSyncStatus;
import com.kuaike.scrm.common.enums.WeworkUserSyncStatus;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.accessToken.entity.CorpCustomizedToken;
import com.kuaike.scrm.dal.accessToken.entity.CorpSuiteToken;
import com.kuaike.scrm.dal.accessToken.mapper.CorpCustomizedTokenMapper;
import com.kuaike.scrm.dal.accessToken.mapper.CorpSuiteTokenMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.dto.WeworkOpenUserId;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkTagGroupMapper;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkTagMapper;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.system.service.UserService;
import com.kuaike.scrm.token.service.ProviderTokenService;
import com.kuaike.scrm.token.service.SuiteTokenService;
import com.kuaike.scrm.token.utils.TokenGen;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomizedAuthServiceImpl
implements CustomizedAuthService {
    private static final Logger log = LoggerFactory.getLogger(CustomizedAuthServiceImpl.class);
    @Value(value="${biz.expire.days:5}")
    private int bizExpireDays;
    @Value(value="${scrm.biz.numCount}")
    private Integer numCount;
    @Value(value="${qyapi.suite.id}")
    private String suiteId;
    @Value(value="${qyapi.customized.id}")
    private String customizedId;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private IdGen idGen;
    @Autowired
    private ProviderTokenService providerTokenService;
    @Autowired
    private SuiteApi suiteApi;
    @Autowired
    private CustomizedApi customizedApi;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private CorpCustomizedTokenMapper corpCustomizedTokenMapper;
    @Autowired
    private CorpSuiteTokenMapper corpSuiteTokenMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private WeworkTagGroupMapper weworkTagGroupMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private SuiteTokenService suiteTokenService;
    @Autowired
    private SuiteAuthService suiteAuthService;
    @Autowired
    private SyncTaskService syncTaskService;

    @Override
    @Deprecated
    public Integer getAuthStatus() {
        Long bizId = LoginUtils.getCurrentUserBizId();
        String corpId = LoginUtils.getCurrentUserCorpId();
        log.info("get auth status, bizId={}, corpId={}", (Object)bizId, (Object)corpId);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        BusinessCustomer biz = this.businessCustomerMapper.selectByCorpId(corpId);
        if (biz == null) {
            String id = (String)this.redisTemplate.opsForValue().get((Object)this.getKey(bizId));
            log.warn("auth biz id not found, bizId={}, corpId={}, existBizId={}", new Object[]{bizId, corpId, id});
            if (StringUtils.isNotBlank((CharSequence)id)) {
                Long existBizId;
                bizId = existBizId = Long.valueOf(Long.parseLong(id));
            }
            return 999;
        }
        if (biz.getAuthCorpId().startsWith("CORP")) {
            log.warn("auth biz id not found, bizId={}, corpId={}, currentUserInfo={}", new Object[]{bizId, corpId, LoginUtils.getCurrentUser()});
            return 999;
        }
        Integer devStatus = this.corpCustomizedTokenMapper.getDevStatusByBizId(bizId, this.customizedId);
        if (devStatus != null) {
            return devStatus;
        }
        return -1;
    }

    @Override
    public Integer getAuthStatus(String key) {
        log.info("get auth status, key={}", (Object)key);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)key), (Object)"key is null");
        Integer devStatus = this.corpCustomizedTokenMapper.getDevStatusByState(key, this.customizedId);
        if (devStatus != null) {
            return devStatus;
        }
        return -1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createAuth(CreateAuth event) {
        String openCorpId;
        log.info("createAuth:{}", (Object)event);
        String customizedId = event.getSuiteId();
        String suiteAccessToken = this.providerTokenService.getSuiteAccessToken(customizedId);
        if (suiteAccessToken == null) {
            log.warn("\u65e0\u6cd5\u83b7\u53d6\u4ee3\u5f00\u53d1\u5e94\u7528\u7684accessToken");
            return;
        }
        PermanentCode permanentCode = this.suiteApi.getPermanentCode(suiteAccessToken, event.getAuthCode());
        log.info("permanentCode:{}", (Object)permanentCode);
        Date authTime = new Date(event.getTimestamp() * 1000L);
        AuthCorpInfo corpInfo = permanentCode.getAuthCorpInfo();
        String corpId = corpInfo.getCorpId();
        if (corpId.startsWith("wp")) {
            openCorpId = corpId;
        } else {
            String providerAccessToken = this.providerTokenService.getProviderToken();
            openCorpId = this.customizedApi.getOpenCorpId(providerAccessToken, corpId);
        }
        Long bizId = this.matchCorpId(permanentCode, corpId, openCorpId, authTime);
        this.updateCorp(bizId, corpId, authTime, permanentCode);
        this.updateAdminUser(bizId, corpId, authTime, permanentCode);
        this.createCorpCustomizedToken(bizId, customizedId, permanentCode, event.getState(), authTime);
    }

    private void updateCorp(Long bizId, String corpId, Date authTime, PermanentCode permanentCode) {
        AuthCorpInfo corpInfo = permanentCode.getAuthCorpInfo();
        AuthUserInfo userInfo = permanentCode.getAuthUserInfo();
        WeworkCorp corp = this.weworkCorpMapper.getByCorpId(corpId);
        corp.setCorpName(corpInfo.getCorpName());
        corp.setCorpFullName(corpInfo.getCorpFullName());
        corp.setCorpType(corpInfo.getCorpType());
        corp.setCorpSquareLogoUrl(corpInfo.getCorpSquareLogoUrl());
        corp.setCorpUserMax(corpInfo.getCorpUserMax());
        corp.setCorpAgentMax(corpInfo.getCorpAgentMax());
        if (corpInfo.getVerifiedEndTime() != null) {
            corp.setVerifiedEndTime(new Date(corpInfo.getVerifiedEndTime()));
        }
        corp.setSubjectType(corpInfo.getSubjectType());
        corp.setCorpWxqrcode(corpInfo.getCorpWxqrcode());
        corp.setCorpScale(corpInfo.getCorpScale());
        corp.setCorpIndustry(corpInfo.getCorpIndustry());
        corp.setCorpSubIndustry(corpInfo.getCorpSubIndustry());
        corp.setLocation(corpInfo.getLocation());
        corp.setIsAuth(Integer.valueOf(1));
        corp.setAuthTime(authTime);
        corp.setUpdateTime(new Date());
        this.weworkCorpMapper.updateByPrimaryKeySelective((Object)corp);
        String name = corpInfo.getCorpFullName();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = corpInfo.getCorpName();
        }
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        biz.setName(name);
        biz.setApplyWeworkUserId(userInfo.getOpenUserId());
        biz.setUpdateTime(new Date());
        this.businessCustomerMapper.updateByPrimaryKeySelective((Object)biz);
    }

    private void updateAdminUser(Long bizId, String corpId, Date authTime, PermanentCode permanentCode) {
        Date now = new Date();
        AuthUserInfo userInfo = permanentCode.getAuthUserInfo();
        String weworkUserId = userInfo.getUserId();
        String openUserId = userInfo.getOpenUserId();
        log.info("create wework user, corpId:{}, weworkUserId:{}, openUserId:{}", new Object[]{corpId, weworkUserId, openUserId});
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        boolean create = false;
        String num = this.idGen.getNum();
        if (weworkUser == null) {
            weworkUser = new WeworkUser();
            weworkUser.setNum(num);
            weworkUser.setBizId(bizId);
            weworkUser.setCorpId(corpId);
            weworkUser.setStatus(Integer.valueOf(1));
            weworkUser.setCreateTime(now);
            create = true;
        }
        weworkUser.setWeworkUserId(weworkUserId);
        weworkUser.setAuthUserId(openUserId);
        weworkUser.setOpenUserId(openUserId);
        weworkUser.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()));
        weworkUser.setName(userInfo.getName());
        weworkUser.setAvatar(userInfo.getAvatar());
        weworkUser.setIsSuiteAuth(Integer.valueOf(1));
        weworkUser.setSuiteAuthTime(authTime);
        weworkUser.setIsAgentAuth(Integer.valueOf(1));
        weworkUser.setAgentAuthTime(authTime);
        weworkUser.setUpdateTime(now);
        if (create) {
            log.info("save wework_user, corpId:{}, weworkUser:{}", (Object)corpId, (Object)weworkUser);
            this.weworkUserMapper.insertSelective((Object)weworkUser);
        } else {
            log.info("update wework_user, corpId:{}, weworkUser:{}", (Object)corpId, (Object)weworkUser);
            this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
        }
        User authUser = this.userMapper.selectUserByWeworkUserIdAndCorpId(openUserId, corpId);
        if (authUser != null) {
            try {
                log.info("\u91cd\u65b0\u914d\u7f6e\u7ba1\u7406\u5458\u7684wework_user_id, corpId:{}, weworkUserId:{}, openUserId:{}", new Object[]{corpId, weworkUserId, openUserId});
                authUser.setWeworkUserId(weworkUserId);
                authUser.setIdentifier(weworkUserId);
                authUser.setAvatar(userInfo.getAvatar());
                authUser.setName(userInfo.getName());
                authUser.setIsDeleted(Integer.valueOf(0));
                authUser.setUpdateTime(new Date());
                this.userMapper.updateByPrimaryKeySelective((Object)authUser);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u91cd\u65b0\u914d\u7f6e\u7ba1\u7406\u5458\u5931\u8d25, corpId:{}, weworkUserId:{}, openUserId:{}", new Object[]{corpId, weworkUserId, openUserId, e});
            }
        } else {
            User user = this.userMapper.getByWeworkUserIdAndCorpId(weworkUser.getWeworkUserId(), corpId);
            if (user == null) {
                log.info("createWeworkUser: \u6210\u5458\u8f6c\u5316\u4e3a\u7528\u6237\uff0cbizId:{}, weworkUser:{}", (Object)bizId, (Object)weworkUser);
                this.userService.insertUser(weworkUser, false);
            }
        }
    }

    private Long matchCorpId(PermanentCode permanentCode, String corpId, String openCorpId, Date authTime) {
        BusinessCustomer biz;
        BusinessCustomer existBiz = this.businessCustomerMapper.getByCorpId(corpId);
        BusinessCustomer authBiz = this.businessCustomerMapper.getByAuthCorpId(openCorpId);
        if (authBiz == null) {
            if (existBiz == null) {
                log.info("\u53d1\u73b0\u4f01\u4e1a\u672a\u6388\u6743\u7b2c\u4e09\u65b9\u5e94\u7528\uff0c\u76f4\u63a5\u626b\u7801\u6388\u6743\u4ee3\u5f00\u53d1\u3002corpId={}, authCorpId={}", (Object)corpId, (Object)openCorpId);
                biz = this.createNewBiz(openCorpId, permanentCode, authTime);
            } else {
                log.info("\u53d1\u73b0\u4f01\u4e1a\u53d6\u6d88\u6388\u6743\u7b2c\u4e09\u65b9\u5e94\u7528\u540e\uff0c\u76f4\u63a5\u626b\u7801\u6388\u6743\u4ee3\u5f00\u53d1\u3002corpId={}, authCorpId={}", (Object)corpId, (Object)openCorpId);
                biz = existBiz;
                this.resetExistBizAuthCorpId(existBiz, openCorpId);
            }
        } else if (existBiz == null) {
            biz = authBiz;
            if (!Objects.equals(authBiz.getCorpId(), corpId)) {
                log.info("\u53d1\u73b0\u4f01\u4e1a\u9996\u6b21\u6388\u6743\u7b2c\u4e09\u65b9\u548c\u4ee3\u5f00\u53d1\u3002corpId={}, authCorpId={}", (Object)corpId, (Object)openCorpId);
                this.resetAuthBizCorpId(authBiz, corpId);
            } else {
                log.info("\u4f01\u4e1acorpId\u5df2\u7ecf\u6253\u901a\uff0c\u65e0\u9700\u66f4\u65b0\u3002corpId={}", (Object)corpId);
            }
        } else {
            biz = existBiz;
            if (!Objects.equals(authBiz.getId(), existBiz.getId())) {
                log.info("\u53d1\u73b0\u4e00\u65b0\u4e00\u65e7\u4e24\u4e2a\u5546\u6237\u6570\u636e\uff0c\u9700\u8981\u6267\u884c\u5408\u5e76\u3002");
                this.mergeExistBiz(authBiz, existBiz);
            } else {
                log.info("\u4f01\u4e1acorpId\u5df2\u7ecf\u6253\u901a\uff0c\u65e0\u9700\u66f4\u65b0\u3002corpId={}", (Object)corpId);
            }
        }
        Long bizId = biz.getId();
        if (biz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
            this.suiteAuthService.initBiz(bizId);
            this.businessCustomerMapper.updateSyncStatus(bizId, Integer.valueOf(WeworkCorpSyncStatus.MATCH_CORP_ID.getValue()));
        }
        return bizId;
    }

    private BusinessCustomer createNewBiz(String openCorpId, PermanentCode permanentCode, Date authTime) {
        AuthCorpInfo corpInfo = permanentCode.getAuthCorpInfo();
        String corpId = corpInfo.getCorpId();
        log.warn("biz not found, corpId={}, openCorpId={}", (Object)corpId, (Object)openCorpId);
        BusinessCustomer biz = this.createBizId(permanentCode, openCorpId, BizChannel.HOME_PAGE);
        this.createWeworkCorp(biz, permanentCode.getAuthCorpInfo(), authTime);
        this.createWeworkUser(biz, permanentCode, authTime);
        this.createCorpSuiteToken(biz, this.suiteId);
        return biz;
    }

    private void resetExistBizAuthCorpId(BusinessCustomer existBiz, String openCorpId) {
        Long bizId = existBiz.getId();
        String corpId = existBiz.getCorpId();
        log.info("reset authCorpId, bizId={}, authCorpId={}, corpId={}", new Object[]{bizId, openCorpId, corpId});
        this.corpSuiteTokenMapper.updateAuthCorpIdByCorpId(bizId, openCorpId, corpId);
        this.weworkCorpMapper.updateAuthCorpIdByCorpId(bizId, openCorpId, corpId);
        this.businessCustomerMapper.updateAuthCorpIdByCorpId(bizId, openCorpId, corpId);
        existBiz.setAuthCorpId(openCorpId);
    }

    private void resetAuthBizCorpId(BusinessCustomer authBiz, String corpId) {
        Long bizId = authBiz.getId();
        String authCorpId = authBiz.getAuthCorpId();
        log.info("reset corpId, bizId={}, authCorpId={}, corpId={}", new Object[]{bizId, authCorpId, corpId});
        this.businessCustomerMapper.updateCorpIdByAuthCorpId(bizId, authCorpId, corpId);
        this.corpSuiteTokenMapper.updateCorpIdByAuthCorpId(bizId, authCorpId, corpId);
        this.weworkCorpMapper.updateCorpIdByAuthCorpId(bizId, authCorpId, corpId);
        this.weworkUserMapper.updateCorpIdByAuthCorpId(bizId, authCorpId, corpId);
        this.userMapper.updateCorpIdByAuthCorpId(bizId, authCorpId, corpId);
        authBiz.setCorpId(corpId);
    }

    private void mergeExistBiz(BusinessCustomer authBiz, BusinessCustomer existBiz) {
        String corpId = existBiz.getCorpId();
        String authCorpId = authBiz.getAuthCorpId();
        log.info("reset authCorpId, bizId={}, authCorpId={}, corpId={}", new Object[]{existBiz.getId(), authCorpId, corpId});
        this.mergeCorpSuiteToken(existBiz, authBiz);
        this.mergeWeworkUser(existBiz, authBiz);
        this.mergeWeworkCorp(existBiz, authBiz);
        this.mergeBiz(existBiz, authBiz);
    }

    private String getKey(Long bizId) {
        return String.format("%s:dkf_merge:%d", this.redisKeyPrefix, bizId);
    }

    private void mergeBiz(BusinessCustomer existBiz, BusinessCustomer authBiz) {
        log.info("merge biz, existBiz={}, authBiz={}", (Object)existBiz.getCorpId(), (Object)authBiz.getCorpId());
        existBiz.setAuthCorpId(authBiz.getAuthCorpId());
        existBiz.setName(authBiz.getName());
        existBiz.setApplyWeworkUserId(authBiz.getApplyWeworkUserId());
        existBiz.setUpdateTime(authBiz.getUpdateTime());
        this.businessCustomerMapper.updateAuthCorpIdByCorpId(authBiz.getId(), authBiz.getCorpId(), authBiz.getCorpId());
        this.businessCustomerMapper.updateByPrimaryKeySelective((Object)existBiz);
        String key = this.getKey(authBiz.getId());
        this.redisTemplate.opsForValue().set((Object)key, (Object)(existBiz.getId() + ""), Duration.ofSeconds(600L));
    }

    private void mergeWeworkCorp(BusinessCustomer existBiz, BusinessCustomer authBiz) {
        log.info("merge wework_corp, existBiz={}, authBiz={}", (Object)existBiz.getCorpId(), (Object)authBiz.getCorpId());
        WeworkCorp existCorp = this.weworkCorpMapper.getByBizId(existBiz.getId());
        WeworkCorp authCorp = this.weworkCorpMapper.getByBizId(authBiz.getId());
        existCorp.setAuthCorpId(authBiz.getAuthCorpId());
        existCorp.setIsAuth(authCorp.getIsAuth());
        existCorp.setAuthTime(authCorp.getAuthTime());
        existCorp.setCorpName(authCorp.getCorpName());
        existCorp.setCorpFullName(authCorp.getCorpFullName());
        existCorp.setCorpType(authCorp.getCorpType());
        existCorp.setCorpSquareLogoUrl(authCorp.getCorpSquareLogoUrl());
        existCorp.setCorpUserMax(authCorp.getCorpUserMax());
        existCorp.setCorpAgentMax(authCorp.getCorpAgentMax());
        if (authCorp.getVerifiedEndTime() != null) {
            existCorp.setVerifiedEndTime(authCorp.getVerifiedEndTime());
        }
        existCorp.setSubjectType(authCorp.getSubjectType());
        existCorp.setCorpWxqrcode(authCorp.getCorpWxqrcode());
        existCorp.setCorpScale(authCorp.getCorpScale());
        existCorp.setCorpIndustry(authCorp.getCorpIndustry());
        existCorp.setCorpSubIndustry(authCorp.getCorpSubIndustry());
        existCorp.setLocation(authCorp.getLocation());
        existCorp.setUpdateTime(authCorp.getUpdateTime());
        existCorp.setIsDeleted(Integer.valueOf(0));
        this.weworkCorpMapper.updateAuthCorpIdByCorpId(authBiz.getId(), authBiz.getCorpId(), authBiz.getCorpId());
        this.weworkCorpMapper.updateByPrimaryKeySelective((Object)existCorp);
    }

    private void mergeCorpSuiteToken(BusinessCustomer existBiz, BusinessCustomer authBiz) {
        log.info("merge corp_suite_token, existBiz={}, authBiz={}", (Object)existBiz.getCorpId(), (Object)authBiz.getCorpId());
        CorpSuiteToken exist = this.corpSuiteTokenMapper.getByBizId(existBiz.getId());
        CorpSuiteToken auth = this.corpSuiteTokenMapper.getByBizId(authBiz.getId());
        exist.setAuthCorpId(auth.getAuthCorpId());
        exist.setAgentId(auth.getAgentId());
        exist.setPermanentCode(auth.getPermanentCode());
        exist.setAccessToken(auth.getAccessToken());
        exist.setExpireTime(auth.getExpireTime());
        exist.setUpdateTime(auth.getUpdateTime());
        this.corpSuiteTokenMapper.updateAuthCorpIdByCorpId(authBiz.getId(), authBiz.getCorpId(), authBiz.getCorpId());
        this.corpSuiteTokenMapper.updateByPrimaryKeySelective((Object)exist);
    }

    private void mergeWeworkUser(BusinessCustomer existBiz, BusinessCustomer authBiz) {
        log.info("merge wework user, existBiz={}, authBiz={}", (Object)existBiz.getCorpId(), (Object)authBiz.getCorpId());
        Long bizId = existBiz.getId();
        String corpId = existBiz.getCorpId();
        String applyUserId = authBiz.getApplyWeworkUserId();
        this.syncOpenUserId(existBiz);
        this.appendSuiteUser(existBiz, authBiz);
        this.createAdmin(bizId, corpId, applyUserId);
    }

    private void syncOpenUserId(BusinessCustomer biz) {
        String applyWeworkUserId;
        OpenUserIds result;
        String corpId = biz.getCorpId();
        log.info("\u5c1d\u8bd5\u540c\u6b65\u4f01\u4e1a\u6210\u5458ID, corpId={}", (Object)corpId);
        List weworkUserIds = this.weworkUserMapper.getWeworkUserIds(corpId);
        if (CollectionUtils.isEmpty((Collection)weworkUserIds)) {
            log.warn("\u4f01\u4e1a\u4e0b\u6ca1\u6709\u6210\u5458, corpId={}", (Object)corpId);
            return;
        }
        try {
            String suiteAccessToken = this.suiteTokenService.getSuiteAccessToken(corpId);
            result = this.customizedApi.getOpenUserIds(suiteAccessToken, weworkUserIds);
        }
        catch (WeworkException e) {
            log.error("\u83b7\u53d6\u4f01\u4e1a\u53c2\u6570\u5931\u8d25, corpId={}", (Object)corpId, (Object)e);
            return;
        }
        List list = result.getOpenUserIdList();
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ArrayList ids = Lists.newArrayList();
            for (OpenUserId it : list) {
                WeworkOpenUserId dto = new WeworkOpenUserId();
                dto.setUserId(it.getUserId());
                dto.setOpenUserId(it.getOpenUserId());
                ids.add(dto);
                map.put(it.getUserId(), it.getOpenUserId());
            }
            List idLists = Lists.partition((List)ids, (int)200);
            for (List idList : idLists) {
                try {
                    log.info("batch update authUserId, corpId={}, ids={}", (Object)corpId, (Object)ids);
                    this.weworkUserMapper.batchUpdateAuthUserId(corpId, idList);
                }
                catch (Exception e) {
                    log.error("\u66f4\u65b0\u6210\u5458authUserId\u5931\u8d25\uff0ccorpId={}, ids={}", new Object[]{corpId, ids, e});
                }
            }
        }
        if ((applyWeworkUserId = (String)map.get(biz.getApplyWeworkUserId())) != null) {
            log.info("update apply wework userId, corpId={}, {} -> {}", new Object[]{corpId, biz.getApplyWeworkUserId(), applyWeworkUserId});
            biz.setApplyWeworkUserId(applyWeworkUserId);
            this.businessCustomerMapper.updateByPrimaryKeySelective((Object)biz);
        }
    }

    private void appendSuiteUser(BusinessCustomer existBiz, BusinessCustomer authBiz) {
        log.info("\u5c1d\u8bd5\u628a\u65b0\u4f01\u4e1a\u4e0b\u6388\u6743\u7684\u6210\u5458\u6dfb\u52a0\u5230\u65e7\u4f01\u4e1a\u4e2d\u3002");
        List authUserList = this.weworkUserMapper.selectByBizId(authBiz.getId());
        if (CollectionUtils.isEmpty((Collection)authUserList)) {
            log.warn("\u65b0\u4f01\u4e1a\u4e0b\u6ca1\u6709\u6210\u5458, bizId={}, authCorpId={}", (Object)authBiz.getId(), (Object)authBiz.getAuthCorpId());
            return;
        }
        int size = authUserList.size();
        Map<Object, Object> existUserMap = Collections.emptyMap();
        List existUserList = this.weworkUserMapper.selectByBizId(existBiz.getId());
        if (CollectionUtils.isNotEmpty((Collection)existUserList)) {
            existUserMap = existUserList.stream().collect(Collectors.toMap(WeworkUser::getAuthUserId, it -> it));
        }
        ArrayList addList = Lists.newArrayListWithCapacity((int)size);
        ArrayList modList = Lists.newArrayListWithCapacity((int)size);
        for (WeworkUser it2 : authUserList) {
            WeworkUser u = (WeworkUser)existUserMap.get(it2.getAuthUserId());
            if (u != null) {
                u.setIsSuiteAuth(it2.getIsSuiteAuth());
                u.setSuiteAuthTime(it2.getSuiteAuthTime());
                u.setSuiteDeauthTime(it2.getSuiteDeauthTime());
                modList.add(u);
                continue;
            }
            it2.setId(null);
            it2.setNum(this.idGen.getNum());
            it2.setBizId(existBiz.getId());
            it2.setCorpId(existBiz.getCorpId());
            addList.add(it2);
        }
        if (CollectionUtils.isNotEmpty((Collection)modList)) {
            log.info("\u6279\u91cf\u66f4\u65b0\u7b2c\u4e09\u65b9\u6388\u6743\u72b6\u6001: {}", (Object)modList);
            this.weworkUserMapper.batchUpdateSuiteAuth((List)modList);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            log.info("\u6279\u91cf\u6dfb\u52a0\u6210\u5458:{}", (Object)addList);
            this.weworkUserMapper.batchInsert((Collection)addList);
        }
    }

    private void createAdmin(Long bizId, String corpId, String applyUserId) {
        User user;
        log.info("\u5c1d\u8bd5\u521b\u5efa\u7ba1\u7406\u5458\u8d26\u53f7\u3002bizId={}, corpId={}, applyUserId={}", new Object[]{bizId, corpId, applyUserId});
        Date now = new Date();
        WeworkUser weworkUser = this.weworkUserMapper.getByAuthUserId(corpId, applyUserId);
        if (weworkUser == null) {
            String num = this.idGen.getNum();
            weworkUser = new WeworkUser();
            weworkUser.setNum(num);
            weworkUser.setBizId(bizId);
            weworkUser.setCorpId(corpId);
            weworkUser.setWeworkUserId(applyUserId);
            weworkUser.setAuthUserId(applyUserId);
            weworkUser.setOpenUserId(applyUserId);
            weworkUser.setCreateTime(now);
            weworkUser.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.ONLY_SUITE.getValue()));
            weworkUser.setName(applyUserId);
            weworkUser.setAvatar("");
            weworkUser.setUpdateTime(now);
            weworkUser.setIsSuiteAuth(Integer.valueOf(1));
            weworkUser.setSuiteAuthTime(weworkUser.getSuiteAuthTime());
            this.weworkUserMapper.insertSelective((Object)weworkUser);
        }
        if ((user = this.userMapper.getByWeworkUserIdAndCorpId(weworkUser.getWeworkUserId(), corpId)) == null) {
            log.info("createWeworkUser: corpId:{}, user:{}", (Object)corpId, (Object)user);
            this.userService.insertUser(weworkUser, false);
        }
    }

    @Override
    public void changeAuth(ChangeAuth event) {
        log.info("changeAuth:{}", (Object)event);
        String suiteId = event.getSuiteId();
        String authCorpId = event.getAuthCorpId();
        String state = event.getState();
        Long timestamp = event.getTimestamp();
        Date changeTime = new Date(timestamp * 1000L);
        Long bizId = this.businessCustomerMapper.getExistBizId(authCorpId);
        if (bizId == null) {
            log.warn("\u5546\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664. authCorpId:{}", (Object)authCorpId);
            return;
        }
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        if (biz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
            log.warn("biz is not synchronized, bizId={}, authCorpId={}", (Object)biz.getId(), (Object)authCorpId);
            return;
        }
        try {
            this.syncTaskService.start(biz.getId(), biz.getCorpId(), SyncTaskType.CONTACT, -1L);
            this.syncTaskService.start(biz.getId(), biz.getCorpId(), SyncTaskType.CUSTOMIZED_APP, -1L);
            this.syncTaskService.start(biz.getId(), biz.getCorpId(), SyncTaskType.EXTERNAL_CONTACT, -1L);
            this.syncTaskService.start(biz.getId(), biz.getCorpId(), SyncTaskType.EXTERNAL_CHAT, -1L);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u6388\u6743\u8303\u56f4\u5931\u8d25. corpId={}", (Object)biz.getCorpId(), (Object)e);
        }
    }

    @Override
    public void cancelAuth(CancelAuth event) {
        log.info("cancelAuth:{}", (Object)event);
        String suiteId = event.getSuiteId();
        String corpId = event.getAuthCorpId();
        Long timestamp = event.getTimestamp();
        Date deauthTime = new Date(timestamp * 1000L);
        Date now = new Date();
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByCorpId(corpId);
        if (weworkCorp != null) {
            if (deauthTime.before(weworkCorp.getAuthTime())) {
                log.warn("\u4f01\u4e1a\u53d6\u6d88\u6388\u6743\u65f6\u95f4\u65e9\u4e8e\u6388\u6743\u65f6\u95f4\uff0c\u7591\u4f3c\u91cd\u590d\u63a8\u9001cancel_auth\u4e8b\u4ef6\u6216\u8005\u5ef6\u8fdf\u63a8\u9001\uff0c\u4e0d\u6267\u884c\u53d6\u6d88\u6388\u6743\u52a8\u4f5c\u3002corpId:{}", (Object)corpId);
                weworkCorp.setDeauthTime(deauthTime);
                weworkCorp.setUpdateTime(now);
                this.weworkCorpMapper.updateByPrimaryKeySelective((Object)weworkCorp);
                return;
            }
            weworkCorp.setIsAuth(Integer.valueOf(0));
            weworkCorp.setDeauthTime(deauthTime);
            weworkCorp.setUpdateTime(now);
            this.weworkCorpMapper.updateByPrimaryKeySelective((Object)weworkCorp);
        } else {
            log.warn("Wework_corp not found, corpId:{}, suiteId:{}", (Object)corpId, (Object)suiteId);
        }
        this.weworkUserMapper.batchAgentDeauth(corpId, deauthTime);
        CorpCustomizedToken record = this.corpCustomizedTokenMapper.getByCorpId(corpId, suiteId);
        if (record == null) {
            log.warn("corp customized token not found, corpId={}", (Object)corpId);
            return;
        }
        if (deauthTime.before(record.getAuthTime())) {
            log.warn("\u4f01\u4e1a\u53d6\u6d88\u6388\u6743\u65f6\u95f4\u65e9\u4e8e\u6388\u6743\u65f6\u95f4\uff0c\u7591\u4f3c\u91cd\u590d\u63a8\u9001cancel_auth\u4e8b\u4ef6\u6216\u8005\u5ef6\u8fdf\u63a8\u9001\uff0c\u4e0d\u6267\u884c\u53d6\u6d88\u6388\u6743\u52a8\u4f5c\u3002corpId:{}", (Object)corpId);
            record.setDeauthTime(deauthTime);
            record.setUpdateTime(new Date());
            this.corpCustomizedTokenMapper.updateByPrimaryKeySelective((Object)record);
            return;
        }
        record.setState("");
        record.setDevStatus(Integer.valueOf(0));
        record.setIsAuth(Integer.valueOf(0));
        record.setDeauthTime(deauthTime);
        record.setUpdateTime(new Date());
        this.corpCustomizedTokenMapper.updateByPrimaryKeySelective((Object)record);
        this.weworkUserMapper.batchAgentDeauth(corpId, deauthTime);
        this.weworkTagMapper.batchSuiteDeauth(corpId);
        this.weworkTagGroupMapper.batchSuiteDeauth(corpId);
    }

    @Override
    public void resetPermanentCode(ResetPermanentCode event) {
        log.info("resetPermanentCode:{}", (Object)event);
        String suiteId = event.getSuiteId();
        String authCode = event.getAuthCode();
        String suiteAccessToken = this.providerTokenService.getSuiteAccessToken(suiteId);
        if (suiteAccessToken == null) {
            log.warn("\u65e0\u6cd5\u83b7\u53d6\u4ee3\u5f00\u53d1\u5e94\u7528\u7684accessToken");
            return;
        }
        PermanentCode permanentCode = this.suiteApi.getPermanentCode(suiteAccessToken, authCode);
        log.info("permanentCode:{}", (Object)permanentCode);
        Date now = new Date();
        AuthCorpInfo corpInfo = permanentCode.getAuthCorpInfo();
        String corpId = corpInfo.getCorpId();
        CorpCustomizedToken record = this.corpCustomizedTokenMapper.getAccessToken(corpId, suiteId);
        if (record == null) {
            log.warn("corp customized app not found, corpId={}", (Object)corpId);
            return;
        }
        record.setPermanentCode(permanentCode.getPermanentCode());
        record.setAccessToken(null);
        record.setExpireTime(null);
        record.setJsapiTicket(null);
        record.setJsapiTicketExpireTime(null);
        record.setAgentTicket(null);
        record.setAgentTicketExpireTime(null);
        record.setUpdateTime(now);
        this.corpCustomizedTokenMapper.updateByPrimaryKey((Object)record);
    }

    private void createCorpCustomizedToken(Long bizId, String suiteId, PermanentCode permanentCode, String state, Date authTime) {
        Date now = new Date();
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String corpId = biz.getCorpId();
        String authCorpId = biz.getAuthCorpId();
        AuthAgentInfo agentInfo = permanentCode.getAuthInfo();
        Agent agent = (Agent)agentInfo.getAgent().get(0);
        CorpCustomizedToken record = this.corpCustomizedTokenMapper.getByCorpId(corpId, suiteId);
        boolean create = false;
        if (record == null) {
            record = new CorpCustomizedToken();
            record.setNum(this.idGen.getNum());
            record.setCorpId(corpId);
            record.setSuiteId(suiteId);
            record.setCreateTime(now);
            create = true;
        }
        record.setBizId(bizId);
        record.setAuthCorpId(authCorpId);
        record.setAgentId(agent.getAgentId());
        record.setPermanentCode(permanentCode.getPermanentCode());
        record.setAccessToken("");
        record.setExpireTime(authTime);
        record.setJsapiTicket("");
        record.setJsapiTicketExpireTime(authTime);
        record.setAgentTicket("");
        record.setAgentTicketExpireTime(authTime);
        record.setToken(TokenGen.getRandomToken());
        record.setAesKey(TokenGen.getRandomAESKey());
        if (StringUtils.isBlank((CharSequence)state)) {
            record.setState("");
        } else {
            record.setState(state);
        }
        record.setDevStatus(Integer.valueOf(0));
        record.setIsAuth(Integer.valueOf(1));
        record.setAuthTime(authTime);
        record.setUpdateTime(now);
        if (create) {
            this.corpCustomizedTokenMapper.insertSelective((Object)record);
            log.info("save corp customized token, corpId:{}", (Object)corpId);
        } else {
            this.corpCustomizedTokenMapper.updateByPrimaryKeySelective((Object)record);
            log.info("update corp customized token, corpId:{}", (Object)corpId);
        }
    }

    private BusinessCustomer createBizId(PermanentCode permanentCode, String openCorpId, BizChannel bizChannel) {
        AuthCorpInfo corpInfo = permanentCode.getAuthCorpInfo();
        AuthUserInfo userInfo = permanentCode.getAuthUserInfo();
        String corpId = corpInfo.getCorpId();
        Date now = new Date();
        String num = this.idGen.getNum();
        String applyUserId = userInfo.getOpenUserId();
        String name = corpInfo.getCorpFullName();
        if (StringUtils.isBlank((CharSequence)name)) {
            name = corpInfo.getCorpName();
        }
        BusinessCustomer biz = new BusinessCustomer();
        biz.setName(name);
        biz.setUpdateTime(now);
        biz.setApplyWeworkUserId(applyUserId);
        biz.setNum(num);
        biz.setCorpId(corpId);
        biz.setAuthCorpId(openCorpId);
        biz.setSyncStatus(Integer.valueOf(WeworkCorpSyncStatus.INIT_SUITE.getValue()));
        biz.setApplyChannel(Integer.valueOf(bizChannel.getValue()));
        biz.setCreateTime(now);
        biz.setNumCount(this.numCount);
        biz.setPkgIds("1");
        biz.setInitPkgIds("1");
        biz.setExpireDate(DateUtil.getDiffDateTime((Date)now, (int)this.bizExpireDays));
        this.businessCustomerMapper.insertSelective((Object)biz);
        log.info("create new business_customer, corpId:{}, authCorpId:{}, bizId:{}", new Object[]{corpId, openCorpId, biz.getId()});
        return biz;
    }

    private void createWeworkCorp(BusinessCustomer biz, AuthCorpInfo corpInfo, Date authTime) {
        Date now = new Date();
        Long bizId = biz.getId();
        String corpId = biz.getCorpId();
        String authCorpId = biz.getAuthCorpId();
        WeworkCorp corp = new WeworkCorp();
        corp.setNum(this.idGen.getNum());
        corp.setBizId(bizId);
        corp.setCorpId(corpId);
        corp.setAuthCorpId(authCorpId);
        corp.setCreateTime(now);
        corp.setCorpName(corpInfo.getCorpName());
        corp.setCorpFullName(corpInfo.getCorpFullName());
        corp.setCorpType(corpInfo.getCorpType());
        corp.setCorpSquareLogoUrl(corpInfo.getCorpSquareLogoUrl());
        corp.setCorpUserMax(corpInfo.getCorpUserMax());
        corp.setCorpAgentMax(corpInfo.getCorpAgentMax());
        if (corpInfo.getVerifiedEndTime() != null) {
            corp.setVerifiedEndTime(new Date(corpInfo.getVerifiedEndTime()));
        }
        corp.setSubjectType(corpInfo.getSubjectType());
        corp.setCorpWxqrcode(corpInfo.getCorpWxqrcode());
        corp.setCorpScale(corpInfo.getCorpScale());
        corp.setCorpIndustry(corpInfo.getCorpIndustry());
        corp.setCorpSubIndustry(corpInfo.getCorpSubIndustry());
        corp.setLocation(corpInfo.getLocation());
        corp.setUpdateTime(now);
        corp.setIsDeleted(Integer.valueOf(0));
        corp.setIsAuth(Integer.valueOf(1));
        corp.setAuthTime(authTime);
        log.info("save wework_corp, corpId:{}, bizId:{}, corp:{}", new Object[]{authCorpId, bizId, corp});
        this.weworkCorpMapper.insertSelective((Object)corp);
    }

    private void createWeworkUser(BusinessCustomer biz, PermanentCode permanentCode, Date authTime) {
        Date now = new Date();
        Long bizId = biz.getId();
        String corpId = biz.getCorpId();
        AuthUserInfo userInfo = permanentCode.getAuthUserInfo();
        String weworkUserId = userInfo.getUserId();
        String openUserId = userInfo.getOpenUserId();
        log.info("create wework user, corpId:{}, weworkUserId:{}, openUserId:{}", new Object[]{corpId, weworkUserId, openUserId});
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfoByBizIdAndAuthUserId(bizId, openUserId);
        boolean create = false;
        String num = this.idGen.getNum();
        if (weworkUser == null) {
            weworkUser = new WeworkUser();
            weworkUser.setNum(num);
            weworkUser.setBizId(bizId);
            weworkUser.setCorpId(corpId);
            weworkUser.setWeworkUserId(weworkUserId);
            weworkUser.setAuthUserId(openUserId);
            weworkUser.setOpenUserId(openUserId);
            weworkUser.setStatus(Integer.valueOf(1));
            weworkUser.setSyncStatus(Integer.valueOf(WeworkUserSyncStatus.SYNCHRONIZED.getValue()));
            weworkUser.setCreateTime(now);
            create = true;
        }
        weworkUser.setName(userInfo.getName());
        weworkUser.setAvatar(userInfo.getAvatar());
        weworkUser.setUpdateTime(now);
        weworkUser.setIsSuiteAuth(Integer.valueOf(0));
        weworkUser.setSuiteAuthTime(authTime);
        weworkUser.setIsAgentAuth(Integer.valueOf(1));
        weworkUser.setAgentAuthTime(authTime);
        if (create) {
            log.info("save wework_user, corpId:{}, weworkUser:{}", (Object)corpId, (Object)weworkUser);
            this.weworkUserMapper.insertSelective((Object)weworkUser);
        } else {
            log.info("update wework_user, corpId:{}, weworkUser:{}", (Object)corpId, (Object)weworkUser);
            this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
        }
        User authUser = this.userMapper.selectUserByWeworkUserIdAndCorpId(openUserId, corpId);
        if (authUser != null) {
            try {
                log.info("\u91cd\u65b0\u914d\u7f6e\u7ba1\u7406\u5458\u7684wework_user_id, corpId:{}, weworkUserId:{}, openUserId:{}", new Object[]{corpId, weworkUserId, openUserId});
                authUser.setWeworkUserId(weworkUserId);
                authUser.setIdentifier(weworkUserId);
                authUser.setAvatar(userInfo.getAvatar());
                authUser.setName(userInfo.getName());
                authUser.setIsDeleted(Integer.valueOf(0));
                authUser.setUpdateTime(new Date());
                this.userMapper.updateByPrimaryKeySelective((Object)authUser);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u91cd\u65b0\u914d\u7f6e\u7ba1\u7406\u5458\u5931\u8d25, corpId:{}, weworkUserId:{}, openUserId:{}", new Object[]{corpId, weworkUserId, openUserId, e});
            }
        } else {
            User user = this.userMapper.getByWeworkUserIdAndCorpId(weworkUser.getWeworkUserId(), corpId);
            if (user == null) {
                log.info("createWeworkUser: \u6210\u5458\u8f6c\u5316\u4e3a\u7528\u6237\uff0cbizId:{}, weworkUser:{}", (Object)bizId, (Object)weworkUser);
                this.userService.insertUser(weworkUser, false);
            }
        }
    }

    private void createCorpSuiteToken(BusinessCustomer biz, String suiteId) {
        Date now = new Date();
        Long bizId = biz.getId();
        String corpId = biz.getCorpId();
        String authCorpId = biz.getAuthCorpId();
        CorpSuiteToken corpSuiteToken = this.corpSuiteTokenMapper.getAccessToken(corpId, suiteId);
        boolean create = false;
        if (corpSuiteToken == null) {
            corpSuiteToken = new CorpSuiteToken();
            corpSuiteToken.setCorpId(corpId);
            corpSuiteToken.setSuiteId(suiteId);
            corpSuiteToken.setCreateTime(now);
            create = true;
        }
        corpSuiteToken.setBizId(bizId);
        corpSuiteToken.setAuthCorpId(authCorpId);
        corpSuiteToken.setAgentId(Integer.valueOf(0));
        corpSuiteToken.setPermanentCode("");
        corpSuiteToken.setAccessToken("");
        corpSuiteToken.setExpireTime(now);
        corpSuiteToken.setUpdateTime(now);
        if (create) {
            this.corpSuiteTokenMapper.insertSelective((Object)corpSuiteToken);
            log.info("create corp suite token, corpId:{}", (Object)corpId);
        } else {
            this.corpSuiteTokenMapper.updateByPrimaryKeySelective((Object)corpSuiteToken);
            log.info("update corp suite token, corpId:{}", (Object)corpId);
        }
    }
}

