/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.callback.service.impl;

import cn.kinyun.wework.sdk.callback.corp.external.AddExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.AddHalfExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.CreateExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.CreateExternalTag;
import cn.kinyun.wework.sdk.callback.corp.external.DelExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.DelFollowUser;
import cn.kinyun.wework.sdk.callback.corp.external.DeleteExternalTag;
import cn.kinyun.wework.sdk.callback.corp.external.DismissExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.EditExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.MsgAuditApproved;
import cn.kinyun.wework.sdk.callback.corp.external.TransferFail;
import cn.kinyun.wework.sdk.callback.corp.external.UpdateExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.UpdateExternalTag;
import com.kuaike.scrm.callback.service.CorpExternalEventService;
import com.kuaike.scrm.synctask.service.ExternalChatSyncService;
import com.kuaike.scrm.synctask.service.ExternalContactSyncService;
import com.kuaike.scrm.synctask.service.ExternalTagSyncService;
import com.kuaike.scrm.token.service.CorpTokenService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class CorpExternalEventServiceImpl
implements CorpExternalEventService {
    private static final Logger log = LoggerFactory.getLogger(CorpExternalEventServiceImpl.class);
    @Autowired
    private CorpTokenService corpTokenService;
    @Autowired
    private ExternalContactSyncService externalContactSyncService;
    @Autowired
    private ExternalChatSyncService externalChatSyncService;
    @Autowired
    private ExternalTagSyncService externalTagSyncService;

    @Override
    public void onAddExternalContact(AddExternalContact event) {
        log.info("add_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String accessToken = this.corpTokenService.getExternalContactAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_external_contact_token is blank");
            return;
        }
        this.externalContactSyncService.modifyExternalContact(accessToken, corpId, userId, externalUserId, timestamp, true);
    }

    @Override
    public void onAddHalfExternalContact(AddHalfExternalContact event) {
        log.info("add_half_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String accessToken = this.corpTokenService.getExternalContactAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_external_contact_token is blank");
            return;
        }
        this.externalContactSyncService.modifyExternalContact(accessToken, corpId, userId, externalUserId, timestamp, true);
    }

    @Override
    public void onEditExternalContact(EditExternalContact event) {
        log.info("edit_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String accessToken = this.corpTokenService.getExternalContactAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_external_contact_token is blank");
            return;
        }
        this.externalContactSyncService.modifyExternalContact(accessToken, corpId, userId, externalUserId, timestamp, false);
    }

    @Override
    public void onDelExternalContact(DelExternalContact event) {
        log.info("del_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        this.externalContactSyncService.delExternalContact(corpId, userId, externalUserId, timestamp);
    }

    @Override
    public void onDelFollowUser(DelFollowUser event) {
        log.info("del_follow_user:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        this.externalContactSyncService.delFollowUser(corpId, userId, externalUserId, timestamp);
    }

    @Override
    public void onTransferFail(TransferFail event) {
        log.info("transfer_fail:{}", (Object)event);
    }

    @Override
    public void onCreateExternalChat(CreateExternalChat event) {
        log.info("create_external_chat:{}", (Object)event);
        String corpId = event.getToUserName();
        String chatId = event.getChatId();
        String accessToken = this.corpTokenService.getExternalContactAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_external_contact_token is blank");
            return;
        }
        this.externalChatSyncService.create(accessToken, corpId, chatId);
    }

    @Override
    public void onUpdateExternalChat(UpdateExternalChat event) {
        log.info("update_external_chat:{}", (Object)event);
        String corpId = event.getToUserName();
        String chatId = event.getChatId();
        Integer quitScene = event.getQuitScene();
        String accessToken = this.corpTokenService.getExternalContactAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_external_contact_token is blank");
            return;
        }
        this.externalChatSyncService.modify(accessToken, corpId, chatId, quitScene);
    }

    @Override
    public void onDismissExternalChat(DismissExternalChat event) {
        log.info("dismiss_external_chat:{}", (Object)event);
        String corpId = event.getToUserName();
        String chatId = event.getChatId();
        this.externalChatSyncService.dismiss(corpId, chatId);
    }

    @Override
    public void onCreateExternalTag(CreateExternalTag event) {
        log.info("create_external_tag:{}", (Object)event);
        String corpId = event.getToUserName();
        String accessToken = this.corpTokenService.getExternalContactAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_external_contact_token is blank");
            return;
        }
        this.externalTagSyncService.modify(accessToken, corpId, event.getChangeType(), event.getTagType(), event.getId(), event.getCreateTime());
    }

    @Override
    public void onUpdateExternalTag(UpdateExternalTag event) {
        log.info("update_external_tag:{}", (Object)event);
        String corpId = event.getToUserName();
        String accessToken = this.corpTokenService.getExternalContactAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_external_contact_token is blank");
            return;
        }
        this.externalTagSyncService.modify(accessToken, corpId, event.getChangeType(), event.getTagType(), event.getId(), event.getCreateTime());
    }

    @Override
    public void onDeleteExternalTag(DeleteExternalTag event) {
        log.info("delete_external_tag:{}", (Object)event);
        this.externalTagSyncService.delete(event.getToUserName(), event.getTagType(), event.getId(), event.getCreateTime());
    }

    @Override
    public void onMsgAuditApproved(MsgAuditApproved event) {
        log.info("msg_audit_approved:{}", (Object)event);
    }
}

