/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.callback.service.impl;

import cn.kinyun.wework.sdk.callback.agent.BaseAgentEvent;
import cn.kinyun.wework.sdk.callback.agent.event.Location;
import cn.kinyun.wework.sdk.callback.agent.event.TaskCardClick;
import cn.kinyun.wework.sdk.callback.agent.msg.ImageMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.LinkMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.LocationMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.TextMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.VideoMsg;
import cn.kinyun.wework.sdk.callback.agent.msg.VoiceMsg;
import cn.kinyun.wework.sdk.callback.corp.external.AddExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.AddHalfExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.CreateExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.CreateExternalTag;
import cn.kinyun.wework.sdk.callback.corp.external.DelExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.DelFollowUser;
import cn.kinyun.wework.sdk.callback.corp.external.DeleteExternalTag;
import cn.kinyun.wework.sdk.callback.corp.external.DismissExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.EditExternalContact;
import cn.kinyun.wework.sdk.callback.corp.external.MsgAuditApproved;
import cn.kinyun.wework.sdk.callback.corp.external.TransferFail;
import cn.kinyun.wework.sdk.callback.corp.external.UpdateExternalChat;
import cn.kinyun.wework.sdk.callback.corp.external.UpdateExternalTag;
import com.kuaike.scrm.callback.service.AgentEventService;
import com.kuaike.scrm.common.enums.WeworkCorpSyncStatus;
import com.kuaike.scrm.common.enums.WeworkUserSyncStatus;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.synctask.service.ContactSyncService;
import com.kuaike.scrm.synctask.service.ExternalChatSyncService;
import com.kuaike.scrm.synctask.service.ExternalContactSyncService;
import com.kuaike.scrm.synctask.service.ExternalTagSyncService;
import com.kuaike.scrm.synctask.service.SyncTaskService;
import com.kuaike.scrm.synctask.service.enums.SyncTaskType;
import com.kuaike.scrm.token.service.AgentTokenService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Deprecated
public class AgentEventServiceImpl
implements AgentEventService {
    private static final Logger log = LoggerFactory.getLogger(AgentEventServiceImpl.class);
    @Autowired
    private AgentTokenService agentTokenService;
    @Autowired
    private ContactSyncService contactSyncService;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private SyncTaskService syncTaskService;
    @Autowired
    private ExternalContactSyncService externalContactSyncService;
    @Autowired
    private ExternalChatSyncService externalChatSyncService;
    @Autowired
    private ExternalTagSyncService externalTagSyncService;

    @Override
    @Transactional
    public void onSubscribe(BaseAgentEvent event) {
        log.info("subscribe:{}", (Object)event);
        Integer agentId = event.getAgentId();
        String corpId = event.getToUserName();
        String weworkUserId = event.getFromUserName();
        Long createTime = event.getCreateTime();
        Date authTime = new Date(createTime * 1000L);
        Date now = new Date();
        Long bizId = this.businessCustomerMapper.getBizId(corpId);
        if (bizId == null) {
            log.warn("\u5546\u6237\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664. corpId:{}, userId:{}", (Object)corpId, (Object)weworkUserId);
            return;
        }
        BusinessCustomer biz = this.businessCustomerMapper.getByCorpId(corpId);
        if (biz.getSyncStatus().intValue() == WeworkCorpSyncStatus.INIT_SUITE.getValue()) {
            log.warn("biz corpId is not synchronized, skip this step. bizId={}, corpId={}", (Object)bizId, (Object)corpId);
            return;
        }
        String accessToken = this.agentTokenService.getAgentAccessToken(corpId, agentId);
        boolean needSyncUserId = false;
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        if (weworkUser == null) {
            weworkUser = this.contactSyncService.subscribe(bizId, corpId, weworkUserId, accessToken);
            if (weworkUser == null) {
                log.info("wework_user not found, corpId:{}, weworkUserId:{}", (Object)corpId, (Object)weworkUserId);
                return;
            }
            needSyncUserId = true;
        } else if (weworkUser.getSyncStatus() == null || weworkUser.getSyncStatus().intValue() != WeworkUserSyncStatus.SYNCHRONIZED.getValue()) {
            needSyncUserId = true;
        }
        weworkUser.setIsAgentAuth(Integer.valueOf(1));
        weworkUser.setAgentAuthTime(authTime);
        weworkUser.setIsDeleted(Integer.valueOf(0));
        weworkUser.setUpdateTime(now);
        this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
        if (needSyncUserId) {
            try {
                this.syncTaskService.start(bizId, corpId, SyncTaskType.SUITE, -1L);
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u4f01\u4e1a\u6210\u5458\u8d26\u53f7\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    public void onUnsubscribe(BaseAgentEvent event) {
        log.info("unsubscribe:{}", (Object)event);
        String corpId = event.getToUserName();
        String weworkUserId = event.getFromUserName();
        Long createTime = event.getCreateTime();
        Date deauthTime = new Date(createTime * 1000L);
        Date now = new Date();
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, weworkUserId);
        if (weworkUser == null) {
            log.info("wework_user not found, corpId:{}, userId:{}", (Object)corpId, (Object)weworkUserId);
            return;
        }
        weworkUser.setIsAgentAuth(Integer.valueOf(0));
        weworkUser.setAgentDeauthTime(deauthTime);
        weworkUser.setUpdateTime(now);
        this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
    }

    @Override
    public void onEnterAgent(BaseAgentEvent event) {
        log.info("enter_agent:{}", (Object)event);
    }

    @Override
    public void onLocation(Location event) {
        log.info("location:{}", (Object)event);
    }

    @Override
    public void onClick(BaseAgentEvent event) {
        log.info("click:{}", (Object)event);
    }

    @Override
    public void onView(BaseAgentEvent event) {
        log.info("view:{}", (Object)event);
    }

    @Override
    public void onTaskCardClick(TaskCardClick event) {
        log.info("taskcard_click:{}", (Object)event);
    }

    @Override
    public void recvText(TextMsg msg) {
        log.info("text:{}", (Object)msg);
    }

    @Override
    public void recvImage(ImageMsg msg) {
        log.info("image:{}", (Object)msg);
    }

    @Override
    public void recvVoice(VoiceMsg msg) {
        log.info("voice:{}", (Object)msg);
    }

    @Override
    public void recvVideo(VideoMsg msg) {
        log.info("video:{}", (Object)msg);
    }

    @Override
    public void recvLocation(LocationMsg msg) {
        log.info("location:{}", (Object)msg);
    }

    @Override
    public void recvLink(LinkMsg msg) {
        log.info("link:{}", (Object)msg);
    }

    @Override
    public void onAddExternalContact(AddExternalContact event) {
        log.info("add_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String accessToken = this.agentTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalContactSyncService.modifyExternalContact(accessToken, corpId, userId, externalUserId, timestamp, true);
    }

    @Override
    public void onAddHalfExternalContact(AddHalfExternalContact event) {
        log.info("add_half_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String accessToken = this.agentTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalContactSyncService.modifyExternalContact(accessToken, corpId, userId, externalUserId, timestamp, true);
    }

    @Override
    public void onEditExternalContact(EditExternalContact event) {
        log.info("edit_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        String accessToken = this.agentTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalContactSyncService.modifyExternalContact(accessToken, corpId, userId, externalUserId, timestamp, false);
    }

    @Override
    public void onDelExternalContact(DelExternalContact event) {
        log.info("del_external_contact:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        this.externalContactSyncService.delExternalContact(corpId, userId, externalUserId, timestamp);
    }

    @Override
    public void onDelFollowUser(DelFollowUser event) {
        log.info("del_follow_user:{}", (Object)event);
        String corpId = event.getToUserName();
        String userId = event.getUserId();
        String externalUserId = event.getExternalUserId();
        Long timestamp = event.getCreateTime();
        this.externalContactSyncService.delFollowUser(corpId, userId, externalUserId, timestamp);
    }

    @Override
    public void onTransferFail(TransferFail event) {
        log.info("transfer_fail:{}", (Object)event);
    }

    @Override
    public void onCreateExternalChat(CreateExternalChat event) {
        log.info("create_external_chat:{}", (Object)event);
        String corpId = event.getToUserName();
        String chatId = event.getChatId();
        String accessToken = this.agentTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalChatSyncService.create(accessToken, corpId, chatId);
    }

    @Override
    public void onUpdateExternalChat(UpdateExternalChat event) {
        log.info("update_external_chat:{}", (Object)event);
        String corpId = event.getToUserName();
        String chatId = event.getChatId();
        Integer quitScene = event.getQuitScene();
        String accessToken = this.agentTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalChatSyncService.modify(accessToken, corpId, chatId, quitScene);
    }

    @Override
    public void onDismissExternalChat(DismissExternalChat event) {
        log.info("dismiss_external_chat:{}", (Object)event);
        String corpId = event.getToUserName();
        String chatId = event.getChatId();
        this.externalChatSyncService.dismiss(corpId, chatId);
    }

    @Override
    public void onCreateExternalTag(CreateExternalTag event) {
        log.info("create_external_tag:{}", (Object)event);
        String corpId = event.getToUserName();
        String accessToken = this.agentTokenService.getAgentAccessToken(corpId);
        this.externalTagSyncService.modify(accessToken, corpId, event.getChangeType(), event.getTagType(), event.getId(), event.getCreateTime());
    }

    @Override
    public void onUpdateExternalTag(UpdateExternalTag event) {
        log.info("update_external_tag:{}", (Object)event);
        String corpId = event.getToUserName();
        String accessToken = this.agentTokenService.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("corp_agent_token is blank");
            return;
        }
        this.externalTagSyncService.modify(accessToken, corpId, event.getChangeType(), event.getTagType(), event.getId(), event.getCreateTime());
    }

    @Override
    public void onDeleteExternalTag(DeleteExternalTag event) {
        log.info("delete_external_tag:{}", (Object)event);
        this.externalTagSyncService.delete(event.getToUserName(), event.getTagType(), event.getId(), event.getCreateTime());
    }

    @Override
    public void onMsgAuditApproved(MsgAuditApproved event) {
        log.info("msg_audit_approved:{}", (Object)event);
    }
}

