/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.setting.service.impl;

import cn.kinyun.wework.sdk.api.AccessTokenApi;
import cn.kinyun.wework.sdk.api.CustomizedApi;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.agent.entity.AgentToken;
import com.kuaike.scrm.dal.agent.mapper.AgentTokenMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.setting.dto.req.SetAgentSecretReq;
import com.kuaike.scrm.setting.dto.resp.GetAgentTokenCfg;
import com.kuaike.scrm.setting.service.SettingAgent2Service;
import com.kuaike.scrm.token.service.ProviderTokenService;
import com.kuaike.scrm.token.service.RefreshTokenService;
import com.kuaike.scrm.token.utils.ServiceContext;
import com.kuaike.scrm.token.utils.TokenGen;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SettingAgent2ServiceImpl
implements SettingAgent2Service {
    private static final Logger log = LoggerFactory.getLogger(SettingAgent2ServiceImpl.class);
    @Value(value="http://${qyapi.domain.scrm-callback}/agent2/")
    private String callbackUrl;
    @Value(value="${qyapi.agent2.whitelist:}")
    private String whiteList;
    @Value(value="${agent.proxy.address:}")
    private String proxyAddress;
    @Value(value="${agent.proxy.port:0}")
    private Integer proxyPort;
    @Autowired
    private AccessTokenApi accessTokenApi;
    @Autowired
    private CustomizedApi customizedApi;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private AgentTokenMapper agentTokenMapper;
    @Autowired
    private RefreshTokenService refreshTokenService;
    @Autowired
    private ProviderTokenService providerTokenService;

    public void setProxy(AgentToken token) {
        Proxy proxy = this.getProxy(token);
        log.info("setProxy, corpId:{}, agentId:{}, proxy:{}", new Object[]{token.getCorpId(), token.getAgentId(), proxy});
        ServiceContext.getContext().setProxy(proxy);
    }

    public Proxy getProxy(AgentToken token) {
        if (StringUtils.isNotBlank((CharSequence)token.getProxyAddress()) && token.getProxyPort() != null) {
            Proxy.Type proxyType = StringUtils.isBlank((CharSequence)token.getProxyType()) ? Proxy.Type.HTTP : Proxy.Type.valueOf(token.getProxyType());
            return new Proxy(proxyType, new InetSocketAddress(token.getProxyAddress(), (int)token.getProxyPort()));
        }
        if (StringUtils.isNotBlank((CharSequence)this.proxyAddress) && this.proxyPort != null && this.proxyPort > 0) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyAddress, (int)this.proxyPort));
        }
        return null;
    }

    @Override
    public boolean set(SetAgentSecretReq params) {
        log.info("set secret, params:{}, operatorId:{}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getCorpId()), (Object)"corpId\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getAgentId() != null ? 1 : 0) != 0, (Object)"agentId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getSecret()), (Object)"secret\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getToken()), (Object)"token\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getAeskey()), (Object)"AESKey\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String corpId = params.getCorpId();
        Integer agentId = params.getAgentId();
        String secret = params.getSecret();
        String token = params.getToken();
        String aesKey = params.getAeskey();
        Date now = new Date();
        AgentToken record = this.agentTokenMapper.queryByBizId(bizId);
        if (record == null) {
            this.checkCorpId(bizId, corpId);
            record = new AgentToken();
            if (StringUtils.isNotBlank((CharSequence)params.getProxyAddress()) && params.getProxyPort() != null && params.getProxyPort() > 0) {
                record.setProxyAddress(params.getProxyAddress());
                record.setProxyPort(params.getProxyPort());
            } else if (StringUtils.isNotBlank((CharSequence)this.proxyAddress) && this.proxyPort != null && this.proxyPort > 0) {
                record.setProxyAddress(this.proxyAddress);
                record.setProxyPort(this.proxyPort);
            }
            this.setProxy(record);
            AccessToken accessToken = this.getAccessToken(corpId, secret);
            record.setBizId(bizId);
            record.setCorpId(corpId);
            record.setAgentId(agentId);
            record.setSecret(secret);
            record.setAccessToken(accessToken.getAccessToken());
            record.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            record.setToken(token);
            record.setAesKey(aesKey);
            record.setCreateTime(now);
            record.setUpdateTime(now);
            log.info("insert secret:{}", (Object)record);
            this.agentTokenMapper.insertSelective((Object)record);
        } else {
            if (corpId.equals(record.getCorpId()) && secret.equals(record.getSecret()) && agentId.equals(record.getAgentId()) && token.equals(record.getToken()) && aesKey.equals(record.getAesKey())) {
                log.info("nothing changed");
                return false;
            }
            this.checkCorpId(bizId, corpId);
            this.setProxy(record);
            AccessToken accessToken = this.getAccessToken(corpId, secret);
            record.setCorpId(corpId);
            record.setAgentId(agentId);
            record.setSecret(secret);
            record.setToken(params.getToken());
            record.setAesKey(params.getAeskey());
            if (!accessToken.getAccessToken().equals(record.getAccessToken())) {
                log.info("update access_token");
                record.setAccessToken(accessToken.getAccessToken());
                record.setExpireTime(new Date(now.getTime() + accessToken.getExpires() * 1000L));
            }
            record.setUpdateTime(now);
            log.info("update secret:{}", (Object)record);
            this.agentTokenMapper.updateByPrimaryKeySelective((Object)record);
            this.refreshTokenService.freshAgent2AccessToken(corpId, accessToken);
        }
        return true;
    }

    private void checkCorpId(Long bizId, String corpId) {
        WeworkCorp corp = this.weworkCorpMapper.getByBizId(bizId);
        Preconditions.checkArgument((corp != null ? 1 : 0) != 0, (Object)"\u4f01\u4e1a\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Preconditions.checkArgument((corp.getIsAuth() != 0 ? 1 : 0) != 0, (Object)"\u8be5\u4f01\u4e1a\u5df2\u53d6\u6d88\u6388\u6743");
        String authCorpId = corp.getAuthCorpId();
        if (!authCorpId.startsWith("wp")) {
            log.warn("\u4f01\u4e1aauth_corp_id\u662f\u660e\u6587!! bizId={}", (Object)bizId);
            Preconditions.checkArgument((boolean)Objects.equals(corpId, authCorpId), (Object)"\u4f01\u4e1acorpId\u4e0d\u6b63\u786e");
            return;
        }
        try {
            String providerAccessToken = this.providerTokenService.getProviderToken();
            String openCorpId = this.customizedApi.getOpenCorpId(providerAccessToken, corpId);
            Preconditions.checkArgument((boolean)Objects.equals(openCorpId, authCorpId), (Object)"\u4f01\u4e1acorpId\u4e0d\u6b63\u786e");
        }
        catch (WeworkException e) {
            if (Objects.equals(e.getErrorCode(), 2000002)) {
                throw new IllegalArgumentException("corpId\u53c2\u6570\u65e0\u6548");
            }
            log.error("\u67e5\u8be2\u4f01\u4e1a\u5bc6\u6587corpId\u5931\u8d25, bizId={}, corpId={}", new Object[]{bizId, corpId, e});
        }
    }

    private AccessToken getAccessToken(String corpId, String secret) {
        AccessToken accessToken = null;
        try {
            accessToken = this.accessTokenApi.getAccessToken(corpId, secret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, secret:{}", new Object[]{e.getMessage(), corpId, secret});
        }
        catch (Exception e) {
            log.error("Failed getting accessToken, corpId:{}, secret:{}", new Object[]{corpId, secret, e});
        }
        Preconditions.checkArgument((accessToken != null ? 1 : 0) != 0, (Object)"\u65e0\u6548\u7684secret");
        return accessToken;
    }

    @Override
    public GetAgentTokenCfg detail() {
        log.info("get token detail, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        WeworkCorp corp = this.weworkCorpMapper.getByBizId(bizId);
        Preconditions.checkArgument((corp != null ? 1 : 0) != 0, (Object)"corp\u4e3a\u7a7a");
        AgentToken record = this.agentTokenMapper.queryByBizId(bizId);
        GetAgentTokenCfg result = new GetAgentTokenCfg();
        result.setCallbackUrl(this.callbackUrl + corp.getNum());
        result.setWhiteList(this.whiteList);
        if (record == null) {
            result.setCorpId(null);
            result.setAgentId(null);
            result.setToken(TokenGen.getRandomToken());
            result.setAeskey(TokenGen.getRandomAESKey());
        } else {
            result.setCorpId(record.getCorpId());
            result.setAgentId(record.getAgentId());
            result.setSecret(record.getSecret());
            result.setToken(record.getToken());
            result.setAeskey(record.getAesKey());
        }
        return result;
    }

    @Override
    public String rndAeskey() {
        log.info("generate random aeskey, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String aesKey = TokenGen.getRandomAESKey();
        AgentToken record = this.agentTokenMapper.getCryptTokenByBizId(bizId);
        if (record != null) {
            record.setAesKey(aesKey);
            record.setUpdateTime(new Date());
            log.info("update aeskey:{}", (Object)record);
            this.agentTokenMapper.updateByPrimaryKeySelective((Object)record);
        }
        return aesKey;
    }

    @Override
    public String rndToken() {
        log.info("generate random token, operatorId:{}", (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((user.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e3a\u7a7a");
        Long bizId = user.getBizId();
        String token = TokenGen.getRandomToken();
        AgentToken record = this.agentTokenMapper.getCryptTokenByBizId(bizId);
        if (record != null) {
            record.setToken(token);
            record.setUpdateTime(new Date());
            log.info("update token:{}", (Object)record);
            this.agentTokenMapper.updateByPrimaryKeySelective((Object)record);
        }
        return token;
    }
}

