/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.setting.service.impl;

import cn.kinyun.wework.sdk.api.AgentApi;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.accesstoken.entity.CorpAgentToken;
import com.kuaike.scrm.dal.accesstoken.entity.CorpContactToken;
import com.kuaike.scrm.dal.accesstoken.entity.CorpCustomizedToken;
import com.kuaike.scrm.dal.accesstoken.entity.CorpExternalContactToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpAgentTokenMapper;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpContactTokenMapper;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpCustomizedTokenMapper;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpExternalContactTokenMapper;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpSuiteTokenMapper;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.chat.entity.WeworkChatSecret;
import com.kuaike.scrm.dal.chat.mapper.WeworkChatSecretMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.setting.dto.req.CheckSecretReq;
import com.kuaike.scrm.setting.dto.resp.CheckSecretResp;
import com.kuaike.scrm.setting.service.CheckSecretService;
import com.kuaike.scrm.token.service.SuiteTokenService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CheckSecretServiceImpl
implements CheckSecretService {
    private static final Logger log = LoggerFactory.getLogger(CheckSecretServiceImpl.class);
    @Value(value="${qyapi.suite.id}")
    private String suiteId;
    @Value(value="${qyapi.customized.id}")
    private String customizedId;
    @Autowired
    private SuiteTokenService suiteTokenService;
    @Autowired
    private AgentApi agentApi;
    @Autowired
    private CorpAgentTokenMapper corpAgentTokenMapper;
    @Autowired
    private CorpSuiteTokenMapper corpSuiteTokenMapper;
    @Autowired
    private CorpCustomizedTokenMapper corpCustomizedTokenMapper;
    @Autowired
    private WeworkChatSecretMapper weworkChatSecretMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private CorpContactTokenMapper corpContactTokenMapper;
    @Autowired
    private CorpExternalContactTokenMapper corpExternalContactTokenMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;

    @Override
    public CheckSecretResp checkAvailable(CheckSecretReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("checkAvailable with req={},corpId={},bizId={},userId={}", new Object[]{req, userInfo.getCorpId(), userInfo.getBizId(), userInfo.getId()});
        req.validate();
        return this.checkByModule(userInfo.getBizId(), userInfo.getCorpId(), req.getModule());
    }

    @Override
    public List<CheckSecretResp> checkAllAvailable() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("checkAvailable with corpId={},bizId={},userId={}", new Object[]{userInfo.getCorpId(), userInfo.getBizId(), userInfo.getId()});
        ArrayList resultList = Lists.newArrayList();
        for (int i = 1; i <= 8; ++i) {
            CheckSecretResp item = this.checkByModule(userInfo.getBizId(), userInfo.getCorpId(), i);
            resultList.add(item);
        }
        return resultList;
    }

    private CheckSecretResp checkByModule(Long bizId, String corpId, int module) {
        CheckSecretResp resp = null;
        switch (module) {
            case 1: {
                break;
            }
            case 2: {
                this.checkAgentSecret(corpId, module);
                break;
            }
            case 3: {
                this.checkContactSecret(corpId, module);
                break;
            }
            case 4: {
                this.checkExternalContactSecret(corpId, module);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                resp = this.checkChatSecret(bizId, module);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                resp = this.checkCustomizedApp(corpId, module);
                break;
            }
            default: {
                return null;
            }
        }
        if (resp != null) {
            return resp;
        }
        return new CheckSecretResp(true, "", null, module);
    }

    @Deprecated
    private CheckSecretResp checkAgentSecret(String corpId, int module) {
        CorpAgentToken agentToken = this.corpAgentTokenMapper.queryByCorpId(corpId);
        if (agentToken == null) {
            return new CheckSecretResp(false, "\u6ca1\u6709\u6388\u6743\u81ea\u5efa\u5e94\u7528", CheckSecretResp.NotAvailableType.NOT_CONFIG, module);
        }
        if (agentToken.getErrCode() != null && agentToken.getErrCode() != 0 || StringUtils.isNotBlank((CharSequence)agentToken.getErrBizMsg())) {
            String reason = StringUtils.isNotBlank((CharSequence)agentToken.getErrBizMsg()) ? agentToken.getErrBizMsg() : agentToken.getErrMsg();
            return new CheckSecretResp(false, reason, CheckSecretResp.NotAvailableType.CONFIG_ERROR, module);
        }
        return null;
    }

    @Deprecated
    private CheckSecretResp checkContactSecret(String corpId, int module) {
        CorpContactToken corpContactToken = this.corpContactTokenMapper.queryByCorpId(corpId);
        if (Objects.isNull(corpContactToken)) {
            return new CheckSecretResp(false, "\u6ca1\u6709\u6388\u6743\u901a\u8baf\u5f55", CheckSecretResp.NotAvailableType.NOT_CONFIG, module);
        }
        if (corpContactToken.getErrCode() != null && corpContactToken.getErrCode() != 0 || StringUtils.isNotBlank((CharSequence)corpContactToken.getErrBizMsg())) {
            String reason = StringUtils.isNotBlank((CharSequence)corpContactToken.getErrBizMsg()) ? corpContactToken.getErrBizMsg() : corpContactToken.getErrMsg();
            return new CheckSecretResp(false, reason, CheckSecretResp.NotAvailableType.CONFIG_ERROR, module);
        }
        return null;
    }

    @Deprecated
    private CheckSecretResp checkExternalContactSecret(String corpId, int module) {
        CorpExternalContactToken corpExternalContactToken = this.corpExternalContactTokenMapper.queryByCorpId(corpId);
        if (Objects.isNull(corpExternalContactToken)) {
            return new CheckSecretResp(false, "\u6ca1\u6709\u6388\u6743\u5ba2\u6237\u8054\u7cfb\u4eba", CheckSecretResp.NotAvailableType.NOT_CONFIG, module);
        }
        if (corpExternalContactToken.getErrCode() != null && corpExternalContactToken.getErrCode() != 0 || StringUtils.isNotBlank((CharSequence)corpExternalContactToken.getErrBizMsg())) {
            String reason = StringUtils.isNotBlank((CharSequence)corpExternalContactToken.getErrBizMsg()) ? corpExternalContactToken.getErrBizMsg() : corpExternalContactToken.getErrMsg();
            return new CheckSecretResp(false, reason, CheckSecretResp.NotAvailableType.CONFIG_ERROR, module);
        }
        return null;
    }

    private CheckSecretResp checkChatSecret(Long bizId, int module) {
        WeworkChatSecret secret = this.weworkChatSecretMapper.queryByBizId(bizId);
        if (Objects.isNull(secret)) {
            return new CheckSecretResp(false, "\u6ca1\u6709\u6388\u6743\u4f1a\u8bdd\u5b58\u6863", CheckSecretResp.NotAvailableType.NOT_CONFIG, module);
        }
        if (secret.getErrCode() != null && secret.getErrCode() != 0 || StringUtils.isNotBlank((CharSequence)secret.getErrBizMsg())) {
            String reason = StringUtils.isNotBlank((CharSequence)secret.getErrBizMsg()) ? secret.getErrBizMsg() : secret.getErrMsg();
            return new CheckSecretResp(false, reason, CheckSecretResp.NotAvailableType.CONFIG_ERROR, module);
        }
        return null;
    }

    private CheckSecretResp checkCustomizedApp(String corpId, int module) {
        CorpCustomizedToken corpCustomizedToken = this.corpCustomizedTokenMapper.getByCorpId(corpId, this.customizedId);
        if (corpCustomizedToken == null) {
            return new CheckSecretResp(false, "\u6ca1\u6709\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528", CheckSecretResp.NotAvailableType.NOT_CONFIG, module);
        }
        if (corpCustomizedToken.getIsAuth() == null || corpCustomizedToken.getIsAuth() == 0) {
            return new CheckSecretResp(false, "\u6ca1\u6709\u6388\u6743\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528", CheckSecretResp.NotAvailableType.NOT_CONFIG, module);
        }
        if (corpCustomizedToken.getDevStatus() != 2) {
            return new CheckSecretResp(false, "\u4ee3\u5f00\u53d1\u81ea\u5efa\u5e94\u7528\u914d\u7f6e\u672a\u5b8c\u6210", CheckSecretResp.NotAvailableType.CONFIG_ERROR, module);
        }
        return null;
    }
}

