/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.token.service.impl;

import cn.kinyun.wework.sdk.api.SuiteApi;
import cn.kinyun.wework.sdk.entity.suite.CorpToken;
import com.kuaike.scrm.dal.accesstoken.entity.CorpSuiteToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpSuiteTokenMapper;
import com.kuaike.scrm.token.service.ProviderTokenService;
import com.kuaike.scrm.token.service.SuiteTokenService;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@Deprecated
public class SuiteTokenServiceImpl
implements SuiteTokenService {
    private static final Logger log = LoggerFactory.getLogger(SuiteTokenServiceImpl.class);
    @Value(value="${qyapi.suite.id}")
    private String suiteId;
    @Autowired
    private SuiteApi suiteApi;
    @Autowired
    private CorpSuiteTokenMapper corpSuiteTokenMapper;
    @Autowired
    private ProviderTokenService providerTokenService;

    @Override
    public String getSuiteAccessToken(String corpId) {
        CorpSuiteToken corpSuiteToken = this.corpSuiteTokenMapper.getAccessToken(corpId, this.suiteId);
        if (corpSuiteToken == null) {
            log.warn("corp_suite_token not found, corpId:{}, suiteId:{}", (Object)corpId, (Object)this.suiteId);
            return null;
        }
        return this.getSuiteAccessToken(corpSuiteToken);
    }

    private String getSuiteAccessToken(CorpSuiteToken corpSuiteToken) {
        Date now = new Date();
        String token = corpSuiteToken.getAccessToken();
        Date expireTime = corpSuiteToken.getExpireTime();
        if (StringUtils.isNotBlank((CharSequence)token) && expireTime != null && expireTime.after(now)) {
            return token;
        }
        String permanentCode = corpSuiteToken.getPermanentCode();
        String suiteAccessToken = this.providerTokenService.getSuiteAccessToken(this.suiteId);
        if (StringUtils.isEmpty((CharSequence)suiteAccessToken)) {
            return null;
        }
        String authCorpId = corpSuiteToken.getAuthCorpId();
        CorpToken corpToken = null;
        try {
            corpToken = this.suiteApi.getCorpToken(suiteAccessToken, authCorpId, permanentCode);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6corpTokenError: param{}", (Object)corpSuiteToken, (Object)e);
        }
        if (Objects.isNull(corpToken)) {
            return null;
        }
        token = corpToken.getAccessToken();
        Long expires = corpToken.getExpires();
        expireTime = new Date(now.getTime() + expires * 1000L);
        CorpSuiteToken corpSuiteToken1 = new CorpSuiteToken();
        corpSuiteToken1.setId(corpSuiteToken.getId());
        corpSuiteToken1.setAccessToken(token);
        corpSuiteToken1.setExpireTime(expireTime);
        corpSuiteToken1.setUpdateTime(now);
        this.corpSuiteTokenMapper.updateByPrimaryKeySelective((Object)corpSuiteToken1);
        return token;
    }

    @Override
    public String getSuiteAccessTokenByAuthCorpId(String authCorpId) {
        CorpSuiteToken corpSuiteToken = this.corpSuiteTokenMapper.getAccessTokenByAuthCorpId(authCorpId, this.suiteId);
        if (corpSuiteToken == null) {
            log.warn("corp_suite_token not found, authCorpId:{}, suiteId:{}", (Object)authCorpId, (Object)this.suiteId);
            return null;
        }
        return this.getSuiteAccessToken(corpSuiteToken);
    }

    @Override
    public Integer getSuiteAgentId(String corpId) {
        return this.getSuiteAgentId(this.suiteId, corpId);
    }

    @Override
    public Integer getSuiteAgentId(String suiteId, String corpId) {
        CorpSuiteToken corpSuiteToken = this.corpSuiteTokenMapper.getAccessToken(corpId, suiteId);
        if (corpSuiteToken == null) {
            log.warn("corp_suite_token not found, corpId:{}, suiteId:{}", (Object)corpId, (Object)suiteId);
            return null;
        }
        return corpSuiteToken.getAgentId();
    }
}

