/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.token.service.impl;

import cn.kinyun.wework.sdk.api.AccessTokenApi;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.accesstoken.entity.CorpExternalPayToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpExternalPayTokenMapper;
import com.kuaike.scrm.token.service.ExternalPayTokenService;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ExternalPayServiceImpl
implements ExternalPayTokenService {
    private static final Logger log = LoggerFactory.getLogger(ExternalPayServiceImpl.class);
    @Resource
    private AccessTokenApi accessTokenApi;
    @Resource
    private CorpExternalPayTokenMapper externalPayTokenMapper;

    @Override
    public String getAccessToken(String corpId) {
        CorpExternalPayToken existRecord = this.externalPayTokenMapper.getAccessToken(corpId);
        if (existRecord == null) {
            log.warn("approve token not found, corpId:{}", (Object)corpId);
            return null;
        }
        Date now = new Date();
        String token = existRecord.getAccessToken();
        Date expireTime = existRecord.getExpireTime();
        if (StringUtils.isNotBlank((CharSequence)token) && expireTime != null && expireTime.after(now)) {
            return token;
        }
        String corpSecret = existRecord.getSecret();
        AccessToken accessToken = this.getAccessToken(corpId, corpSecret);
        token = accessToken != null ? accessToken.getAccessToken() : null;
        this.updateApproveAccessToken(existRecord.getBizId(), accessToken);
        return token;
    }

    private AccessToken getAccessToken(String corpId, String secret) {
        AccessToken accessToken = null;
        try {
            accessToken = this.accessTokenApi.getAccessToken(corpId, secret);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}, secret:{}", new Object[]{e.getMessage(), corpId, secret});
        }
        catch (Exception e) {
            log.error("Failed getting accessToken, corpId:{}, secret:{}", new Object[]{corpId, secret, e});
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(accessToken), (Object)"\u65e0\u6548\u7684secret");
        return accessToken;
    }

    private void updateApproveAccessToken(Long bizId, AccessToken accessToken) {
        if (accessToken == null) {
            return;
        }
        CorpExternalPayToken corpExternalPayToken = this.externalPayTokenMapper.getCryptToken(bizId);
        String token = accessToken.getAccessToken();
        Date now = new Date();
        Long expires = accessToken.getExpires();
        Date expireTime = new Date(now.getTime() + expires * 1000L);
        this.externalPayTokenMapper.updateAccessToken(corpExternalPayToken.getId(), token, expireTime, now, null, Integer.valueOf(0), null, null);
    }
}

