/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.token.service.impl;

import cn.kinyun.wework.sdk.entity.AccessToken;
import com.kuaike.scrm.dal.accesstoken.entity.CorpContactToken;
import com.kuaike.scrm.dal.accesstoken.entity.CorpExternalContactToken;
import com.kuaike.scrm.dal.accesstoken.entity.CorpMiniProgramToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpContactTokenMapper;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpExternalContactTokenMapper;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpMiniProgramTokenMapper;
import com.kuaike.scrm.dal.chat.entity.WeworkChatSecret;
import com.kuaike.scrm.dal.chat.mapper.WeworkChatSecretMapper;
import com.kuaike.scrm.token.service.CorpTokenService;
import com.kuaike.scrm.token.service.RefreshTokenService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CorpTokenServiceImpl
implements CorpTokenService {
    private static final Logger log = LoggerFactory.getLogger(CorpTokenServiceImpl.class);
    @Autowired
    private WeworkChatSecretMapper weworkChatSecretMapper;
    @Autowired
    private CorpContactTokenMapper corpContactTokenMapper;
    @Autowired
    private CorpExternalContactTokenMapper corpExternalContactTokenMapper;
    @Autowired
    private RefreshTokenService refreshTokenService;
    @Autowired
    private CorpMiniProgramTokenMapper corpMiniProgramTokenMapper;

    @Override
    public String getChatAccessToken(String corpId) {
        WeworkChatSecret existRecord = this.weworkChatSecretMapper.getAccessToken(corpId);
        if (existRecord == null) {
            log.warn("wework_chat_secret not found, corpId:{}", (Object)corpId);
            return null;
        }
        Date now = new Date();
        String token = existRecord.getAccessToken();
        Date expireTime = existRecord.getExpireTime();
        if (StringUtils.isNotBlank((CharSequence)token) && expireTime != null && expireTime.after(now)) {
            return token;
        }
        String corpSecret = existRecord.getSecret();
        AccessToken accessToken = this.refreshTokenService.getChatAccessToken(corpSecret, corpId);
        token = accessToken == null ? null : accessToken.getAccessToken();
        this.refreshTokenService.freshChatAccessToken(corpId, accessToken);
        return token;
    }

    @Override
    public String getContactAccessToken(String corpId) {
        CorpContactToken existRecord = this.corpContactTokenMapper.getAccessToken(corpId);
        if (existRecord == null) {
            log.warn("corp_contact_token not found, corpId:{}", (Object)corpId);
            return null;
        }
        Date now = new Date();
        String token = existRecord.getAccessToken();
        Date expireTime = existRecord.getExpireTime();
        if (StringUtils.isNotBlank((CharSequence)token) && expireTime != null && expireTime.after(now)) {
            return token;
        }
        String corpSecret = existRecord.getSecret();
        AccessToken accessToken = this.refreshTokenService.getContactAccessToken(corpSecret, corpId);
        token = accessToken == null ? null : accessToken.getAccessToken();
        this.refreshTokenService.freshContactAccessToken(corpId, accessToken);
        return token;
    }

    @Override
    public String getMiniProgramAccessToken(String corpId) {
        CorpMiniProgramToken existRecord = this.corpMiniProgramTokenMapper.getAccessToken(corpId);
        if (existRecord == null) {
            log.warn("mini_program_token not found, corpId:{}", (Object)corpId);
            return null;
        }
        Date now = new Date();
        String token = existRecord.getAccessToken();
        Date expireTime = existRecord.getExpireTime();
        if (StringUtils.isNotBlank((CharSequence)token) && expireTime != null && expireTime.after(now)) {
            return token;
        }
        String corpSecret = existRecord.getSecret();
        AccessToken accessToken = this.refreshTokenService.getMiniProgramAccessToken(corpSecret, corpId);
        token = accessToken == null ? null : accessToken.getAccessToken();
        this.refreshTokenService.freshMiniProgramAccessToken(corpId, accessToken);
        return token;
    }

    @Override
    public String getExternalContactAccessToken(String corpId) {
        CorpExternalContactToken existRecord = this.corpExternalContactTokenMapper.getAccessToken(corpId);
        if (existRecord == null) {
            log.warn("corp_external_contact_token not found, corpId:{}", (Object)corpId);
            return null;
        }
        Date now = new Date();
        String token = existRecord.getAccessToken();
        Date expireTime = existRecord.getExpireTime();
        if (StringUtils.isNotBlank((CharSequence)token) && expireTime != null && expireTime.after(now)) {
            return token;
        }
        String corpSecret = existRecord.getSecret();
        AccessToken accessToken = this.refreshTokenService.getExternalContactAccessToken(corpSecret, corpId);
        token = accessToken == null ? null : accessToken.getAccessToken();
        this.refreshTokenService.freshExternalContactAccessToken(corpId, accessToken);
        return token;
    }
}

