/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.token.service.impl;

import cn.kinyun.wework.sdk.api.JsSdkApi;
import cn.kinyun.wework.sdk.entity.AccessToken;
import cn.kinyun.wework.sdk.entity.Ticket;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.kuaike.scrm.dal.accesstoken.entity.CorpAgentToken;
import com.kuaike.scrm.dal.accesstoken.mapper.CorpAgentTokenMapper;
import com.kuaike.scrm.token.service.AgentTokenService;
import com.kuaike.scrm.token.service.RefreshTokenService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgentTokenServiceImpl
implements AgentTokenService {
    private static final Logger log = LoggerFactory.getLogger(AgentTokenServiceImpl.class);
    @Autowired
    private JsSdkApi jsSdkApi;
    @Autowired
    private CorpAgentTokenMapper corpAgentTokenMapper;
    @Autowired
    RefreshTokenService refreshTokenService;

    @Override
    public Integer getAgentId(String corpId) {
        return this.corpAgentTokenMapper.getAgentId(corpId);
    }

    @Override
    public String getJsapiTicket(String corpId) {
        CorpAgentToken existRecord = this.corpAgentTokenMapper.getJsapiTicket(corpId);
        if (existRecord == null) {
            log.warn("corp_agent_token not found, corpId:{}", (Object)corpId);
            return null;
        }
        Date now = new Date();
        String jsapiTicket = existRecord.getJsapiTicket();
        Date expireTime = existRecord.getJsapiTicketExpireTime();
        if (StringUtils.isNotBlank((CharSequence)jsapiTicket) && expireTime != null && expireTime.after(now)) {
            return jsapiTicket;
        }
        String accessToken = this.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684access_token\uff0c\u65e0\u6cd5\u83b7\u53d6jsapi_ticket");
            return null;
        }
        Ticket ticket = null;
        try {
            ticket = this.jsSdkApi.getJsapiTicket(accessToken);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}", new Object[]{e.getMessage(), corpId, e});
            return null;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6jsapi_ticket\u5931\u8d25, corpId:{}", (Object)corpId, (Object)e);
            return null;
        }
        jsapiTicket = ticket.getTicket();
        int expires = ticket.getExpires();
        expireTime = new Date(now.getTime() + (long)expires * 1000L);
        CorpAgentToken corpAgentToken = new CorpAgentToken();
        corpAgentToken.setId(existRecord.getId());
        corpAgentToken.setJsapiTicket(jsapiTicket);
        corpAgentToken.setJsapiTicketExpireTime(expireTime);
        corpAgentToken.setUpdateTime(now);
        this.corpAgentTokenMapper.updateByPrimaryKeySelective((Object)corpAgentToken);
        return jsapiTicket;
    }

    @Override
    public String getAgentTicket(String corpId) {
        CorpAgentToken existRecord = this.corpAgentTokenMapper.getAgentTicket(corpId);
        if (existRecord == null) {
            log.warn("corp_agent_token not found, corpId:{}", (Object)corpId);
            return null;
        }
        Date now = new Date();
        String agentTicket = existRecord.getAgentTicket();
        Date expireTime = existRecord.getAgentTicketExpireTime();
        if (StringUtils.isNotBlank((CharSequence)agentTicket) && expireTime != null && expireTime.after(now)) {
            return agentTicket;
        }
        String accessToken = this.getAgentAccessToken(corpId);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            log.warn("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684access_token\uff0c\u65e0\u6cd5\u83b7\u53d6agent_ticket");
            return null;
        }
        Ticket ticket = null;
        try {
            ticket = this.jsSdkApi.getAgentTicket(accessToken);
        }
        catch (WeworkException e) {
            log.error("{}, corpId:{}", new Object[]{e.getMessage(), corpId, e});
            return null;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6agent_ticket\u5931\u8d25, corpId:{}", (Object)corpId, (Object)e);
            return null;
        }
        agentTicket = ticket.getTicket();
        int expires = ticket.getExpires();
        expireTime = new Date(now.getTime() + (long)expires * 1000L);
        CorpAgentToken corpAgentToken = new CorpAgentToken();
        corpAgentToken.setId(existRecord.getId());
        corpAgentToken.setAgentTicket(agentTicket);
        corpAgentToken.setAgentTicketExpireTime(expireTime);
        corpAgentToken.setUpdateTime(now);
        this.corpAgentTokenMapper.updateByPrimaryKeySelective((Object)corpAgentToken);
        return agentTicket;
    }

    @Override
    public String getAgentAccessToken(String corpId) {
        CorpAgentToken existRecord = this.corpAgentTokenMapper.getAccessToken(corpId);
        if (existRecord == null) {
            log.warn("corp_agent_token not found, corpId:{}", (Object)corpId);
            return null;
        }
        return this.getAccessToken(corpId, existRecord);
    }

    @Override
    public String getAgentAccessToken(String corpId, Integer agentId) {
        CorpAgentToken existRecord = this.corpAgentTokenMapper.getAccessTokenWithAgentId(corpId, agentId);
        if (existRecord == null) {
            log.warn("corp_agent_token not found, corpId:{}, angetId:{}", (Object)corpId, (Object)agentId);
            return null;
        }
        return this.getAccessToken(corpId, existRecord);
    }

    private String getAccessToken(String corpId, CorpAgentToken existRecord) {
        Date now = new Date();
        String token = existRecord.getAccessToken();
        Date expireTime = existRecord.getExpireTime();
        if (StringUtils.isNotBlank((CharSequence)token) && expireTime != null && expireTime.after(now)) {
            return token;
        }
        String corpSecret = existRecord.getSecret();
        AccessToken accessToken = this.refreshTokenService.getAgentToken(corpSecret, corpId);
        if (accessToken != null) {
            token = accessToken.getAccessToken();
        }
        this.refreshTokenService.freshCorpAgentAccessToken(corpId, accessToken);
        return token;
    }
}

