/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.link.common_dto.dto.BaseRequest;
import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.common_dto.enums.OpPlatform;
import cn.kinyun.link.service.OperateService;
import cn.kinyun.link.service.response.WeworkStatusInfo;
import cn.kinyun.scrm.page.auth.service.WeworkOauthService;
import cn.kinyun.scrm.vip.dto.OpenVipUserListDto;
import cn.kinyun.scrm.vip.dto.OpenVipUserReq;
import cn.kinyun.scrm.vip.dto.SelectOpenUserDto;
import cn.kinyun.scrm.vip.dto.req.OnlineReq;
import cn.kinyun.scrm.vip.dto.resp.OnlineResp;
import cn.kinyun.scrm.vip.dto.resp.OpenSettingResp;
import cn.kinyun.scrm.vip.dto.resp.VipOpenLogResp;
import cn.kinyun.scrm.vip.dto.resp.VipStatusResp;
import cn.kinyun.scrm.vip.service.BizOpenSettingService;
import cn.kinyun.scrm.vip.service.VipSettingService;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.vip.dto.VipUserDto;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAccount;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAuthorizeAccount;
import com.kuaike.scrm.dal.vip.entity.VipWeworkSetting;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkSettingMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.synctask.service.VipWeworkChatRoomSyncService;
import com.kuaike.scrm.synctask.service.VipWeworkContactSyncService;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VipSettingServiceImpl
implements VipSettingService {
    private static final Logger log = LoggerFactory.getLogger(VipSettingServiceImpl.class);
    @Value(value="${scrm.vip.elasticsearch.onOffLineMsg}")
    private String onlineIndex;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}/memberAuthSuccess")
    private String redirectUrl;
    private static final String OAUTH_TEMPLATE = "\u60a8\u6b63\u5728\u5f00\u901a\u3010\u4f01\u5fae\u8425\u9500\u5b9d\u3011\u5e94\u7528 (\u6ce8\uff1a\u8bf7\u4fdd\u6301\u4e8c\u7ef4\u7801\u9ed8\u8ba4\u52fe\u9009\uff0c \u5426\u5219\u4f1a\u9a8c\u8bc1\u5931\u8d25)\uff0c\u8bf7\u70b9\u51fb\u6388\u6743 <a href=\"{0}\">>>\u6388\u6743</a>";
    private static final String TYPE = "doc";
    @Autowired
    private VipWeworkAccountMapper vipWeworkAccountMapper;
    @Autowired
    private VipWeworkSettingMapper vipWeworkSettingMapper;
    @Autowired
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private BizOpenSettingService openSettingService;
    @Autowired(required=false)
    private OperateService operateService;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private RemindService remindService;
    @Autowired
    private WeworkOauthService weworkOauthService;
    @Autowired
    private VipWeworkChatRoomSyncService vipWeworkChatRoomSyncService;
    @Autowired
    private VipWeworkContactSyncService vipWeworkContactSyncService;

    @Override
    public List<VipOpenLogResp> queryOpenLogList() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("queryOpenLogList bizId: {}, uid\uff1a{}", (Object)userInfo.getBizId(), (Object)userInfo.getId());
        List settingList = this.vipWeworkSettingMapper.queryAllSettingBy(userInfo.getCorpId());
        if (CollectionUtils.isEmpty((Collection)settingList)) {
            return null;
        }
        ArrayList settingLogs = Lists.newArrayList();
        for (VipWeworkSetting setting : settingList) {
            VipOpenLogResp log = new VipOpenLogResp();
            settingLogs.add(log);
            log.setOpenType(setting.getAddType());
            log.setVipCount(setting.getVipCount());
            log.setExpansionCount(setting.getExpansionCount());
            log.setEndTime(setting.getEndTime());
            log.setCreateTime(setting.getCreateTime());
        }
        return settingLogs;
    }

    @Override
    public VipStatusResp queryOpenStatus() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("queryOpenLogList bizId: {}, uid\uff1a{}", (Object)userInfo.getBizId(), (Object)userInfo.getId());
        OpenSettingResp resp = this.openSettingService.getVipDetail(userInfo.getCorpId());
        log.info("queryOpenStatus get resp: {}", (Object)resp);
        if (resp == null) {
            return null;
        }
        VipStatusResp statusResp = new VipStatusResp();
        statusResp.setVipCount(resp.getVipCount());
        statusResp.setEndTime(resp.getEndTime());
        statusResp.setRemainDays(resp.getOpenPeriod());
        return statusResp;
    }

    @Override
    public void resetVipUser(String corpId) {
        log.info("resetVipUser corpId: {}", (Object)corpId);
        List accountList = this.vipWeworkAuthorizeAccountMapper.queryExpiredAccount(corpId);
        if (CollectionUtils.isEmpty((Collection)accountList)) {
            log.info("resetVipUser query accountList is empty");
            return;
        }
        List vipUserNums = accountList.stream().map(VipWeworkAuthorizeAccount::getWeworkUserNum).collect(Collectors.toList());
        log.info("resetVipUser query vipUserNums: {}", vipUserNums);
        List weworkUsers = this.weworkUserMapper.getWeworkUserIdsByNum(corpId, vipUserNums);
        if (CollectionUtils.isEmpty((Collection)weworkUsers)) {
            log.info("resetVipUser query weworkUsers is empty");
            return;
        }
        List weworkDigitId = weworkUsers.stream().map(WeworkUser::getWeworkDigitId).collect(Collectors.toList());
        log.info("resetVipUser query weworkDigitId: {}", weworkDigitId);
        if (CollectionUtils.isNotEmpty(weworkDigitId)) {
            for (WeworkUser weworkUser : weworkUsers) {
                BaseRequest baseRequest = new BaseRequest();
                baseRequest.setBizId(weworkUser.getBizId());
                baseRequest.setCorpId(weworkUser.getCorpId());
                baseRequest.setOpPlatform(Integer.valueOf(OpPlatform.MANAGER.getType()));
                baseRequest.setWeworkId(weworkUser.getWeworkDigitId());
                BaseResponse response = this.operateService.banAccount(baseRequest);
                log.info("resetVipUser get response: {}", (Object)response);
                if (response == null || response.getCode() != 0L) continue;
                this.vipWeworkAuthorizeAccountMapper.resetAuthAccount(corpId, (List)Lists.newArrayList((Object[])new String[]{weworkUser.getNum()}));
            }
        }
    }

    @Override
    public List<OnlineResp> getOnlineLog(OnlineReq req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("queryOpenLogList bizId: {}, uid\uff1a{}", (Object)userInfo.getBizId(), (Object)userInfo.getId());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)req.getWeworkUserNum()), (Object)"\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(req.getWeworkUserNum());
        if (weworkUser == null || weworkUser.getWeworkDigitId() == null) {
            log.info("queryOpenLogList query weworkUser is empty");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8be5\u6210\u5458\u672a\u6388\u6743\u767b\u5f55");
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"bizId", (Object)userInfo.getBizId())).must((QueryBuilder)QueryBuilders.termQuery((String)"weworkId", (String)weworkUser.getWeworkDigitId()));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.onlineIndex});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("time", SortOrder.DESC);
        if (Objects.isNull(req.getPageDto())) {
            searchSourceBuilder.size(20);
            searchSourceBuilder.from(0);
        } else {
            searchSourceBuilder.size(req.getPageDto().getPageSize().intValue());
            searchSourceBuilder.from(req.getPageDto().getOffset());
        }
        searchRequest.source(searchSourceBuilder);
        log.info("searchRequest: {}", (Object)searchRequest);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
        }
        if (Objects.isNull(searchResponse)) {
            log.info("searchResponse is  null");
            return null;
        }
        ArrayList logList = Lists.newArrayList();
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        long totalHits = hits.getTotalHits();
        if (req.getPageDto() != null) {
            req.getPageDto().setCount(Integer.valueOf((int)totalHits));
            req.getPageDto().setCurPageCount(Integer.valueOf(searchHits.length));
        }
        Stream.of(searchHits).forEach(searchHit -> {
            String sourceAsString = searchHit.getSourceAsString();
            OnlineResp onlineResp = (OnlineResp)JSON.parseObject((String)sourceAsString, OnlineResp.class);
            logList.add(onlineResp);
        });
        return logList;
    }

    @Override
    @Transactional
    public void openVipUser(SelectOpenUserDto params) {
        log.info("open vip user params: {}", (Object)params);
        params.validate();
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long userId = LoginUtils.getCurrentUserId();
        String corpId = LoginUtils.getCurrentUserCorpId();
        int portCount = 0;
        VipStatusResp vipStatus = this.queryOpenStatus();
        if (vipStatus == null) {
            log.warn("vip status is null");
            return;
        }
        if (vipStatus.getVipCount() == null || vipStatus.getVipCount() <= 0) {
            log.warn("vip count is null or 0");
        } else {
            portCount = vipStatus.getVipCount();
        }
        if (portCount < params.getWeworkUserNums().size()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6388\u6743\u7aef\u53e3\u5df2\u8fbe\u4e0a\u9650");
        }
        List existsList = this.vipWeworkAuthorizeAccountMapper.queryAuthAccount(bizId);
        Map userNumMap = existsList.stream().collect(Collectors.toMap(VipWeworkAuthorizeAccount::getWeworkUserNum, Function.identity()));
        ArrayList addList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        Date curTime = new Date();
        for (String weworkUserNum : params.getWeworkUserNums()) {
            if (userNumMap.containsKey(weworkUserNum)) {
                VipWeworkAuthorizeAccount updateAccount = (VipWeworkAuthorizeAccount)userNumMap.get(weworkUserNum);
                updateAccount.setUpdateBy(userId);
                updateAccount.setUpdateTime(curTime);
                updateAccount.setIsDeleted(Integer.valueOf(0));
                updateAccount.setEndTime(vipStatus.getEndTime());
                updateList.add(updateAccount);
                userNumMap.remove(weworkUserNum);
                continue;
            }
            VipWeworkAuthorizeAccount addAccount = new VipWeworkAuthorizeAccount();
            addAccount.setNum(this.idGen.getNum());
            addAccount.setBizId(bizId);
            addAccount.setCorpId(corpId);
            addAccount.setWeworkUserNum(weworkUserNum);
            addAccount.setEndTime(vipStatus.getEndTime());
            addAccount.setIsDeleted(Integer.valueOf(0));
            addAccount.setCreateBy(userId);
            addAccount.setUpdateBy(userId);
            addAccount.setCreateTime(curTime);
            addAccount.setUpdateTime(curTime);
            addList.add(addAccount);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            this.vipWeworkAuthorizeAccountMapper.batchInsert((Collection)addList);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            this.vipWeworkAuthorizeAccountMapper.batchUpdate((Collection)updateList);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList) || CollectionUtils.isNotEmpty((Collection)updateList)) {
            this.vipWeworkChatRoomSyncService.sync();
            this.vipWeworkContactSyncService.sync();
        }
        if (CollectionUtils.isNotEmpty(userNumMap.keySet())) {
            List ids = userNumMap.values().stream().filter(it -> it.getIsDeleted() == 0).map(it -> it.getId()).collect(Collectors.toList());
            Set<String> weworkUserNums = userNumMap.values().stream().filter(it -> it.getIsDeleted() == 0).map(it -> it.getWeworkUserNum()).collect(Collectors.toSet());
            this.vipWeworkAuthorizeAccountMapper.batchDel(userId, ids);
            this.cancelOpenVip(bizId, corpId, weworkUserNums);
        }
    }

    private void cancelOpenVip(Long bizId, String corpId, Collection<String> weworkUserNums) {
        log.info("cancel openvip weworkUserNums: {}", weworkUserNums);
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            log.warn("cancelOpenVip weworkUserNums is empty");
            return;
        }
        List vipUsers = this.weworkUserMapper.queryVipUser(bizId, weworkUserNums);
        if (CollectionUtils.isNotEmpty((Collection)vipUsers)) {
            List weworkIds = vipUsers.stream().map(it -> it.getWeworkDigitId()).collect(Collectors.toList());
            log.info("kick off weworkIds: {}", weworkIds);
            for (String weworkId : weworkIds) {
                BaseRequest baseRequest = new BaseRequest();
                baseRequest.setBizId(bizId);
                baseRequest.setCorpId(corpId);
                baseRequest.setOpPlatform(Integer.valueOf(OpPlatform.MANAGER.getType()));
                baseRequest.setWeworkId(weworkId);
                BaseResponse response = this.operateService.banAccount(baseRequest);
                log.info("kick off line base response: {}, weworkId: {}", (Object)response, (Object)weworkId);
            }
        } else {
            log.warn("cancelOpenVip vipUsers is empty: {}", weworkUserNums);
        }
    }

    @Override
    public List<OpenVipUserListDto> list(OpenVipUserReq params) {
        PageDto pageDto;
        log.info("openList params: {}", (Object)params);
        params.validate();
        Long bizId = LoginUtils.getCurrentUserBizId();
        List list = this.vipWeworkAuthorizeAccountMapper.queryOpenVipList(bizId, params.getUserName());
        List weworkDigitIds = list.stream().map(VipUserDto::getWeworkDigitId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List result = BeanUtil.convertToList((Collection)list, OpenVipUserListDto.class, (String[])new String[0]);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return result;
        }
        BaseResponse weworksStatus = this.operateService.queryWeworksStatus(bizId, weworkDigitIds);
        HashMap weworkOnlineMap = Maps.newHashMap();
        if (weworksStatus != null && weworksStatus.getCode() == 0L) {
            List statusData = (List)weworksStatus.getData();
            if (CollectionUtils.isEmpty((Collection)statusData)) {
                log.warn("wework online status is empty");
            } else {
                for (WeworkStatusInfo statusInfo : statusData) {
                    weworkOnlineMap.put(statusInfo.getWeworkId(), statusInfo.isOnline() ? 1 : 0);
                }
            }
        }
        List vipWeworkAccounts = this.vipWeworkAccountMapper.queryListByWeworkIds(weworkDigitIds);
        HashMap accountLoginTimeMap = Maps.newHashMap();
        for (VipWeworkAccount weworkAccount : vipWeworkAccounts) {
            accountLoginTimeMap.put(weworkAccount.getWeworkId(), weworkAccount.getLoginTime());
        }
        for (OpenVipUserListDto dto : result) {
            dto.setLastLoginTime((Date)accountLoginTimeMap.get(dto.getWeworkDigitId()));
            dto.setStatus(weworkOnlineMap.getOrDefault(dto.getWeworkDigitId(), 0));
            if (StringUtils.isNotBlank((CharSequence)dto.getVcode())) {
                dto.setOauthStatus(1);
                continue;
            }
            dto.setOauthStatus(0);
        }
        if (params.getStatus() != null) {
            result = result.stream().filter(it -> it.getStatus().compareTo(params.getStatus()) == 0).collect(Collectors.toList());
        }
        if ((pageDto = params.getPageDto()) != null) {
            pageDto.setCount(Integer.valueOf(result.size()));
            int indexStart = Math.min(pageDto.getOffset(), result.size());
            int indexEnd = Math.min(indexStart + pageDto.getPageSize(), result.size());
            result = result.subList(indexStart, indexEnd);
        }
        return result;
    }

    @Override
    public void sendOauthUrl(List<String> weworkUserNums) {
        String corpId = LoginUtils.getCurrentUserCorpId();
        List weworkUsers = this.weworkUserMapper.queryWeworkUsersByNums(corpId, weworkUserNums);
        if (CollectionUtils.isEmpty((Collection)weworkUsers)) {
            log.info("sendOauthUrl weworkUsers is empty: {}", (Object)weworkUsers);
            return;
        }
        String oauthUrl = this.weworkOauthService.getOAuthUrl(this.redirectUrl);
        String sendContent = MessageFormat.format(OAUTH_TEMPLATE, oauthUrl);
        for (WeworkUser weworkUser : weworkUsers) {
            if (StringUtils.isNotBlank((CharSequence)weworkUser.getQrCode())) {
                log.info("weworkUser qrcode is not empty: {}", (Object)weworkUser);
                continue;
            }
            try {
                log.info("form send oauth url msg sendTarget: {}, sendContent: {}", (Object)weworkUser.getWeworkUserId(), (Object)sendContent);
                String requestId = this.remindService.asyncSendMsg(weworkUser.getCorpId(), weworkUser.getWeworkUserId(), sendContent);
                log.info("send oauth url SendMsgResult requestId: {}", (Object)requestId);
            }
            catch (Exception e) {
                log.error("send oauth url error:", (Throwable)e);
            }
        }
    }
}

