/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.resp.CrmLeadsInfoResp;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.scrm.vip.dto.UserVipStatusDto;
import cn.kinyun.scrm.vip.dto.req.OneClickAddReqDto;
import cn.kinyun.scrm.vip.dto.req.VipAddFriendAddReqDto;
import cn.kinyun.scrm.vip.dto.req.VipAddFriendApplyReqDto;
import cn.kinyun.scrm.vip.dto.req.VipAddFriendDetailReqDto;
import cn.kinyun.scrm.vip.dto.req.VipAddFriendListReqDto;
import cn.kinyun.scrm.vip.dto.req.VipAllocDto;
import cn.kinyun.scrm.vip.dto.resp.VipAddFriendListRespDto;
import cn.kinyun.scrm.vip.service.VipFriendService;
import cn.kinyun.scrm.vip.service.VipWeworkService;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.dto.addfriend.TelAndRemarkDto;
import com.kuaike.scrm.common.enums.TelAddFriendStatus;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.enums.addfriend.AddFriendsTaskType;
import com.kuaike.scrm.common.enums.addfriend.FilteredLeadsEnum;
import com.kuaike.scrm.common.enums.addfriend.TelAddType;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.CachePhoneService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.teladdfriend.dto.DetailListReqDto;
import com.kuaike.scrm.dal.teladdfriend.dto.ListReqDto;
import com.kuaike.scrm.dal.teladdfriend.dto.TaskMobileDto;
import com.kuaike.scrm.dal.teladdfriend.dto.VipAddFriendDetailDto;
import com.kuaike.scrm.dal.teladdfriend.dto.VipAddFriendRecordDto;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTask;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTaskCriteria;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTaskDetail;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTaskDetailCriteria;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskDetailMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskMapper;
import com.kuaike.scrm.dal.vip.dto.VipUserDto;
import com.kuaike.scrm.dal.vip.entity.VipFriendSendRecord;
import com.kuaike.scrm.dal.vip.mapper.VipFriendSendRecordMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.teladdfriend.dto.TelAddFriendAddReqDto;
import com.kuaike.scrm.teladdfriend.service.TelAddFriendService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VipFriendServiceImpl
implements VipFriendService {
    private static final Logger log = LoggerFactory.getLogger(VipFriendServiceImpl.class);
    @Autowired
    private TelAddFriendTaskMapper telAddFriendTaskMapper;
    @Autowired
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private CrmLeadsService crmLeadsService;
    @Autowired
    private VipFriendSendRecordMapper vipFriendSendRecordMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private CachePhoneService cachePhoneService;
    @Resource
    private AppBindingsMapper appBindingsMapper;
    @Value(value="${app.yingxiaobao.code:yingxiaobao}")
    private String yingxiaobaoCode;
    @Autowired
    private CcCustomerNumService customerNumService;
    @Resource
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;
    @Autowired
    private CcCustomerDetailService ccCustomerDetailService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private VipWeworkService vipWeworkService;
    @Autowired
    private TelAddFriendService telAddFriendService;

    @Override
    public List<VipAddFriendListRespDto> taskList(VipAddFriendListReqDto reqDto) {
        log.info("vip add friend taskList:{}", (Object)reqDto);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        StopWatchDto timer = new StopWatchDto("taskList", true, log);
        timer.start("convert");
        ListReqDto req = (ListReqDto)BeanUtil.convert((Object)reqDto, ListReqDto.class, (String[])new String[0]);
        req.setCorpId(currentUser.getCorpId());
        req.setManageUserIds(this.userRoleCommonService.getManageUserIds());
        req.setTaskType(Integer.valueOf(1));
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCreateBy())) {
            req.setCreateBy(this.userMapper.getIdByNum(reqDto.getCreateBy()));
        }
        timer.stop();
        timer.start("vipList");
        List taskList = this.telAddFriendTaskMapper.vipList(req);
        if (CollectionUtils.isEmpty((Collection)taskList)) {
            log.info("\u6839\u636ereq:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req);
            return Collections.emptyList();
        }
        if (Objects.nonNull(req.getPageDto())) {
            Integer count = this.telAddFriendTaskMapper.listCount(req);
            req.getPageDto().setCount(count);
        }
        timer.stop();
        timer.start("for");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)taskList.size());
        for (TelAddFriendTask task : taskList) {
            VipAddFriendListRespDto dto = new VipAddFriendListRespDto();
            dto.setCreateTime(task.getCreateTime());
            dto.setTaskNum(task.getNum());
            dto.setImportTelCount(task.getImportCount());
            dto.setCreateName(task.getCreateName());
            dto.setTaskName(task.getTaskName());
            dto.setWeworkUserNameList(StringUtils.isNotEmpty((CharSequence)task.getWeworkUserNames()) ? Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)task.getWeworkUserNames()) : Lists.newArrayList());
            List countStrList = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)task.getCountStr());
            if (CollectionUtils.isNotEmpty((Collection)countStrList) && countStrList.size() >= 2) {
                dto.setApplyCount(Integer.valueOf((String)countStrList.get(0)));
                dto.setSuccessCount(Integer.valueOf((String)countStrList.get(1)));
            } else {
                dto.setApplyCount(0);
                dto.setSuccessCount(0);
            }
            result.add(dto);
        }
        timer.stop();
        timer.print();
        return result;
    }

    @Override
    public List<VipAddFriendDetailDto> detailList(VipAddFriendDetailReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("vip add friend detailList:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        DetailListReqDto req = (DetailListReqDto)BeanUtil.convert((Object)reqDto, DetailListReqDto.class, (String[])new String[0]);
        req.setCorpId(currentUser.getCorpId());
        req.setManageUserIds(this.userRoleCommonService.getManageUserIds());
        req.setTaskType(Integer.valueOf(1));
        req.setTaskNum(reqDto.getNum());
        List detailList = this.telAddFriendTaskDetailMapper.vipDetailList(req);
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            log.info("\u6839\u636e\u6761\u4ef6:{}\u672a\u67e5\u5904\u5230\u8bb0\u5f55", (Object)req);
            return Collections.emptyList();
        }
        HashSet tagIds = Sets.newHashSet();
        for (VipAddFriendDetailDto detailDto : detailList) {
            if (!StringUtils.isNotEmpty((CharSequence)detailDto.getTagIds())) continue;
            List tags = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)detailDto.getTagIds());
            tagIds.addAll(tags);
            detailDto.setTagIdList(tags);
        }
        if (Objects.nonNull(req.getPageDto())) {
            Integer count = this.telAddFriendTaskDetailMapper.detailListCount(req);
            req.getPageDto().setCount(count);
        }
        Map tagMap = null;
        if (CollectionUtils.isNotEmpty((Collection)tagIds)) {
            tagMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(currentUser.getCorpId(), (Collection)tagIds);
        }
        HashMap contactDetailMap = Maps.newHashMap();
        List contactIds = detailList.stream().map(VipAddFriendDetailDto::getContactId).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(contactIds) && reqDto.getApply() != 1) {
            Map numMap = this.ccCustomerNumService.butchGetCustomerNumByContactId(currentUser.getBizId(), contactIds);
            HashBiMap biMap = HashBiMap.create((Map)numMap);
            List detailRespList = this.ccCustomerDetailService.queryCustomerDetails(currentUser.getBizId(), numMap.values());
            Map numDetailMap = detailRespList.stream().collect(Collectors.toMap(CustomerDetailResp::getCustomerNum, Function.identity()));
            numDetailMap.entrySet().forEach(arg_0 -> VipFriendServiceImpl.lambda$detailList$0(contactDetailMap, (BiMap)biMap, arg_0));
        }
        for (VipAddFriendDetailDto detailDto : detailList) {
            TelAddType telAddType;
            TelAddFriendStatus telAddFriendStatus;
            if (CollectionUtils.isNotEmpty((Collection)detailDto.getTagIdList())) {
                ArrayList tagNames = Lists.newArrayList();
                for (String tagId : detailDto.getTagIdList()) {
                    if (!MapUtils.isNotEmpty((Map)tagMap) || !tagMap.containsKey(tagId)) continue;
                    tagNames.add(tagMap.get(tagId));
                }
                detailDto.setTagNames((List)tagNames);
            }
            if (Objects.nonNull(telAddFriendStatus = TelAddFriendStatus.getTelAddFriendStatus((Integer)detailDto.getStatus()))) {
                detailDto.setStatusDesc(telAddFriendStatus.getDesc());
            }
            if (Objects.nonNull(telAddType = TelAddType.get((int)detailDto.getAddType()))) {
                detailDto.setAddTypeDesc(telAddType.getDesc());
            }
            if (!MapUtils.isNotEmpty((Map)contactDetailMap) || !StringUtils.isNotBlank((CharSequence)detailDto.getContactId())) continue;
            if (StringUtils.isBlank((CharSequence)detailDto.getRemark())) {
                detailDto.setRemark(contactDetailMap.getOrDefault(detailDto.getContactId(), new CustomerDetailResp()).getName());
            }
            String customerNum = contactDetailMap.getOrDefault(detailDto.getContactId(), new CustomerDetailResp()).getCustomerNum();
            detailDto.setCustomerNum(customerNum);
        }
        return detailList;
    }

    @Override
    public List<VipAddFriendDetailDto> queryAddDetail(VipAddFriendDetailReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("vip add friend queryAddDetail:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        TelAddFriendTaskDetail telAddFriendTaskDetail = this.telAddFriendTaskDetailMapper.selectByDetailNum(reqDto.getNum());
        if (telAddFriendTaskDetail == null || StringUtils.isBlank((CharSequence)telAddFriendTaskDetail.getTel())) {
            return Collections.emptyList();
        }
        TelAddFriendTaskDetailCriteria telAddFriendTaskDetailQuery = new TelAddFriendTaskDetailCriteria();
        telAddFriendTaskDetailQuery.createCriteria().andCorpIdEqualTo(currentUser.getCorpId()).andTelEqualTo(telAddFriendTaskDetail.getTel());
        telAddFriendTaskDetailQuery.setOrderByClause("create_time desc");
        List detailList = this.telAddFriendTaskDetailMapper.selectByExample((Object)telAddFriendTaskDetailQuery);
        List taskNums = detailList.stream().map(TelAddFriendTaskDetail::getTaskNum).collect(Collectors.toList());
        TelAddFriendTaskCriteria telAddFriendTaskCriteria = new TelAddFriendTaskCriteria();
        telAddFriendTaskCriteria.createCriteria().andNumIn(taskNums);
        List telAddFriendTasks = this.telAddFriendTaskMapper.selectByExample((Object)telAddFriendTaskCriteria);
        Map<String, String> taskNameMap = telAddFriendTasks.stream().collect(Collectors.toMap(TelAddFriendTask::getNum, TelAddFriendTask::getTaskName));
        ArrayList result = Lists.newArrayListWithExpectedSize((int)detailList.size());
        for (TelAddFriendTaskDetail taskDetail : detailList) {
            VipAddFriendDetailDto vipAddFriendDetailDto = new VipAddFriendDetailDto();
            vipAddFriendDetailDto.setDetailNum(taskDetail.getNum());
            vipAddFriendDetailDto.setTaskNum(taskDetail.getTaskNum());
            vipAddFriendDetailDto.setCreateTime(taskDetail.getCreateTime());
            vipAddFriendDetailDto.setTaskName(taskNameMap.get(taskDetail.getTaskNum()));
            result.add(vipAddFriendDetailDto);
        }
        List recordList = this.vipFriendSendRecordMapper.selectByMobile(currentUser.getBizId(), telAddFriendTaskDetail.getTel());
        if (CollectionUtils.isEmpty((Collection)recordList)) {
            return result;
        }
        List weworkUserNums = recordList.stream().map(VipFriendSendRecord::getWeworkUserNum).collect(Collectors.toList());
        Map weworkUserNameMap = this.weworkUserMapper.queryWeworkUserNameMapByNums(currentUser.getCorpId(), weworkUserNums);
        HashMap<String, List> recordMap = new HashMap<String, List>();
        for (VipFriendSendRecord sendRecord : recordList) {
            VipAddFriendRecordDto recordDto = (VipAddFriendRecordDto)BeanUtil.convert((Object)sendRecord, VipAddFriendRecordDto.class, (String[])new String[0]);
            recordDto.setWeworkUserName((String)weworkUserNameMap.get(sendRecord.getWeworkUserNum()));
            if (recordMap.containsKey(sendRecord.getTaskDetailNum())) {
                List recordDtos = (List)recordMap.get(sendRecord.getTaskDetailNum());
                recordDtos.add(recordDto);
                recordMap.put(sendRecord.getTaskDetailNum(), recordDtos);
                continue;
            }
            recordMap.put(sendRecord.getTaskDetailNum(), Lists.newArrayList((Object[])new VipAddFriendRecordDto[]{recordDto}));
        }
        for (VipAddFriendDetailDto detailDto : result) {
            detailDto.setRecords((List)recordMap.get(detailDto.getDetailNum()));
        }
        return result;
    }

    @Override
    public void apply(VipAddFriendApplyReqDto reqDto) {
        List<String> nums;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("vip add friend apply:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUser.getId(), currentUser.getCorpId()});
        if (reqDto.getIsSelectAll() == null || reqDto.getIsSelectAll() == 0) {
            nums = reqDto.getNums();
        } else {
            VipAddFriendDetailReqDto vipAddFriendDetailReqDto = (VipAddFriendDetailReqDto)BeanUtil.convert((Object)reqDto, VipAddFriendDetailReqDto.class, (String[])new String[0]);
            vipAddFriendDetailReqDto.setApply(1);
            List<VipAddFriendDetailDto> vipAddFriendDetailDtos = this.detailList(vipAddFriendDetailReqDto);
            nums = vipAddFriendDetailDtos.stream().map(VipAddFriendDetailDto::getDetailNum).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(nums)) {
            log.warn("detail nums not found");
            return;
        }
        TelAddFriendTaskDetailCriteria criteria = new TelAddFriendTaskDetailCriteria();
        criteria.createCriteria().andBizIdEqualTo(currentUser.getBizId()).andNumIn(nums);
        TelAddFriendTaskDetail telAddFriendTaskDetail = new TelAddFriendTaskDetail();
        telAddFriendTaskDetail.setUpdateTime(new Date());
        telAddFriendTaskDetail.setUpdateBy(currentUser.getId());
        telAddFriendTaskDetail.setStatus(Integer.valueOf(TelAddFriendStatus.TOBE_APPLY.getStatus()));
        telAddFriendTaskDetail.setRemark("");
        this.telAddFriendTaskDetailMapper.updateByExampleSelective((Object)telAddFriendTaskDetail, (Object)criteria);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(VipAddFriendAddReqDto reqDto) {
        CurrentUserInfo currentUser;
        if (reqDto.getIsMarketingSop().booleanValue()) {
            currentUser = new CurrentUserInfo();
            currentUser.setBizId(reqDto.getBizId());
            currentUser.setCorpId(reqDto.getCorpId());
            currentUser.setId(reqDto.getUserId());
        } else {
            currentUser = LoginUtils.getCurrentUser();
        }
        log.info("add,params:{}, operatorId:{}, corpId:{}", new Object[]{JSON.toJSONString((Object)reqDto), currentUser.getId(), currentUser.getCorpId()});
        reqDto.validate();
        reqDto.setBizId(currentUser.getBizId());
        AppBindings appBindings = this.appBindingsMapper.selectByBizIdAndAppCode(currentUser.getBizId(), this.yingxiaobaoCode);
        if (Objects.isNull(appBindings) || YnEnum.NO.getValue().equals(appBindings.getIsOpen())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u5546\u5bb6\u672a\u5f00\u901a\u8425\u9500\u5b9d");
        }
        TelAddFriendTask task = this.buildTask(reqDto, currentUser, null);
        reqDto.setTaskNum(task.getNum());
        List<TelAddFriendTaskDetail> telAddFriendTaskDetails = this.buildDetail(reqDto, currentUser);
        task.setImportCount(Integer.valueOf(telAddFriendTaskDetails.size()));
        this.saveTaskAndAddWx(task, telAddFriendTaskDetails, reqDto.getBatchId());
        return task.getId();
    }

    @Override
    public void crmAdd(VipAddFriendAddReqDto dto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        dto.setBizId(currentUser.getBizId());
        if (StringUtils.isNotBlank((CharSequence)dto.getBatchId())) {
            dto.setTelAndRemarkDtos(this.convert2TelAndRemarkDto(dto.getBatchId()));
        }
        if (StringUtils.isBlank((CharSequence)dto.getTaskNum())) {
            this.add(dto);
            return;
        }
        AppBindings appBindings = this.appBindingsMapper.selectByBizIdAndAppCode(currentUser.getBizId(), this.yingxiaobaoCode);
        if (Objects.isNull(appBindings) || YnEnum.NO.getValue().equals(appBindings.getIsOpen())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u5546\u5bb6\u672a\u5f00\u901a\u8425\u9500\u5b9d");
        }
        String taskNum = dto.getTaskNum();
        TelAddFriendTask task = this.telAddFriendTaskMapper.selectByNum(taskNum);
        if (Objects.isNull(task)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, dto.getTaskName() + "\u65b0\u589e\u597d\u53cb\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (Objects.isNull(task.getCreateBy()) || !task.getCreateBy().equals(currentUser.getId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, dto.getTaskName() + "\u53ea\u80fd\u65b0\u589e\u5230\u81ea\u5df1\u5df2\u521b\u5efa\u7684\u4efb\u52a1\u91cd");
        }
        dto.setTaskName(task.getTaskName());
        dto.validate();
        List<TelAddFriendTaskDetail> details = this.buildDetail(dto, currentUser);
        TelAddFriendTask update = new TelAddFriendTask();
        update.setId(task.getId());
        if (Objects.nonNull(dto.getDeadline())) {
            update.setExpireTime(dto.getDeadline());
            update.setDeadline(dto.getDeadline());
            update.setUpdateTime(new Date());
        }
        update.setImportCount(Integer.valueOf(task.getImportCount() + details.size()));
        this.saveTaskAndAddWx(update, details, dto.getBatchId());
    }

    @Override
    public void oneClickAdd(OneClickAddReqDto reqDto) {
        int taskType;
        log.info("oneClickAdd reqDto:{}", (Object)reqDto);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)LoginUtils.getCurrentUser().getWeworkUserId()), (Object)"\u975e\u6210\u5458\u65e0\u6cd5\u6dfb\u52a0");
        reqDto.validate();
        Set<Object> telAndRemarkDtos = null;
        telAndRemarkDtos = StringUtils.isNotBlank((CharSequence)reqDto.getBatchId()) ? this.convert2TelAndRemarkDto(reqDto.getBatchId()) : reqDto.getAddList().stream().map(item -> {
            String name = item.getRemark();
            if (StringUtils.isNotBlank((CharSequence)name) && name.length() > 20) {
                name = name.substring(0, 20);
            }
            TelAndRemarkDto telAndRemarkDto = new TelAndRemarkDto();
            if (name == null) {
                name = "";
            }
            telAndRemarkDto.setRemark(name);
            telAndRemarkDto.setTel(item.getTel());
            return telAndRemarkDto;
        }).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(telAndRemarkDtos)) {
            log.info("oneClickAdd: \u624b\u673a\u53f7\u6570\u91cf\u4e3a0, bizId:{}, reqDto:{}", (Object)LoginUtils.getCurrentUserBizId(), (Object)reqDto);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u624b\u673a\u53f7\u6570\u91cf\u4e3a0");
        }
        AppBindings appBindings = this.appBindingsMapper.selectByBizIdAndAppCode(LoginUtils.getCurrentUserBizId(), this.yingxiaobaoCode);
        if (Objects.isNull(appBindings) || YnEnum.NO.getValue().equals(appBindings.getIsOpen())) {
            taskType = AddFriendsTaskType.NORMAL_ADD.getValue();
        } else {
            UserVipStatusDto userVipStatus = this.vipWeworkService.getUserVipStatus(LoginUtils.getCurrentUserBizId(), LoginUtils.getCurrentUser().getWeworkUserNum());
            if (userVipStatus.getIsOpenVip() == 1) {
                if (userVipStatus.getStatus() == 0) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d26\u53f7\u4e0d\u5728\u7ebf\u6682\u65e0\u6cd5\u4f7f\u7528\u8425\u9500\u5b9d");
                }
                if (userVipStatus.getOauthStatus() == 0) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8d26\u53f7\u672a\u6388\u6743\u6682\u65e0\u6cd5\u4f7f\u7528\u8425\u9500\u5b9d");
                }
                taskType = AddFriendsTaskType.ENHANCE_ADD.getValue();
            } else {
                log.info("open yingxiaobao, but current user not open vip");
                taskType = AddFriendsTaskType.NORMAL_ADD.getValue();
            }
        }
        log.info("oneClickAdd taskType:{}", (Object)taskType);
        TelAddFriendTask queryTask = new TelAddFriendTask();
        queryTask.setBizId(LoginUtils.getCurrentUserBizId());
        queryTask.setTaskType(Integer.valueOf(taskType));
        queryTask.setCreateBy(LoginUtils.getCurrentUserId());
        queryTask.setAddType(Integer.valueOf(TelAddType.ONE_CLICK.getValue()));
        TelAddFriendTask telAddFriendTask = (TelAddFriendTask)this.telAddFriendTaskMapper.selectOne((Object)queryTask);
        String taskNum = telAddFriendTask == null ? null : telAddFriendTask.getNum();
        String weworkUserNum = LoginUtils.getCurrentUser().getWeworkUserNum();
        if (taskType == AddFriendsTaskType.ENHANCE_ADD.getValue()) {
            VipAddFriendAddReqDto vipAddFriendAddReqDto = new VipAddFriendAddReqDto();
            vipAddFriendAddReqDto.setTaskName(TelAddType.ONE_CLICK.getDesc() + "[" + LoginUtils.getCurrentUser().getName() + "]");
            vipAddFriendAddReqDto.setTaskNum(taskNum);
            vipAddFriendAddReqDto.setTaskType(taskType);
            vipAddFriendAddReqDto.setTelAndRemarkDtos(telAndRemarkDtos);
            vipAddFriendAddReqDto.setWeworkUserNums(Lists.newArrayList((Object[])new String[]{weworkUserNum}));
            vipAddFriendAddReqDto.setAddType(TelAddType.ONE_CLICK.getValue());
            vipAddFriendAddReqDto.setIsDistinct(NumberUtils.INTEGER_ZERO);
            vipAddFriendAddReqDto.setAllocType(NumberUtils.INTEGER_ZERO);
            log.info("oneClickAdd crmAdd vipAddFriendAddReqDto:{}", (Object)reqDto);
            this.crmAdd(vipAddFriendAddReqDto);
        } else {
            TelAddFriendAddReqDto telAddFriendAddReqDto = new TelAddFriendAddReqDto();
            telAddFriendAddReqDto.setTaskNum(taskNum);
            telAddFriendAddReqDto.setTaskName(TelAddType.ONE_CLICK.getDesc() + "[" + LoginUtils.getCurrentUser().getName() + "]");
            telAddFriendAddReqDto.setTaskType(Integer.valueOf(taskType));
            telAddFriendAddReqDto.setWeworkUserNums((Set)Sets.newHashSet((Object[])new String[]{weworkUserNum}));
            telAddFriendAddReqDto.setAddType(Integer.valueOf(TelAddType.ONE_CLICK.getValue()));
            telAddFriendAddReqDto.setIsDistinct(NumberUtils.INTEGER_ONE);
            telAddFriendAddReqDto.setTelAndRemarkDtos(telAndRemarkDtos);
            log.info("oneClickAdd telAdd telAddFriendAddReqDto:{}", (Object)telAddFriendAddReqDto);
            this.telAddFriendService.add(telAddFriendAddReqDto);
        }
    }

    private Set<TelAndRemarkDto> convert2TelAndRemarkDto(String batchId) {
        List customers = this.cachePhoneService.getCustomer(batchId);
        if (CollectionUtils.isNotEmpty((Collection)customers)) {
            return customers.stream().map(item -> {
                String name = item.getName();
                if (StringUtils.isNotBlank((CharSequence)name) && name.length() > 20) {
                    name = name.substring(0, 20);
                }
                TelAndRemarkDto telAndRemarkDto = new TelAndRemarkDto();
                if (name == null) {
                    name = "";
                }
                telAndRemarkDto.setRemark(name);
                telAndRemarkDto.setTel(item.getPhone());
                return telAndRemarkDto;
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Override
    public List<VipAllocDto> queryAlloc(VipAddFriendAddReqDto reqDto) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        reqDto.setAddType(TelAddType.EXCEL.getValue());
        reqDto.setBizId(currentUser.getBizId());
        reqDto.validateForAlloc();
        List<WeworkUser> weworkUsers = this.weworkUserMapper.queryWeworkUsersByDigitId(currentUser.getCorpId(), reqDto.getWeworkUserNums());
        weworkUsers = weworkUsers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getWeworkDigitId())).collect(Collectors.toList());
        Map<String, String> tel2RemarkMap = this.getMobile2Remark(reqDto, currentUser, true);
        if (MapUtils.isEmpty(tel2RemarkMap)) {
            return Lists.newArrayList();
        }
        Map<String, List<String>> groupByWeworkDigitId = this.groupByWeworkDigitId(reqDto, Lists.newArrayList(tel2RemarkMap.keySet()), weworkUsers);
        if (MapUtils.isEmpty(groupByWeworkDigitId)) {
            return Lists.newArrayList();
        }
        List weworkDigitIds = groupByWeworkDigitId.keySet().stream().sorted().collect(Collectors.toList());
        Map weworkUserMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getWeworkDigitId, Function.identity()));
        ArrayList allocInfoList = Lists.newArrayList();
        for (String id : weworkDigitIds) {
            List<String> tels;
            VipAllocDto vipAllocDto = new VipAllocDto();
            vipAllocDto.setWeworkDigitId(id);
            WeworkUser weworkUser = (WeworkUser)weworkUserMap.get(id);
            if (Objects.nonNull(weworkUser)) {
                vipAllocDto.setWeworkName(weworkUser.getName());
                vipAllocDto.setAvatar(weworkUser.getAvatar());
            }
            if (CollectionUtils.isEmpty(tels = groupByWeworkDigitId.get(id))) continue;
            List<TelAndRemarkDto> telAndRemarkDtoList = tels.stream().map(item -> {
                TelAndRemarkDto dto = new TelAndRemarkDto();
                dto.setTel(item);
                dto.setRemark((String)tel2RemarkMap.get(item));
                return dto;
            }).collect(Collectors.toList());
            vipAllocDto.setUsers(telAndRemarkDtoList);
            allocInfoList.add(vipAllocDto);
        }
        return allocInfoList;
    }

    @Override
    public void startTask() {
        TaskMobileDto taskMobileDto = new TaskMobileDto();
        taskMobileDto.setTaskType(Integer.valueOf(AddFriendsTaskType.ENHANCE_ADD.getValue()));
        taskMobileDto.setStatus(Integer.valueOf(TelAddFriendStatus.TOBE_APPLY.getStatus()));
        taskMobileDto.setOffset(Integer.valueOf(0));
        taskMobileDto.setPageSize(Integer.valueOf(200));
        taskMobileDto.setExpireDate(new Date());
        List bizIds = this.telAddFriendTaskDetailMapper.selectToTaskBizIds(taskMobileDto);
        if (CollectionUtils.isEmpty((Collection)bizIds)) {
            log.info("\u6700\u8fd1\u4e03\u5929\u6ca1\u6709\u589e\u5f3a\u7248\u6dfb\u52a0\u624b\u673a\u53f7\u64cd\u4f5c\u5f85\u6267\u884c \uff1aparam:{}", (Object)JSON.toJSONString((Object)taskMobileDto));
            return;
        }
        for (Long bizId : bizIds) {
            taskMobileDto.setBizId(bizId);
            List details = this.telAddFriendTaskDetailMapper.selectByParams(taskMobileDto);
            if (!CollectionUtils.isEmpty((Collection)details)) continue;
            return;
        }
    }

    private Map<String, String> getMobile2Remark(VipAddFriendAddReqDto reqDto, CurrentUserInfo currentUser, boolean enableNull) {
        Set<TelAndRemarkDto> telAndRemarkDtos = reqDto.getTelAndRemarkDtos();
        for (TelAndRemarkDto telAndRemarkDto : telAndRemarkDtos) {
            StringBuilder uniqKey = new StringBuilder(telAndRemarkDto.getTel());
            if (reqDto.getIsMarketingSop().booleanValue()) {
                uniqKey.append(':').append(telAndRemarkDto.getWeworkUserNum());
            }
            telAndRemarkDto.setUniqKey(uniqKey.toString());
        }
        Map tel2RemarkMap = telAndRemarkDtos.stream().collect(HashMap::new, (m, v) -> m.put(v.getUniqKey(), StringUtils.isBlank((CharSequence)v.getRemark()) ? "" : v.getRemark()), HashMap::putAll);
        if (NumberUtils.INTEGER_ONE.equals(reqDto.getIsDistinct())) {
            List tels = telAndRemarkDtos.stream().map(TelAndRemarkDto::getTel).collect(Collectors.toList());
            ArrayList filteredTels = Lists.newArrayList();
            Lists.partition(tels, (int)200).forEach(partitionTels -> {
                Map telMapCustomerNums = this.customerNumService.batchGetContactCustomerNumByMobile(currentUser.getBizId(), (Collection)partitionTels);
                if (MapUtils.isEmpty((Map)telMapCustomerNums)) {
                    return;
                }
                List customerNums = telMapCustomerNums.keySet().stream().filter(Objects::nonNull).collect(Collectors.toList());
                Set boundedCustomers = this.weworkContactMapper.selectCustomerNumHasBinded(currentUser.getCorpId(), null, customerNums);
                if (CollectionUtils.isNotEmpty((Collection)boundedCustomers)) {
                    List boundedMobiles = boundedCustomers.stream().map(telMapCustomerNums::get).collect(Collectors.toList());
                    filteredTels.addAll(boundedMobiles);
                }
            });
            log.info("corpId:{},\u8fc7\u6ee4\u6389\u7684\u624b\u673a\u53f7:{}", (Object)currentUser.getCorpId(), (Object)filteredTels);
            for (String tel : filteredTels) {
                tel2RemarkMap.remove(tel);
            }
        }
        if (MapUtils.isEmpty((Map)tel2RemarkMap) && !enableNull) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53bb\u91cd\u8fc7\u6ee4\u4e4b\u540e\u624b\u673a\u53f7\u6570\u91cf\u4e3a0");
        }
        return tel2RemarkMap;
    }

    private Map<String, List<String>> groupByWeworkDigitId(VipAddFriendAddReqDto reqDto, List<String> totalTels, List<WeworkUser> weworkUsers) {
        ArrayList toAllocPhone = Lists.newArrayList();
        if (CollectionUtils.isEmpty(weworkUsers)) {
            log.info("\u8fc7\u6ee4\u540e\u7684\u7528\u6237\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString(reqDto.getWeworkUserNums()));
            return Maps.newHashMap();
        }
        Map<String, List<String>> leadsGroupByUserDigitId = this.crmBindAlloc(totalTels, weworkUsers, reqDto, toAllocPhone);
        List<String> weworkDigitIds = weworkUsers.stream().map(WeworkUser::getWeworkDigitId).collect(Collectors.toList());
        Map<String, List<String>> partitioned = this.partition(toAllocPhone, weworkDigitIds);
        leadsGroupByUserDigitId.forEach((digitId, tels) -> {
            if (CollectionUtils.isEmpty((Collection)tels)) {
                return;
            }
            List partitionedTels = (List)partitioned.get(digitId);
            if (CollectionUtils.isEmpty((Collection)partitionedTels)) {
                partitioned.put((String)digitId, (List<String>)tels);
            } else {
                partitionedTels.addAll(tels);
                partitioned.put((String)digitId, partitionedTels);
            }
        });
        return partitioned;
    }

    private void saveTaskAndAddWx(TelAddFriendTask task, List<TelAddFriendTaskDetail> detailList, String butchNum) {
        if (CollectionUtils.isEmpty(detailList)) {
            log.warn("\u5f53\u524d\u4efb\u52a1\u89e3\u6790\u7684 \u8be6\u60c5\u4fe1\u606f\u672a\u7a7a taskParam:{}", (Object)task.getParamJson());
            return;
        }
        if (Objects.isNull(task.getId())) {
            this.telAddFriendTaskMapper.insertSelective((Object)task);
        } else {
            this.telAddFriendTaskMapper.updateByPrimaryKeySelective((Object)task);
        }
        try {
            List partition = Lists.partition(detailList, (int)200);
            partition.forEach(partitionSubTasks -> this.telAddFriendTaskDetailMapper.batchInsert(partitionSubTasks));
        }
        catch (Exception ex) {
            log.error("\u4fdd\u5b58\u5b50\u4efb\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u624b\u673a\u53f7\u52a0\u597d\u53cb\u4efb\u52a1\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if (StringUtils.isNotBlank((CharSequence)butchNum) && Objects.nonNull(task.getAddType()) && TelAddType.LEADS.getValue() == task.getAddType().intValue()) {
            this.cachePhoneService.deleteCustomerCache(butchNum);
        }
    }

    private Map<String, List<String>> crmBindAlloc(List<String> tels, List<WeworkUser> weworkUsers, VipAddFriendAddReqDto dto, List<String> toAllocTels) {
        if (dto.getAddType().equals(TelAddType.LEADS.getValue())) {
            toAllocTels.addAll(tels.stream().sorted().collect(Collectors.toList()));
            return Maps.newHashMap();
        }
        CrmLeadsInfoReq req = new CrmLeadsInfoReq();
        req.setBizId(dto.getBizId());
        req.setMobiles(tels);
        List crmLeadsInfoResps = Lists.newArrayList();
        try {
            crmLeadsInfoResps = this.crmLeadsService.queryBindInfoByMobile(req);
            log.info("crm leads info req: {}; resp:{}", (Object)JSON.toJSONString((Object)req), (Object)JSON.toJSONString((Object)crmLeadsInfoResps));
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2crm \u7cfb\u7edf\u5f02\u5e38\uff1a{}", (Object)JSON.toJSONString((Object)req), (Object)e);
        }
        if (CollectionUtils.isEmpty((Collection)crmLeadsInfoResps)) {
            toAllocTels.addAll(tels.stream().sorted().collect(Collectors.toList()));
            return Maps.newHashMap();
        }
        Map groupByBindUser = crmLeadsInfoResps.stream().collect(Collectors.groupingBy(CrmLeadsInfoResp::getBindingUserId, Collectors.mapping(CrmLeadsInfoResp::getMobile, Collectors.toList())));
        List userIdList = weworkUsers.stream().map(WeworkUser::getUserId).collect(Collectors.toList());
        ArrayList bindingUserIds = Lists.newArrayList(groupByBindUser.keySet());
        List bindedTels = groupByBindUser.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        tels.removeAll(bindedTels);
        bindingUserIds.removeAll(userIdList);
        ArrayList notAllocTels = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)bindingUserIds) && Objects.nonNull(dto.getFilteredLeads())) {
            for (Long bindingUserId : bindingUserIds) {
                List mobileList = groupByBindUser.get(bindingUserId);
                if (dto.getFilteredLeads().equals(FilteredLeadsEnum.RANDOM_ADD.getValue())) {
                    tels.addAll(mobileList);
                    continue;
                }
                notAllocTels.addAll(mobileList);
            }
        }
        log.info("\u901a\u8fc7crm \u8fc7\u6ee4\u6389\u7684\u624b\u673a\u53f7\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)notAllocTels));
        HashMap toAllocTelsMap = Maps.newHashMap();
        weworkUsers.forEach(item -> {
            List mobileList = (List)groupByBindUser.get(item.getUserId());
            if (CollectionUtils.isNotEmpty((Collection)mobileList)) {
                toAllocTelsMap.put(item.getWeworkDigitId(), mobileList);
            }
        });
        tels = tels.stream().sorted().collect(Collectors.toList());
        toAllocTels.addAll(tels);
        return toAllocTelsMap;
    }

    private List<TelAddFriendTaskDetail> buildDetail(VipAddFriendAddReqDto reqDto, CurrentUserInfo currentUser) {
        List weworkUsers = this.weworkUserMapper.queryWeworkUsersByDigitId(currentUser.getCorpId(), reqDto.getWeworkUserNums());
        this.validateUserAuth(weworkUsers, currentUser.getBizId());
        Map<String, String> tel2RemarkMap = this.getMobile2Remark(reqDto, currentUser, false);
        Map<Object, Object> groupByWeworkDigitId = Maps.newHashMap();
        if (reqDto.getIsMarketingSop().booleanValue()) {
            Map<String, String> weworkUserNum2DigitIdMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, WeworkUser::getWeworkDigitId));
            Map weworkUserNum2TelsMap = reqDto.getTelAndRemarkDtos().stream().collect(Collectors.groupingBy(TelAndRemarkDto::getWeworkUserNum, Collectors.mapping(TelAndRemarkDto::getTel, Collectors.toList())));
            for (Map.Entry entry : weworkUserNum2TelsMap.entrySet()) {
                if (!MapUtils.isNotEmpty(weworkUserNum2DigitIdMap) || !weworkUserNum2DigitIdMap.containsKey(entry.getKey())) continue;
                groupByWeworkDigitId.put(weworkUserNum2DigitIdMap.get(entry.getKey()), entry.getValue());
            }
        } else {
            groupByWeworkDigitId = this.groupByWeworkDigitId(reqDto, Lists.newArrayList(tel2RemarkMap.keySet()), weworkUsers);
        }
        if (MapUtils.isEmpty((Map)groupByWeworkDigitId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53bb\u91cd\u8fc7\u6ee4\u4e4b\u540e\u624b\u673a\u53f7\u6570\u91cf\u4e3a0");
        }
        Map weworkUserMap = weworkUsers.stream().filter(item -> Objects.nonNull(item.getWeworkDigitId())).collect(Collectors.toMap(WeworkUser::getWeworkDigitId, Function.identity()));
        ArrayList subTaskList = Lists.newArrayListWithExpectedSize((int)reqDto.getTelAndRemarkDtos().size());
        groupByWeworkDigitId.forEach((weworkDigitId, tels) -> {
            WeworkUser weworkUser = (WeworkUser)weworkUserMap.get(weworkDigitId);
            if (Objects.isNull(weworkUser)) {
                return;
            }
            if (CollectionUtils.isEmpty((Collection)tels)) {
                return;
            }
            for (String tel : tels) {
                StringBuilder uniqKey = new StringBuilder(tel);
                if (reqDto.getIsMarketingSop().booleanValue()) {
                    uniqKey.append(':').append(weworkUser.getNum());
                }
                TelAddFriendTaskDetail detail = this.buildTaskDetail(weworkUser, currentUser, tel, reqDto, (String)tel2RemarkMap.get(uniqKey.toString()));
                subTaskList.add(detail);
            }
        });
        if (!reqDto.getIsMarketingSop().booleanValue() && (long)subTaskList.size() > 5000L) {
            log.info("\u624b\u673a\u53f7\u4e2a\u6570\u4e3a:{}", (Object)subTaskList.size());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u624b\u673a\u53f7\u4e2a\u6570\u8d85\u8fc75000");
        }
        return subTaskList;
    }

    private Map<String, List<String>> partition(List<String> tels, List<String> weworkDigitIds) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)weworkDigitIds.size());
        int size = weworkDigitIds.size();
        int j = 0;
        for (String tel : tels) {
            if (j == size) {
                j = 0;
            }
            List mobiles = Optional.ofNullable(result.get(weworkDigitIds.get(j))).orElse(Lists.newArrayList());
            mobiles.add(tel);
            result.put(weworkDigitIds.get(j), mobiles);
            ++j;
        }
        return result;
    }

    private TelAddFriendTaskDetail buildTaskDetail(WeworkUser weworkUser, CurrentUserInfo currentUserInfo, String tel, VipAddFriendAddReqDto reqDto, String remark) {
        TelAddFriendTaskDetail detail = new TelAddFriendTaskDetail();
        detail.setBizId(currentUserInfo.getBizId());
        detail.setCorpId(currentUserInfo.getCorpId());
        detail.setCreateBy(currentUserInfo.getId());
        detail.setCreateTime(new Date());
        detail.setNum(this.idGen.getNum());
        detail.setWeworkUserNum(weworkUser.getNum());
        detail.setUserDigitId(weworkUser.getWeworkDigitId());
        detail.setTel(tel);
        detail.setUpdateTime(new Date());
        detail.setUpdateBy(currentUserInfo.getId());
        detail.setTaskNum(reqDto.getTaskNum());
        detail.setFriendRemark(remark);
        detail.setStatus(Integer.valueOf(TelAddFriendStatus.TOBE_APPLY.getStatus()));
        detail.setIsSync(NumberUtils.INTEGER_ZERO);
        detail.setRoomDigitId(null);
        detail.setMemberDigitId(null);
        detail.setWeworkUserName(weworkUser.getName());
        detail.setExpireTime(reqDto.getDeadline());
        detail.setTaskType(reqDto.getTaskType());
        detail.setAddType(reqDto.getAddType());
        return detail;
    }

    private void validateUserAuth(List<WeworkUser> weworkUsers, Long bizId) {
        if (CollectionUtils.isEmpty(weworkUsers)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u9009\u62e9\u5f00\u901a\u4f01\u5fae\u5b9d\u7684\u7528\u6237");
        }
        if (CollectionUtils.isEmpty(weworkUsers = weworkUsers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getWeworkDigitId())).collect(Collectors.toList()))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u9009\u62e9\u5f00\u901a\u4f01\u5fae\u5b9d\u7684\u5408\u6cd5\u7528\u6237");
        }
        List weworkUserNum = weworkUsers.stream().map(WeworkUser::getNum).collect(Collectors.toList());
        List list = this.vipWeworkAuthorizeAccountMapper.batchQueryByWeworkNums(bizId, weworkUserNum);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6240\u9009\u7528\u6237\u672a\u5f00\u901a\u4f01\u5fae\u5b9d");
        }
        Map<String, VipUserDto> mapToWeworkUserNum = list.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getWeworkDigitId())).collect(Collectors.toMap(VipUserDto::getWeworkUserNum, vipUserDto -> vipUserDto, (v1, v2) -> v2));
        for (WeworkUser weworkUser : weworkUsers) {
            VipUserDto vipUserDto2 = mapToWeworkUserNum.get(weworkUser.getNum());
            String userName = weworkUser.getName();
            if (!Objects.isNull(vipUserDto2)) continue;
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "[" + userName + "]\u672a\u5f00\u901a\u4f01\u5fae\u5b9d");
        }
    }

    private TelAddFriendTask buildTask(VipAddFriendAddReqDto reqDto, CurrentUserInfo currentUserInfo, Integer totalCount) {
        TelAddFriendTask task = new TelAddFriendTask();
        task.setNum(this.idGen.getNum());
        task.setBizId(currentUserInfo.getBizId());
        task.setCorpId(currentUserInfo.getCorpId());
        task.setTaskName(reqDto.getTaskName());
        task.setAddType(reqDto.getAddType());
        if (CollectionUtils.isNotEmpty(reqDto.getTagIds())) {
            task.setTagIds(Joiner.on((String)",").join(reqDto.getTagIds()));
        }
        task.setIsDistinct(reqDto.getIsDistinct());
        task.setImportCount(totalCount);
        task.setDeadline(reqDto.getDeadline());
        task.setCreateBy(currentUserInfo.getId());
        task.setCreateTime(new Date());
        task.setUpdateTime(new Date());
        task.setUpdateBy(currentUserInfo.getId());
        task.setFileUrl(reqDto.getFileUrl());
        task.setTaskType(reqDto.getTaskType());
        task.setParamJson(JSON.toJSONString((Object)reqDto));
        if (Objects.nonNull(reqDto.getDeadline())) {
            task.setExpireTime(reqDto.getDeadline());
        }
        if (CollectionUtils.isNotEmpty(reqDto.getChannelIds())) {
            task.setChannelNums(Joiner.on((String)",").join(reqDto.getChannelIds()));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getFriendRemark())) {
            task.setFriendRemark(reqDto.getFriendRemark());
        }
        if (reqDto.getFriendWelcome() != null) {
            String welcomeStr = JacksonUtil.obj2Str((Object)reqDto.getFriendWelcome());
            task.setWelcomeJson(welcomeStr);
        }
        task.setIsVisible(NumberUtils.INTEGER_ONE);
        if (reqDto.getIsMarketingSop().booleanValue()) {
            task.setIsVisible(NumberUtils.INTEGER_ZERO);
        }
        return task;
    }

    private static /* synthetic */ void lambda$detailList$0(Map contactDetailMap, BiMap biMap, Map.Entry numDetail) {
        CustomerDetailResp cfr_ignored_0 = (CustomerDetailResp)contactDetailMap.put(biMap.inverse().get(numDetail.getKey()), numDetail.getValue());
    }
}

