/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.scrm.vip.dto.ChatRoomDetailParam;
import cn.kinyun.scrm.vip.dto.TagAndLevelDto;
import cn.kinyun.scrm.vip.dto.WechatChatRoomDetailRespDto;
import cn.kinyun.scrm.vip.service.VipChatroomService;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAccount;
import com.kuaike.scrm.dal.vip.entity.VipWeworkReportChatRoom;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAliasInfoMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkChatRoomLabelRelationMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkCorporationMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkLabelMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkReportChatRoomMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VipChatroomServiceImpl
implements VipChatroomService {
    private static final Logger log = LoggerFactory.getLogger(VipChatroomServiceImpl.class);
    @Autowired
    private VipWeworkAccountMapper vipWeworkAccountMapper;
    @Autowired
    private VipWeworkReportChatRoomMapper vipWeworkReportChatRoomMapper;
    @Autowired
    private VipWeworkChatRoomRelationMapper vipWeworkChatRoomRelationMapper;
    @Autowired
    private VipWeworkCorporationMapper vipWeworkCorporationMapper;
    @Autowired
    private VipWeworkLabelMapper vipWeworkLabelMapper;
    @Autowired
    private VipWeworkChatRoomLabelRelationMapper vipWeworkChatRoomLabelRelationMapper;
    @Autowired
    private VipWeworkAliasInfoMapper vipWeworkAliasInfoMapper;

    @Override
    public WechatChatRoomDetailRespDto getVipChatRoomDetail(ChatRoomDetailParam param) {
        param.validate();
        String chatRoomId = param.getChatRoomId();
        String weworkId = param.getWeworkId();
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Long bizId = currentUser.getBizId();
        VipWeworkAccount weworkAccount = this.vipWeworkAccountMapper.getWeworkAccount(bizId, weworkId);
        if (weworkAccount == null) {
            return null;
        }
        String digitCorpId = weworkAccount.getCorpId();
        VipWeworkReportChatRoom vipWeworkChatRoom = this.vipWeworkReportChatRoomMapper.queryByWeworkIdAndChatRoomId(weworkId, chatRoomId, bizId, digitCorpId);
        if (Objects.isNull(vipWeworkChatRoom)) {
            return null;
        }
        List roomRelations = this.vipWeworkChatRoomRelationMapper.queryWeworkRoomRelations((Collection)Lists.newArrayList((Object[])new String[]{chatRoomId}));
        List vipWeworkAliasInfos = this.vipWeworkAliasInfoMapper.queryMemberInfo(chatRoomId);
        List tagIds = this.vipWeworkChatRoomLabelRelationMapper.queryLabelsByChatRoomId(bizId, digitCorpId, chatRoomId);
        Map weworkLabels = this.vipWeworkLabelMapper.queryLabelNameByIds((Collection)tagIds);
        ArrayList tagAndLevelDtos = Lists.newArrayList();
        weworkLabels.forEach((tagId, name) -> {
            TagAndLevelDto levelDto = new TagAndLevelDto();
            levelDto.setGroupId((String)tagId);
            levelDto.setGroupName((String)name);
            tagAndLevelDtos.add(levelDto);
        });
        return WechatChatRoomDetailRespDto.fromEntity(vipWeworkChatRoom, roomRelations, vipWeworkAliasInfos, tagAndLevelDtos);
    }
}

