/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.common_dto.dto.ResponseCodeType;
import cn.kinyun.link.common_dto.enums.OpType;
import cn.kinyun.scrm.vip.enums.AddFriendConstants;
import cn.kinyun.scrm.vip.enums.FlowStatus;
import cn.kinyun.scrm.vip.service.VipAddFriendService;
import cn.kinyun.scrm.vip.service.WeworkOperationService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.enums.TelAddFriendStatus;
import com.kuaike.scrm.common.enums.WeworkActiveStatusEnum;
import com.kuaike.scrm.common.enums.sop.SopTaskType;
import com.kuaike.scrm.common.enums.sop.TaskRunStatusEnum;
import com.kuaike.scrm.common.service.SopTaskStatusService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.teladdfriend.entity.TelAddFriendTaskDetail;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskDetailMapper;
import com.kuaike.scrm.dal.teladdfriend.mapper.TelAddFriendTaskMapper;
import com.kuaike.scrm.dal.vip.entity.VipFriendSendRecord;
import com.kuaike.scrm.dal.vip.mapper.VipFriendSendRecordMapper;
import com.kuaike.scrm.dal.wework.dto.TelContactRelation;
import com.kuaike.scrm.dal.wework.entity.LinkOpLog;
import com.kuaike.scrm.dal.wework.mapper.LinkOpLogMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.vip.dto.enums.AndroidErrorCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VipAddFriendServiceImpl
implements VipAddFriendService {
    private static final Logger log = LoggerFactory.getLogger(VipAddFriendServiceImpl.class);
    @Autowired
    private TelAddFriendTaskDetailMapper telAddFriendTaskDetailMapper;
    @Autowired
    private VipFriendSendRecordMapper vipFriendSendRecordMapper;
    @Autowired
    private WeworkOperationService weworkOperationService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private LinkOpLogMapper linkOpLogMapper;
    @Value(value="${scrm.vip.addFriend.startTime}")
    private String addFriendStartTime;
    @Value(value="${scrm.vip.addFriend.endTime}")
    private String addFriendEndTime;
    @Autowired
    private TelAddFriendTaskMapper telAddFriendTaskMapper;
    @Autowired
    private SopTaskStatusService sopTaskStatusService;
    private final ExecutorService executeService = new ThreadPoolExecutor(3, 3, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(128), (ThreadFactory)new NamedThreadFactory("vipAddFriendTask"), new ThreadPoolExecutor.DiscardPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.executeService);
    }

    @Override
    public void addFriendTask() {
        long start = System.currentTimeMillis();
        log.info("addFriendTask: start");
        List weworkIds = this.telAddFriendTaskDetailMapper.queryNeedSendWeworkIds();
        if (CollectionUtils.isEmpty((Collection)weworkIds)) {
            log.info("addFriendTask: \u6ca1\u6709\u8981\u52a0\u597d\u53cb\u7684\u4f01\u5fae\u53f7");
            return;
        }
        ArrayList addDetailList = Lists.newArrayList();
        List partitionList = Lists.partition((List)weworkIds, (int)3);
        for (Object subList : partitionList) {
            List list = this.telAddFriendTaskDetailMapper.queryAddDetailList((List)subList);
            addDetailList.addAll(list);
        }
        if (CollectionUtils.isEmpty((Collection)addDetailList)) {
            log.info("addFriendTask: \u6ca1\u6709\u8981\u52a0\u597d\u53cb\u7684\u4fe1\u606f");
            return;
        }
        Map<Long, List<TelAddFriendTaskDetail>> listMap = addDetailList.stream().collect(Collectors.groupingBy(TelAddFriendTaskDetail::getBizId));
        for (Map.Entry entry : listMap.entrySet()) {
            this.executeService.execute(() -> {
                try {
                    this.addFriend((Long)entry.getKey(), (List)entry.getValue());
                }
                catch (Exception e) {
                    log.error("addFriendTask: vip\u52a0\u597d\u53cb\u5f02\u5e38, bizId:{}, e = ", entry.getKey(), (Object)e);
                }
            });
        }
        long end = System.currentTimeMillis();
        log.info("addFriendTask: end, times:{}", (Object)(end - start));
    }

    @Override
    @Transactional
    public void addFriendApproveTask() {
        long start = System.currentTimeMillis();
        log.info("addFriendApproveTask: start");
        List detailList = this.telAddFriendTaskDetailMapper.queryListByStatus(null, TelAddFriendStatus.APPLY_ING.getStatus());
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            Set taskNums = detailList.stream().map(it -> it.getTaskNum()).collect(Collectors.toSet());
            Map taskNumIdMap = this.telAddFriendTaskMapper.queryIdByTaskNums(taskNums);
            detailList.forEach(detail -> {
                String mobile = detail.getTel();
                String corpId = detail.getCorpId();
                Long bizId = detail.getBizId();
                String weworkUserId = detail.getWeworkUserId();
                String requestId = detail.getRequestId();
                try {
                    TelContactRelation telContactRelation = this.weworkContactMapper.selectByCorpIdWeworkUserIdAndMobile(corpId, weworkUserId, mobile);
                    if (Objects.nonNull(telContactRelation)) {
                        this.telAddFriendTaskDetailMapper.updateStatusById(Integer.valueOf(TelAddFriendStatus.SUCCESS.getStatus()), telContactRelation.getContactId(), detail.getId(), telContactRelation.getAddTime());
                        this.vipFriendSendRecordMapper.updateSuccessByRequestId(bizId, requestId, new Date(), TelAddFriendStatus.SUCCESS.getDesc());
                        Long taskId = (Long)taskNumIdMap.get(detail.getTaskNum());
                        this.sopTaskStatusService.sendSopTaskStatusMsg(taskId, detail.getId(), SopTaskType.TEL_ADD_FRIEND, detail.getTel(), Integer.valueOf(TaskRunStatusEnum.SUCCESS.getStatus()), null, null);
                    }
                }
                catch (Exception e) {
                    log.error("addFriendApproveTask: \u66f4\u65b0vip\u52a0\u597d\u53cb\u72b6\u6001\u5f02\u5e38, e = ", (Throwable)e);
                }
            });
        }
        long end = System.currentTimeMillis();
        log.info("addFriendApproveTask: end, times:{}", (Object)(end - start));
    }

    @Override
    @Transactional
    public void addFriendExpiredTask() {
        long start = System.currentTimeMillis();
        log.info("addFriendExpiredTask: start");
        List detailList = this.telAddFriendTaskDetailMapper.queryListByStatus(null, TelAddFriendStatus.APPLY_ING.getStatus());
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            Date now = new Date();
            Set taskNums = detailList.stream().map(it -> it.getTaskNum()).collect(Collectors.toSet());
            Map taskNumIdMap = this.telAddFriendTaskMapper.queryIdByTaskNums(taskNums);
            detailList.forEach(detail -> {
                Long bizId = detail.getBizId();
                String requestId = detail.getRequestId();
                LinkOpLog linkOpLog = this.linkOpLogMapper.queryByRequestId(requestId);
                int respCode = 0;
                String respMsg = "";
                if (Objects.nonNull(linkOpLog) && linkOpLog.getStatus() == 3 && StringUtils.isNotBlank((CharSequence)linkOpLog.getResponseBody())) {
                    JSONObject respObject = JSONObject.fromObject((Object)linkOpLog.getResponseBody());
                    respCode = respObject.getInt("code");
                    respMsg = respObject.getString("msg");
                }
                try {
                    if (0 != respCode) {
                        AndroidErrorCode androidErrorCode = AndroidErrorCode.getByCode((int)respCode);
                        if (androidErrorCode != null) {
                            respMsg = androidErrorCode.getDesc();
                        }
                        this.updateDetailStatus((TelAddFriendTaskDetail)detail, TelAddFriendStatus.FAILED.getStatus(), now, respMsg);
                        this.vipFriendSendRecordMapper.updateFailByRequestId(bizId, requestId, new Date(), respMsg);
                        Long taskId = (Long)taskNumIdMap.get(detail.getTaskNum());
                        this.sopTaskStatusService.sendSopTaskStatusMsg(taskId, detail.getId(), SopTaskType.TEL_ADD_FRIEND, detail.getTel(), Integer.valueOf(TaskRunStatusEnum.FAIL.getStatus()), respMsg, null);
                        return;
                    }
                    Date sendDate = detail.getApplyTime();
                    int days = DateUtil.getQuotByDays((Date)sendDate, (Date)now);
                    if (days > AddFriendConstants.EXPIRE_DAYS) {
                        this.updateDetailStatus((TelAddFriendTaskDetail)detail, TelAddFriendStatus.EXPIRE.getStatus(), now, "\u4efb\u52a1\u8fc7\u671f");
                        this.vipFriendSendRecordMapper.updateExpireByRequestId(bizId, detail.getRequestId(), now, "\u4efb\u52a1\u8fc7\u671f");
                        Long taskId = (Long)taskNumIdMap.get(detail.getTaskNum());
                        this.sopTaskStatusService.sendSopTaskStatusMsg(taskId, detail.getId(), SopTaskType.TEL_ADD_FRIEND, detail.getTel(), Integer.valueOf(TaskRunStatusEnum.FAIL.getStatus()), "\u4efb\u52a1\u8fc7\u671f", null);
                    }
                }
                catch (Exception e) {
                    log.error("addFriendExpiredTask: \u66f4\u65b0vip\u52a0\u597d\u53cb\u8fc7\u671f\u72b6\u6001\u5f02\u5e38\uff0c e = ", (Throwable)e);
                }
            });
        }
        long end = System.currentTimeMillis();
        log.info("addFriendExpiredTask: end, times:{}", (Object)(end - start));
    }

    private void updateDetailStatus(TelAddFriendTaskDetail detail, Integer status, Date date, String remark) {
        detail.setStatus(status);
        detail.setUpdateTime(date);
        if (StringUtils.isNotBlank((CharSequence)remark)) {
            detail.setRemark(remark);
        }
        this.telAddFriendTaskDetailMapper.updateByPrimaryKeySelective((Object)detail);
    }

    private void addFriend(Long bizId, List<TelAddFriendTaskDetail> detailList) {
        List widList = detailList.stream().map(TelAddFriendTaskDetail::getUserDigitId).collect(Collectors.toList());
        Map wechatOpLeftMap = this.weworkOperationService.ruleDataByWeworkIds(bizId, widList, OpType.OP_ADD_FRIEND);
        if (MapUtils.isEmpty((Map)wechatOpLeftMap)) {
            log.info("addFriend: \u83b7\u53d6\u52a0\u597d\u53cb\u914d\u7f6e\u5931\u8d25\uff0c\u6b64\u6b21\u4efb\u52a1\u653e\u5f03, bizId:{}, widList:{}", (Object)bizId, widList);
            return;
        }
        Map onlineMap = this.weworkOperationService.onLineByWeworkIds(bizId, (Set)Sets.newHashSet(widList));
        if (MapUtils.isEmpty((Map)onlineMap)) {
            log.info("addFriend: \u83b7\u53d6\u5fae\u4fe1\u5728\u7ebf\u914d\u7f6e\u5931\u8d25\uff0c\u6b64\u6b21\u4efb\u52a1\u653e\u5f03, bizId:{},widList:{}", (Object)bizId, widList);
            return;
        }
        String nowTime = DateUtil.getCurTimeString((String)"HH:mm:ss");
        if (!Range.closed((Comparable)((Object)this.addFriendStartTime), (Comparable)((Object)this.addFriendEndTime)).contains((Comparable)((Object)nowTime))) {
            log.info("addFriend: \u5f53\u524d\u65f6\u95f4\u4e0d\u5728\u8fd0\u8425\u65f6\u95f4\u8303\u56f4\uff0c\u6b64\u5904\u4efb\u52a1\u653e\u5f03, bizId:{}, time:{}", (Object)bizId, (Object)nowTime);
            return;
        }
        List userNums = detailList.stream().map(TelAddFriendTaskDetail::getWeworkUserNum).collect(Collectors.toList());
        Map userStatusMap = this.weworkUserMapper.queryUserStatus(bizId, userNums);
        ArrayList recordList = Lists.newArrayList();
        String nowDate = DateUtil.getCurDate();
        Date now = new Date();
        HashSet userStatusErrorIds = Sets.newHashSet();
        HashSet expireIds = Sets.newHashSet();
        HashSet offlineIds = Sets.newHashSet();
        HashSet overLimitIds = Sets.newHashSet();
        HashSet failIds = Sets.newHashSet();
        Set taskNums = detailList.stream().map(it -> it.getTaskNum()).collect(Collectors.toSet());
        Map taskNumIdMap = this.telAddFriendTaskMapper.queryIdByTaskNums(taskNums);
        HashMap taskDetailMap = Maps.newHashMap();
        ArrayList updateDetailList = Lists.newArrayList();
        for (TelAddFriendTaskDetail detail : detailList) {
            taskDetailMap.put(detail.getId(), detail);
            String weworkId = detail.getUserDigitId();
            Long relationId = detail.getId();
            String weworkUserNum = detail.getWeworkUserNum();
            String corpId = detail.getCorpId();
            log.info("addFriend: \u52a0\u597d\u53cb\u8bf7\u6c42, relationId:{}", (Object)relationId);
            VipFriendSendRecord record = this.toRecord(detail);
            String recordMsg = "";
            Integer userStatus = (Integer)userStatusMap.get(weworkUserNum);
            WeworkActiveStatusEnum status = WeworkActiveStatusEnum.get((Integer)userStatus);
            if (status != WeworkActiveStatusEnum.ALREADY_ACTIVE) {
                log.info("addFriend: \u6210\u5458\u72b6\u6001\u5f02\u5e38, relationId:{}, userStatus:{}", (Object)relationId, (Object)userStatus);
                recordMsg = "\u6210\u5458\u72b6\u6001\u5f02\u5e38";
                record.setRecordMsg(recordMsg);
                record.setFailTime(now);
                recordList.add(record);
                userStatusErrorIds.add(relationId);
                continue;
            }
            if (detail.getExpireTime() != null && detail.getExpireTime().getTime() <= System.currentTimeMillis()) {
                log.info("addFriend: \u5df2\u8fc7\u671f, relationId:{}, status:{}", (Object)detail.getId(), (Object)detail.getStatus());
                recordMsg = "\u4efb\u52a1\u8fc7\u671f";
                record.setRecordMsg(recordMsg);
                record.setFailTime(now);
                recordList.add(record);
                expireIds.add(relationId);
                continue;
            }
            boolean online = (Boolean)onlineMap.get(detail.getUserDigitId());
            if (!online) {
                log.info("addFriend: \u673a\u5668\u4eba\u4e0d\u5728\u7ebf\uff0c\u4e0d\u80fd\u6dfb\u52a0\u597d\u53cb, relationId:{}", (Object)relationId);
                recordMsg = "\u4f01\u5fae\u4e0d\u5728\u7ebf";
                record.setRecordMsg(recordMsg);
                record.setFailTime(now);
                recordList.add(record);
                offlineIds.add(relationId);
                continue;
            }
            int opLeft = (Integer)wechatOpLeftMap.get(weworkId);
            if (opLeft <= 0) {
                log.info("addFriend: \u5fae\u4fe1\u53f7\u5f53\u65e5\u7533\u8bf7\u989d\u5ea6\u5df2\u7528\u5b8c\uff0c relationId:{}, date:{}", (Object)relationId, (Object)nowDate);
                recordMsg = "\u4efb\u52a1\u8d85\u51fa\u6bcf\u65e5\u9650\u989d";
                record.setRecordMsg(recordMsg);
                record.setFailTime(now);
                recordList.add(record);
                overLimitIds.add(relationId);
                continue;
            }
            String applyContent = "\u6211\u662f";
            if (StringUtils.isNotBlank((CharSequence)detail.getWeworkUserName())) {
                applyContent = "\u6211\u662f" + detail.getWeworkUserName();
            }
            BaseResponse baseResponse = this.weworkOperationService.addFriendByPhone(bizId, corpId, weworkId, detail.getTel(), applyContent);
            String requestId = baseResponse.getRequestId();
            Long code = baseResponse.getCode();
            if ((long)ResponseCodeType.SUCCESS.getCode() == code) {
                record.setFlowStatus(Integer.valueOf(FlowStatus.FINISH.getValue()));
                recordMsg = "\u5df2\u7533\u8bf7";
                record.setRecordMsg(recordMsg);
            } else {
                log.info("addFriend\uff1a responseCode\uff0crelationId:{}, code:{}", (Object)relationId, (Object)code);
                recordMsg = "\u5904\u7406\u5f02\u5e38";
                record.setRecordMsg(recordMsg);
                record.setFailTime(new Date());
                failIds.add(relationId);
            }
            record.setRequestId(requestId);
            record.setSendTime(new Date());
            recordList.add(record);
            if ((long)ResponseCodeType.SUCCESS.getCode() != code) continue;
            detail.setUpdateTime(new Date());
            detail.setStatus(Integer.valueOf(TelAddFriendStatus.APPLY_ING.getStatus()));
            detail.setRequestId(requestId);
            detail.setApplyTime(new Date());
            updateDetailList.add(detail);
            wechatOpLeftMap.put(weworkId, opLeft--);
            Long taskId = (Long)taskNumIdMap.get(detail.getTaskNum());
            this.sopTaskStatusService.sendSopTaskStatusMsg(taskId, detail.getId(), SopTaskType.TEL_ADD_FRIEND, detail.getTel(), Integer.valueOf(TaskRunStatusEnum.EXECUTED.getStatus()), null, new Date());
        }
        if (CollectionUtils.isNotEmpty((Collection)updateDetailList)) {
            Set updateIdSet = updateDetailList.stream().map(TelAddFriendTaskDetail::getId).collect(Collectors.toSet());
            log.info("addFriend: bizId:{}, \u66f4\u65b0id:{}", (Object)bizId, updateIdSet);
            Lists.partition((List)updateDetailList, (int)50).forEach(arg_0 -> ((TelAddFriendTaskDetailMapper)this.telAddFriendTaskDetailMapper).batchUpdate(arg_0));
        }
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            Lists.partition((List)recordList, (int)50).forEach(arg_0 -> ((VipFriendSendRecordMapper)this.vipFriendSendRecordMapper).batchInsert(arg_0));
        }
        if (CollectionUtils.isNotEmpty((Collection)expireIds)) {
            log.info("addFriend: \u8fc7\u671f:{}", (Object)expireIds);
            Lists.partition((List)Lists.newArrayList((Iterable)expireIds), (int)50).forEach(it -> {
                this.telAddFriendTaskDetailMapper.updateStatusByIds((Collection)it, Integer.valueOf(TelAddFriendStatus.FAILED.getStatus()), "\u4efb\u52a1\u8fc7\u671f");
                this.wrapSendSopStatusMsg((List<Long>)it, taskDetailMap, taskNumIdMap, "\u4efb\u52a1\u8fc7\u671f");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)offlineIds)) {
            log.info("addFriend: \u4e0d\u5728\u7ebf:{}", (Object)offlineIds);
            Lists.partition((List)Lists.newArrayList((Iterable)offlineIds), (int)50).forEach(it -> {
                this.telAddFriendTaskDetailMapper.updateStatusByIds((Collection)it, Integer.valueOf(TelAddFriendStatus.FAILED.getStatus()), "\u4f01\u5fae\u4e0d\u5728\u7ebf");
                this.wrapSendSopStatusMsg((List<Long>)it, taskDetailMap, taskNumIdMap, "\u4f01\u5fae\u4e0d\u5728\u7ebf");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)overLimitIds)) {
            log.info("addFriend: \u8d85\u51fa\u989d\u5ea6:{}", (Object)overLimitIds);
            Lists.partition((List)Lists.newArrayList((Iterable)overLimitIds), (int)50).forEach(it -> {
                this.telAddFriendTaskDetailMapper.updateStatusByIds((Collection)it, Integer.valueOf(TelAddFriendStatus.FAILED.getStatus()), "\u4efb\u52a1\u8d85\u51fa\u6bcf\u65e5\u9650\u989d");
                this.wrapSendSopStatusMsg((List<Long>)it, taskDetailMap, taskNumIdMap, "\u4efb\u52a1\u8d85\u51fa\u6bcf\u65e5\u9650\u989d");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)userStatusErrorIds)) {
            log.info("addFriend: \u6210\u5458\u72b6\u6001\u5f02\u5e38:{}", (Object)userStatusErrorIds);
            Lists.partition((List)Lists.newArrayList((Iterable)userStatusErrorIds), (int)50).forEach(it -> {
                this.telAddFriendTaskDetailMapper.updateStatusByIds((Collection)it, Integer.valueOf(TelAddFriendStatus.FAILED.getStatus()), "\u6210\u5458\u72b6\u6001\u5f02\u5e38");
                this.wrapSendSopStatusMsg((List<Long>)it, taskDetailMap, taskNumIdMap, "\u6210\u5458\u72b6\u6001\u5f02\u5e38");
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)failIds)) {
            log.info("addFriend: \u63a5\u53e3\u8c03\u7528\u540e\u5931\u8d25:{}", (Object)failIds);
            Lists.partition((List)Lists.newArrayList((Iterable)failIds), (int)50).forEach(it -> {
                this.telAddFriendTaskDetailMapper.updateStatusByIds((Collection)it, Integer.valueOf(TelAddFriendStatus.FAILED.getStatus()), "\u5904\u7406\u5f02\u5e38");
                this.wrapSendSopStatusMsg((List<Long>)it, taskDetailMap, taskNumIdMap, "\u5904\u7406\u5f02\u5e38");
            });
        }
    }

    private VipFriendSendRecord toRecord(TelAddFriendTaskDetail detail) {
        VipFriendSendRecord record = new VipFriendSendRecord();
        record.setNum(this.idGen.getNum());
        record.setBizId(detail.getBizId());
        record.setCorpId(detail.getCorpId());
        record.setTaskNum(detail.getTaskNum());
        record.setTaskDetailNum(detail.getNum());
        record.setRequestId(UUID.randomUUID().toString());
        record.setWeworkUserNum(detail.getWeworkUserNum());
        record.setWeworkRoomId(detail.getWeworkRoomId());
        record.setMemberId(detail.getMemberId());
        record.setUserDigitId(detail.getUserDigitId());
        record.setRoomDigitId(detail.getRoomDigitId());
        record.setMemberDigitId(detail.getMemberDigitId());
        record.setMobile(detail.getTel());
        record.setFlowStatus(Integer.valueOf(FlowStatus.ING.getValue()));
        record.setCreateBy(Long.valueOf(-1L));
        record.setCreateTime(new Date());
        record.setUpdateBy(Long.valueOf(-1L));
        record.setUpdateTime(new Date());
        record.setIsDeleted(NumberUtils.INTEGER_ZERO);
        return record;
    }

    private void wrapSendSopStatusMsg(List<Long> subTaskIds, Map<Long, TelAddFriendTaskDetail> taskDetailMap, Map<String, Long> taskNumIdMap, String failReason) {
        for (Long subTaskId : subTaskIds) {
            TelAddFriendTaskDetail detail = taskDetailMap.get(subTaskId);
            if (detail == null) continue;
            Long taskId = taskNumIdMap.get(detail.getTaskNum());
            this.sopTaskStatusService.sendSopTaskStatusMsg(taskId, subTaskId, SopTaskType.TEL_ADD_FRIEND, detail.getTel(), Integer.valueOf(TaskRunStatusEnum.FAIL.getStatus()), failReason, null);
        }
    }
}

