/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.scrm.vip.dto.req.OpenSettingBaseReq;
import cn.kinyun.scrm.vip.dto.req.OpenSettingDetailReq;
import cn.kinyun.scrm.vip.dto.req.OpenSettingReqDto;
import cn.kinyun.scrm.vip.dto.resp.OpenSettingLog;
import cn.kinyun.scrm.vip.dto.resp.OpenSettingResp;
import cn.kinyun.scrm.vip.service.BizOpenSettingService;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.vip.entity.VipWeworkSetting;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkSettingMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BizOpenSettingServiceImpl
implements BizOpenSettingService {
    private static final Logger log = LoggerFactory.getLogger(BizOpenSettingServiceImpl.class);
    @Autowired
    private VipWeworkSettingMapper vipWeworkSettingMapper;
    @Autowired
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;

    @Override
    public void vipWeworkOpenSetting(OpenSettingReqDto reqDto) {
        log.info("vipWeworkOpenSetting param: {}", (Object)reqDto);
        reqDto.validateParam();
        Long bizId = this.businessCustomerMapper.getBizId(reqDto.getCorpId());
        VipWeworkSetting newOpenSetting = this.vipWeworkSettingMapper.queryNewOpenSetting(reqDto.getCorpId());
        if (newOpenSetting == null) {
            log.info("vipWeworkOpenSetting settingList is empty");
            if (reqDto.getOpenType() == 2) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u8fd8\u6ca1\u6709\u5f00\u901a\u8d26\u53f7\uff0c\u8bf7\u65b0\u5f00\u4e4b\u540e\u5728\u6267\u884c\u6269\u5bb9");
            }
            VipWeworkSetting setting = this.buildSetting(reqDto, bizId);
            this.vipWeworkSettingMapper.insertSelective((Object)setting);
        } else {
            switch (reqDto.getOpenType()) {
                case 1: {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u5df2\u5f00\u901a\u8d26\u53f7\uff0c\u4e0d\u9700\u8981\u91cd\u590d\u5f00\u901a\uff0c\u8bf7\u6267\u884c\u7eed\u8d39\u6216\u6269\u5bb9");
                }
                case 2: {
                    long days = DateUtil.compareDateDay((String)DateUtil.getCurDateTime(), (String)DateUtil.dateToDateString((Date)newOpenSetting.getEndTime()));
                    log.info("expansionHandle get days: {}", (Object)days);
                    if (days < 0L) {
                        throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u5f00\u901a\u8d26\u53f7\u5df2\u8fc7\u671f\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u7eed\u8d39");
                    }
                    VipWeworkSetting expansionSetting = this.buildSetting(reqDto, bizId);
                    this.vipWeworkSettingMapper.insertSelective((Object)expansionSetting);
                    break;
                }
            }
        }
    }

    private VipWeworkSetting buildSetting(OpenSettingReqDto reqDto, Long bizId) {
        VipWeworkSetting setting = new VipWeworkSetting();
        setting.setNum(this.idGen.getNum());
        setting.setBizId(bizId);
        setting.setCorpId(reqDto.getCorpId());
        setting.setCreateBy(Long.valueOf(-1L));
        setting.setCreateTime(new Date());
        setting.setUpdateBy(Long.valueOf(-1L));
        setting.setUpdateTime(new Date());
        setting.setIsDeleted(Integer.valueOf(0));
        setting.setAddType(reqDto.getOpenType());
        setting.setVipCount(reqDto.getVipCount());
        setting.setExpansionCount(reqDto.getExpansionCount());
        setting.setOpenPeriod(reqDto.getOpenPeriod());
        setting.setEndTime(reqDto.getEndTime());
        setting.setOriginalPrice(reqDto.getAccountPrice());
        setting.setPrice(reqDto.getAccountPayPrice());
        setting.setTotalPay(reqDto.getTotalPay());
        return setting;
    }

    @Override
    public List<OpenSettingLog> vipWeworkOpenSettingLog(OpenSettingBaseReq baseReq) {
        log.info("vipWeworkOpenSettingLog param: {}", (Object)baseReq);
        List settingList = this.vipWeworkSettingMapper.queryAllSettingBy(baseReq.getCorpId());
        if (CollectionUtils.isEmpty((Collection)settingList)) {
            return null;
        }
        ArrayList settingLogs = Lists.newArrayList();
        for (VipWeworkSetting setting : settingList) {
            OpenSettingLog log = new OpenSettingLog();
            settingLogs.add(log);
            log.setOpenType(setting.getAddType());
            log.setVipCount(setting.getVipCount());
            log.setExpansionCount(setting.getExpansionCount());
            log.setEndTime(setting.getEndTime());
            log.setTotalPay(setting.getTotalPay());
            log.setCreateTime(setting.getCreateTime());
        }
        return settingLogs;
    }

    @Override
    public OpenSettingResp getSettingDetail(OpenSettingDetailReq req) {
        log.info("getSettingDetail param: {}", (Object)req);
        return this.getVipDetail(req.getCorpId());
    }

    @Override
    public OpenSettingResp getVipDetail(String corpId) {
        List newOpenSetting = this.vipWeworkSettingMapper.qeuryOpenSetting(corpId, Integer.valueOf(1));
        List expansionList = this.vipWeworkSettingMapper.qeuryOpenSetting(corpId, Integer.valueOf(2));
        log.info("getVipDetail newOpenSetting: {}, expansionList: {}", (Object)newOpenSetting, (Object)expansionList);
        if (CollectionUtils.isEmpty((Collection)newOpenSetting)) {
            return null;
        }
        VipWeworkSetting setting = (VipWeworkSetting)newOpenSetting.get(0);
        OpenSettingResp resp = new OpenSettingResp();
        resp.setEndTime(setting.getEndTime());
        Integer vipCount = setting.getVipCount();
        if (CollectionUtils.isNotEmpty((Collection)expansionList)) {
            for (VipWeworkSetting eSetting : expansionList) {
                vipCount = vipCount + eSetting.getExpansionCount();
                if (eSetting.getEndTime().compareTo(resp.getEndTime()) <= 0) continue;
                resp.setEndTime(eSetting.getEndTime());
            }
        }
        long days = DateUtil.compareDateDay((String)DateUtil.getCurDateTime(), (String)DateUtil.dateToDateString((Date)resp.getEndTime()));
        resp.setOpenPeriod(days);
        resp.setVipCount(vipCount);
        if (days <= 0L) {
            resp.setVipCount(0);
        }
        return resp;
    }
}

