/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.reply.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

public final class MsgUtils {
    public static final String ADD_FRIEND_FORWARDLY = "\u6211\u901a\u8fc7\u4e86\u4f60\u7684\u8054\u7cfb\u4eba\u9a8c\u8bc1\u8bf7\u6c42\uff0c\u73b0\u5728\u6211\u4eec\u53ef\u4ee5\u5f00\u59cb\u804a\u5929\u4e86";
    public static final String ADD_FRIEND_FORWARDLY_2 = "\u6211\u5df2\u7ecf\u6dfb\u52a0\u4e86\u4f60\uff0c\u73b0\u5728\u6211\u4eec\u53ef\u4ee5\u5f00\u59cb\u804a\u5929\u4e86\u3002";
    public static final Pattern FRIEND_IS_JOINED_PATTERN = Pattern.compile("\u4f60\u5df2\u6dfb\u52a0\u4e86(.*?)\uff0c\u73b0\u5728\u53ef\u4ee5\u5f00\u59cb\u804a\u5929\u4e86\u3002");
    public static final Pattern JOINED_BY_FRIEND_PATTERN = Pattern.compile("(.*?)\u521a\u521a\u628a\u4f60\u6dfb\u52a0\u5230\u901a\u8baf\u5f55\uff0c\u73b0\u5728\u53ef\u4ee5\u5f00\u59cb\u804a\u5929\u4e86\u3002");
    public static final Pattern NOT_FRIEND_PATTERN = Pattern.compile("(.*?)\u8fd8\u4e0d\u662f\u4f60\u7684\u8054\u7cfb\u4eba\uff0c\u8bf7\u5148\u53d1\u9001\u7533\u8bf7\u9a8c\u8bc1\uff0c\u5bf9\u65b9\u901a\u8fc7\u9a8c\u8bc1\u540e\uff0c\u624d\u80fd\u804a\u5929\u3002\u53d1\u9001\u8054\u7cfb\u4eba\u7533\u8bf7");
    public static final Pattern NOT_FRIEND_PATTERN_MSG = Pattern.compile("(.*?)\u5f00\u542f\u4e86\u8054\u7cfb\u4eba\u9a8c\u8bc1\uff0c\u4f60\u8fd8\u4e0d\u662f\u4ed6\uff08\u5979\uff09\u7684\u8054\u7cfb\u4eba\u3002\u8bf7\u5148\u53d1\u9001\u8054\u7cfb\u4eba\u9a8c\u8bc1\u8bf7\u6c42\uff0c\u5bf9\u65b9\u9a8c\u8bc1\u901a\u8fc7\u540e\uff0c\u624d\u80fd\u804a\u5929\u3002 \u53d1\u9001\u8054\u7cfb\u4eba\u9a8c\u8bc1");
    public static final Pattern GROUP_YOU_ARE_OWNER_PATTERN = Pattern.compile("\u4f60\u5df2\u6210\u4e3a\u65b0\u7fa4\u4e3b");
    public static final Pattern GROUP_YOU_ARE_KICKED_PATTERN = Pattern.compile("\u4f60\u88ab\"(.*?)\"\u79fb\u51fa\u7fa4\u804a");
    public static final Pattern GROUP_STRANGER_PATTERN = Pattern.compile("\"(.*?)\"\u4e0e\u7fa4\u91cc\u5176\u4ed6\u4eba\u90fd\u4e0d\u662f\u5fae\u4fe1\u670b\u53cb\u5173\u7cfb\uff0c\u8bf7\u6ce8\u610f\u9690\u79c1\u5b89\u5168");
    public static final Pattern AT_MEMBER_PATTERN = Pattern.compile("@\\S+?(?:\\s+|$)");

    private MsgUtils() {
    }

    public static boolean match(String message, Pattern pattern) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return false;
        }
        Matcher matcher = pattern.matcher(message);
        return matcher.matches();
    }

    public static String getJoinFriendNickName(String text) {
        if (MsgUtils.match(text, FRIEND_IS_JOINED_PATTERN)) {
            int begin = "\u4f60\u5df2\u6dfb\u52a0\u4e86".length();
            int end = text.length() - "\uff0c\u73b0\u5728\u53ef\u4ee5\u5f00\u59cb\u804a\u5929\u4e86\u3002".length();
            return text.substring(begin, end);
        }
        if (MsgUtils.match(text, JOINED_BY_FRIEND_PATTERN)) {
            int begin = 0;
            int end = text.length() - "\u521a\u521a\u628a\u4f60\u6dfb\u52a0\u5230\u901a\u8baf\u5f55\uff0c\u73b0\u5728\u53ef\u4ee5\u5f00\u59cb\u804a\u5929\u4e86\u3002".length();
            return text.substring(begin, end);
        }
        return null;
    }

    public static String removeAtMembers(String text) {
        return (String)StringUtils.defaultIfEmpty((CharSequence)RegExUtils.removeAll((String)text, (Pattern)AT_MEMBER_PATTERN), (CharSequence)"");
    }

    public static String removeReferredText(String text) {
        String head = "\u300c";
        String eof = "\u300d\n- - - - - - - - - - - - - - -";
        int start = text.indexOf(head);
        int end = text.lastIndexOf(eof);
        if (start > -1 && end > start) {
            return text.substring(end + eof.length());
        }
        return text;
    }
}

