/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.reply.service.impl;

import cn.kinyun.scrm.vip.reply.dto.req.FriendKeywordReplyCheckReq;
import cn.kinyun.scrm.vip.reply.dto.req.FriendKeywordReplyIdReqDto;
import cn.kinyun.scrm.vip.reply.dto.req.FriendKeywordReplyListReq;
import cn.kinyun.scrm.vip.reply.dto.req.FriendKeywordReplyReq;
import cn.kinyun.scrm.vip.reply.dto.resp.FriendKeywordReplyDetailResp;
import cn.kinyun.scrm.vip.reply.dto.resp.FriendKeywordReplyListResp;
import cn.kinyun.scrm.vip.reply.service.FriendKeywordReplyService;
import cn.kinyun.scrm.vip.reply.service.WechatFriendKeywordReplyService;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.app.entity.AppBindings;
import com.kuaike.scrm.dal.app.mapper.AppBindingsMapper;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WechatFriendKeywordReplyServiceImpl
implements WechatFriendKeywordReplyService {
    private static final Logger log = LoggerFactory.getLogger(WechatFriendKeywordReplyServiceImpl.class);
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private FriendKeywordReplyService friendKeywordReplyService;
    @Autowired
    private AppBindingsMapper appBindingsMapper;
    @Value(value="${app.yingxiaobao.code:yingxiaobao}")
    private String yingxiaobaoCode;

    private void validateYxb(Long bizId) {
        AppBindings appBindings = this.appBindingsMapper.selectByBizIdAndAppCode(bizId, this.yingxiaobaoCode);
        if (Objects.isNull(appBindings) || YnEnum.NO.getValue().equals(appBindings.getIsOpen())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u5546\u5bb6\u672a\u5f00\u901a\u8425\u9500\u5b9d");
        }
    }

    @Override
    public void add(FriendKeywordReplyReq params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        params.setOperatorId(currentUserInfo.getId());
        params.setBizId(currentUserInfo.getBizId());
        params.setCorpId(currentUserInfo.getCorpId());
        params.setNodeId(currentUserInfo.getUserNodeId());
        log.info("add friend keyword reply with params={}", (Object)params);
        this.validateYxb(currentUserInfo.getBizId());
        try {
            this.friendKeywordReplyService.add(params);
        }
        catch (Exception e) {
            log.error("\u6dfb\u52a0\u79c1\u804a\u5173\u952e\u8bcd\u56de\u590d\u5931\u8d25, params={}", (Object)params, (Object)e);
            throw e;
        }
    }

    @Override
    public void addAll(List<FriendKeywordReplyReq> list) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        StopWatchDto timer = new StopWatchDto("\u6279\u91cf\u6dfb\u52a0\u5fae\u4fe1\u597d\u53cb\u79c1\u804a\u5173\u952e\u8bcd\u56de\u590d", true, log);
        timer.start("forLoop");
        for (FriendKeywordReplyReq params : list) {
            params.setOperatorId(currentUserInfo.getId());
            params.setBizId(currentUserInfo.getBizId());
            params.setCorpId(currentUserInfo.getCorpId());
            params.setNodeId(currentUserInfo.getUserNodeId());
        }
        timer.stop();
        log.info("add all friend keyword reply with list={}", list);
        this.validateYxb(currentUserInfo.getBizId());
        try {
            timer.start("addAll");
            this.friendKeywordReplyService.addAll(list);
            timer.stop();
            timer.print();
        }
        catch (Exception e) {
            log.info("\u6279\u91cf\u6dfb\u52a0\u79c1\u804a\u5173\u952e\u8bcd\u56de\u590d\u5931\u8d25, list={}", list, (Object)e);
            throw e;
        }
    }

    @Override
    public void modify(FriendKeywordReplyReq params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        params.setOperatorId(currentUserInfo.getId());
        params.setBizId(currentUserInfo.getBizId());
        params.setCorpId(currentUserInfo.getCorpId());
        params.setNodeId(currentUserInfo.getUserNodeId());
        log.info("modify friend keyword reply with params={}", (Object)params);
        this.validateYxb(currentUserInfo.getBizId());
        try {
            this.friendKeywordReplyService.modify(params);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u79c1\u804a\u5173\u952e\u8bcd\u56de\u590d\u5931\u8d25, params={}", (Object)params, (Object)e);
            throw e;
        }
    }

    @Override
    public Boolean check(FriendKeywordReplyCheckReq params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        params.setOperatorId(currentUserInfo.getId());
        params.setBizId(currentUserInfo.getBizId());
        params.setCorpId(currentUserInfo.getCorpId());
        params.setNodeId(currentUserInfo.getUserNodeId());
        log.info("check existing friend keyword reply with params={}", (Object)params);
        this.validateYxb(currentUserInfo.getBizId());
        try {
            return this.friendKeywordReplyService.check(params);
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u5931\u8d25, params={}", (Object)params, (Object)e);
            throw e;
        }
    }

    @Override
    public List<FriendKeywordReplyDetailResp> list(FriendKeywordReplyListReq params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        params.setNodeIds(this.userRoleCommonService.getManageNodeIds());
        params.setOperatorId(currentUserInfo.getId());
        params.setBizId(currentUserInfo.getBizId());
        params.setCorpId(currentUserInfo.getCorpId());
        params.setNodeId(currentUserInfo.getUserNodeId());
        log.info("query friend keyword reply list with params={}", (Object)params);
        this.validateYxb(currentUserInfo.getBizId());
        try {
            FriendKeywordReplyListResp resp = this.friendKeywordReplyService.list(params);
            params.setPageDto(resp.getPageDto());
            return resp.getList();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u79c1\u804a\u5173\u952e\u8bcd\u5217\u8868\u5931\u8d25, params={}", (Object)params, (Object)e);
            throw e;
        }
    }

    @Override
    public FriendKeywordReplyDetailResp detail(FriendKeywordReplyIdReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        params.setOperatorId(currentUserInfo.getId());
        params.setBizId(currentUserInfo.getBizId());
        params.setCorpId(currentUserInfo.getCorpId());
        params.setNodeId(currentUserInfo.getUserNodeId());
        log.info("query friend keyword reply detail with params={}", (Object)params);
        this.validateYxb(currentUserInfo.getBizId());
        try {
            return this.friendKeywordReplyService.detail(params);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u79c1\u804a\u5173\u952e\u8bcd\u56de\u590d\u8be6\u60c5\u5931\u8d25, params:{}", (Object)params, (Object)e);
            throw e;
        }
    }

    @Override
    public void delete(FriendKeywordReplyIdReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        params.setOperatorId(currentUserInfo.getId());
        params.setBizId(currentUserInfo.getBizId());
        params.setCorpId(currentUserInfo.getCorpId());
        params.setNodeId(currentUserInfo.getUserNodeId());
        log.info("delete friend keyword reply with params={}", (Object)params);
        this.validateYxb(currentUserInfo.getBizId());
        try {
            this.friendKeywordReplyService.delete(params);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u79c1\u804a\u5173\u952e\u8bcd\u56de\u590d\u8be6\u60c5\u5931\u8d25, params:{}", (Object)params, (Object)e);
            throw e;
        }
    }
}

