/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.cache.service.impl;

import cn.kinyun.scrm.vip.cache.dto.CachedReplyData;
import cn.kinyun.scrm.vip.cache.dto.MatchedResult;
import cn.kinyun.scrm.vip.cache.service.MerchantKeywordCache;
import cn.kinyun.scrm.vip.cache.service.VersionedCache;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMerchantKeywordCache<T>
extends VersionedCache
implements MerchantKeywordCache<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractMerchantKeywordCache.class);
    protected Map<Long, Map<T, CachedReplyData>> cachedReplyData = Maps.newConcurrentMap();

    @Override
    public Map<T, CachedReplyData> getCache(Long businessCustomerId) {
        if (businessCustomerId == null) {
            return null;
        }
        return this.cachedReplyData.get(businessCustomerId);
    }

    @Override
    public CachedReplyData getCache(Long businessCustomerId, T key) {
        if (businessCustomerId == null || key == null) {
            return null;
        }
        Map<T, CachedReplyData> cache = this.cachedReplyData.get(businessCustomerId);
        if (cache != null) {
            return cache.get(key);
        }
        return null;
    }

    @Override
    public MatchedResult match(Long bizId, T key, String message) {
        log.info("Matching {} keyword with bizId:{}, key:{}, text:{}", new Object[]{this.getClass().getSimpleName(), bizId, key, message});
        CachedReplyData cache = this.getCache(bizId, key);
        if (cache == null) {
            log.info("Cache not found for {} businessCustomerId:{}, key:{}", new Object[]{this.getClass().getSimpleName(), bizId, key});
            return MatchedResult.EMPTY;
        }
        return cache.match(message);
    }
}

