/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.reply.service.impl;

import cn.kinyun.scrm.vip.reply.enums.MultipleKeywordStrategy;
import cn.kinyun.scrm.vip.reply.service.ReplySettingService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.vip.dto.enums.SystemParamName;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ReplySettingServiceImpl
implements ReplySettingService {
    private static final Logger log = LoggerFactory.getLogger(ReplySettingServiceImpl.class);
    private final Random rand = new SecureRandom();
    private static final int DEFAULT_DEDUPLICATE_TIME = 60;
    private static final int DEFAULT_MULTIPLY_KEYWORD_STRATEGY = MultipleKeywordStrategy.REPLY_NEAREST_ONE.getValue();
    @Autowired
    private SettingService settingService;
    @Value(value="${minSystemRestTime:22:00}")
    private String minSystemRestTime;
    @Value(value="${maxSystemRestTime:24:00}")
    private String maxSystemRestTime;
    private final SimpleDateFormat formatter = new SimpleDateFormat("HH:mm", Locale.getDefault());

    @Override
    public boolean isRestTime(Long bizId) {
        if (!this.isSystemRestEnabled(bizId)) {
            return false;
        }
        String begin = this.settingService.getStringOrDefault(bizId, SystemParamName.MIN_SYSTEM_REST_TIME.getKey(), this.minSystemRestTime);
        String end = this.settingService.getStringOrDefault(bizId, SystemParamName.MAX_SYSTEM_REST_TIME.getKey(), this.maxSystemRestTime);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{begin, end})) {
            log.warn("No rest time found, bizId={}, begin={}, end={}", new Object[]{bizId, begin, end});
            return false;
        }
        String now = this.formatter.format(new Date());
        return this.between(bizId, now, begin, end);
    }

    private boolean between(Long bizId, String now, String begin, String end) {
        int cp = begin.compareTo(end);
        if (cp > 0) {
            if (now.compareTo(begin) >= 0 || now.compareTo(end) <= 0) {
                log.info("It's rest time, bizId={}, now={}, begin={}, end={}", new Object[]{bizId, now, begin, end});
                return true;
            }
        } else if (now.compareTo(begin) >= 0 && now.compareTo(end) <= 0) {
            log.info("It's rest time, bizId={}, now={}, begin={}, end={}", new Object[]{bizId, now, begin, end});
            return true;
        }
        return false;
    }

    private boolean isSystemRestEnabled(Long bizId) {
        return this.settingService.getBooleanOrDefault(bizId, SystemParamName.SYSTEM_REST_ENABLED.getKey(), Boolean.valueOf(true));
    }

    @Override
    public Integer getFriendSendIntervalTime(Long bizId) {
        int minInterval = this.settingService.getIntegerOrDefault(bizId, SystemParamName.MIN_FRIEND_WELCOME_INTERVAL.getKey(), Integer.valueOf(3));
        int maxInterval = this.settingService.getIntegerOrDefault(bizId, SystemParamName.MAX_FRIEND_WELCOME_INTERVAL.getKey(), Integer.valueOf(10));
        if (maxInterval <= minInterval) {
            return minInterval;
        }
        return minInterval + this.rand.nextInt(maxInterval - minInterval);
    }

    @Override
    public Integer getGroupSendIntervalTime(Long bizId) {
        int minInterval = this.settingService.getIntegerOrDefault(bizId, SystemParamName.MIN_CHAT_ROOM_WELCOME_INTERVAL.getKey(), Integer.valueOf(30));
        int maxInterval = this.settingService.getIntegerOrDefault(bizId, SystemParamName.MAX_CHAT_ROOM_WELCOME_INTERVAL.getKey(), Integer.valueOf(50));
        if (maxInterval <= minInterval) {
            return minInterval;
        }
        return minInterval + this.rand.nextInt(maxInterval - minInterval);
    }

    @Override
    public Integer getMemberIntervalNum(Long bizId) {
        return this.settingService.getIntegerOrDefault(bizId, SystemParamName.CHAT_ROOM_WELCOME_INTERVAL_NUM.getKey(), Integer.valueOf(3));
    }

    @Override
    public boolean isAtMember(Long bizId) {
        return this.settingService.getBooleanOrDefault(bizId, SystemParamName.GROUP_REPLY_SHOULD_AT_MEMBER.getKey(), Boolean.valueOf(false));
    }

    @Override
    public boolean isReferText(Long bizId) {
        return this.settingService.getBooleanOrDefault(bizId, SystemParamName.GROUP_REPLY_CONTAINS_QUESTION.getKey(), Boolean.valueOf(false));
    }

    @Override
    public boolean isReferFriendText(Long bizId) {
        return this.settingService.getBooleanOrDefault(bizId, SystemParamName.FRIEND_REPLY_CONTAINS_QUESTION.getKey(), Boolean.valueOf(false));
    }

    @Override
    public boolean needAtRobot(Long bizId) {
        return this.settingService.getBooleanOrDefault(bizId, SystemParamName.GROUP_REPLY_NEED_AT_ROBOT.getKey(), Boolean.valueOf(false));
    }

    @Override
    public MultipleKeywordStrategy getGroupMultipleKeywordStrategy(Long bizId) {
        MultipleKeywordStrategy strategy;
        Integer value = this.settingService.getIntegerOrDefault(bizId, SystemParamName.GROUP_MULTIPLE_KEYWORD_STRATEGY.getKey(), Integer.valueOf(1));
        try {
            strategy = MultipleKeywordStrategy.getType(value);
            if (strategy == null) {
                strategy = MultipleKeywordStrategy.REPLY_OPTION;
                log.warn("Unsupported gruop multiple keyword strategy, value={}, bizId={}", (Object)value, (Object)bizId);
            }
        }
        catch (Exception e) {
            log.warn("Failed parsing gruop multiple keyword strategy, value={}, bizId={}", (Object)value, (Object)bizId);
            strategy = MultipleKeywordStrategy.REPLY_OPTION;
        }
        return strategy;
    }

    @Override
    public boolean getGroupReplyDeduplicateEnabled(Long bizId) {
        return this.settingService.getBooleanOrDefault(bizId, SystemParamName.GROUP_REPLY_DEDUPLICATE_ENABLED.getKey(), Boolean.valueOf(false));
    }

    @Override
    public Integer getGroupReplyDeduplicateTime(Long bizId) {
        return this.settingService.getIntegerOrDefault(bizId, SystemParamName.GROUP_REPLY_DEDUPLICATE_TIME.getKey(), Integer.valueOf(60));
    }

    @Override
    public MultipleKeywordStrategy getFriendMultipleKeywordStrategy(Long bizId) {
        MultipleKeywordStrategy strategy;
        Integer value = this.settingService.getIntegerOrDefault(bizId, SystemParamName.FRIEND_MULTIPLE_KEYWORD_STRATEGY.getKey(), Integer.valueOf(DEFAULT_MULTIPLY_KEYWORD_STRATEGY));
        try {
            strategy = MultipleKeywordStrategy.getType(value);
            if (strategy == null) {
                strategy = MultipleKeywordStrategy.REPLY_OPTION;
                log.warn("Unsupported friend multiple keyword strategy, value={}, bizId={}", (Object)value, (Object)bizId);
            }
        }
        catch (Exception e) {
            log.warn("Failed parsing friend multiple keyword strategy, value={}, bizId={}", (Object)value, (Object)bizId);
            strategy = MultipleKeywordStrategy.REPLY_OPTION;
        }
        return strategy;
    }

    @Override
    public boolean getFriendReplyDeduplicateEnabled(Long bizId) {
        return this.settingService.getBooleanOrDefault(bizId, SystemParamName.FRIEND_REPLY_DEDUPLICATE_ENABLED.getKey(), Boolean.valueOf(false));
    }

    @Override
    public Integer getFriendReplyDeduplicateTime(Long bizId) {
        return this.settingService.getIntegerOrDefault(bizId, SystemParamName.FRIEND_REPLY_DEDUPLICATE_TIME.getKey(), Integer.valueOf(60));
    }
}

