/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.reply.service.impl;

import cn.kinyun.scrm.vip.reply.dto.req.FriendKeywordReplyCheckReq;
import cn.kinyun.scrm.vip.reply.dto.req.FriendKeywordReplyReq;
import cn.kinyun.scrm.vip.reply.enums.AutoReplyRelationType;
import cn.kinyun.scrm.vip.reply.enums.AutoReplyType;
import cn.kinyun.scrm.vip.reply.enums.FriendMsgReplyType;
import cn.kinyun.scrm.vip.reply.service.FriendDefaultReplyService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.SHA1Utils;
import com.kuaike.scrm.dal.vip.dto.VipUserDto;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.vip.reply.entity.VipAutoReply;
import com.kuaike.scrm.dal.vip.reply.entity.VipAutoReplyWework;
import com.kuaike.scrm.dal.vip.reply.enums.VipWeworkConfigType;
import com.kuaike.scrm.dal.vip.reply.mapper.VipAutoReplyMapper;
import com.kuaike.scrm.dal.vip.reply.mapper.VipAutoReplyWeworkMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FriendDefaultReplyServiceImpl
implements FriendDefaultReplyService {
    private static final Logger log = LoggerFactory.getLogger(FriendDefaultReplyServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private VipAutoReplyMapper vipAutoReplyMapper;
    @Autowired
    private VipAutoReplyWeworkMapper vipAutoReplyWeworkMapper;
    @Autowired
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;

    private List<String> toWeworkDigitIds(Long bizId, String corpId, List<String> weworkUserNums) {
        List weworkUsers = this.weworkUserMapper.queryWeworkUsersByDigitId(corpId, weworkUserNums);
        if (CollectionUtils.isEmpty((Collection)weworkUsers)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u9009\u62e9\u5f00\u901a\u4f01\u5fae\u5b9d\u7684\u7528\u6237");
        }
        if (CollectionUtils.isEmpty(weworkUsers = weworkUsers.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getWeworkDigitId())).collect(Collectors.toList()))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u9009\u62e9\u5f00\u901a\u4f01\u5fae\u5b9d\u7684\u5408\u6cd5\u7528\u6237");
        }
        List list = this.vipWeworkAuthorizeAccountMapper.batchQueryByWeworkNums(bizId, weworkUserNums);
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6240\u9009\u7528\u6237\u672a\u5f00\u901a\u4f01\u5fae\u5b9d");
        }
        Map<String, VipUserDto> mapToWeworkUserNum = list.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getWeworkDigitId())).collect(Collectors.toMap(VipUserDto::getWeworkUserNum, vipUserDto -> vipUserDto, (v1, v2) -> v2));
        for (WeworkUser item2 : weworkUsers) {
            VipUserDto vipUserDto2 = mapToWeworkUserNum.get(item2.getNum());
            String userName = item2.getName();
            if (!Objects.isNull(vipUserDto2)) continue;
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "[" + userName + "]\u672a\u5f00\u901a\u4f01\u5fae\u5b9d");
        }
        return weworkUsers.stream().map(WeworkUser::getWeworkDigitId).collect(Collectors.toList());
    }

    @Override
    public Long add(FriendKeywordReplyReq params) {
        log.info("Add friend default reply with params={}", (Object)params);
        this.validate(params);
        List<String> weworkDigitIds = this.toWeworkDigitIds(params.getBizId(), params.getCorpId(), params.getWeworkIds());
        VipAutoReply reply = new VipAutoReply();
        reply.setRelationType(Integer.valueOf(AutoReplyRelationType.WEWORK.getValue()));
        reply.setReplyType(Integer.valueOf(AutoReplyType.DEFAULT_REPLY.getValue()));
        String message = JacksonUtil.obj2Str(params.getReplyMessage());
        reply.setMessage(message);
        String digest = SHA1Utils.digest((String)message);
        reply.setDigest(digest);
        FriendMsgReplyType rType = FriendMsgReplyType.getType(params.getRtype());
        reply.setRequest(rType.getDesc());
        reply.setCreateBy(params.getOperatorId());
        reply.setUpdateBy(params.getOperatorId());
        reply.setNodeId(params.getNodeId());
        reply.setBizId(params.getBizId());
        reply.setNum(this.idGen.getNum());
        reply.setCreateTime(new Date());
        reply.setUpdateTime(new Date());
        this.vipAutoReplyMapper.insertSelective((Object)reply);
        params.setId(reply.getId());
        List<VipAutoReplyWework> weworkList = this.newVipReplyWeworkList(params.getBizId(), reply.getId(), weworkDigitIds, params.getOperatorId());
        this.vipAutoReplyWeworkMapper.batchInsert(weworkList);
        List existWeworkList = this.vipAutoReplyWeworkMapper.queryExistFriendDefaultReply(rType.getDesc(), weworkDigitIds, params.getId(), Integer.valueOf(AutoReplyType.DEFAULT_REPLY.getValue()), Integer.valueOf(AutoReplyRelationType.WEWORK.getValue()), params.getBizId());
        if (CollectionUtils.isNotEmpty((Collection)existWeworkList)) {
            this.clear(existWeworkList, params.getOperatorId());
        }
        return params.getId();
    }

    @Override
    public void modify(FriendKeywordReplyReq params) {
        log.info("Modify friend default reply with params={}", (Object)params);
        this.validate(params);
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e0d\u53ef\u4e3a\u7a7a");
        List<String> weworkDigitIds = this.toWeworkDigitIds(params.getBizId(), params.getCorpId(), params.getWeworkIds());
        params.setRelationType(AutoReplyRelationType.WEWORK.getValue());
        params.setReplyType(AutoReplyType.DEFAULT_REPLY.getValue());
        Long updateBy = params.getOperatorId();
        Date updateTime = new Date();
        VipAutoReply reply = new VipAutoReply();
        reply.setId(params.getId());
        String message = JacksonUtil.obj2Str(params.getReplyMessage());
        reply.setMessage(message);
        String digest = SHA1Utils.digest((String)message);
        reply.setDigest(digest);
        reply.setUpdateBy(updateBy);
        reply.setUpdateTime(updateTime);
        this.vipAutoReplyMapper.updateByPrimaryKeySelective((Object)reply);
        List<VipAutoReplyWework> weworkList = this.newVipReplyWeworkList(params.getBizId(), reply.getId(), weworkDigitIds, params.getOperatorId());
        List<Long> ids = Collections.singletonList(params.getId());
        this.vipAutoReplyWeworkMapper.logicDeleteByAutoReplyIds(ids, updateBy, updateTime);
        this.vipAutoReplyWeworkMapper.batchInsert(weworkList);
        FriendMsgReplyType rType = FriendMsgReplyType.getType(params.getRtype());
        List existWeworkList = this.vipAutoReplyWeworkMapper.queryExistFriendDefaultReply(rType.getDesc(), weworkDigitIds, params.getId(), Integer.valueOf(AutoReplyType.DEFAULT_REPLY.getValue()), Integer.valueOf(AutoReplyRelationType.WEWORK.getValue()), params.getBizId());
        if (CollectionUtils.isNotEmpty((Collection)existWeworkList)) {
            this.clear(existWeworkList, params.getOperatorId());
        }
    }

    @Override
    public Boolean check(FriendKeywordReplyCheckReq params) {
        log.info("Check friend default reply with params={}", (Object)params);
        if (CollectionUtils.isEmpty(params.getWeworkIds())) {
            log.info("\u5fae\u4fe1\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u68c0\u6d4b");
            return false;
        }
        List<String> weworkDigitIds = this.toWeworkDigitIds(params.getBizId(), params.getCorpId(), params.getWeworkIds());
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"\u5546\u6237ID\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getRtype() != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a");
        FriendMsgReplyType rType = FriendMsgReplyType.getType(params.getRtype());
        Preconditions.checkArgument((rType != null ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
        Preconditions.checkArgument((rType != FriendMsgReplyType.KEYWORD ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
        List existWeworkIds = this.vipAutoReplyWeworkMapper.queryExistFriendDefaultReply(rType.getDesc(), weworkDigitIds, params.getId(), Integer.valueOf(AutoReplyType.DEFAULT_REPLY.getValue()), Integer.valueOf(AutoReplyRelationType.WEWORK.getValue()), params.getBizId());
        return CollectionUtils.isNotEmpty((Collection)existWeworkIds);
    }

    @Override
    public void validate(FriendKeywordReplyReq params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getRtype() != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        FriendMsgReplyType rType = FriendMsgReplyType.getType(params.getRtype());
        Preconditions.checkArgument((rType != null ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
        Preconditions.checkArgument((rType != FriendMsgReplyType.KEYWORD ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getNodeId() != null ? 1 : 0) != 0, (Object)"nodeId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getWeworkIds()), (Object)"weworkIds\u4e0d\u80fd\u4e3a\u7a7a");
        for (String weworkId : params.getWeworkIds()) {
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{weworkId}), (Object)"weworkId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getReplyMessage()), (Object)"\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private List<VipAutoReplyWework> newVipReplyWeworkList(Long bizId, Long autoReplyId, List<String> weworkDigitIds, Long operatorId) {
        ArrayList<VipAutoReplyWework> list = new ArrayList<VipAutoReplyWework>(weworkDigitIds.size());
        for (String weworkId : weworkDigitIds) {
            VipAutoReplyWework replyWework = new VipAutoReplyWework();
            replyWework.setAutoReplyId(autoReplyId);
            replyWework.setWeworkId(weworkId);
            replyWework.setCreateBy(operatorId);
            replyWework.setUpdateBy(operatorId);
            replyWework.setNum(this.idGen.getNum());
            replyWework.setBizId(bizId);
            replyWework.setCreateTime(new Date());
            replyWework.setUpdateTime(new Date());
            replyWework.setType(Integer.valueOf(VipWeworkConfigType.KEYWORD_REPLY.getValue()));
            list.add(replyWework);
        }
        return list;
    }

    private void clear(List<VipAutoReplyWework> existWeworkList, Long updateBy) {
        Date updateTime = new Date();
        Set existWeworkIds = existWeworkList.stream().map(VipAutoReplyWework::getId).collect(Collectors.toSet());
        this.vipAutoReplyWeworkMapper.logicDeleteByPrimaryKeys(existWeworkIds, updateBy, updateTime);
        Set existReplyIds = existWeworkList.stream().map(VipAutoReplyWework::getAutoReplyId).collect(Collectors.toSet());
        Map existWeworkCountMap = this.vipAutoReplyWeworkMapper.queryExistCount(existReplyIds);
        HashSet toDel = Sets.newHashSet();
        for (Long replyId : existReplyIds) {
            Integer count = existWeworkCountMap.getOrDefault(replyId, 0);
            if (count != 0) continue;
            toDel.add(replyId);
        }
        if (CollectionUtils.isNotEmpty((Collection)toDel)) {
            this.vipAutoReplyMapper.logicDeleteByPrimaryKeys((Collection)toDel, updateBy, updateTime);
        }
    }
}

