/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.cache.service.impl;

import cn.kinyun.scrm.vip.cache.dto.CachedReplyData;
import cn.kinyun.scrm.vip.cache.dto.CachedReplyMsg;
import cn.kinyun.scrm.vip.cache.service.FriendKeywordCacheService;
import cn.kinyun.scrm.vip.cache.service.impl.AbstractMerchantKeywordCache;
import cn.kinyun.scrm.vip.reply.enums.AutoReplyRelationType;
import cn.kinyun.scrm.vip.reply.enums.AutoReplyType;
import cn.kinyun.scrm.vip.reply.enums.KeywordMatchType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.utils.SHA1Utils;
import com.kuaike.scrm.dal.vip.reply.entity.VipAutoReply;
import com.kuaike.scrm.dal.vip.reply.entity.VipAutoReplyWework;
import com.kuaike.scrm.dal.vip.reply.entity.VipAutoReplyWord;
import com.kuaike.scrm.dal.vip.reply.mapper.VipAutoReplyMapper;
import com.kuaike.scrm.dal.vip.reply.mapper.VipAutoReplyWeworkMapper;
import com.kuaike.scrm.dal.vip.reply.mapper.VipAutoReplyWordMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class FriendKeywordCacheServiceImpl
extends AbstractMerchantKeywordCache<String>
implements FriendKeywordCacheService {
    private static final Logger log = LoggerFactory.getLogger(FriendKeywordCacheServiceImpl.class);
    @Autowired
    private VipAutoReplyMapper vipAutoReplyMapper;
    @Autowired
    private VipAutoReplyWordMapper vipAutoReplyWordMapper;
    @Autowired
    private VipAutoReplyWeworkMapper vipAutoReplyWeworkMapper;
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.friendReplyVersion:friend_reply_version}")
    private String versionRedisKey;

    @Override
    public void newVersion() {
        super.reset();
    }

    @Override
    @Scheduled(fixedRate=5000L)
    public void refresh() {
        super.refresh();
    }

    @Override
    protected String getVersionRedisKey() {
        return this.versionRedisKey;
    }

    @Override
    protected Long getExpiredInSecond() {
        return 300L;
    }

    @Override
    protected void initialize() {
        ConcurrentMap merchantDataMap = Maps.newConcurrentMap();
        VipAutoReply example = new VipAutoReply();
        example.setReplyType(Integer.valueOf(AutoReplyType.KEYWORD_REPLY.getValue()));
        example.setRelationType(Integer.valueOf(AutoReplyRelationType.WEWORK.getValue()));
        example.setEnabled(Integer.valueOf(1));
        example.setIsDeleted(Integer.valueOf(0));
        List replyList = this.vipAutoReplyMapper.select((Object)example);
        List ids = replyList.stream().map(VipAutoReply::getId).collect(Collectors.toList());
        List wordList = this.vipAutoReplyWordMapper.selectByAutoReplyIds(ids);
        Map<Long, List<VipAutoReplyWord>> wordMap = wordList.stream().collect(Collectors.groupingBy(VipAutoReplyWord::getAutoReplyId));
        List weworkList = this.vipAutoReplyWeworkMapper.selectByAutoReplyIds(ids);
        Map<Long, List<VipAutoReplyWework>> weworkMap = weworkList.stream().collect(Collectors.groupingBy(VipAutoReplyWework::getAutoReplyId));
        ArrayList uselessIds = Lists.newArrayList();
        for (VipAutoReply it : replyList) {
            Long id = it.getId();
            Long businessCustomerId = it.getBizId();
            Map cachedReplyData = merchantDataMap.computeIfAbsent(businessCustomerId, k -> Maps.newHashMap());
            List<VipAutoReplyWord> replyWordList = wordMap.get(id);
            List<VipAutoReplyWework> replyWework = weworkMap.get(id);
            if (CollectionUtils.isEmpty(replyWordList) || CollectionUtils.isEmpty(replyWework)) {
                uselessIds.add(id);
                continue;
            }
            HashMap accurateMatch = Maps.newHashMap();
            HashSet dict = Sets.newHashSet();
            HashMap wordToReplyIds = Maps.newHashMap();
            HashMap<String, CachedReplyMsg> idToReplyMap = new HashMap<String, CachedReplyMsg>();
            CachedReplyMsg reply = new CachedReplyMsg();
            reply.setReplyId(id);
            reply.setDesc(it.getRequest());
            reply.setMsg(it.getMessage());
            reply.setUpdateTime(it.getUpdateTime().getTime());
            if (StringUtils.isNotBlank((CharSequence)it.getDigest())) {
                reply.setDigest(it.getDigest());
            } else {
                reply.setDigest(SHA1Utils.digest((String)it.getMessage()));
            }
            idToReplyMap.put(reply.getId(), reply);
            for (VipAutoReplyWord replyWord : replyWordList) {
                String[] words;
                String keyword = replyWord.getKeyword();
                Integer type = replyWord.getType();
                if (type.intValue() == KeywordMatchType.ACCURATE.getValue()) {
                    accurateMatch.put(keyword, reply.getId());
                    continue;
                }
                for (String w : words = StringUtils.split((String)keyword, (String)",")) {
                    dict.add(w);
                    List list = wordToReplyIds.computeIfAbsent(w, k -> new ArrayList());
                    list.add(reply.getId());
                }
            }
            for (VipAutoReplyWework wework : replyWework) {
                String weworkId = wework.getWeworkId();
                CachedReplyData cache = (CachedReplyData)cachedReplyData.get(weworkId);
                if (cache == null) {
                    cache = new CachedReplyData();
                    cachedReplyData.put(weworkId, cache);
                }
                cache.merge(accurateMatch, dict, wordToReplyIds, idToReplyMap);
            }
        }
        this.cachedReplyData = merchantDataMap;
        if (CollectionUtils.isNotEmpty((Collection)uselessIds)) {
            log.warn("Useless reply ids={}", (Object)uselessIds);
        }
    }
}

