/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.cache.service;

import java.time.Duration;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class VersionedCache
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(VersionedCache.class);
    protected boolean initialized;
    protected String version = "";
    @Autowired
    protected RedisTemplate<String, Object> redisTemplate;

    public void run(String ... args) throws Exception {
        this.initialized = true;
        this.refresh();
    }

    protected abstract String getVersionRedisKey();

    protected abstract Long getExpiredInSecond();

    protected abstract void initialize();

    private String initVersion() {
        String redisKey = this.getVersionRedisKey();
        String value = UUID.randomUUID().toString();
        try {
            Long expire = this.getExpiredInSecond();
            Boolean ok = expire != null && expire > 0L ? this.redisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)value, Duration.ofSeconds(expire)) : this.redisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)value);
            if (ok != null && ok.booleanValue()) {
                log.info("Cache version initialized, key:{}, value:{}, expire:{}", new Object[]{redisKey, value, expire});
            }
        }
        catch (Exception e) {
            log.error("Failed init cache version, key:{}, value:{}", new Object[]{redisKey, value, e});
        }
        return value;
    }

    private String getCurrentVersion() {
        String redisKey = this.getVersionRedisKey();
        Object obj = this.redisTemplate.opsForValue().get((Object)redisKey);
        String value = obj == null ? this.initVersion() : (String)obj;
        return value;
    }

    protected void reset() {
        String redisKey = this.getVersionRedisKey();
        String value = UUID.randomUUID().toString();
        try {
            Long expire = this.getExpiredInSecond();
            if (expire != null && expire > 0L) {
                this.redisTemplate.opsForValue().set((Object)redisKey, (Object)value, Duration.ofSeconds(expire));
            } else {
                this.redisTemplate.opsForValue().set((Object)redisKey, (Object)value);
            }
            log.info("Set new cache version, key:{}, value:{}, expire:{}", new Object[]{redisKey, value, expire});
        }
        catch (Exception e) {
            log.error("Failed to create new version", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        if (!this.initialized) {
            return;
        }
        String currentVersion = this.getCurrentVersion();
        VersionedCache versionedCache = this;
        synchronized (versionedCache) {
            if (this.version.equals(currentVersion)) {
                return;
            }
            this.version = currentVersion;
            long time = System.currentTimeMillis();
            this.initialize();
            time = System.currentTimeMillis() - time;
            log.info("{} cache refreshed in {}ms", (Object)this.getClass().getSimpleName(), (Object)time);
        }
    }
}

