/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.handler.common;

import cn.kinyun.scrm.vip.cache.dto.MatchedResult;
import cn.kinyun.scrm.vip.cache.dto.WordHit;
import cn.kinyun.scrm.vip.context.ReplyContext;
import cn.kinyun.scrm.vip.context.ReplyContextUtil;
import cn.kinyun.scrm.vip.handler.common.MsgDigestHelper;
import cn.kinyun.scrm.vip.handler.common.ReplyMsgSendHelper;
import cn.kinyun.scrm.vip.reply.enums.MultipleKeywordStrategy;
import cn.kinyun.scrm.vip.reply.service.ReplySettingService;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KeywordReplyHelper {
    private static final Logger log = LoggerFactory.getLogger(KeywordReplyHelper.class);
    @Autowired
    private ReplyMsgSendHelper replyMsgSendHelper;
    @Autowired
    private MsgDigestHelper msgDigestHelper;
    @Autowired
    private ReplySettingService settingService;

    private void removeCached(MatchedResult result) {
        Set<String> words = this.msgDigestHelper.isCached(result.getWords());
        if (CollectionUtils.isEmpty(words)) {
            return;
        }
        Iterator itor = result.getHits().iterator();
        while (itor.hasNext()) {
            WordHit hit = (WordHit)itor.next();
            if (!words.contains(hit.getWord())) continue;
            log.info("remove cached word={}", (Object)hit.getWord());
            itor.remove();
        }
    }

    public boolean friendKeyword(MatchedResult result) {
        ReplyContext ctx = ReplyContextUtil.get();
        log.info("matching keyword requestId={}, matched={}", (Object)ctx.getRequestId(), (Object)result.getWords());
        if (result.isEmpty()) {
            log.info("No matched words, requestId={}", (Object)ctx.getRequestId());
            return false;
        }
        this.removeCached(result);
        if (result.isEmpty()) {
            log.info("No matched words, requestId={}", (Object)ctx.getRequestId());
            return false;
        }
        List matched = result.getList();
        if (CollectionUtils.isEmpty((Collection)matched)) {
            return false;
        }
        if (matched.size() > 1) {
            MultipleKeywordStrategy strategy = this.settingService.getFriendMultipleKeywordStrategy(ctx.getBizId());
            switch (strategy) {
                case REPLY_OPTION: {
                    return this.replyMsgSendHelper.sendFriendOption(ctx.getPureMsg(), matched);
                }
                case REPLY_NEAREST_ONE: {
                    WordHit hit = (WordHit)result.getHits().get(0);
                    if (hit == null) {
                        log.info("All matched reply msg digest is cached, nothing to reply. requestId={}", (Object)ctx.getRequestId());
                        return false;
                    }
                    return this.replyMsgSendHelper.sendFriendMsg(ctx.getPureMsg(), hit.getWord(), hit.first());
                }
            }
            log.warn("Unsupported multiple keyword strategy={}", (Object)strategy);
            return this.replyMsgSendHelper.sendFriendOption(ctx.getPureMsg(), matched);
        }
        WordHit hit = (WordHit)result.getHits().get(0);
        return this.replyMsgSendHelper.sendFriendMsg(ctx.getPureMsg(), hit.getWord(), hit.first());
    }
}

