/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.handler;

import cn.kinyun.scrm.vip.context.ReplyContext;
import cn.kinyun.scrm.vip.context.ReplyContextUtil;
import cn.kinyun.scrm.vip.handler.AbstractDispatcher;
import cn.kinyun.scrm.vip.handler.utils.VipMsgLock;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAccount;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkConversationMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkReportChatRoomMapper;
import com.kuaike.scrm.vip.dto.model.WeworkMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupMsgRecvHandler
extends AbstractDispatcher {
    private static final Logger log = LoggerFactory.getLogger(GroupMsgRecvHandler.class);
    @Autowired
    private VipMsgLock msgLock;
    @Autowired
    private VipWeworkAccountMapper weworkAccountMapper;
    @Autowired
    private VipWeworkReportChatRoomMapper vipWeworkReportChatRoomMapper;
    @Autowired
    private VipWeworkChatRoomRelationMapper vipWeworkChatRoomRelationMapper;
    @Autowired
    private VipWeworkConversationMapper vipWeworkConversationMapper;

    @Override
    public void dispatch(WeworkMessage weworkMessage) {
        ReplyContext ctx = ReplyContextUtil.get();
        ctx.setChatRoomId(weworkMessage.getConId());
        String owner = weworkMessage.getOwner();
        if (StringUtils.isBlank((CharSequence)owner)) {
            log.warn("owner is blank");
        }
        ctx.setChatRoomOwner(ctx.getWeworkId().equals(owner));
        if (!this.msgLock.locked(ctx.getBizId(), ctx.getAppInfo())) {
            ctx.setLocked(false);
            if (weworkMessage.getContentType() != 1002) {
                log.info("Not locked, requestId={}", (Object)ctx.getRequestId());
                return;
            }
        }
        ctx.setLocked(true);
        Long ownerBizId = this.getOwnerBizId(ctx);
        if (ownerBizId != null && !ownerBizId.equals(ctx.getBizId())) {
            log.info("From different businessCustomer, ignore this message. owner={}, robot={}", (Object)ownerBizId, (Object)ctx.getBizId());
            return;
        }
        super.dispatch(weworkMessage);
    }

    private Long getOwnerBizId(ReplyContext ctx) {
        VipWeworkAccount ownerAccount = this.weworkAccountMapper.selectByWeworkId(ctx.getOwner());
        if (ownerAccount == null || ownerAccount.getBizId() == null) {
            return null;
        }
        return ownerAccount.getBizId();
    }

    @Override
    public boolean dismissRoom(WeworkMessage weworkMessage) {
        ReplyContext ctx = ReplyContextUtil.get();
        if (StringUtils.isNotBlank((CharSequence)ctx.getChatRoomId())) {
            int chatRoomCount = this.vipWeworkReportChatRoomMapper.dismiss(ctx.getChatRoomId());
            int memberCount = this.vipWeworkChatRoomRelationMapper.dismiss(ctx.getChatRoomId());
            int conversationCount = this.vipWeworkConversationMapper.dismissRoom(ctx.getChatRoomId());
            log.info("{}\u5df2\u89e3\u6563\u7fa4\u804a{}\uff0c\u6240\u6709\u7fa4\u6210\u5458\u88ab\u79fb\u51fa\u4e86\u7fa4\u804a\u3002\u5220\u9664\u7fa4:{}, \u5220\u9664\u6210\u5458:{}, \u5220\u9664\u4f1a\u8bdd:{}", new Object[]{ctx.getOwner(), ctx.getChatRoomId(), chatRoomCount, memberCount, conversationCount});
        }
        return false;
    }
}

