/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.utils;

import cn.kinyun.link.service.push.request.BaseSendReq;
import cn.kinyun.link.service.push.request.SendFileReq;
import cn.kinyun.link.service.push.request.SendImgReq;
import cn.kinyun.link.service.push.request.SendLinkCardReq;
import cn.kinyun.link.service.push.request.SendTextReq;
import cn.kinyun.link.service.push.request.SendVideoReq;
import cn.kinyun.link.service.push.request.SendVoiceReq;
import com.kuaike.scrm.common.dto.jsmsg.FileDto;
import com.kuaike.scrm.common.dto.jsmsg.JsNewsDto;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.JsMsgType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UniformMsgToLinkMsg {
    private static final Logger log = LoggerFactory.getLogger(UniformMsgToLinkMsg.class);

    private UniformMsgToLinkMsg() {
    }

    public static BaseSendReq convert(UniformMsgDto message) {
        JsMsgType type = JsMsgType.get((String)message.getMsgType());
        if (type == null) {
            log.warn("\u672a\u77e5\u6d88\u606f\u7c7b\u578b, type={}", (Object)message.getMsgType());
            return null;
        }
        switch (type) {
            case TEXT: 
            case MEETING: 
            case FRIEND_FISSION_WORDS: {
                return UniformMsgToLinkMsg.text(message);
            }
            case IMAGE: {
                return UniformMsgToLinkMsg.image(message);
            }
            case VIDEO: {
                return UniformMsgToLinkMsg.video(message);
            }
            case VOICE: {
                return UniformMsgToLinkMsg.voice(message);
            }
            case NEWS: {
                return UniformMsgToLinkMsg.link(message);
            }
            case MINI_PROGRAM: {
                log.warn("\u6682\u4e0d\u652f\u6301\u5c0f\u7a0b\u5e8f:{}", (Object)message.getMiniprogram());
                return null;
            }
            case FILE: {
                return UniformMsgToLinkMsg.file(message);
            }
        }
        log.info("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b:{}", (Object)type);
        return null;
    }

    public static SendTextReq text(UniformMsgDto message) {
        SendTextReq sendTextReq = new SendTextReq();
        sendTextReq.setTextContent(message.getContent());
        if (StringUtils.isNotBlank((CharSequence)message.getQuoteMsgRequestId())) {
            sendTextReq.setQuoteMsgRequestId(message.getQuoteMsgRequestId());
        }
        return sendTextReq;
    }

    public static SendImgReq image(UniformMsgDto message) {
        FileDto file = message.getFile();
        SendImgReq sendImgReq = new SendImgReq();
        sendImgReq.setImgUrl(file.getFileUrl());
        return sendImgReq;
    }

    public static SendVideoReq video(UniformMsgDto message) {
        FileDto file = message.getFile();
        SendVideoReq sendVideoReq = new SendVideoReq();
        sendVideoReq.setVideoUrl(file.getFileUrl());
        return sendVideoReq;
    }

    public static SendVoiceReq voice(UniformMsgDto message) {
        FileDto file = message.getFile();
        SendVoiceReq sendVoiceReq = new SendVoiceReq();
        sendVoiceReq.setVoiceUrl(file.getExtraUrl());
        sendVoiceReq.setVoiceTime(file.getVoiceTime().intValue());
        return sendVoiceReq;
    }

    public static SendLinkCardReq link(UniformMsgDto message) {
        JsNewsDto news = message.getNews();
        SendLinkCardReq sendLinkCardReq = new SendLinkCardReq();
        sendLinkCardReq.setUrl(news.getLink());
        sendLinkCardReq.setTitle(news.getTitle());
        sendLinkCardReq.setDesc(news.getDesc());
        sendLinkCardReq.setIconUrl(news.getImgUrl());
        return sendLinkCardReq;
    }

    public static BaseSendReq file(UniformMsgDto message) {
        FileDto file = message.getFile();
        if (StringUtils.endsWithIgnoreCase((CharSequence)file.getFileUrl(), (CharSequence)".png") || StringUtils.endsWithIgnoreCase((CharSequence)file.getFileUrl(), (CharSequence)".jpeg")) {
            SendImgReq image = new SendImgReq();
            image.setImgUrl(file.getFileUrl());
            return image;
        }
        SendFileReq msg = new SendFileReq();
        msg.setTitle(file.getFileName());
        msg.setFileUrl(file.getFileUrl());
        return msg;
    }
}

