/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.service.OperateService;
import cn.kinyun.link.service.response.WeworkStatusInfo;
import cn.kinyun.scrm.vip.dto.UserVipStatusDto;
import cn.kinyun.scrm.vip.service.VipWeworkService;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAuthorizeAccount;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VipWeworkServiceImpl
implements VipWeworkService {
    private static final Logger log = LoggerFactory.getLogger(VipWeworkServiceImpl.class);
    @Autowired
    private OperateService operateService;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;

    @Override
    public UserVipStatusDto getUserVipStatus(Long bizId, String weworkUserNum) {
        BaseResponse weworksStatus;
        if (StringUtils.isEmpty((CharSequence)weworkUserNum)) {
            return new UserVipStatusDto();
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
        if (weworkUser == null) {
            log.warn("weworkUser is null weworkUserNum: {}", (Object)weworkUserNum);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230weworkUser");
        }
        UserVipStatusDto userVipStatusDto = new UserVipStatusDto();
        userVipStatusDto.setWeworkUserNum(weworkUserNum);
        userVipStatusDto.setWeworkUserName(weworkUser.getName());
        VipWeworkAuthorizeAccount account = this.vipWeworkAuthorizeAccountMapper.queryOpenVipUser(bizId, weworkUserNum);
        if (account == null) {
            userVipStatusDto.setIsOpenVip(0);
            return userVipStatusDto;
        }
        if (StringUtils.isNotBlank((CharSequence)weworkUser.getVcode())) {
            userVipStatusDto.setOauthStatus(1);
        } else {
            userVipStatusDto.setOauthStatus(0);
        }
        String weworkDigitId = weworkUser.getWeworkDigitId();
        int status = 0;
        if (StringUtils.isNotBlank((CharSequence)weworkDigitId) && (weworksStatus = this.operateService.queryWeworksStatus(bizId, (List)Lists.newArrayList((Object[])new String[]{weworkDigitId}))) != null && weworksStatus.getCode() == 0L) {
            List statusData = (List)weworksStatus.getData();
            if (CollectionUtils.isEmpty((Collection)statusData)) {
                log.warn("wework online status is empty");
            } else {
                for (WeworkStatusInfo statusInfo : statusData) {
                    if (!statusInfo.getWeworkId().equals(weworkDigitId)) continue;
                    status = statusInfo.isOnline() ? 1 : 0;
                    break;
                }
            }
        }
        userVipStatusDto.setStatus(status);
        userVipStatusDto.setIsOpenVip(1);
        userVipStatusDto.setExpireTime(account.getEndTime());
        return userVipStatusDto;
    }
}

