/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.scrm.vip.service.VipFileService;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.HttpClientUtils;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.enums.FileStatus;
import com.kuaike.scrm.dal.vip.entity.VipWeworkFile;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkFileMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class VipFileServiceImpl
implements VipFileService {
    private static final Logger log = LoggerFactory.getLogger(VipFileServiceImpl.class);
    @Autowired
    private VipWeworkFileMapper vipWeworkFileMapper;
    @Value(value="${silk-v3-decoder.path:}")
    private String basePath;
    @Autowired
    private AliyunOss aliyunOss;
    private static final Cache<String, Object> FILE_CONVERT_RECORDER = CacheBuilder.newBuilder().expireAfterWrite(40L, TimeUnit.SECONDS).initialCapacity(1000).build();
    private static final String FILE_TYPE_MP3_SUFFIX = ".mp3";
    private static final String FILE_PROCESSED = "processed";

    @Override
    public String manualConvertAmr2Mp3(String corpId, String msgId) {
        log.info("manualConvertAmr2Mp3 with msgId={}", (Object)msgId);
        VipWeworkFile weworkFile = new VipWeworkFile();
        weworkFile.setUniqueId(msgId);
        weworkFile = (VipWeworkFile)this.vipWeworkFileMapper.selectOne((Object)weworkFile);
        if (weworkFile == null) {
            log.info("\u627e\u4e0d\u5230\u6d88\u606f\u6587\u4ef6");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u627e\u4e0d\u5230\u6d88\u606f\u6587\u4ef6");
        }
        if (StringUtils.isNotBlank((CharSequence)weworkFile.getTranscodeFileUrl())) {
            return weworkFile.getTranscodeFileUrl();
        }
        String transferPatch = this.downloadAmrFileAndUploadMp3File(weworkFile, corpId);
        if (StringUtils.isBlank((CharSequence)transferPatch)) {
            weworkFile.setStatus(Integer.valueOf(FileStatus.CONVERT_TO_MP3_FAIL.getStatus()));
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8f6c\u7801\u5931\u8d25");
        }
        if (transferPatch.equals(FILE_PROCESSED)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6b63\u5728\u5904\u7406\u4e2d");
        }
        weworkFile.setStatus(Integer.valueOf(FileStatus.HAVE_CONVERT_TO_MP3.getStatus()));
        weworkFile.setTranscodeFileUrl(transferPatch);
        this.vipWeworkFileMapper.updateByPrimaryKeySelective((Object)weworkFile);
        return transferPatch;
    }

    private String downloadAmrFileAndUploadMp3File(VipWeworkFile weworkFile, String corpId) {
        String amrPath = weworkFile.getFileUrl();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)amrPath), (Object)"amrPath is not blank");
        log.info("downloadAmrFileAndUploadMp3File amrPath:{}", (Object)amrPath);
        String extName = FilenameUtils.getExtension((String)amrPath);
        String fileName = FilenameUtils.getBaseName((String)amrPath);
        String fileKey = VipFileServiceImpl.getFileKey(amrPath);
        log.info("basePath:{}, extName: {}, fileName:{}, fileKey:{}", new Object[]{this.basePath, extName, fileName, fileKey});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)fileKey), (Object)"fileKey is not null; amrPath is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.basePath), (Object)"basePath is not null");
        Object presentObject = FILE_CONVERT_RECORDER.getIfPresent((Object)amrPath);
        if (Objects.nonNull(presentObject)) {
            log.warn("request is already processed, amrPath={}", (Object)amrPath);
            return FILE_PROCESSED;
        }
        FILE_CONVERT_RECORDER.put((Object)amrPath, new Object());
        String aliYunUrl = null;
        boolean errorFlag = false;
        StopWatchDto watch = new StopWatchDto("downloadAmrFileAndUploadMp3File", true, log);
        watch.start("\u4e0b\u8f7d\u6587\u4ef6");
        byte[] bytes = new byte[]{};
        try {
            bytes = HttpClientUtils.download((String)amrPath);
        }
        catch (Exception e) {
            errorFlag = true;
            log.error("downloadAmrFileAndUploadMp3File download error; amrPath:{}, e", (Object)amrPath, (Object)e);
        }
        watch.stop();
        log.info("amrPath:{}", (Object)amrPath);
        if (errorFlag) {
            return null;
        }
        watch.start("\u5199\u5165arm\u6587\u4ef6");
        String localPath = FilenameUtils.getName((String)amrPath);
        File source = new File(localPath);
        try {
            IOUtils.write((byte[])bytes, (OutputStream)new FileOutputStream(source));
        }
        catch (IOException e) {
            errorFlag = true;
            log.error("downloadAmrFile and UploadMp3File write error; amrPath:{}", (Object)amrPath, (Object)e);
        }
        watch.stop();
        log.info("\u5199\u5165arm\u6587\u4ef6,fileName:{}", (Object)fileName);
        if (errorFlag) {
            return null;
        }
        watch.start("arm\u8f6c\u7801mp3");
        File target = this.convert(this.basePath, source.getAbsolutePath());
        watch.stop();
        log.info("amr\u8f6c\u7801mp3\u6587\u4ef6, fileName:{}", (Object)fileKey);
        watch.start("\u4e0a\u4f20mp3\u6587\u4ef6");
        if (target.exists()) {
            try {
                aliYunUrl = this.aliyunOss.uploadFile(corpId, target, fileKey);
                log.info("uploadFile success, url:{}", (Object)aliYunUrl);
            }
            catch (Exception e) {
                log.error("uploadFile amrPath:{}", (Object)amrPath, (Object)e);
            }
        } else {
            log.error("convert error, target file not exists, fileName:{}", (Object)fileName);
        }
        watch.stop();
        log.info("\u4e0a\u4f20mp3\u6587\u4ef6,fileName:{}", (Object)fileName);
        FileUtils.deleteQuietly((File)source);
        FileUtils.deleteQuietly((File)target);
        watch.print();
        FILE_CONVERT_RECORDER.invalidate((Object)amrPath);
        return aliYunUrl;
    }

    private File convert(String basePath, String fileName) {
        log.info("convert basePath:{}, fileName:{}", (Object)basePath, (Object)fileName);
        String[] command = new String[]{basePath + "converter.sh", fileName, "mp3"};
        try {
            String line;
            Process ps = Runtime.getRuntime().exec(command);
            BufferedReader stdReader = new BufferedReader(new InputStreamReader(ps.getInputStream()));
            while ((line = stdReader.readLine()) != null) {
                log.info("{}", (Object)line);
            }
            BufferedReader errReader = new BufferedReader(new InputStreamReader(ps.getInputStream()));
            while ((line = errReader.readLine()) != null) {
                log.error("{}", (Object)line);
            }
            int exitValue = ps.waitFor();
            if (0 != exitValue && log.isErrorEnabled()) {
                log.error("call shell failed. error code is :{}", (Object)exitValue);
            }
        }
        catch (Exception e) {
            log.error("convert error fileName:{}", (Object)fileName, (Object)e);
            Thread.currentThread().interrupt();
        }
        String mp3LocalPath = FilenameUtils.removeExtension((String)fileName) + FILE_TYPE_MP3_SUFFIX;
        log.info("convert mp3LocalPath:{}", (Object)mp3LocalPath);
        return new File(mp3LocalPath);
    }

    private static String getFileKey(String armPath) {
        String[] split = armPath.split("/");
        if (split.length > 2) {
            return split[split.length - 1] + FILE_TYPE_MP3_SUFFIX;
        }
        return null;
    }
}

