/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.scrm.vip.service.IdTranslateService;
import cn.kinyun.wework.sdk.api.external.ExternalContactClient;
import cn.kinyun.wework.sdk.entity.external.contact.ExternalContactRemark;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.kuaike.scrm.common.constants.VipIdTranslateConstants;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.vip.entity.VipWeworkContact;
import com.kuaike.scrm.dal.vip.entity.VipWeworkContactDigitId;
import com.kuaike.scrm.dal.vip.entity.VipWeworkReportChatRoom;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAuthorizeAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkContactDigitIdMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkReportChatRoomMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IdTranslateServiceImpl
implements IdTranslateService {
    private static final Logger log = LoggerFactory.getLogger(IdTranslateServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private VipWeworkContactDigitIdMapper vipWeworkContactDigitIdMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private VipWeworkAuthorizeAccountMapper vipWeworkAuthorizeAccountMapper;
    @Autowired
    private VipWeworkReportChatRoomMapper vipWeworkReportChatRoomMapper;
    @Autowired
    private ExternalContactClient externalContactClient;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("sync-vip-wework-contact-digit-id-%d").build());

    @Override
    public void addDescription(String corpId, String weworkUserId, String contactId) {
        WeworkContactRelation wcr = this.weworkContactRelationMapper.get(corpId, weworkUserId, contactId);
        this.addDescription(wcr);
    }

    @Override
    public void addDescription(WeworkContactRelation wcr) {
        String spec;
        if (wcr == null) {
            log.warn("wework_contact_relation is null");
            return;
        }
        String desc = wcr.getDescription();
        if (desc.contains(spec = "#wr" + wcr.getNum() + "#")) {
            return;
        }
        log.info("add spec num to description, corpId={}, weworkUserId={}, contactId={}", new Object[]{wcr.getCorpId(), wcr.getWeworkUserId(), wcr.getContactId()});
        if (StringUtils.isEmpty((CharSequence)desc)) {
            desc = spec;
            this.updateDescription(wcr, desc);
        } else if (desc.length() <= 135) {
            desc = desc + spec;
            this.updateDescription(wcr, desc);
        } else {
            log.info("description is too long, desc={}", (Object)desc);
            desc = desc.substring(0, 134) + spec;
            this.updateDescription(wcr, desc);
        }
    }

    private void updateDescription(WeworkContactRelation wcr, String desc) {
        String corpId = wcr.getCorpId();
        String weworkUserId = wcr.getWeworkUserId();
        String contactId = wcr.getContactId();
        ExternalContactRemark remark = new ExternalContactRemark();
        remark.setUserId(weworkUserId);
        remark.setExternalUserId(contactId);
        remark.setDescription(desc);
        try {
            this.externalContactClient.remark(corpId, remark);
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u5907\u6ce8\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void matchVipContact(VipWeworkContact vwc) {
        String desc = vwc.getDescription();
        if (StringUtils.isBlank((CharSequence)desc)) {
            return;
        }
        Matcher matcher = VipIdTranslateConstants.DESC_REGEX.matcher(desc);
        while (matcher.find()) {
            String num = matcher.group(1);
            this.executorService.submit(() -> {
                try {
                    this.matchedContactDigitId(vwc.getContactId(), num, desc);
                }
                catch (Exception e) {
                    log.error("\u4fdd\u5b58\u5ba2\u6237\u589e\u5f3a\u7248ID\u5931\u8d25, digitId={}, num={}, desc={}", new Object[]{vwc.getContactId(), num, desc, e});
                }
            });
        }
    }

    private void matchedContactDigitId(String digitId, String num, String desc) {
        log.info("VIP description matched, weworkDigitId={}, num={}, description={}", new Object[]{digitId, num, desc});
        WeworkContactRelation wcr = this.weworkContactRelationMapper.getByNum(num);
        if (wcr == null) {
            log.warn("wework_contact_relation not found, num={}", (Object)num);
            return;
        }
        Long bizId = wcr.getBizId();
        String corpId = wcr.getCorpId();
        String contactId = wcr.getContactId();
        log.info("\u8bb0\u5f55wework_digit_id,corpId={}, contactId={}, digitId={}", new Object[]{corpId, contactId, digitId});
        this.weworkContactMapper.setWeworkDigitId(corpId, contactId, digitId);
        Date now = new Date();
        VipWeworkContactDigitId weworkContactDigitId = new VipWeworkContactDigitId();
        weworkContactDigitId.setNum(this.idGen.getNum());
        weworkContactDigitId.setBizId(bizId);
        weworkContactDigitId.setCorpId(corpId);
        weworkContactDigitId.setContactId(contactId);
        weworkContactDigitId.setWeworkDigitId(digitId);
        weworkContactDigitId.setCreateTime(now);
        weworkContactDigitId.setUpdateTime(now);
        this.vipWeworkContactDigitIdMapper.insertOrUpdate(weworkContactDigitId);
        String flag = "#wr" + num + "#";
        String description = wcr.getDescription();
        description = description.replace(flag, "");
        this.updateDescription(wcr, description);
    }

    @Override
    public String matchChatRoomDigitId(Long bizId, String corpId, String chatId) {
        WeworkChatRoom weworkChatRoom = this.weworkChatRoomMapper.getWeworkChatRoom(corpId, chatId);
        if (weworkChatRoom == null) {
            log.warn("chat room not found, corpId={}, chatId={}", (Object)corpId, (Object)chatId);
            return null;
        }
        return this.matchChatRoomDigitId(weworkChatRoom);
    }

    @Override
    public String matchChatRoomDigitId(WeworkChatRoom weworkChatRoom) {
        if (weworkChatRoom == null) {
            log.warn("chat room is null");
            return null;
        }
        Long bizId = weworkChatRoom.getBizId();
        String corpId = weworkChatRoom.getCorpId();
        String chatId = weworkChatRoom.getWeworkRoomId();
        if (StringUtils.isNotBlank((CharSequence)weworkChatRoom.getWeworkDigitId())) {
            log.info("chat room already matched, corpId={}, chatId={}, digitId={}", new Object[]{corpId, chatId, weworkChatRoom.getWeworkDigitId()});
            return weworkChatRoom.getWeworkDigitId();
        }
        Date buildRoomTime = weworkChatRoom.getBuildRoomTime();
        List list = this.vipWeworkReportChatRoomMapper.queryByVCreateTime(bizId, buildRoomTime);
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("chat room not found, bizId={}, buildRoomTime={}", (Object)bizId, (Object)buildRoomTime);
            return null;
        }
        List chatRoomIds = list.stream().map(VipWeworkReportChatRoom::getChatRoomId).distinct().collect(Collectors.toList());
        if (chatRoomIds.size() == 1) {
            String digitId = (String)chatRoomIds.get(0);
            this.saveRoomDigitId(digitId, weworkChatRoom);
            return digitId;
        }
        String name = weworkChatRoom.getName();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            chatRoomIds = (list = list.stream().filter(it -> name.equals(it.getNickname()) || name.equals(it.getDisplayName())).collect(Collectors.toList())).stream().map(VipWeworkReportChatRoom::getChatRoomId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(chatRoomIds)) {
                log.info("no chat room found, corpId={}, buildTime={}, name={}", new Object[]{corpId, buildRoomTime, name});
                return null;
            }
            if (chatRoomIds.size() == 1) {
                String digitId = (String)chatRoomIds.get(0);
                this.saveRoomDigitId(digitId, weworkChatRoom);
                return digitId;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)weworkChatRoom.getNotice())) {
            String notice = weworkChatRoom.getNotice().trim();
            chatRoomIds = (list = list.stream().filter(it -> notice.equals(it.getNotice().trim())).collect(Collectors.toList())).stream().map(VipWeworkReportChatRoom::getChatRoomId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(chatRoomIds)) {
                log.info("no chat room found, corpId={}, buildRoomTime={}, name={}, notice={}", new Object[]{corpId, buildRoomTime, name, notice});
                return null;
            }
            if (chatRoomIds.size() == 1) {
                String digitId = (String)chatRoomIds.get(0);
                this.saveRoomDigitId(digitId, weworkChatRoom);
                return digitId;
            }
        }
        log.info("Too many digit ids, corpId={}, chatId={}, buildTime={}, digitIds={}", new Object[]{corpId, chatId, buildRoomTime, chatRoomIds});
        return null;
    }

    @Override
    public void matchVipChatRoom(VipWeworkReportChatRoom chatRoom) {
        this.executorService.submit(() -> this.matchVipChatRoomDigitId(chatRoom));
    }

    private void matchVipChatRoomDigitId(VipWeworkReportChatRoom chatRoom) {
        String digitId = chatRoom.getChatRoomId();
        Long bizId = chatRoom.getBizId();
        Date buildRoomTime = chatRoom.getvCreateTime();
        List matched = this.weworkChatRoomMapper.selectByWeworkDigitId(bizId, digitId);
        if (CollectionUtils.isNotEmpty((Collection)matched)) {
            log.info("chat room already matched, bizId={}, digitId={}, roomList={}", new Object[]{bizId, digitId, matched});
            return;
        }
        List list = this.weworkChatRoomMapper.queryByBuildRoomTime(bizId, buildRoomTime);
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("chat room not found, bizId={}, buildRoomTime={}", (Object)bizId, (Object)buildRoomTime);
            return;
        }
        if (list.size() == 1) {
            WeworkChatRoom room = (WeworkChatRoom)list.get(0);
            this.saveRoomDigitId(digitId, room);
            return;
        }
        String name = StringUtils.isBlank((CharSequence)chatRoom.getNickname()) ? chatRoom.getDisplayName() : chatRoom.getNickname();
        if (CollectionUtils.isEmpty(list = list.stream().filter(it -> Objects.equals(name, it.getName())).collect(Collectors.toList()))) {
            log.info("chat room not found, bizId={}, buildRoomTime={}, name={}", new Object[]{bizId, buildRoomTime, name});
            return;
        }
        if (list.size() == 1) {
            WeworkChatRoom room = (WeworkChatRoom)list.get(0);
            this.saveRoomDigitId(digitId, room);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)chatRoom.getNotice())) {
            String notice = chatRoom.getNotice().trim();
            if (CollectionUtils.isEmpty(list = list.stream().filter(it -> Objects.equals(notice, it.getNotice().trim())).collect(Collectors.toList()))) {
                log.info("chat room not found, bizId={}, buildRoomTime={}, name={}, notice={}", new Object[]{bizId, buildRoomTime, name, notice});
                return;
            }
            if (list.size() == 1) {
                WeworkChatRoom room = (WeworkChatRoom)list.get(0);
                this.saveRoomDigitId(digitId, room);
                return;
            }
        }
        log.info("Too many chatRoom ids, bizId={}, digitId={}, buildRoomTime={}", new Object[]{bizId, digitId, buildRoomTime});
    }

    private void saveRoomDigitId(String digitId, WeworkChatRoom room) {
        String corpId = room.getCorpId();
        String chatId = room.getWeworkRoomId();
        this.weworkChatRoomMapper.updateWeworkDigitId(corpId, chatId, digitId);
        log.info("matched wework chat room digitId, corpId={}, chatId={}, buildTime={}, digitId={}", new Object[]{corpId, chatId, room.getBuildRoomTime(), digitId});
    }
}

