/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.common_dto.dto.ResponseCodeType;
import cn.kinyun.link.common_dto.enums.OpPlatform;
import cn.kinyun.link.common_dto.enums.OpType;
import cn.kinyun.link.service.ContactService;
import cn.kinyun.link.service.OperateService;
import cn.kinyun.link.service.contact.request.AddFriendByConReq;
import cn.kinyun.link.service.contact.request.AddFriendByPhoneReq;
import cn.kinyun.link.service.request.QueryRuleRequest;
import cn.kinyun.link.service.response.QueryRuleData;
import cn.kinyun.link.service.response.WeworkStatusInfo;
import cn.kinyun.scrm.vip.service.WeworkOperationService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeworkOperationServiceImpl
implements WeworkOperationService {
    private static final Logger log = LoggerFactory.getLogger(WeworkOperationServiceImpl.class);
    @Autowired
    private ContactService contactService;
    @Autowired
    private OperateService operateService;

    @Override
    public boolean isOnline(Long bizId, String weworkId) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId not null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)weworkId), (Object)"weworkId not null");
        try {
            List deviceStatusInfos;
            BaseResponse response = this.operateService.queryWeworksStatus(bizId, (List)Lists.newArrayList((Object[])new String[]{weworkId}));
            if (response.getCode() == (long)ResponseCodeType.SUCCESS.getCode() && CollectionUtils.isNotEmpty((Collection)(deviceStatusInfos = (List)response.getData()))) {
                return ((WeworkStatusInfo)deviceStatusInfos.get(0)).isOnline();
            }
        }
        catch (Exception e) {
            log.error("bizId:{}, wechatId:{} isOnline error", new Object[]{bizId, weworkId, e});
        }
        return false;
    }

    @Override
    public Map<String, Boolean> queryWeworkIsOnline(Long bizId, List<String> weworkIds) {
        BaseResponse weworksStatus = this.operateService.queryWeworksStatus(bizId, weworkIds);
        HashMap weworkIsOnline = Maps.newHashMap();
        if (weworksStatus.getCode() == (long)ResponseCodeType.SUCCESS.getCode()) {
            for (WeworkStatusInfo info : (List)weworksStatus.getData()) {
                weworkIsOnline.put(info.getWeworkId(), info.isOnline());
            }
        }
        return weworkIsOnline;
    }

    @Override
    public Map<String, Boolean> onLineByWeworkIds(Long bizId, Set<String> weworkIds) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId not null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(weworkIds), (Object)"\u5fae\u4fe1ID\u5217\u8868\u4e3a\u7a7a");
        BaseResponse response = this.operateService.queryWeworksStatus(bizId, new ArrayList<String>(weworkIds));
        Preconditions.checkArgument((0L == response.getCode() ? 1 : 0) != 0, (Object)("\u83b7\u53d6\u5fae\u4fe1\u72b6\u6001\u5931\u8d25\uff1a" + response.getMsg()));
        List deviceStatusInfos = (List)response.getData();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)deviceStatusInfos), (Object)"\u83b7\u53d6\u5fae\u4fe1\u72b6\u6001\u5931\u8d25");
        return deviceStatusInfos.stream().collect(Collectors.toMap(WeworkStatusInfo::getWeworkId, WeworkStatusInfo::isOnline, (k1, k2) -> k2));
    }

    @Override
    public BaseResponse<?> addFriendByPhone(Long bizId, String corpId, String weworkId, String phoneNum, String applyContent) {
        log.info("addFriendByPhone: phoneNum:{}, applyContent:{}", (Object)phoneNum, (Object)applyContent);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u5546\u6237Id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)corpId), (Object)"\u516c\u53f8Id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)weworkId), (Object)"\u673a\u5668\u4ebaId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)phoneNum), (Object)"\u624b\u673a\u53f7\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)applyContent), (Object)"\u52a0\u597d\u53cb\u8bdd\u672f\u4e0d\u80fd\u4e3a\u7a7a");
        AddFriendByPhoneReq req = new AddFriendByPhoneReq();
        req.setControl(true);
        req.setWeworkId(weworkId);
        req.setPhoneNum(phoneNum);
        req.setApplyContent(applyContent);
        req.setCorpId(corpId);
        req.setBizId(bizId);
        req.setOpPlatform(Integer.valueOf(OpPlatform.MANAGER.getType()));
        return this.contactService.addFriendByPhone(req);
    }

    @Override
    public BaseResponse<?> addFriendByCon(String weworkId, String roomDigitId, String memberDigitId, String applyContent) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)weworkId), (Object)"\u673a\u5668\u4ebaId\u4e3a\u7a7a");
        log.info("addFriendByCon: roomDigitId:{}, memberDigitId:{}, applyContent:{}", new Object[]{roomDigitId, memberDigitId, applyContent});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)roomDigitId), (Object)"\u7fa4\u6570\u5b57Id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)memberDigitId), (Object)"\u7fa4\u6210\u5458\u6570\u5b57Id\u4e3a\u7a7a");
        applyContent = Optional.ofNullable(applyContent).orElse("");
        AddFriendByConReq req = new AddFriendByConReq();
        req.setControl(true);
        req.setWeworkId(weworkId);
        req.setApplyContent(applyContent);
        req.setConId(roomDigitId);
        req.setWxId(memberDigitId);
        req.setApplyContent(applyContent);
        return this.contactService.addFriendByCon(req);
    }

    @Override
    public Map<String, Integer> ruleDataByWeworkIds(Long bizId, List<String> weworkIds, OpType opType) {
        QueryRuleRequest queryRuleRequest = new QueryRuleRequest();
        queryRuleRequest.setBizId(bizId);
        queryRuleRequest.setWeworkIds(weworkIds);
        queryRuleRequest.setOpType(opType);
        BaseResponse resultData = this.operateService.queryRuleData(queryRuleRequest);
        if (Objects.nonNull(resultData) && resultData.getCode() == 0L) {
            QueryRuleData ruleData = (QueryRuleData)resultData.getData();
            return ruleData.getWeworkOpLeftMap();
        }
        return Collections.emptyMap();
    }
}

