/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.scrm.vip.service.RequestIdCacheService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RequestIdCacheServiceImpl
implements RequestIdCacheService {
    private static final Logger log = LoggerFactory.getLogger(RequestIdCacheServiceImpl.class);
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public void cacheRequestIds(List<String> requestIds) {
        for (String requestId : requestIds) {
            this.redisTemplate.opsForValue().set((Object)this.getKey(requestId), (Object)"", 5L, TimeUnit.MINUTES);
        }
    }

    @Override
    public boolean existsRequestId(String requestId) {
        return this.redisTemplate.hasKey((Object)this.getKey(requestId));
    }

    @Override
    public void removeRequestId(String requestId) {
        this.redisTemplate.delete((Object)this.getKey(requestId));
    }

    private String getKey(String requestId) {
        return this.redisKeyPrefix + "requestId:" + requestId;
    }
}

