/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.link.common_dto.enums.OpPlatform;
import cn.kinyun.link.service.MessageService;
import cn.kinyun.link.service.push.request.BaseSendReq;
import cn.kinyun.link.service.push.request.BatchPushMessageReq;
import cn.kinyun.link.service.push.request.SendAtReq;
import cn.kinyun.link.service.push.request.SendTextReq;
import cn.kinyun.scrm.vip.service.PushMsgService;
import cn.kinyun.scrm.vip.utils.UniformMsgToLinkMsg;
import com.google.common.collect.Lists;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushMsgServiceImpl
implements PushMsgService {
    private static final Logger log = LoggerFactory.getLogger(PushMsgServiceImpl.class);
    @Autowired
    private MessageService messageService;

    @Override
    public BaseResponse<List<BaseResponse>> push(String weworkId, Long bizId, String corpId, String conId, Integer conType, List<String> atMembers, List<? extends UniformMsgDto> messageDtoList) {
        log.info("\u63a8\u9001\u6d88\u606f, weworkId={}, bizId={}, corpId={}, conId={}, conType={}, atMembers={}, message=\n{}", new Object[]{weworkId, bizId, corpId, conId, conType, atMembers, messageDtoList});
        LinkedList<BaseSendReq> list = this.convertMsgList(messageDtoList);
        if (CollectionUtils.isEmpty(list)) {
            log.warn("\u53d1\u9001\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a");
            return new BaseResponse(400L, "\u53d1\u9001\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a", null, null);
        }
        if (conType == 1 && CollectionUtils.isNotEmpty(atMembers)) {
            int idx = atMembers.indexOf(weworkId);
            if (idx >= 0) {
                atMembers.remove(idx);
                log.info("@\u7fa4\u6210\u5458\u5305\u542b\u673a\u5668\u4eba\u81ea\u8eab");
            }
            if (CollectionUtils.isNotEmpty(atMembers)) {
                SendAtReq at = new SendAtReq();
                at.setAtIds(atMembers);
                at.setTextContent("");
                BaseSendReq first = list.getFirst();
                if (first instanceof SendTextReq) {
                    SendTextReq text = (SendTextReq)list.removeFirst();
                    at.setTextContent(text.getTextContent());
                }
                list.addFirst((BaseSendReq)at);
            }
        }
        return this.batchPush(weworkId, bizId, corpId, conId, conType, list);
    }

    private LinkedList<BaseSendReq> convertMsgList(List<? extends UniformMsgDto> messageDtoList) {
        LinkedList list = Lists.newLinkedList();
        for (UniformMsgDto uniformMsgDto : messageDtoList) {
            BaseSendReq it = UniformMsgToLinkMsg.convert(uniformMsgDto);
            if (it == null) continue;
            list.add(it);
        }
        return list;
    }

    private BaseResponse<List<BaseResponse>> batchPush(String weworkId, Long bizId, String corpId, String conId, Integer conType, List<BaseSendReq> list) {
        BatchPushMessageReq req = new BatchPushMessageReq();
        req.setOpPlatform(Integer.valueOf(OpPlatform.MANAGER.getType()));
        req.setWeworkId(weworkId);
        req.setBizId(bizId);
        req.setCorpId(corpId);
        req.setTargetId(conId);
        req.setType(conType.intValue());
        req.setList(list);
        try {
            log.info("\u6279\u91cf\u63a8\u9001\u6d88\u606f, \u8bf7\u6c42={}", (Object)JacksonUtil.obj2Str((Object)req));
            BaseResponse resp = this.messageService.batchPush(req);
            log.info("\u6279\u91cf\u63a8\u9001\u6d88\u606f, \u54cd\u5e94={}", (Object)JacksonUtil.obj2Str((Object)resp));
            return resp;
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u63a8\u9001\u6d88\u606f\u5931\u8d25, weworkId={}, req={}", new Object[]{weworkId, JacksonUtil.obj2Str((Object)req), e});
            return null;
        }
    }
}

