/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.service.impl;

import cn.kinyun.scrm.vip.model.PersonCard;
import cn.kinyun.scrm.weworkmessage.model.pb.EmotionMessage;
import cn.kinyun.scrm.weworkmessage.model.pb.FileMessage;
import cn.kinyun.scrm.weworkmessage.model.pb.IdSystemTipsMessage;
import cn.kinyun.scrm.weworkmessage.model.pb.IdTips;
import cn.kinyun.scrm.weworkmessage.model.pb.KfCard;
import cn.kinyun.scrm.weworkmessage.model.pb.LinkMessage;
import cn.kinyun.scrm.weworkmessage.model.pb.LocationMessage;
import cn.kinyun.scrm.weworkmessage.model.pb.PersonalCard;
import cn.kinyun.scrm.weworkmessage.model.pb.VideoMessage;
import cn.kinyun.wework.sdk.entity.chat.ChatMsg;
import cn.kinyun.wework.sdk.entity.chat.msg.Card;
import cn.kinyun.wework.sdk.entity.chat.msg.Emotion;
import cn.kinyun.wework.sdk.entity.chat.msg.File;
import cn.kinyun.wework.sdk.entity.chat.msg.Image;
import cn.kinyun.wework.sdk.entity.chat.msg.Link;
import cn.kinyun.wework.sdk.entity.chat.msg.Location;
import cn.kinyun.wework.sdk.entity.chat.msg.Text;
import cn.kinyun.wework.sdk.entity.chat.msg.Video;
import cn.kinyun.wework.sdk.entity.chat.msg.Voice;
import cn.kinyun.wework.sdk.enums.ChatMsgType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.InvalidProtocolBufferException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.TalkerMessageRespDto;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAccount;
import com.kuaike.scrm.dal.vip.entity.VipWeworkAliasInfo;
import com.kuaike.scrm.dal.vip.entity.VipWeworkContact;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAccountMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkAliasInfoMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkChatRoomRelationMapper;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkContactMapper;
import com.kuaike.scrm.vip.dto.model.WeworkMessage;
import com.kuaike.scrm.vip.service.WeworkCommonMessageService;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageConvertSupport {
    private static final Logger log = LoggerFactory.getLogger(MessageConvertSupport.class);
    @Autowired
    private VipWeworkAccountMapper vipWeworkAccountMapper;
    @Autowired
    private VipWeworkAliasInfoMapper vipWeworkAliasInfoMapper;
    @Autowired
    private VipWeworkContactMapper vipWeworkContactMapper;
    @Autowired
    private VipWeworkChatRoomRelationMapper vipWeworkChatRoomRelationMapper;
    @Autowired
    private WeworkCommonMessageService weworkCommonMessageService;

    public List<TalkerMessageRespDto> convertMessageList(Long bizId, String weworkId, String weworkUserNum, String conId, List<WeworkMessage> messageList) {
        Set<String> quoteSenderIds = this.fillQuoteMsg(messageList.get(0).getCorpId(), messageList);
        Integer conType = messageList.get(0).getConType();
        HashMap remarkMap = Maps.newHashMap();
        HashMap nicknameMap = Maps.newHashMap();
        HashMap avatarMap = Maps.newHashMap();
        if (1 == conType) {
            List aliasInfoList;
            Map remarks;
            Set memberIds = messageList.stream().map(WeworkMessage::getSenderId).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(quoteSenderIds)) {
                memberIds.addAll(quoteSenderIds);
            }
            if (MapUtils.isNotEmpty((Map)(remarks = this.vipWeworkChatRoomRelationMapper.queryChatRoomMemberRemark(conId, memberIds)))) {
                remarkMap.putAll(remarks);
            }
            if (CollectionUtils.isNotEmpty((Collection)(aliasInfoList = this.vipWeworkAliasInfoMapper.queryAlias(memberIds)))) {
                for (VipWeworkAliasInfo aliasInfo : aliasInfoList) {
                    nicknameMap.put(aliasInfo.getWeworkId(), aliasInfo.getNickname());
                    avatarMap.put(aliasInfo.getWeworkId(), aliasInfo.getAvatar());
                }
            }
        } else {
            VipWeworkContact vipWeworkContact = this.vipWeworkContactMapper.queryByWeworkIdAndContactId(weworkId, conId, bizId);
            if (vipWeworkContact != null) {
                avatarMap.put(conId, vipWeworkContact.getAvatar());
                nicknameMap.put(conId, vipWeworkContact.getNickname());
                remarkMap.put(conId, vipWeworkContact.getRemark());
            }
        }
        VipWeworkAccount vipWeworkAccount = this.vipWeworkAccountMapper.getWeworkAccount(bizId, weworkId);
        ArrayList talkerMsgList = Lists.newArrayListWithCapacity((int)messageList.size());
        for (WeworkMessage item : messageList) {
            TalkerMessageRespDto talkerMessageRespDto = this.convertToMsgRespDto(weworkId, weworkUserNum, vipWeworkAccount, remarkMap, nicknameMap, avatarMap, item);
            WeworkMessage quoteWeworkMessage = item.getQuoteWeworkMessage();
            if (quoteWeworkMessage != null) {
                TalkerMessageRespDto quoteRespDto = this.convertToMsgRespDto(weworkId, weworkUserNum, vipWeworkAccount, remarkMap, nicknameMap, avatarMap, quoteWeworkMessage);
                talkerMessageRespDto.setQuoteMsgRespDto(quoteRespDto);
            }
            talkerMsgList.add(talkerMessageRespDto);
        }
        return talkerMsgList;
    }

    private TalkerMessageRespDto convertToMsgRespDto(String weworkId, String weworkUserNum, VipWeworkAccount vipWeworkAccount, Map<String, String> remarkMap, Map<String, String> nicknameMap, Map<String, String> avatarMap, WeworkMessage item) {
        TalkerMessageRespDto talkerMessageRespDto = this.convertMessage(item);
        if (weworkId.equals(item.getSenderId())) {
            talkerMessageRespDto.setSendNum(weworkUserNum);
            talkerMessageRespDto.setSenderName(vipWeworkAccount.getNickname());
            talkerMessageRespDto.setSendOriginName(vipWeworkAccount.getNickname());
            talkerMessageRespDto.setAvatar(vipWeworkAccount.getAvatar());
        } else {
            talkerMessageRespDto.setSenderName(remarkMap.get(item.getSenderId()));
            talkerMessageRespDto.setSendOriginName(nicknameMap.get(item.getSenderId()));
            talkerMessageRespDto.setAvatar(avatarMap.get(item.getSenderId()));
        }
        return talkerMessageRespDto;
    }

    private Set<String> fillQuoteMsg(String corpId, List<WeworkMessage> messages) {
        Set quoteMsgRequestIds = messages.stream().map(WeworkMessage::getQuoteMsgRequestId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(quoteMsgRequestIds)) {
            log.info("fillQuoteMsg: quoteMsgRequestIds is null");
            return Collections.emptySet();
        }
        List quoteMsgList = this.weworkCommonMessageService.queryListByRequestIds(corpId, quoteMsgRequestIds);
        if (CollectionUtils.isEmpty((Collection)quoteMsgList)) {
            log.info("fillQuoteMsg: quoteMsgRequestIds is null");
            return Collections.emptySet();
        }
        Map<String, WeworkMessage> requestIdAnMsgMap = quoteMsgList.stream().collect(Collectors.toMap(WeworkMessage::getRequestId, a -> a, (u, v) -> v));
        HashSet resultSet = Sets.newHashSet();
        for (WeworkMessage message : messages) {
            WeworkMessage quoteMsg;
            String quoteMsgRequestId = message.getQuoteMsgRequestId();
            if (StringUtils.isBlank((CharSequence)quoteMsgRequestId) || (quoteMsg = requestIdAnMsgMap.get(quoteMsgRequestId)) == null) continue;
            message.setQuoteWeworkMessage(quoteMsg);
            if (!StringUtils.isNotBlank((CharSequence)quoteMsg.getSenderId())) continue;
            resultSet.add(quoteMsg.getSenderId());
        }
        return resultSet;
    }

    public TalkerMessageRespDto convertMessage(WeworkMessage weworkMessage) {
        TalkerMessageRespDto respDto = new TalkerMessageRespDto();
        respDto.setMsgId(weworkMessage.getUniqueId());
        respDto.setSenderId(weworkMessage.getSenderId());
        respDto.setSenderName(weworkMessage.getSenderName());
        respDto.setSendOriginName(weworkMessage.getSenderName());
        respDto.setAvatar(null);
        respDto.setSendNum(null);
        respDto.setRequestId(weworkMessage.getRequestId());
        respDto.setMsgTime(weworkMessage.getSendTime());
        respDto.setFileStatus(weworkMessage.getFileStatus());
        ChatMsg chatMsg = new ChatMsg();
        chatMsg.setMsgId(weworkMessage.getUniqueId());
        chatMsg.setFrom(weworkMessage.getSenderId());
        chatMsg.setMsgTime(Long.valueOf(weworkMessage.getSendTime().getTime()));
        chatMsg.setFileUrl(weworkMessage.getFileUrl());
        chatMsg.setFileName(weworkMessage.getFileName());
        chatMsg.setFileType(FilenameUtils.getExtension((String)chatMsg.getFileName()));
        chatMsg.setTranscodeFileUrl(weworkMessage.getTranscodeFileUrl());
        if (weworkMessage.getIsRevoke() != null && NumberUtils.INTEGER_ONE.equals(weworkMessage.getIsRevoke())) {
            chatMsg.setIsRevoked(Boolean.valueOf(true));
        }
        this.decodeContentBase64(weworkMessage, chatMsg);
        respDto.setMessage(JacksonUtil.toMap((Object)chatMsg));
        respDto.setIsSend(Boolean.valueOf(weworkMessage.getIsSend()));
        return respDto;
    }

    private void text(WeworkMessage wm, ChatMsg chatMsg) {
        Text text = new Text();
        text.setContent(wm.getContent());
        chatMsg.setText(text);
        chatMsg.setMsgType(ChatMsgType.TEXT.getValue());
    }

    private void image(WeworkMessage wm, ChatMsg chatMsg) throws InvalidProtocolBufferException {
        byte[] data = Base64.getDecoder().decode(wm.getContentBase64());
        FileMessage message = FileMessage.parseFrom((byte[])data);
        Image image = new Image();
        image.setFileSize(Long.valueOf(message.getSize()));
        image.setMd5sum(message.getMd5().toString(StandardCharsets.UTF_8));
        chatMsg.setImage(image);
        chatMsg.setMsgType(ChatMsgType.IMAGE.getValue());
        chatMsg.setFileUrl(wm.getFileUrl());
    }

    private void emotion(WeworkMessage wm, ChatMsg chatMsg) throws InvalidProtocolBufferException {
        byte[] data = Base64.getDecoder().decode(wm.getContentBase64());
        EmotionMessage message = EmotionMessage.parseFrom((byte[])data);
        Emotion emotion = new Emotion();
        emotion.setHeight(Integer.valueOf(message.getHeight()));
        emotion.setImageSize(Integer.valueOf((int)message.getSize()));
        emotion.setWidth(Integer.valueOf(message.getWidth()));
        emotion.setType(Integer.valueOf(message.getType()));
        chatMsg.setEmotion(emotion);
        chatMsg.setMsgType(ChatMsgType.EMOTION.getValue());
    }

    private void voice(WeworkMessage wm, ChatMsg chatMsg) throws InvalidProtocolBufferException {
        byte[] data = Base64.getDecoder().decode(wm.getContentBase64());
        FileMessage message = FileMessage.parseFrom((byte[])data);
        Voice voice = new Voice();
        voice.setMd5sum(message.getMd5().toString(StandardCharsets.UTF_8));
        voice.setVoiceSize(Integer.valueOf((int)message.getSize()));
        voice.setPlayLength(Integer.valueOf(message.getVoiceTime()));
        chatMsg.setVoice(voice);
        chatMsg.setMsgType(ChatMsgType.VOICE.getValue());
    }

    private void video(WeworkMessage wm, ChatMsg chatMsg) throws InvalidProtocolBufferException {
        byte[] data = Base64.getDecoder().decode(wm.getContentBase64());
        VideoMessage message = VideoMessage.parseFrom((byte[])data);
        Video video = new Video();
        video.setFileSize(Integer.valueOf((int)message.getSize()));
        video.setPlayLength(Integer.valueOf(message.getVideoDuration()));
        video.setMd5sum(message.getMd5().toString(StandardCharsets.UTF_8));
        chatMsg.setVideo(video);
        chatMsg.setMsgType(ChatMsgType.VIDEO.getValue());
    }

    private void personalCard(WeworkMessage wm, ChatMsg chatMsg) throws InvalidProtocolBufferException {
        byte[] data = Base64.getDecoder().decode(wm.getContentBase64());
        PersonalCard message = PersonalCard.parseFrom((byte[])data);
        PersonCard card = new PersonCard();
        card.setCorpName(message.getCorpName().toString(StandardCharsets.UTF_8));
        card.setName(message.getName().toString(StandardCharsets.UTF_8));
        card.setAvatar(message.getAvatarUrl().toString(StandardCharsets.UTF_8));
        card.setUserId(String.valueOf(message.getVid()));
        card.setCorpId(String.valueOf(message.getCorpId()));
        chatMsg.setMsgType(ChatMsgType.CARD.getValue());
        chatMsg.setFileUrl(message.getAvatarUrl().toString(StandardCharsets.UTF_8));
        chatMsg.setCard((Card)card);
    }

    private void kfCard(WeworkMessage wm, ChatMsg chatMsg) throws InvalidProtocolBufferException {
        byte[] data = Base64.getDecoder().decode(wm.getContentBase64());
        KfCard message = KfCard.parseFrom((byte[])data);
        PersonCard card = new PersonCard();
        card.setCorpName(message.getCorpName().toString(StandardCharsets.UTF_8));
        card.setName(message.getName().toString(StandardCharsets.UTF_8));
        card.setAvatar(message.getAvatarUrl().toString(StandardCharsets.UTF_8));
        card.setKfUrl(message.getKfUrl().toString(StandardCharsets.UTF_8));
        card.setUserId(String.valueOf(message.getVid()));
        card.setCorpId(String.valueOf(message.getCorpId()));
        chatMsg.setMsgType(ChatMsgType.CARD.getValue());
        chatMsg.setFileUrl(message.getAvatarUrl().toString(StandardCharsets.UTF_8));
        chatMsg.setCard((Card)card);
    }

    private void link(WeworkMessage wm, ChatMsg chatMsg) throws InvalidProtocolBufferException {
        byte[] data = Base64.getDecoder().decode(wm.getContentBase64());
        LinkMessage message = LinkMessage.parseFrom((byte[])data);
        Link link = new Link();
        link.setDescription(message.getDescription().toString(StandardCharsets.UTF_8));
        link.setLinkUrl(message.getLinkUrl().toString(StandardCharsets.UTF_8));
        link.setTitle(message.getTitle().toString(StandardCharsets.UTF_8));
        link.setImageUrl(wm.getFileUrl());
        chatMsg.setMsgType(ChatMsgType.LINK.getValue());
        chatMsg.setLink(link);
    }

    private void file(WeworkMessage wm, ChatMsg chatMsg) throws InvalidProtocolBufferException {
        byte[] data = Base64.getDecoder().decode(wm.getContentBase64());
        FileMessage message = FileMessage.parseFrom((byte[])data);
        File file = new File();
        file.setFileSize(Integer.valueOf((int)message.getSize()));
        file.setFilename(message.getFileName().toString(StandardCharsets.UTF_8));
        file.setFileext(FilenameUtils.getExtension((String)file.getFilename()));
        chatMsg.setMsgType(ChatMsgType.FILE.getValue());
        chatMsg.setFile(file);
    }

    private void location(WeworkMessage wm, ChatMsg chatMsg) throws InvalidProtocolBufferException {
        byte[] data = Base64.getDecoder().decode(wm.getContentBase64());
        LocationMessage message = LocationMessage.parseFrom((byte[])data);
        Location location = new Location();
        location.setLatitude(Double.valueOf(message.getLatitude()));
        location.setLongitude(Double.valueOf(message.getLongitude()));
        location.setTitle(message.getTitle().toString(StandardCharsets.UTF_8));
        location.setAddress(message.getAddress().toString(StandardCharsets.UTF_8));
        location.setZoom(Integer.valueOf((int)message.getZoom()));
        chatMsg.setMsgType(ChatMsgType.LOCATION.getValue());
        chatMsg.setLocation(location);
    }

    private void idSystemTips(WeworkMessage wm, ChatMsg chatMsg) throws InvalidProtocolBufferException {
        byte[] data = Base64.getDecoder().decode(wm.getContentBase64());
        IdSystemTipsMessage idSystemTipsMessage = IdSystemTipsMessage.parseFrom((byte[])data);
        StringBuilder stringBuffer = new StringBuilder();
        for (IdTips item : idSystemTipsMessage.getTipsList()) {
            stringBuffer.append(item.getTips().toString(StandardCharsets.UTF_8));
        }
        Text text = new Text();
        text.setContent(stringBuffer.toString());
        chatMsg.setText(text);
        chatMsg.setMsgType("system");
    }

    private void textNotify(WeworkMessage wm, ChatMsg chatMsg) throws InvalidProtocolBufferException {
        byte[] data = Base64.getDecoder().decode(wm.getContentBase64());
        IdTips tips = IdTips.parseFrom((byte[])data);
        Text text = new Text();
        text.setContent(tips.getTips().toString(StandardCharsets.UTF_8));
        chatMsg.setText(text);
        chatMsg.setMsgType("system");
    }

    private void addRoomMember(WeworkMessage wm, ChatMsg chatMsg) {
        Text text = new Text();
        text.setContent(wm.getContent());
        chatMsg.setText(text);
        chatMsg.setMsgType("system");
    }

    private void createRoom(WeworkMessage wm, ChatMsg chatMsg) {
        String room;
        Text text = new Text();
        text.setContent(wm.getContent());
        List<String> memberIds = Arrays.asList(wm.getContent().split(";"));
        List aliasList = this.vipWeworkAliasInfoMapper.queryAliasInfoByWeworkIds(memberIds);
        int memberSize = aliasList.size();
        String memberNames = "\u597d\u53cb";
        if (memberSize > 0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (VipWeworkAliasInfo alias : aliasList) {
                if (Objects.equals(wm.getWeworkId(), alias.getWeworkId())) {
                    sb.append('\u4f60');
                } else {
                    sb.append(alias.getNickname());
                }
                if (i < memberSize - 1) {
                    if (i < memberSize - 2) {
                        sb.append('\u3001');
                    } else {
                        sb.append('\u548c');
                    }
                }
                ++i;
            }
            memberNames = sb.toString();
        }
        String string = room = wm.getExternalFlag() == 1 ? "\u5916\u90e8\u7fa4" : "\u5185\u90e8\u7fa4";
        if (Objects.equals(wm.getWeworkId(), wm.getOwner())) {
            text.setContent("\u4f60\u9080\u8bf7" + memberNames + "\u52a0\u5165\u4e86" + room);
        } else {
            VipWeworkAliasInfo owner = this.vipWeworkAliasInfoMapper.selectAliasInfoByWeworkId(wm.getOwner());
            String ownerName = owner == null ? "\u7fa4\u4e3b" : owner.getNickname();
            text.setContent(ownerName + "\u9080\u8bf7" + memberNames + "\u52a0\u5165\u4e86" + room);
        }
        chatMsg.setText(text);
        chatMsg.setMsgType("system");
    }

    private void dismiss(WeworkMessage wm, ChatMsg chatMsg) {
        Text text = new Text();
        if (Objects.equals(wm.getWeworkId(), wm.getOwner())) {
            text.setContent("\u4f60\u5df2\u89e3\u6563\u7fa4\u804a\uff0c\u6240\u6709\u7fa4\u6210\u5458\u88ab\u79fb\u51fa\u4e86\u7fa4\u804a");
        } else {
            text.setContent("\u7fa4\u4e3b\u5df2\u89e3\u6563\u8be5\u7fa4\u804a");
        }
        chatMsg.setText(text);
        chatMsg.setMsgType("system");
    }

    private void changeRoomName(WeworkMessage wm, ChatMsg chatMsg) {
        Text text = new Text();
        if (Objects.equals(wm.getWeworkId(), wm.getOwner())) {
            text.setContent("\u4f60\u4fee\u6539\u7fa4\u540d\u4e3a\"" + wm.getContent() + "\"");
        } else {
            text.setContent("\u7fa4\u4e3b\u4fee\u6539\u7fa4\u540d\u4e3a\"" + wm.getContent() + "\"");
        }
        chatMsg.setText(text);
        chatMsg.setMsgType("system");
    }

    private void textControl(WeworkMessage wm, ChatMsg chatMsg) {
        Text text = new Text();
        text.setContent(wm.getContent());
        chatMsg.setText(text);
        chatMsg.setMsgType("system");
    }

    private void unknown(WeworkMessage weworkMessage, ChatMsg chatMsg) {
        log.info("unknown content-type:{}, requestId:{}, contentBase64:{}, content:{}", new Object[]{weworkMessage.getContentType(), weworkMessage.getRequestId(), weworkMessage.getContentBase64(), weworkMessage.getContent()});
        Text text = new Text();
        text.setContent("[\u6d88\u606f\u6682\u4e0d\u652f\u6301]");
        chatMsg.setMsgType(ChatMsgType.TEXT.getValue());
        chatMsg.setText(text);
    }

    private void decodeContentBase64(WeworkMessage weworkMessage, ChatMsg chatMsg) {
        try {
            switch (weworkMessage.getContentType()) {
                case 0: 
                case 2: {
                    this.text(weworkMessage, chatMsg);
                    break;
                }
                case 7: 
                case 14: 
                case 101: {
                    this.image(weworkMessage, chatMsg);
                    break;
                }
                case 29: 
                case 104: {
                    this.emotion(weworkMessage, chatMsg);
                    break;
                }
                case 9: 
                case 16: {
                    this.voice(weworkMessage, chatMsg);
                    break;
                }
                case 5: 
                case 17: 
                case 23: 
                case 103: {
                    this.video(weworkMessage, chatMsg);
                    break;
                }
                case 41: {
                    this.personalCard(weworkMessage, chatMsg);
                    break;
                }
                case 148: {
                    this.kfCard(weworkMessage, chatMsg);
                    break;
                }
                case 13: {
                    this.link(weworkMessage, chatMsg);
                    break;
                }
                case 8: 
                case 15: 
                case 102: {
                    this.file(weworkMessage, chatMsg);
                    break;
                }
                case 6: {
                    this.location(weworkMessage, chatMsg);
                    break;
                }
                case 1001: {
                    this.changeRoomName(weworkMessage, chatMsg);
                    break;
                }
                case 1002: {
                    this.addRoomMember(weworkMessage, chatMsg);
                    break;
                }
                case 1006: {
                    this.createRoom(weworkMessage, chatMsg);
                    break;
                }
                case 1023: {
                    this.dismiss(weworkMessage, chatMsg);
                    break;
                }
                case 1011: {
                    this.textControl(weworkMessage, chatMsg);
                    break;
                }
                case 1037: {
                    this.idSystemTips(weworkMessage, chatMsg);
                    break;
                }
                case 1054: {
                    this.textNotify(weworkMessage, chatMsg);
                    break;
                }
                default: {
                    log.info("unsupported content-type:{}, requestId:{}", (Object)weworkMessage.getContentType(), (Object)weworkMessage.getRequestId());
                    this.unknown(weworkMessage, chatMsg);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u89e3\u6790\u5931\u8d25, message:{}", (Object)weworkMessage, (Object)e);
            this.unknown(weworkMessage, chatMsg);
        }
    }
}

