/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.utils;

import cn.kinyun.link.common_dto.dto.OpBaseResponse;
import cn.kinyun.link.common_dto.dto.ResponseCodeType;
import com.kuaike.scrm.vip.dto.enums.AndroidErrorCode;
import com.kuaike.scrm.vip.dto.enums.WxError;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseErrUtil {
    private static final Logger log = LoggerFactory.getLogger(ResponseErrUtil.class);
    private static final Pattern CHINESE_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]");
    private static final ConcurrentMap<String, String> KEYS = new ConcurrentHashMap<String, String>();

    private ResponseErrUtil() {
    }

    public static String getRemark(OpBaseResponse opBaseResponse) {
        return ResponseErrUtil.getRemarkWithSpecial(opBaseResponse, null, null);
    }

    public static String getRemarkWithSpecial(OpBaseResponse opBaseResponse, Map<Integer, String> codeRemarkMap, Map<String, String> wxErrRemarkMap) {
        AndroidErrorCode androidErrorCode;
        String remark = "";
        if (opBaseResponse.getCode() == AndroidErrorCode.SUCCESS.getValue()) {
            return remark;
        }
        boolean customerContains = false;
        int code = opBaseResponse.getCode();
        if (opBaseResponse.getWxErr() != null) {
            int errCode = opBaseResponse.getWxErr().getErrCode();
            if (opBaseResponse.getWxErr() != null && errCode != 0) {
                String errMsg;
                if (MapUtils.isNotEmpty(wxErrRemarkMap)) {
                    String key = StringUtils.join((Object[])new Integer[]{errCode}, (String)"##");
                    customerContains = wxErrRemarkMap.containsKey(key);
                    remark = wxErrRemarkMap.get(key);
                }
                if (customerContains) {
                    return remark;
                }
                if (StringUtils.isEmpty((CharSequence)remark) && StringUtils.isNotBlank((CharSequence)opBaseResponse.getWxErr().getErrMsg()) && !(errMsg = opBaseResponse.getWxErr().getErrMsg()).contains("CDATA") && CHINESE_PATTERN.matcher(errMsg).find()) {
                    remark = errMsg;
                }
                if (StringUtils.isEmpty((CharSequence)remark)) {
                    remark = WxError.getReasonStr((int)errCode);
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)remark) && (androidErrorCode = AndroidErrorCode.getByCode((int)code)) != null) {
            if (MapUtils.isNotEmpty(codeRemarkMap)) {
                customerContains = codeRemarkMap.containsKey(code);
                remark = codeRemarkMap.get(code);
            }
            if (customerContains) {
                return remark;
            }
            if (StringUtils.isEmpty((CharSequence)remark)) {
                remark = androidErrorCode.getDesc();
            }
        }
        if (StringUtils.isEmpty((CharSequence)remark)) {
            if (MapUtils.isNotEmpty(codeRemarkMap)) {
                customerContains = codeRemarkMap.containsKey(code);
                remark = codeRemarkMap.get(code);
            }
            if (customerContains) {
                return remark;
            }
            ResponseCodeType responseCodeType = ResponseCodeType.getInstance((int)code);
            if (responseCodeType != null) {
                if (responseCodeType == ResponseCodeType.ANDROID_PROCESS_ERROR && StringUtils.isNotEmpty((CharSequence)opBaseResponse.getMsg())) {
                    remark = opBaseResponse.getMsg();
                }
                if (responseCodeType == ResponseCodeType.ANDROID_PROCESS_ERROR && StringUtils.isEmpty((CharSequence)remark)) {
                    remark = "\u88ab\u5fae\u4fe1\u9650\u5236\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5";
                }
                if (StringUtils.isEmpty((CharSequence)remark)) {
                    remark = responseCodeType.getDesc();
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)remark)) {
            remark = "\u5904\u7406\u5f02\u5e38,\u539f\u56e0\u672a\u77e5";
            ResponseErrUtil.contains(opBaseResponse);
        }
        return remark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void contains(OpBaseResponse opBaseResponse) {
        if (opBaseResponse == null || opBaseResponse.getWxErr() == null) {
            return;
        }
        int errCode = opBaseResponse.getWxErr().getErrCode();
        String errMsg = opBaseResponse.getWxErr().getErrMsg();
        String key = StringUtils.join((Object[])new Object[]{errCode, errMsg}, (String)"#");
        boolean needLog = false;
        ConcurrentMap<String, String> concurrentMap = KEYS;
        synchronized (concurrentMap) {
            if (KEYS.containsKey(key)) {
                needLog = true;
                KEYS.put(key, errMsg);
            }
        }
        if (needLog) {
            ResponseErrUtil.logMsg(opBaseResponse);
        }
    }

    public static void logMsg(OpBaseResponse opBaseResponse) {
        log.info("{}", (Object)opBaseResponse);
    }
}

