/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.tranfer.service.impl;

import cn.kinyun.wework.sdk.api.external.TransferClient;
import cn.kinyun.wework.sdk.entity.external.transfer.TransferCustomerParams;
import cn.kinyun.wework.sdk.entity.external.transfer.TransferCustomerResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.TakeoverStatus;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.transfer.dto.ContactQueryParams;
import com.kuaike.scrm.dal.transfer.dto.InJobAllocateQueryParams;
import com.kuaike.scrm.dal.transfer.entity.InJobAllocateRecord;
import com.kuaike.scrm.dal.transfer.mapper.InJobAllocateRecordMapper;
import com.kuaike.scrm.dal.wework.dto.ContactRelationDto;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactMobile;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartment;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartmentUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMobileMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.entity.WeworkContactTag;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkContactTagMapper;
import com.kuaike.scrm.tranfer.dto.request.ContactReqDto;
import com.kuaike.scrm.tranfer.dto.request.InJobAllocateRecordReqDto;
import com.kuaike.scrm.tranfer.dto.request.InJobAllocateReqDto;
import com.kuaike.scrm.tranfer.dto.request.TransferListReqDto;
import com.kuaike.scrm.tranfer.dto.response.AllocateResultRespDto;
import com.kuaike.scrm.tranfer.dto.response.ContactRespDto;
import com.kuaike.scrm.tranfer.dto.response.InJobAllocateRecordRespDto;
import com.kuaike.scrm.tranfer.service.InJobService;
import com.kuaike.scrm.wework.weworkuser.service.WeworkUserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InJobServiceImpl
implements InJobService {
    private static final Logger log = LoggerFactory.getLogger(InJobServiceImpl.class);
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkContactTagMapper weworkContactTagMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private InJobAllocateRecordMapper inJobAllocateRecordMapper;
    @Autowired
    private WeworkContactMobileMapper weworkContactMobileMapper;
    @Autowired
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Autowired
    private WeworkDepartmentMapper weworkDepartmentMapper;
    @Autowired
    private SettingService settingService;
    @Autowired
    private TransferClient transferClient;
    @Autowired
    private WeworkUserService weworkUserService;

    @Override
    public List<ContactRespDto> contactList(ContactReqDto reqDto) {
        CurrentUserInfo userInfo = this.validateCurrentOperateUser();
        log.info("contactList,params:{}, operatorId:{}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validateBaseParams();
        ContactQueryParams contactQueryParams = this.buildContactQueryParams(userInfo.getCorpId(), reqDto);
        List contactRelations = this.weworkContactRelationMapper.selectByContactQueryParams(contactQueryParams);
        if (CollectionUtils.isEmpty((Collection)contactRelations)) {
            log.info("\u6839\u636equeryParams:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)contactQueryParams);
            return Collections.emptyList();
        }
        int count = this.weworkContactRelationMapper.getCountByQueryParams(contactQueryParams);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        ArrayList contactIds = Lists.newArrayList();
        ArrayList weworkUserIds = Lists.newArrayList();
        for (ContactRelationDto relationDto : contactRelations) {
            contactIds.add(relationDto.getContactId());
            weworkUserIds.add(relationDto.getWeworkUserId());
        }
        HashMap weworkUserId2NumMap = Maps.newHashMap();
        HashMap weworkUserId2WeworkUserMap = Maps.newHashMap();
        List weworkUsers = this.weworkUserMapper.selectByWeworkUserIdsAndCorpId((Collection)weworkUserIds, userInfo.getCorpId());
        for (WeworkUser weworkUser : weworkUsers) {
            weworkUserId2NumMap.put(weworkUser.getWeworkUserId(), weworkUser.getNum());
            weworkUserId2WeworkUserMap.put(weworkUser.getWeworkUserId(), weworkUser);
        }
        Map uniqKey2TagNamesMap = null;
        List tags = this.weworkContactTagMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(userInfo.getCorpId(), (Collection)contactIds, (Collection)weworkUserIds);
        if (CollectionUtils.isNotEmpty((Collection)tags)) {
            tags.forEach(weworkContactTag -> weworkContactTag.setWeworkUserAndContactId(weworkContactTag.getWeworkUserId() + ":" + weworkContactTag.getContactId()));
            uniqKey2TagNamesMap = tags.stream().collect(Collectors.groupingBy(WeworkContactTag::getWeworkUserAndContactId, Collectors.mapping(WeworkContactTag::getTagName, Collectors.toList())));
        }
        ArrayList contactRespDtos = Lists.newArrayList();
        for (ContactRelationDto contactRelation : contactRelations) {
            String weworkUserId = contactRelation.getWeworkUserId();
            String contactId = contactRelation.getContactId();
            String uniqKey = weworkUserId + ":" + contactId;
            ContactRespDto contactRespDto = new ContactRespDto();
            contactRespDtos.add(contactRespDto);
            contactRespDto.setWeworkUserId(weworkUserId);
            contactRespDto.setContactId(contactId);
            contactRespDto.setAvatar(contactRelation.getAvatar());
            contactRespDto.setName(contactRelation.getName());
            contactRespDto.setCorpName(contactRelation.getCorpName());
            if (MapUtils.isNotEmpty((Map)weworkUserId2WeworkUserMap) && weworkUserId2WeworkUserMap.containsKey(weworkUserId)) {
                contactRespDto.setWeworkUserName(((WeworkUser)weworkUserId2WeworkUserMap.get(weworkUserId)).getName());
            }
            if (MapUtils.isNotEmpty(uniqKey2TagNamesMap) && uniqKey2TagNamesMap.containsKey(uniqKey)) {
                contactRespDto.setTagNames(uniqKey2TagNamesMap.get(uniqKey));
            }
            contactRespDto.setRemark(contactRelation.getRemark());
            contactRespDto.setAddTime(contactRelation.getAddTime());
            if (!MapUtils.isNotEmpty((Map)weworkUserId2NumMap) || !weworkUserId2NumMap.containsKey(contactRespDto.getWeworkUserId())) continue;
            contactRespDto.setWeworkUserId((String)weworkUserId2NumMap.get(contactRespDto.getWeworkUserId()));
        }
        return contactRespDtos;
    }

    @Override
    public AllocateResultRespDto allocate(InJobAllocateReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        String weworkUserNum = reqDto.getList().get(0).getWeworkUserId();
        log.info("allocate,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.validateParams();
        this.changeWeworkUserNum2WeworkUserId(reqDto);
        this.validateTakeoverUserAndWeworkUserIsSame(reqDto, corpId);
        this.validateTakeoverUser(reqDto.getTakeoverUserId(), corpId);
        int contactCount = this.weworkContactRelationMapper.getContactCountByCorpIdAndWeworkUserId(corpId, reqDto.getTakeoverUserId());
        log.info("\u6210\u5458takeoverUserId:{}\u7684\u597d\u53cb\u6570:{},\u5f85\u63a5\u66ff\u6570:{}", new Object[]{reqDto.getTakeoverUserId(), contactCount, reqDto.getList().size()});
        if (reqDto.getList().size() + contactCount > 50000) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5355\u4e2a\u6210\u5458\u7684\u597d\u53cb\u6570\u6700\u591a\u53ea\u80fd\u4e3a50000");
        }
        this.checkIsCanTransfer(corpId, reqDto, weworkUserNum);
        List<TransferListReqDto> transferListReqDtos = reqDto.getList();
        Map weworkUserId2ContactIdsMap = transferListReqDtos.stream().collect(Collectors.groupingBy(TransferListReqDto::getWeworkUserId, Collectors.mapping(TransferListReqDto::getWeworkContactId, Collectors.toList())));
        AtomicInteger successCount = new AtomicInteger(0);
        AtomicInteger failCount = new AtomicInteger(0);
        ArrayList inJobAllocateRecords = Lists.newArrayList();
        TransferCustomerParams transferCustomerParams = new TransferCustomerParams();
        transferCustomerParams.setTakeoverUserId(reqDto.getTakeoverUserId());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getTransferSuccessMsg())) {
            transferCustomerParams.setTransferSuccessMsg(reqDto.getTransferSuccessMsg());
        }
        for (Map.Entry entry : weworkUserId2ContactIdsMap.entrySet()) {
            String weworkUserId = entry.getKey();
            transferCustomerParams.setHandoverUserId(weworkUserId);
            List contactIds = entry.getValue();
            Lists.partition(contactIds, (int)50).forEach(partitionContactIds -> {
                try {
                    transferCustomerParams.setExternalUserIdList(partitionContactIds);
                    log.info("transferCustomerParams:{}", (Object)transferCustomerParams);
                    TransferCustomerResp transferCustomerResp = this.transferClient.transferCustomer(corpId, transferCustomerParams);
                    log.info("transferCustomerResp:{}", (Object)transferCustomerResp);
                    List customers = transferCustomerResp.getCustomer();
                    for (TransferCustomerResp.Customer customer : customers) {
                        int status = TakeoverStatus.WAIT_TAKEOVER.getValue();
                        if (!String.valueOf(NumberUtils.INTEGER_ZERO).equals(customer.getErrCode())) {
                            status = TakeoverStatus.FAIL.getValue();
                            failCount.addAndGet(NumberUtils.INTEGER_ONE);
                        } else {
                            successCount.addAndGet(NumberUtils.INTEGER_ONE);
                        }
                        InJobAllocateRecord inJobAllocateRecord = this.buildAllocateRecord(weworkUserId, customer.getExternalUserId(), reqDto.getTakeoverUserId(), reqDto.getTransferSuccessMsg(), status, customer.getErrCode(), currentUserInfo);
                        inJobAllocateRecords.add(inJobAllocateRecord);
                    }
                }
                catch (Exception ex) {
                    log.error("\u5206\u914d\u5728\u804c\u6210\u5458\u5ba2\u6237\u5f02\u5e38,\u5f02\u5e38\u4fe1\u606f:", (Throwable)ex);
                    failCount.addAndGet(partitionContactIds.size());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)inJobAllocateRecords)) {
            Lists.partition((List)inJobAllocateRecords, (int)100).forEach(partitionRecords -> this.inJobAllocateRecordMapper.batchInsert((Collection)partitionRecords));
        }
        AllocateResultRespDto allocateResultRespDto = new AllocateResultRespDto();
        allocateResultRespDto.setContactSuccessCount(successCount.get());
        allocateResultRespDto.setContactFailCount(failCount.get());
        return allocateResultRespDto;
    }

    @Override
    public List<InJobAllocateRecordRespDto> allocateRecords(InJobAllocateRecordReqDto reqDto) {
        List allocateRecords;
        Collection<Object> contactIds;
        CurrentUserInfo currentUserInfo = this.validateCurrentOperateUser();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        log.info("allocateRecords,params:{}, operatorId:{},bizId:{},corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), bizId, corpId});
        reqDto.validateParams();
        Set managedWeworkUserIds = this.weworkUserService.queryCurManagerWeworkUserContainDel();
        if (CollectionUtils.isEmpty((Collection)managedWeworkUserIds)) {
            log.info("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u7ba1\u8f96\u7684\u4f01\u5fae\u6210\u5458");
            return Collections.emptyList();
        }
        Collection<String> managedWeworkUserNums = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(corpId, (Collection)managedWeworkUserIds).values();
        if (CollectionUtils.isEmpty(managedWeworkUserNums)) {
            log.info("\u6839\u636ecorpId\u548c\u6210\u5458userIds\u672a\u83b7\u53d6\u5230\u6210\u5458\u8bb0\u5f55\u552f\u4e00\u6807\u8bc6");
            return Collections.emptyList();
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getWeworkUserId())) {
            managedWeworkUserNums.retainAll(Sets.newHashSet((Object[])new String[]{reqDto.getWeworkUserId()}));
            if (CollectionUtils.isEmpty(managedWeworkUserNums)) {
                log.info("\u7ba1\u8f96\u7684\u6210\u5458\u548c\u524d\u7aef\u4f20\u5165\u7684\u6ca1\u6709\u4ea4\u96c6");
                return Collections.emptyList();
            }
        }
        InJobAllocateQueryParams queryParams = reqDto.convert2QueryParams(corpId, managedWeworkUserNums);
        if (StringUtils.isNotBlank((CharSequence)reqDto.getQuery())) {
            Set weworkUserNums = this.inJobAllocateRecordMapper.selectWeworkUserNumsByCorpId(corpId);
            if (CollectionUtils.isEmpty((Collection)weworkUserNums)) {
                return Collections.emptyList();
            }
            Set handoverUserIds = this.weworkUserMapper.getWeworkUserIdsByNums((Collection)weworkUserNums);
            contactIds = this.weworkContactRelationMapper.selectContactIdsByCorpIdAndQuery(corpId, reqDto.getQuery(), (Collection)handoverUserIds);
            if (CollectionUtils.isEmpty((Collection)contactIds)) {
                log.info("\u6839\u636ecorpId:{}, query:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)corpId, (Object)reqDto.getQuery());
                return Collections.emptyList();
            }
            queryParams.setContactIds(contactIds);
        }
        if (CollectionUtils.isEmpty((Collection)(allocateRecords = this.inJobAllocateRecordMapper.selectByQueryParams(queryParams)))) {
            log.info("\u6839\u636equeryParams:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)queryParams);
            return Collections.emptyList();
        }
        int count = this.inJobAllocateRecordMapper.getCountByQueryParams(queryParams);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        contactIds = allocateRecords.stream().map(InJobAllocateRecord::getWeworkContactId).collect(Collectors.toList());
        List weworkUserNums = allocateRecords.stream().map(InJobAllocateRecord::getWeworkUserNum).collect(Collectors.toList());
        Collection weworkUserIds = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(weworkUserNums).values();
        List takeoverUserNums = allocateRecords.stream().map(InJobAllocateRecord::getTakeoverUserNum).collect(Collectors.toList());
        Collection<String> takeoverUserIds = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(takeoverUserNums).values();
        List contacts = this.weworkContactMapper.selectByCorpIdAndContactIds(corpId, (Collection)contactIds);
        Map<String, WeworkContact> contactId2ObjMap = contacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, Function.identity()));
        List contactRelations = this.weworkContactRelationMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, (Collection)contactIds, weworkUserIds);
        Map<String, WeworkContactRelation> contactId2RelationMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactRelations)) {
            contactId2RelationMap = contactRelations.stream().collect(Collectors.toMap(it -> it.getWeworkUserId() + ":" + it.getContactId(), Functions.identity()));
        }
        boolean mobileEncrypt = this.settingService.getMobileEncrypt(bizId);
        List contactMobiles = this.weworkContactMobileMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, (Collection)contactIds, weworkUserIds);
        Map<Object, Object> contactId2MobilesMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)contactMobiles)) {
            contactMobiles.forEach(contactMobile -> contactMobile.setWeworkUserAndContactId(contactMobile.getWeworkUserId() + ":" + contactMobile.getContactId()));
            contactId2MobilesMap = contactMobiles.stream().collect(Collectors.groupingBy(WeworkContactMobile::getWeworkUserAndContactId, Collectors.mapping(WeworkContactMobile::getRemarkMobile, Collectors.toList())));
            for (Map.Entry<Object, Object> entry : contactId2MobilesMap.entrySet()) {
                List remarkMobiles = (List)entry.getValue();
                if (mobileEncrypt) {
                    MobileUtils.encryptMobile((List)remarkMobiles);
                }
                contactId2MobilesMap.put(entry.getKey(), remarkMobiles);
            }
        }
        List contactTags = this.weworkContactTagMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, (Collection)contactIds, weworkUserIds);
        Map<String, List<String>> contactId2TagNamesMap = null;
        if (CollectionUtils.isNotEmpty((Collection)contactTags)) {
            contactTags.forEach(contactTag -> contactTag.setWeworkUserAndContactId(contactTag.getWeworkUserId() + ":" + contactTag.getContactId()));
            contactId2TagNamesMap = contactTags.stream().collect(Collectors.groupingBy(WeworkContactTag::getWeworkUserAndContactId, Collectors.mapping(WeworkContactTag::getTagName, Collectors.toList())));
        }
        Map<String, List<Integer>> takeoverUserId2DepartmentIdsMap = this.getWeworkUserId2DepartmentIdsMap(corpId, takeoverUserIds);
        Map<Integer, WeworkDepartment> weworkDepartmentId2ObjMap = this.getWeworkDepartmentMap(corpId);
        HashSet wwUserIds = Sets.newHashSet();
        wwUserIds.addAll(weworkUserIds);
        wwUserIds.addAll(takeoverUserIds);
        List weworkUsers = this.weworkUserMapper.selectByWeworkUserIdsAndCorpId((Collection)wwUserIds, corpId);
        Map<String, String> weworkUserId2NameMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, WeworkUser::getName));
        return this.buildAllocatedRecordList(allocateRecords, contactId2ObjMap, contactId2RelationMap, contactId2MobilesMap, contactId2TagNamesMap, takeoverUserId2DepartmentIdsMap, weworkDepartmentId2ObjMap, weworkUserId2NameMap);
    }

    private CurrentUserInfo validateCurrentOperateUser() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u7528\u6237\u5546\u6237id\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e3a\u7a7a");
        return currentUserInfo;
    }

    private void validateTakeoverUser(String takeoverUserId, String corpId) {
        WeworkUser weworkUser = this.weworkUserMapper.selectByWeworkUserIdAndCorpId(takeoverUserId, corpId);
        if (Objects.isNull(weworkUser)) {
            log.warn("\u6839\u636e\u63a5\u66ff\u6210\u5458userId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)takeoverUserId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u63a5\u66ff\u6210\u5458\u4e0d\u5408\u6cd5");
        }
        if (NumberUtils.INTEGER_ONE.equals(weworkUser.getIsDeleted())) {
            log.warn("\u63a5\u66ff\u6210\u5458:{}\u5df2\u88ab\u5220\u9664", (Object)takeoverUserId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u63a5\u66ff\u6210\u5458\u4e0d\u5408\u6cd5");
        }
        if (NumberUtils.INTEGER_ZERO.equals(weworkUser.getIsAgentAuth())) {
            log.warn("takeoverUserId:{}, isAgentAuth:{}", (Object)takeoverUserId, (Object)weworkUser.getIsAgentAuth());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, "\u63a5\u66ff\u6210\u5458\u5fc5\u987b\u5728\u5e94\u7528\u7684\u53ef\u89c1\u8303\u56f4\u5185");
        }
        if (!NumberUtils.INTEGER_ONE.equals(weworkUser.getStatus())) {
            log.warn("takeoverUserId:{},status:{}", (Object)takeoverUserId, (Object)weworkUser.getStatus());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.SIGN_INVALIDATE, "\u63a5\u66ff\u6210\u5458\u9700\u8981\u5728\u4f01\u4e1a\u5fae\u4fe1\u6fc0\u6d3b");
        }
    }

    private InJobAllocateRecord buildAllocateRecord(String weworkUserId, String contactId, String takeoverUserId, String transferSuccessMsg, Integer status, String errorCode, CurrentUserInfo currentUserInfo) {
        HashSet weworkUserIds = Sets.newHashSet((Object[])new String[]{weworkUserId, takeoverUserId});
        Map weworkUserId2NumMap = this.weworkUserMapper.selectWeworkUserIdAndNumByWeworkUserIds(currentUserInfo.getCorpId(), (Collection)weworkUserIds);
        InJobAllocateRecord inJobAllocateRecord = new InJobAllocateRecord();
        inJobAllocateRecord.setWeworkUserNum((String)weworkUserId2NumMap.get(weworkUserId));
        inJobAllocateRecord.setWeworkContactId(contactId);
        inJobAllocateRecord.setTakeoverUserNum((String)weworkUserId2NumMap.get(takeoverUserId));
        inJobAllocateRecord.setTransferSuccessMsg(transferSuccessMsg);
        inJobAllocateRecord.setStatus(status);
        inJobAllocateRecord.setErrorCode(errorCode);
        inJobAllocateRecord.setBizId(currentUserInfo.getBizId());
        inJobAllocateRecord.setCreateBy(currentUserInfo.getId());
        inJobAllocateRecord.setUpdateBy(currentUserInfo.getId());
        inJobAllocateRecord.setCreateTime(new Date());
        inJobAllocateRecord.setUpdateTime(new Date());
        inJobAllocateRecord.setCorpId(currentUserInfo.getCorpId());
        inJobAllocateRecord.setAllocateTime(new Date());
        if (!String.valueOf(NumberUtils.INTEGER_ZERO).equals(errorCode)) {
            inJobAllocateRecord.setErrorMsg(WeworkException.getErrorMsg((Integer)Integer.parseInt(errorCode)));
        }
        return inJobAllocateRecord;
    }

    private Map<String, List<Integer>> getWeworkUserId2DepartmentIdsMap(String corpId, Collection<String> weworkUserIds) {
        List weworkDepartmentUsers = this.weworkDepartmentUserMapper.selectByCorpIdAndWwUserIds(corpId, weworkUserIds);
        Map weworkUserId2DepartmentIdsMap = null;
        if (CollectionUtils.isNotEmpty((Collection)weworkDepartmentUsers)) {
            weworkUserId2DepartmentIdsMap = weworkDepartmentUsers.stream().collect(Collectors.groupingBy(WeworkDepartmentUser::getWeworkUserId, Collectors.mapping(WeworkDepartmentUser::getDepartmentId, Collectors.toList())));
        }
        return weworkUserId2DepartmentIdsMap;
    }

    private Map<Integer, WeworkDepartment> getWeworkDepartmentMap(String corpId) {
        List weworkDepartments = this.weworkDepartmentMapper.selectByCorpId(corpId);
        Map departmentId2ObjMap = null;
        if (CollectionUtils.isNotEmpty((Collection)weworkDepartments)) {
            departmentId2ObjMap = weworkDepartments.stream().collect(Collectors.toMap(WeworkDepartment::getDepartmentId, Functions.identity()));
        }
        return departmentId2ObjMap;
    }

    private void getAllNode(List<IdAndNameDto> nodes, Map<Integer, WeworkDepartment> weworkDepartmentId2ObjMap, Integer departmentId) {
        if (MapUtils.isNotEmpty(weworkDepartmentId2ObjMap) && weworkDepartmentId2ObjMap.containsKey(departmentId)) {
            IdAndNameDto idAndNameDto = new IdAndNameDto();
            nodes.add(idAndNameDto);
            WeworkDepartment weworkDepartment = weworkDepartmentId2ObjMap.get(departmentId);
            idAndNameDto.setId(Long.valueOf(weworkDepartment.getDepartmentId().intValue()));
            idAndNameDto.setName(weworkDepartment.getName());
            this.getAllNode(nodes, weworkDepartmentId2ObjMap, weworkDepartment.getParentId());
        }
    }

    private List<InJobAllocateRecordRespDto> buildAllocatedRecordList(List<InJobAllocateRecord> allocateRecords, Map<String, WeworkContact> contactId2ObjMap, Map<String, WeworkContactRelation> contactId2RelationMap, Map<String, List<String>> contactId2MobilesMap, Map<String, List<String>> contactId2TagNamesMap, Map<String, List<Integer>> takeoverUserId2DepartmentIdsMap, Map<Integer, WeworkDepartment> weworkDepartmentId2ObjMap, Map<String, String> weworkUserId2NameMap) {
        ArrayList allocateRecordRespDtos = Lists.newArrayList();
        Set weworkUserNums = allocateRecords.stream().map(InJobAllocateRecord::getWeworkUserNum).collect(Collectors.toSet());
        weworkUserNums.addAll(allocateRecords.stream().map(InJobAllocateRecord::getTakeoverUserNum).collect(Collectors.toSet()));
        Map weworkUserNum2IdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums(weworkUserNums);
        for (InJobAllocateRecord allocateRecord : allocateRecords) {
            String weworkUserNum = allocateRecord.getWeworkUserNum();
            String contactId = allocateRecord.getWeworkContactId();
            String takeoverUserNum = allocateRecord.getTakeoverUserNum();
            String weworkUserId = (String)weworkUserNum2IdMap.get(weworkUserNum);
            String takeoverUserId = (String)weworkUserNum2IdMap.get(takeoverUserNum);
            String weworkUserAndContactId = weworkUserId + ":" + contactId;
            InJobAllocateRecordRespDto inJobAllocateRecordRespDto = new InJobAllocateRecordRespDto();
            allocateRecordRespDtos.add(inJobAllocateRecordRespDto);
            inJobAllocateRecordRespDto.setAllocateTime(allocateRecord.getAllocateTime());
            inJobAllocateRecordRespDto.setWeworkContactId(contactId);
            if (MapUtils.isNotEmpty(contactId2ObjMap) && contactId2ObjMap.containsKey(contactId)) {
                inJobAllocateRecordRespDto.setAvatar(contactId2ObjMap.get(contactId).getAvatar());
                inJobAllocateRecordRespDto.setNickname(contactId2ObjMap.get(contactId).getName());
                inJobAllocateRecordRespDto.setCorpName(contactId2ObjMap.get(contactId).getCorpName());
            }
            if (MapUtils.isNotEmpty(contactId2RelationMap) && contactId2RelationMap.containsKey(weworkUserAndContactId)) {
                inJobAllocateRecordRespDto.setRemark(contactId2RelationMap.get(weworkUserAndContactId).getRemark());
            }
            if (MapUtils.isNotEmpty(contactId2MobilesMap) && contactId2MobilesMap.containsKey(weworkUserAndContactId)) {
                inJobAllocateRecordRespDto.setRemarkMobiles(contactId2MobilesMap.get(weworkUserAndContactId));
            }
            if (MapUtils.isNotEmpty(contactId2TagNamesMap) && contactId2TagNamesMap.containsKey(weworkUserAndContactId)) {
                inJobAllocateRecordRespDto.setWeworkTagNames(contactId2TagNamesMap.get(weworkUserAndContactId));
            }
            inJobAllocateRecordRespDto.setTakeoverUserId(takeoverUserNum);
            inJobAllocateRecordRespDto.setWeworkUserId(weworkUserNum);
            if (MapUtils.isNotEmpty(weworkUserId2NameMap)) {
                inJobAllocateRecordRespDto.setWeworkUserName(weworkUserId2NameMap.get(weworkUserId));
                inJobAllocateRecordRespDto.setTakeoverUserName(weworkUserId2NameMap.get(takeoverUserId));
            }
            inJobAllocateRecordRespDto.setStatus(allocateRecord.getStatus());
            TakeoverStatus takeoverStatus = TakeoverStatus.get((int)inJobAllocateRecordRespDto.getStatus());
            if (Objects.nonNull(takeoverStatus)) {
                inJobAllocateRecordRespDto.setStatusDesc(takeoverStatus.getDesc());
            }
            if (!MapUtils.isNotEmpty(takeoverUserId2DepartmentIdsMap) || !takeoverUserId2DepartmentIdsMap.containsKey(takeoverUserId)) continue;
            ArrayList nodes = Lists.newArrayList();
            inJobAllocateRecordRespDto.setNodes(nodes);
            List<Integer> departmentIds = takeoverUserId2DepartmentIdsMap.get(takeoverUserId);
            for (Integer departmentId : departmentIds) {
                ArrayList idAndNameDtos = Lists.newArrayList();
                this.getAllNode(idAndNameDtos, weworkDepartmentId2ObjMap, departmentId);
                Collections.reverse(idAndNameDtos);
                nodes.add(idAndNameDtos);
            }
        }
        return allocateRecordRespDtos;
    }

    private ContactQueryParams buildContactQueryParams(String corpId, ContactReqDto reqDto) {
        ContactQueryParams contactQueryParams = new ContactQueryParams();
        contactQueryParams.setCorpId(corpId);
        contactQueryParams.setQuery(reqDto.getQuery());
        contactQueryParams.setWeworkUserNum(reqDto.getWeworkUserId());
        contactQueryParams.setTagIds(reqDto.getTagIds());
        contactQueryParams.setOffset(Integer.valueOf((reqDto.getPageDto().getPageNum() - 1) * reqDto.getPageDto().getPageSize()));
        contactQueryParams.setPageSize(reqDto.getPageDto().getPageSize());
        Date curDate = new Date();
        contactQueryParams.setAllocEndTime(curDate);
        contactQueryParams.setAllocStartTime(DateUtil.getDateAddDay((Date)curDate, (int)-1));
        return contactQueryParams;
    }

    private void changeWeworkUserNum2WeworkUserId(InJobAllocateReqDto reqDto) {
        HashSet weworkUserNums = Sets.newHashSet();
        weworkUserNums.add(reqDto.getTakeoverUserId());
        for (TransferListReqDto transferListReqDto : reqDto.getList()) {
            weworkUserNums.add(transferListReqDto.getWeworkUserId());
        }
        Map weworkUserNum2IdMap = this.weworkUserMapper.selectWeworkUserNumAndIdByNums((Collection)weworkUserNums);
        if (MapUtils.isEmpty((Map)weworkUserNum2IdMap)) {
            log.error("\u6839\u636eweworkUserNums:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)weworkUserNum2IdMap);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        String takeoverUserId = (String)weworkUserNum2IdMap.get(reqDto.getTakeoverUserId());
        if (StringUtils.isBlank((CharSequence)takeoverUserId)) {
            log.error("\u6839\u636etakeoverUserNum:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getTakeoverUserId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u63a5\u66ff\u8005\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        reqDto.setTakeoverUserId((String)weworkUserNum2IdMap.get(reqDto.getTakeoverUserId()));
        for (TransferListReqDto transferListReqDto : reqDto.getList()) {
            if (weworkUserNum2IdMap.containsKey(transferListReqDto.getWeworkUserId())) {
                transferListReqDto.setWeworkUserId((String)weworkUserNum2IdMap.get(transferListReqDto.getWeworkUserId()));
                continue;
            }
            log.error("\u6839\u636eweworkUserNum:{}\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684weworkUserId", (Object)transferListReqDto.getWeworkUserId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
    }

    private void validateTakeoverUserAndWeworkUserIsSame(InJobAllocateReqDto reqDto, String corpId) {
        String takeoverUserId = reqDto.getTakeoverUserId();
        HashSet contactIds = Sets.newHashSet();
        HashSet weworkUserIds = Sets.newHashSet();
        ArrayList transferListReqDtos = Lists.newArrayList();
        reqDto.getList().forEach(transferListReqDto -> {
            if (takeoverUserId.equals(transferListReqDto.getWeworkUserId())) {
                transferListReqDtos.add(transferListReqDto);
                contactIds.add(transferListReqDto.getWeworkContactId());
                weworkUserIds.add(transferListReqDto.getWeworkUserId());
            }
        });
        if (CollectionUtils.isEmpty((Collection)contactIds)) {
            return;
        }
        List weworkContacts = this.weworkContactMapper.selectByCorpIdAndContactIds(corpId, (Collection)contactIds);
        Map<String, String> contactId2NameMap = weworkContacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, WeworkContact::getName));
        List weworkContactRelations = this.weworkContactRelationMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, (Collection)contactIds, (Collection)weworkUserIds);
        Map<String, String> uniqKey2RemarkMap = null;
        if (CollectionUtils.isNotEmpty((Collection)weworkContactRelations)) {
            weworkContactRelations.forEach(relation -> relation.setWeworkUserAndContactId(relation.getWeworkUserId() + ":" + relation.getContactId()));
            uniqKey2RemarkMap = weworkContactRelations.stream().collect(Collectors.toMap(WeworkContactRelation::getWeworkUserAndContactId, WeworkContactRelation::getRemark));
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("\u5ba2\u6237");
        for (TransferListReqDto transferListReqDto2 : transferListReqDtos) {
            String uniqKey = transferListReqDto2.getWeworkUserId() + ":" + transferListReqDto2.getWeworkContactId();
            if (MapUtils.isNotEmpty(uniqKey2RemarkMap) && uniqKey2RemarkMap.containsKey(uniqKey)) {
                stringBuilder.append(uniqKey2RemarkMap.get(uniqKey)).append(',');
                continue;
            }
            stringBuilder.append(contactId2NameMap.get(transferListReqDto2.getWeworkUserId())).append(',');
        }
        String errMsg = stringBuilder.append("\u539f\u8ddf\u8fdb\u4eba\u4e0e\u63a5\u66ff\u8005\u76f8\u540c\uff0c\u4e0d\u53ef\u7ee7\u627f").toString();
        throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, errMsg);
    }

    private void checkIsCanTransfer(String corpId, InJobAllocateReqDto reqDto, String weworkUserNum) {
        Date allocateTime;
        List<TransferListReqDto> transferListReqDtos = reqDto.getList();
        if (transferListReqDtos.size() > 1) {
            return;
        }
        String contactId = transferListReqDtos.get(0).getWeworkContactId();
        List inJobAllocateRecords = this.inJobAllocateRecordMapper.selectByCorpIdWeworkUserNumAndContactId(corpId, weworkUserNum, contactId);
        if (CollectionUtils.isEmpty((Collection)inJobAllocateRecords)) {
            return;
        }
        List waitRecords = inJobAllocateRecords.stream().filter(inJobAllocateRecord -> inJobAllocateRecord.getStatus().intValue() == TakeoverStatus.WAIT_TAKEOVER.getValue()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(waitRecords)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u5ba2\u6237\u6b63\u5728\u8f6c\u63a5\u4e2d");
        }
        List finishRecords = inJobAllocateRecords.stream().filter(inJobAllocateRecord -> inJobAllocateRecord.getStatus().intValue() == TakeoverStatus.FINISH.getValue()).collect(Collectors.toList());
        if (finishRecords.size() >= 2) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5728\u804c\u6210\u5458\u7684\u6bcf\u4f4d\u5ba2\u6237\u6700\u591a\u88ab\u5206\u914d2\u6b21");
        }
        if (finishRecords.size() == 1 && new Date().before(DateUtil.getDateAddDay((Date)(allocateTime = ((InJobAllocateRecord)finishRecords.get(0)).getAllocateTime()), (int)90))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "90\u5929\u5185\u53ea\u5141\u8bb8\u8f6c\u63a5\u4e00\u6b21");
        }
    }
}

