/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.tranfer.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.dal.transfer.dto.RoomQueryParams;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RoomReqDto {
    private String weworkUserId;
    private String name;
    private Date startTime;
    private Date endTime;
    private PageDto pageDto;
    private String takeoverUserId;

    public void baseValidate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto), (Object)"\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto.getPageNum()), (Object)"\u5206\u9875\u9875\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.pageDto.getPageSize()), (Object)"\u5206\u9875\u5927\u5c0f\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public void allocateParams() {
        this.baseValidate();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.weworkUserId), (Object)"\u79bb\u804c\u6210\u5458\u552f\u4e00\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
    }

    public RoomQueryParams convert2QueryParams(String corpId) {
        RoomQueryParams roomQueryParams = new RoomQueryParams();
        roomQueryParams.setCorpId(corpId);
        roomQueryParams.setWeworkUserNum(this.weworkUserId);
        roomQueryParams.setName(this.name);
        roomQueryParams.setStartTime(this.startTime);
        roomQueryParams.setEndTime(this.endTime);
        roomQueryParams.setOffset(Integer.valueOf((this.pageDto.getPageNum() - 1) * this.pageDto.getPageSize()));
        roomQueryParams.setPageSize(this.pageDto.getPageSize());
        roomQueryParams.setTakeoverUserNum(this.takeoverUserId);
        return roomQueryParams;
    }

    public String getWeworkUserId() {
        return this.weworkUserId;
    }

    public String getName() {
        return this.name;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public String getTakeoverUserId() {
        return this.takeoverUserId;
    }

    public void setWeworkUserId(String weworkUserId) {
        this.weworkUserId = weworkUserId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setTakeoverUserId(String takeoverUserId) {
        this.takeoverUserId = takeoverUserId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoomReqDto)) {
            return false;
        }
        RoomReqDto other = (RoomReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$weworkUserId = this.getWeworkUserId();
        String other$weworkUserId = other.getWeworkUserId();
        if (this$weworkUserId == null ? other$weworkUserId != null : !this$weworkUserId.equals(other$weworkUserId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        String this$takeoverUserId = this.getTakeoverUserId();
        String other$takeoverUserId = other.getTakeoverUserId();
        return !(this$takeoverUserId == null ? other$takeoverUserId != null : !this$takeoverUserId.equals(other$takeoverUserId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoomReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $weworkUserId = this.getWeworkUserId();
        result = result * 59 + ($weworkUserId == null ? 43 : $weworkUserId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        String $takeoverUserId = this.getTakeoverUserId();
        result = result * 59 + ($takeoverUserId == null ? 43 : $takeoverUserId.hashCode());
        return result;
    }

    public String toString() {
        return "RoomReqDto(weworkUserId=" + this.getWeworkUserId() + ", name=" + this.getName() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", pageDto=" + this.getPageDto() + ", takeoverUserId=" + this.getTakeoverUserId() + ")";
    }
}

