/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.enums.TagAutoType;
import com.kuaike.scrm.common.service.ScrmTagAutoService;
import com.kuaike.scrm.common.service.dto.resp.TagAutoRespDto;
import com.kuaike.scrm.dal.system.entity.TagAutoSetting;
import com.kuaike.scrm.dal.system.mapper.TagAutoSettingMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScrmTagAutoServiceImpl
implements ScrmTagAutoService {
    private static final Logger log = LoggerFactory.getLogger(ScrmTagAutoServiceImpl.class);
    @Autowired
    private TagAutoSettingMapper tagAutoSettingMapper;

    public List<TagAutoRespDto> list(Long bizId) {
        if (bizId == null || bizId < NumberUtils.LONG_ZERO) {
            return Collections.emptyList();
        }
        List tagAutoSettings = this.tagAutoSettingMapper.selectByBizId(bizId);
        Map<Object, Object> type2SettingMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)tagAutoSettings)) {
            type2SettingMap = tagAutoSettings.stream().collect(Collectors.toMap(TagAutoSetting::getType, Functions.identity()));
        }
        TagAutoType[] tagAutoTypes = TagAutoType.values();
        ArrayList resps = Lists.newArrayList();
        for (TagAutoType autoType : tagAutoTypes) {
            TagAutoRespDto resp = new TagAutoRespDto();
            resps.add(resp);
            resp.setType(Integer.valueOf(autoType.getValue()));
            resp.setIsEnable(NumberUtils.INTEGER_ZERO);
            if (!type2SettingMap.containsKey(autoType.getValue())) continue;
            TagAutoSetting tagAutoSetting = (TagAutoSetting)type2SettingMap.get(autoType.getValue());
            resp.setIsEnable(tagAutoSetting.getIsEnable());
        }
        return resps;
    }

    public Integer queryIsEnableByType(Long bizId, Integer type) {
        if (Objects.isNull(bizId) || Objects.isNull(type)) {
            log.warn("bizId:{},type:{}\u90fd\u4e0d\u80fd\u4e3a\u7a7a", (Object)bizId, (Object)type);
            return NumberUtils.INTEGER_ZERO;
        }
        Integer isEnable = this.tagAutoSettingMapper.selectIsEnableByBizIdAndType(bizId, type);
        if (Objects.isNull(isEnable)) {
            isEnable = NumberUtils.INTEGER_ZERO;
        }
        return isEnable;
    }
}

