/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import cn.kinyun.pay.business.dto.request.PayConfigGroupQuery;
import cn.kinyun.pay.business.dto.response.PayConfigGroupDto;
import cn.kinyun.pay.business.dto.response.PayConfigGroupDtoResp;
import cn.kinyun.pay.business.service.ScrmPayConfigService;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.IdDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.system.dto.request.BranchSchoolReqDto;
import com.kuaike.scrm.system.dto.request.OrgTypeCodeAddOrModeReqDto;
import com.kuaike.scrm.system.dto.request.ProvinceOfficeReqDto;
import com.kuaike.scrm.system.dto.request.SetPayGroupKeyReqDto;
import com.kuaike.scrm.system.dto.response.OrgTypeCodeRespDto;
import com.kuaike.scrm.system.dto.response.PayGroupInfoRespDto;
import com.kuaike.scrm.system.dto.response.SchoolListRespDto;
import com.kuaike.scrm.system.service.OrgSettingService;
import com.kuaike.scrm.system.service.ScrmNetSchoolService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgSettingServiceImpl
implements OrgSettingService {
    private static final Logger log = LoggerFactory.getLogger(OrgSettingServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Resource
    private ScrmPayConfigService scrmPayConfigService;
    @Resource
    private ScrmNetSchoolService scrmNetSchoolService;

    @Override
    public void addOrModOrgTypeCode(OrgTypeCodeAddOrModeReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("addOrgTypeCode,params:{}, operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        params.validateParams();
        String corpId = currentUserInfo.getCorpId();
        Organization organization = this.organizationMapper.selectByCorpIdAndId(corpId, params.getId());
        if (Objects.isNull(organization)) {
            log.warn("\u6839\u636e\u90e8\u95e8id:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)params.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u90e8\u95e8id\u503c\u4e0d\u5408\u6cd5");
        }
        List organizations = this.organizationMapper.selectByCorpIdAndOrgCode(corpId, params.getOrgCode());
        if (CollectionUtils.isNotEmpty((Collection)organizations)) {
            if (organizations.size() > 1) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u90e8\u95e8\u4ee3\u7801\u91cd\u590d");
            }
            if (organizations.size() == 1 && !((Organization)organizations.get(0)).getId().equals(organization.getId())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u90e8\u95e8\u4ee3\u7801\u91cd\u590d");
            }
        }
        organization.setOrgType(params.getOrgType());
        organization.setOrgCode(params.getOrgCode());
        organization.setUpdateBy(currentUserInfo.getId());
        organization.setUpdateTime(new Date());
        this.organizationMapper.updateByPrimaryKey((Object)organization);
    }

    @Override
    public OrgTypeCodeRespDto getOrgTypeCode(IdDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("getOrgTypeCode,params:{}, operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        Organization organization = this.organizationMapper.selectByCorpIdAndId(currentUserInfo.getCorpId(), params.getId());
        OrgTypeCodeRespDto respDto = new OrgTypeCodeRespDto();
        if (Objects.isNull(organization)) {
            log.warn("\u6839\u636ecorpId:{}, orgId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)currentUserInfo.getCorpId(), (Object)params.getId());
            return respDto;
        }
        respDto.setOrgType(organization.getOrgType());
        respDto.setOrgCode(organization.getOrgCode());
        return respDto;
    }

    @Override
    public List<IdAndNameDto> getBranchSchools(BranchSchoolReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        return this.organizationMapper.selectBranchSchoolByIds(currentUserInfo.getBizId(), reqDto.getBranchSchoolName());
    }

    @Override
    public List<IdAndNameDto> getProvinceOffice(ProvinceOfficeReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        return this.organizationMapper.selectProvinceOffice(currentUserInfo.getBizId(), reqDto.getProvinceName());
    }

    @Override
    public void setPayGroupKey(SetPayGroupKeyReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("org setPayGroupKey,params:{}, operatorId:{}", (Object)reqDto, (Object)currentUserInfo.getId());
        reqDto.validateParams();
        if (Objects.nonNull(reqDto.getNetSchoolId()) && StringUtils.isNotBlank((CharSequence)reqDto.getPayGroupKey())) {
            List organizations = this.organizationMapper.selectByBizIdAndSchoolId(currentUserInfo.getBizId(), reqDto.getNetSchoolId());
            for (Organization organization : organizations) {
                if (organization.getId().equals(reqDto.getId()) || !StringUtils.isNotBlank((CharSequence)organization.getPayGroupKey()) || reqDto.getPayGroupKey().equals(organization.getPayGroupKey())) continue;
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u90e8\u95e8\u3010" + organization.getName() + "\u3011\u5728\u76f8\u540c\u6821\u533a\u4e0a\u5df2\u7ed1\u5b9a\u4e86\u5176\u4ed6\u652f\u4ed8\u4e3b\u4f53");
            }
        }
        this.organizationMapper.updatePayGroupKeyById(reqDto.getPayGroupKey(), reqDto.getNetSchoolId(), reqDto.getId());
    }

    @Override
    public PayGroupInfoRespDto getPayGroupKeyInfo(IdDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("getPayGroupKeyInfo,params:{}, operatorId:{}", (Object)reqDto, (Object)currentUserInfo.getId());
        reqDto.validateParams();
        Organization organization = (Organization)this.organizationMapper.selectByPrimaryKey((Object)reqDto.getId());
        if (organization == null) {
            log.info("\u6839\u636eorgId:{}\u672a\u67e5\u8be2\u5230organization", (Object)reqDto.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        PayGroupInfoRespDto payGroupInfoRespDto = null;
        if (StringUtils.isNotBlank((CharSequence)organization.getPayGroupKey())) {
            PayConfigGroupQuery payConfigGroupQuery = new PayConfigGroupQuery();
            payConfigGroupQuery.setCorpId(organization.getCorpId());
            payConfigGroupQuery.setGroupKeys(Collections.singletonList(organization.getPayGroupKey()));
            PayConfigGroupDtoResp payConfigGroupDto = this.scrmPayConfigService.queryConfigGroup(payConfigGroupQuery);
            if (Objects.nonNull(payConfigGroupDto) && CollectionUtils.isNotEmpty((Collection)payConfigGroupDto.getList())) {
                payGroupInfoRespDto = new PayGroupInfoRespDto();
                payGroupInfoRespDto.setPayGroupKey(organization.getPayGroupKey());
                payGroupInfoRespDto.setPayGroupName(((PayConfigGroupDto)payConfigGroupDto.getList().get(0)).getGroupName());
            }
        }
        if (Objects.nonNull(organization.getNetSchoolId())) {
            if (payGroupInfoRespDto == null) {
                payGroupInfoRespDto = new PayGroupInfoRespDto();
            }
            payGroupInfoRespDto.setNetSchoolId(organization.getNetSchoolId());
            SchoolListRespDto schoolListRespDto = this.scrmNetSchoolService.schoolSimpleInfo(organization.getBizId(), Sets.newHashSet((Object[])new Long[]{organization.getNetSchoolId()}));
            if (schoolListRespDto != null && org.apache.commons.collections.CollectionUtils.isNotEmpty(schoolListRespDto.getData())) {
                payGroupInfoRespDto.setNetSchoolName(schoolListRespDto.getData().get(0).getOrgName());
            }
        }
        return payGroupInfoRespDto;
    }
}

