/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.enums.OrgTypeEnum;
import com.kuaike.scrm.system.dto.request.NetSchoolRoleModReqDto;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class RoleModReqDto
implements Serializable {
    private static final long serialVersionUID = 6836999830753159852L;
    private Long id;
    private String name;
    private String remark;
    private Integer orgType;

    public NetSchoolRoleModReqDto convertToRoleModReqDto(Integer netSchoolUserId) {
        NetSchoolRoleModReqDto reqDto = new NetSchoolRoleModReqDto();
        reqDto.setRoleName(this.name);
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            reqDto.setDescription(this.remark);
        }
        reqDto.setUserId(netSchoolUserId);
        return reqDto;
    }

    public void validate() {
        Preconditions.checkArgument((this.id != null ? 1 : 0) != 0, (Object)"\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.name), (Object)"\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.name.length() >= 1 && this.name.length() <= 128 ? 1 : 0) != 0, (Object)"\u89d2\u8272\u540d\u79f0\u957f\u5ea6\u4e0d\u5408\u6cd5");
        Preconditions.checkArgument((StringUtils.isEmpty((CharSequence)this.remark) || this.remark.length() <= 200 ? 1 : 0) != 0, (Object)"\u89d2\u8272\u63cf\u8ff0\u8d85\u8fc7\u6700\u957f\u9650\u5236");
        if (Objects.nonNull(this.orgType)) {
            Preconditions.checkArgument((boolean)Objects.nonNull(OrgTypeEnum.get((int)this.orgType)), (Object)"\u89d2\u8272\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u5408\u6cd5");
        }
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getRemark() {
        return this.remark;
    }

    public Integer getOrgType() {
        return this.orgType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setOrgType(Integer orgType) {
        this.orgType = orgType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoleModReqDto)) {
            return false;
        }
        RoleModReqDto other = (RoleModReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$orgType = this.getOrgType();
        Integer other$orgType = other.getOrgType();
        if (this$orgType == null ? other$orgType != null : !((Object)this$orgType).equals(other$orgType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        return !(this$remark == null ? other$remark != null : !this$remark.equals(other$remark));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoleModReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $orgType = this.getOrgType();
        result = result * 59 + ($orgType == null ? 43 : ((Object)$orgType).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        return result;
    }

    public String toString() {
        return "RoleModReqDto(id=" + this.getId() + ", name=" + this.getName() + ", remark=" + this.getRemark() + ", orgType=" + this.getOrgType() + ")";
    }
}

