/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.entity.CustomerStageReason;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.system.mapper.CustomerStageReasonMapper;
import com.kuaike.scrm.system.dto.request.CustomerStageModReqDto;
import com.kuaike.scrm.system.dto.response.CustomerStageReasonDto;
import com.kuaike.scrm.system.dto.response.CustomerStageRespDto;
import com.kuaike.scrm.system.service.CustomerStageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerStageServiceImpl
implements CustomerStageService {
    private static final Logger log = LoggerFactory.getLogger(CustomerStageServiceImpl.class);
    private static final int STAGE_TYPE_FLOWING = 1;
    private static final int STAGE_TYPE_END = 2;
    private static final String UNENABLE_EDIT_STAGE_NAME = "\u5df2\u6210\u5355";
    private static final int ENABLE_MOD_YES = 0;
    private static final int ENABLE_MOD_NO = 1;
    @Autowired
    private CustomerStageMapper customerStageMapper;
    @Autowired
    private CustomerStageReasonMapper customerStageReasonMapper;

    @Override
    public List<CustomerStageRespDto> list() {
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("addOrMod: bizId:{}, corpId:{}, id:{}", new Object[]{currentUserInfo.getBizId(), currentUserInfo.getCorpId(), currentUserInfo.getId()});
        List customerStages = this.customerStageMapper.queryStageList(currentUserInfo.getBizId(), currentUserInfo.getCorpId());
        if (CollectionUtils.isEmpty((Collection)customerStages)) {
            log.info("list : customerStages is null");
            return Collections.emptyList();
        }
        List customerStageReasons = this.customerStageReasonMapper.queryReasonList(currentUserInfo.getBizId(), currentUserInfo.getCorpId());
        Map<Long, List<CustomerStageReason>> stageReasonMap = customerStageReasons.stream().collect(Collectors.groupingBy(CustomerStageReason::getStageId));
        ArrayList<CustomerStageRespDto> stageRespDtos = new ArrayList<CustomerStageRespDto>();
        for (CustomerStage stage : customerStages) {
            List<CustomerStageReason> reasons;
            CustomerStageRespDto respDto = new CustomerStageRespDto();
            respDto.setId(stage.getId());
            respDto.setType(stage.getType());
            respDto.setStageName(stage.getStageName());
            respDto.setStageValue(stage.getStageValue());
            respDto.setOrder(stage.getOrder());
            respDto.setUnableMod(stage.getUnableMod());
            if (stage.getType() == 2 && CollectionUtils.isNotEmpty(reasons = stageReasonMap.get(stage.getId()))) {
                ArrayList reasonDtos = Lists.newArrayList();
                for (CustomerStageReason reason : reasons) {
                    CustomerStageReasonDto reasonDto = new CustomerStageReasonDto();
                    reasonDto.setReason(reason.getReason());
                    reasonDto.setStageReasonId(reason.getId());
                    reasonDtos.add(reasonDto);
                }
                respDto.setReasons(reasonDtos);
            }
            stageRespDtos.add(respDto);
        }
        log.info("list stageRespDtos : {}", stageRespDtos);
        return stageRespDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrMod(List<CustomerStageModReqDto> list) {
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("addOrMod: bizId:{}, corpId:{}, id:{}", new Object[]{currentUserInfo.getBizId(), currentUserInfo.getCorpId(), currentUserInfo.getId()});
        this.validate(list);
        Map<Long, CustomerStageModReqDto> dtoMap = list.stream().collect(Collectors.toMap(CustomerStageModReqDto::getId, a -> a, (k1, k2) -> k2));
        HashSet reasonDtoSet = new HashSet();
        for (CustomerStageModReqDto dto : list) {
            List<CustomerStageReasonDto> reasonDtos = dto.getReasons();
            if (!CollectionUtils.isNotEmpty(reasonDtos)) continue;
            reasonDtos.stream().map(reasonDto -> this.buildKey(dto.getId(), reasonDto.getStageReasonId())).forEach(reasonDtoSet::add);
        }
        List customerStages = this.customerStageMapper.queryStageList(currentUserInfo.getBizId(), currentUserInfo.getCorpId());
        List customerStageReasons = this.customerStageReasonMapper.queryReasonList(currentUserInfo.getBizId(), currentUserInfo.getCorpId());
        Map<Long, CustomerStage> stageMap = customerStages.stream().collect(Collectors.toMap(CustomerStage::getId, a -> a, (k1, k2) -> k2));
        Map<String, CustomerStage> stageNameMap = customerStages.stream().collect(Collectors.toMap(CustomerStage::getStageName, a -> a, (k1, k2) -> k2));
        Map<String, List<CustomerStageReason>> stageReasonMap = customerStageReasons.stream().collect(Collectors.groupingBy(item -> this.buildKey(item.getStageId(), item.getId())));
        ArrayList insertStageList = Lists.newArrayList();
        ArrayList updateStageList = Lists.newArrayList();
        ArrayList insertReasonList = Lists.newArrayList();
        ArrayList updateReasonList = Lists.newArrayList();
        HashSet<Long> deleteStageSet = new HashSet<Long>();
        HashSet<Long> deleteStageReasonSet = new HashSet<Long>();
        for (CustomerStage stage : customerStages) {
            if (dtoMap.containsKey(stage.getId())) continue;
            deleteStageSet.add(stage.getId());
        }
        for (CustomerStageReason reason : customerStageReasons) {
            String key = this.buildKey(reason.getStageId(), reason.getId());
            if (reasonDtoSet.contains(key)) continue;
            deleteStageReasonSet.add(reason.getId());
        }
        for (CustomerStageModReqDto reqDto : list) {
            List<CustomerStageReasonDto> reasonDtos;
            log.info("addOrMod: reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
            if (Objects.isNull(reqDto.getId())) {
                if (UNENABLE_EDIT_STAGE_NAME.equals(reqDto.getStageName())) {
                    Preconditions.checkArgument((!stageNameMap.containsKey(reqDto.getStageName()) ? 1 : 0) != 0, (Object)"'\u5df2\u6210\u5355'\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u65b0\u589e");
                }
                insertStageList.add(this.newStage(reqDto, currentUserInfo));
                continue;
            }
            if (stageMap.containsKey(reqDto.getId())) {
                updateStageList.add(this.newStage(reqDto, currentUserInfo));
            }
            if (reqDto.getType() != 2 || !CollectionUtils.isNotEmpty(reasonDtos = reqDto.getReasons())) continue;
            for (CustomerStageReasonDto reasonDto2 : reasonDtos) {
                String key = this.buildKey(reqDto.getId(), reasonDto2.getStageReasonId());
                if (Objects.isNull(reasonDto2.getStageReasonId())) {
                    insertReasonList.add(this.newStageReason(reqDto, reasonDto2));
                    continue;
                }
                if (!stageReasonMap.containsKey(key)) continue;
                updateReasonList.add(this.newStageReason(reqDto, reasonDto2));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)insertStageList)) {
            this.customerStageMapper.batchInsert((List)insertStageList);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateStageList)) {
            this.customerStageMapper.batchUpdate((List)updateStageList);
        }
        log.info("addOrMod: deleteStageSet:{}", deleteStageSet);
        if (CollectionUtils.isNotEmpty(deleteStageSet)) {
            this.customerStageMapper.batchDelete(currentUserInfo.getBizId(), currentUserInfo.getCorpId(), currentUserInfo.getId(), deleteStageSet);
        }
        if (CollectionUtils.isNotEmpty((Collection)insertReasonList)) {
            this.customerStageReasonMapper.batchInsert((List)insertReasonList);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateReasonList)) {
            this.customerStageReasonMapper.batchUpdate((List)updateReasonList);
        }
        log.info("addOrMod: deleteStageReasonSet:{}", deleteStageReasonSet);
        if (CollectionUtils.isNotEmpty(deleteStageReasonSet)) {
            this.customerStageReasonMapper.batchDelete(currentUserInfo.getBizId(), currentUserInfo.getCorpId(), currentUserInfo.getId(), deleteStageReasonSet);
        }
    }

    private CustomerStage newStage(CustomerStageModReqDto dto, CurrentUserInfo userInfo) {
        CustomerStage stage = new CustomerStage();
        if (Objects.nonNull(dto.getId())) {
            stage.setId(dto.getId());
        }
        stage.setType(dto.getType());
        stage.setOrder(dto.getOrder());
        stage.setStageValue(dto.getStageValue());
        if (UNENABLE_EDIT_STAGE_NAME.equals(dto.getStageName())) {
            stage.setStageName(UNENABLE_EDIT_STAGE_NAME);
            stage.setUnableMod(Integer.valueOf(1));
        } else {
            stage.setStageName(dto.getStageName());
            stage.setUnableMod(dto.getUnableMod());
        }
        stage.setCreateBy(userInfo.getId());
        stage.setCreateTime(new Date());
        stage.setUpdateBy(userInfo.getId());
        stage.setUpdateTime(new Date());
        stage.setCorpId(userInfo.getCorpId());
        stage.setBizId(userInfo.getBizId());
        stage.setIsDeleted(NumberUtils.INTEGER_ZERO);
        return stage;
    }

    private CustomerStageReason newStageReason(CustomerStageModReqDto stageDto, CustomerStageReasonDto dto) {
        CustomerStageReason stageReason = new CustomerStageReason();
        if (Objects.nonNull(dto.getStageReasonId())) {
            stageReason.setId(dto.getStageReasonId());
        }
        stageReason.setReason(dto.getReason());
        stageReason.setStageId(stageDto.getId());
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        stageReason.setCreateBy(userInfo.getId());
        stageReason.setCreateTime(new Date());
        stageReason.setUpdateBy(userInfo.getId());
        stageReason.setUpdateTime(new Date());
        stageReason.setIsDeleted(NumberUtils.INTEGER_ZERO);
        stageReason.setCorpId(userInfo.getCorpId());
        stageReason.setBizId(userInfo.getBizId());
        return stageReason;
    }

    private CurrentUserInfo baseValidate() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        return currentUserInfo;
    }

    private void validate(List<CustomerStageModReqDto> list) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(list), (Object)"\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a");
        for (CustomerStageModReqDto dto : list) {
            List<CustomerStageReasonDto> reasonDtos;
            dto.validate();
            if (dto.getType() == 1) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getStageValue()), (Object)"\u8ddf\u8fdb\u4e2d\u9636\u6bb5\u540d\u4e0d\u80fd\u4e3a\u7a7a");
                Preconditions.checkArgument((boolean)Objects.isNull(dto.getReasons()), (Object)"\u8ddf\u8fdb\u4e2d\u7ed3\u675f\u539f\u56e0\u5fc5\u987b\u4e3anull");
                if (Objects.equals(dto.getStageName(), UNENABLE_EDIT_STAGE_NAME)) {
                    Preconditions.checkArgument((boolean)Objects.equals(dto.getUnableMod(), 1), (Object)"\u8ddf\u8fdb\u4e2d'\u5df2\u6210\u5355'\u5fc5\u987b\u662f\u4e0d\u53ef\u4fee\u6539\u7684");
                } else {
                    Preconditions.checkArgument((boolean)Objects.equals(dto.getUnableMod(), 0), (Object)"\u8ddf\u8fdb\u4e2d\u975e'\u5df2\u6210\u5355'\u5fc5\u987b\u662f\u53ef\u4fee\u6539\u7684");
                }
            } else if (dto.getType() == 2) {
                Preconditions.checkArgument((!Objects.equals(dto.getStageName(), UNENABLE_EDIT_STAGE_NAME) ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u9636\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u4e3a'\u5df2\u6210\u5355'");
                Preconditions.checkArgument((boolean)Objects.equals(dto.getUnableMod(), 0), (Object)"\u7ed3\u675f\u9636\u6bb5\u5fc5\u987b\u662f\u53ef\u7f16\u8f91\u7684");
            }
            if (!CollectionUtils.isNotEmpty(reasonDtos = dto.getReasons())) continue;
            Preconditions.checkArgument(((int)reasonDtos.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getReason())).count() <= 0 ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument(((int)reasonDtos.stream().filter(a -> a.getReason().length() > 500).count() <= 0 ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u539f\u56e0\u5b57\u7b26\u4e0d\u80fd\u8d85\u8fc7500");
            Preconditions.checkArgument(((int)reasonDtos.stream().map(CustomerStageReasonDto::getReason).collect(Collectors.toList()).stream().distinct().count() >= reasonDtos.size() ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u539f\u56e0\u4e0d\u80fd\u91cd\u590d");
            Preconditions.checkArgument((reasonDtos.size() <= 10 ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u539f\u56e0\u4e0d\u80fd\u5927\u4e8e10\u4e2a");
        }
        int flowingCount = (int)list.stream().filter(a -> a.getType() == 1).count();
        Preconditions.checkArgument((flowingCount <= 10 ? 1 : 0) != 0, (Object)"\u8ddf\u8fdb\u4e2d\u7684\u9636\u6bb5\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc710\u4e2a");
        Set stageValueSet = list.stream().filter(a -> a.getType() == 1).map(CustomerStageModReqDto::getStageValue).collect(Collectors.toSet());
        Preconditions.checkArgument((stageValueSet.size() == flowingCount ? 1 : 0) != 0, (Object)"\u8ddf\u8fdb\u4e2d\u7684\u9636\u6bb5\u540d\u4e0d\u80fd\u91cd\u590d");
        Preconditions.checkArgument((list.stream().map(CustomerStageModReqDto::getStageName).collect(Collectors.toSet()).size() >= list.size() ? 1 : 0) != 0, (Object)"\u9636\u6bb5\u5b9a\u4e49\u4e0d\u80fd\u91cd\u590d");
    }

    private String buildKey(Long stageId, Long stageReasonId) {
        return stageId + "_" + stageReasonId;
    }
}

