/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.IdDto;
import com.kuaike.scrm.common.service.dto.req.RegionReqDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.region.entity.RegionInfo;
import com.kuaike.scrm.dal.region.mapper.RegionInfoMapper;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.system.service.RegionService;
import com.kuaike.scrm.system.service.ScrmNetSchoolService;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RegionServiceImpl
implements RegionService {
    private static final Logger log = LoggerFactory.getLogger(RegionServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Resource
    private RegionInfoMapper regionInfoMapper;
    @Resource
    private ScrmNetSchoolService scrmNetSchoolService;

    @Override
    @Transactional
    public void setRegion(RegionReqDto params) {
        log.info("set region params: {}", (Object)params);
        if (params == null) {
            return;
        }
        params.checkParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Long orgId = params.getId();
        Organization organization = (Organization)this.organizationMapper.selectByPrimaryKey((Object)orgId);
        if (organization == null || !organization.getCorpId().equals(corpId) || organization.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u90e8\u95e8\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        Date curDate = new Date();
        RegionInfo regionInfo = null;
        regionInfo = this.regionInfoMapper.queryRegionInfoByName(corpId, params.getRegion());
        if (regionInfo == null) {
            regionInfo = new RegionInfo();
            regionInfo.setBizId(bizId);
            regionInfo.setCorpId(corpId);
            regionInfo.setCreateBy(userInfo.getId());
            regionInfo.setCreateTime(curDate);
        }
        regionInfo.setLongitude(params.getLongitude());
        regionInfo.setLatitude(params.getLatitude());
        regionInfo.setRegion(params.getRegion());
        regionInfo.setName(params.getName());
        regionInfo.setUpdateBy(userInfo.getId());
        regionInfo.setUpdateTime(curDate);
        regionInfo.setIsDeleted(Integer.valueOf(0));
        if (regionInfo.getId() != null) {
            this.regionInfoMapper.updateByPrimaryKeySelective((Object)regionInfo);
        } else {
            this.regionInfoMapper.insertSelective((Object)regionInfo);
        }
        organization.setRegionInfoId(regionInfo.getId());
        organization.setUpdateTime(curDate);
        organization.setUpdateBy(userInfo.getId());
        this.organizationMapper.updateByPrimaryKeySelective((Object)organization);
    }

    @Override
    public RegionReqDto getRegion(IdDto params) {
        log.info("get region params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        params.validateParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Organization organization = (Organization)this.organizationMapper.selectByPrimaryKey((Object)params.getId());
        if (organization == null || !organization.getCorpId().equals(corpId) || organization.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u90e8\u95e8\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        Long regionId = organization.getRegionInfoId();
        RegionReqDto result = new RegionReqDto();
        if (regionId == null) {
            return null;
        }
        RegionInfo regionInfo = (RegionInfo)this.regionInfoMapper.selectByPrimaryKey((Object)regionId);
        if (regionInfo == null) {
            return null;
        }
        result.setId(params.getId());
        result.setLatitude(regionInfo.getLatitude());
        result.setLongitude(regionInfo.getLongitude());
        result.setRegion(regionInfo.getRegion());
        result.setName(regionInfo.getName());
        return result;
    }

    @Override
    @Transactional
    public void delRegion(IdDto params) {
        log.info("get region params: {}", (Object)params);
        if (params == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        params.validateParams();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        String corpId = userInfo.getCorpId();
        Organization organization = (Organization)this.organizationMapper.selectByPrimaryKey((Object)params.getId());
        if (organization == null || !organization.getCorpId().equals(corpId) || organization.getIsDeleted() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u90e8\u95e8\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        if (organization.getRegionInfoId() != null) {
            organization.setRegionInfoId(null);
            this.organizationMapper.updateByPrimaryKey((Object)organization);
        }
    }
}

