/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.google.common.base.Preconditions;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.scrm.common.enums.SystemTypeEnum;
import com.kuaike.scrm.dal.system.entity.Package;
import com.kuaike.scrm.dal.system.entity.PackageMenu;
import com.kuaike.scrm.dal.system.entity.System;
import com.kuaike.scrm.dal.system.mapper.PackageMapper;
import com.kuaike.scrm.dal.system.mapper.PackageMenuMapper;
import com.kuaike.scrm.dal.system.mapper.SystemMapper;
import com.kuaike.scrm.system.dto.request.PackageEditReqDto;
import com.kuaike.scrm.system.dto.request.PackageListReqDto;
import com.kuaike.scrm.system.dto.request.PackageReqDto;
import com.kuaike.scrm.system.dto.response.PackageListRespDto;
import com.kuaike.scrm.system.dto.response.PackageMenuRespDto;
import com.kuaike.scrm.system.dto.response.PackageRespDto;
import com.kuaike.scrm.system.service.PackageService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PackageServiceImpl
implements PackageService {
    private static final Logger log = LoggerFactory.getLogger(PackageServiceImpl.class);
    @Autowired
    private SystemMapper systemMapper;
    @Autowired
    private PackageMapper packageMapper;
    @Autowired
    private PackageMenuMapper packageMenuMapper;

    @Override
    public void initSystemMenu() {
        String[] sMenu = new String[]{SystemTypeEnum.SCRM.getDesc(), SystemTypeEnum.TRADE.getDesc(), SystemTypeEnum.CRM.getDesc(), SystemTypeEnum.PAY.getDesc(), SystemTypeEnum.AD.getDesc()};
        for (int i = 0; i < sMenu.length; ++i) {
            String name = sMenu[i];
            System system = this.systemMapper.queryByName(name);
            if (system == null) {
                System menu = new System();
                menu.setName(name);
                menu.setCreateBy(Long.valueOf(-1L));
                menu.setCreateTime(new Date());
                menu.setUpdateTime(new Date());
                menu.setIsDeleted(Integer.valueOf(0));
                this.systemMapper.insert((Object)menu);
                continue;
            }
            log.info("initSystem name is exist : {}", (Object)name);
        }
        log.info("initSystem complete");
    }

    @Override
    public List<IdAndNameDto> systemList() {
        List list = this.systemMapper.queryAllSystem();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        ArrayList dtos = Lists.newArrayList();
        for (System menu : list) {
            IdAndNameDto dto = new IdAndNameDto();
            dto.setId(menu.getId());
            dto.setName(menu.getName());
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public List<PackageListRespDto> packageList(PackageListReqDto reqDto) {
        List pkgList = this.packageMapper.queryList(reqDto.getName());
        if (CollectionUtils.isEmpty((Collection)pkgList)) {
            return null;
        }
        ArrayList respDtos = Lists.newArrayList();
        for (Package pkg : pkgList) {
            PackageListRespDto respDto = new PackageListRespDto();
            respDto.setId(pkg.getId());
            respDto.setName(pkg.getName());
            respDto.setRemark(pkg.getRemark());
            respDto.setCreateTime(pkg.getCreateTime());
            respDto.setSystemId(pkg.getSystemId());
            respDto.setIsAppPkg(pkg.getIsAppPkg());
            System system = this.systemMapper.queryById(pkg.getSystemId());
            if (system != null) {
                respDto.setSystemName(system.getName());
            }
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    @Transactional
    public void addPackage(PackageReqDto reqDto) {
        reqDto.validateParams();
        Package pge = this.setPkgPerm(reqDto);
        this.packageMapper.insert((Object)pge);
        Long pkgId = pge.getId();
        for (String menuCode : reqDto.getMenuCodes()) {
            PackageMenu pkgMenu = this.setPkgPermMenu(menuCode, pkgId);
            this.packageMenuMapper.insert((Object)pkgMenu);
        }
    }

    private Package setPkgPerm(PackageReqDto reqDto) {
        Package pge = new Package();
        pge.setName(reqDto.getPackageName());
        pge.setCreateBy(Long.valueOf(-1L));
        pge.setUpdateBy(Long.valueOf(-1L));
        pge.setCreateTime(new Date());
        pge.setUpdateTime(new Date());
        pge.setIsDeleted(Integer.valueOf(0));
        pge.setSystemId(reqDto.getSystemId());
        pge.setRemark(reqDto.getRemark());
        if (Objects.nonNull(reqDto.getIsAppPkg())) {
            pge.setIsAppPkg(reqDto.getIsAppPkg());
        }
        return pge;
    }

    private PackageMenu setPkgPermMenu(String menuCode, Long pkgId) {
        PackageMenu pkgMenu = new PackageMenu();
        pkgMenu.setMenuCode(menuCode);
        pkgMenu.setCreateBy(Long.valueOf(-1L));
        pkgMenu.setUpdateBy(Long.valueOf(-1L));
        pkgMenu.setCreateTime(new Date());
        pkgMenu.setUpdateTime(new Date());
        pkgMenu.setIsDeleted(Integer.valueOf(0));
        pkgMenu.setPackageId(pkgId);
        return pkgMenu;
    }

    @Override
    @Transactional
    public void editPackage(PackageEditReqDto reqDto) {
        reqDto.validateParams();
        Package pkgPermission = this.packageMapper.queryPkgPermission(reqDto.getPackageId());
        if (pkgPermission == null) {
            log.info("editPackage not exist packageId:{}", (Object)reqDto.getPackageId());
            return;
        }
        this.packageMenuMapper.delMenus(reqDto.getPackageId());
        Package pge = this.setPkgPerm(reqDto);
        pge.setId(reqDto.getPackageId());
        this.packageMapper.updateByPrimaryKey((Object)pge);
        for (String menuCode : reqDto.getMenuCodes()) {
            PackageMenu pkgMenu = this.setPkgPermMenu(menuCode, reqDto.getPackageId());
            this.packageMenuMapper.insert((Object)pkgMenu);
        }
    }

    @Override
    @Transactional
    public void delPackage(PackageEditReqDto reqDto) {
        Long packageId = reqDto.getPackageId();
        Preconditions.checkArgument((boolean)Objects.nonNull(packageId), (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Package pkgPermission = this.packageMapper.queryPkgPermission(packageId);
        if (pkgPermission == null) {
            log.info("delPackage not exist packageId:{}", (Object)packageId);
            return;
        }
        this.packageMenuMapper.delMenus(packageId);
        this.packageMapper.delPkgPermission(packageId);
    }

    @Override
    public PackageRespDto packageInfo(PackageEditReqDto reqDto) {
        Long packageId = reqDto.getPackageId();
        Preconditions.checkArgument((boolean)Objects.nonNull(packageId), (Object)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Package pkgPermission = this.packageMapper.queryPkgPermission(packageId);
        if (pkgPermission == null) {
            return null;
        }
        PackageRespDto respDto = new PackageRespDto();
        respDto.setPackageId(packageId);
        respDto.setPackageName(pkgPermission.getName());
        respDto.setRemark(pkgPermission.getRemark());
        respDto.setSystemId(pkgPermission.getSystemId());
        respDto.setIsAppPkg(pkgPermission.getIsAppPkg());
        System systemMenu = this.systemMapper.queryById(pkgPermission.getSystemId());
        if (systemMenu != null) {
            respDto.setSystemName(systemMenu.getName());
        }
        List menus = this.packageMenuMapper.queryMenus(packageId);
        HashSet<String> codes = new HashSet<String>();
        for (PackageMenu m : menus) {
            codes.add(m.getMenuCode());
        }
        respDto.setMenuCodes(codes);
        log.info("packageInfo respDto:{}", (Object)respDto);
        return respDto;
    }

    @Override
    public PackageMenuRespDto packageMenuInfo(List<Long> packageIds) {
        if (CollectionUtils.isEmpty(packageIds)) {
            return null;
        }
        List menus = this.packageMenuMapper.queryAllMenus(packageIds);
        if (CollectionUtils.isEmpty((Collection)menus)) {
            return null;
        }
        PackageMenuRespDto respDto = new PackageMenuRespDto();
        Set<String> pkgMenus = menus.stream().map(PackageMenu::getMenuCode).collect(Collectors.toSet());
        log.info("packageMenuInfo : {}", pkgMenus);
        respDto.setMenuCodes(pkgMenus);
        return respDto;
    }
}

