/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import cn.kinyun.pay.business.dto.request.PayConfigGroupQuery;
import cn.kinyun.pay.business.dto.response.PayConfigGroupDto;
import cn.kinyun.pay.business.dto.response.PayConfigGroupDtoResp;
import cn.kinyun.pay.business.service.ScrmPayConfigService;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.IdDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.system.dto.request.BranchSchoolReqDto;
import com.kuaike.scrm.system.dto.request.OrgTypeCodeAddOrModeReqDto;
import com.kuaike.scrm.system.dto.request.ProvinceOfficeReqDto;
import com.kuaike.scrm.system.dto.request.SetPayGroupKeyReqDto;
import com.kuaike.scrm.system.dto.response.OrgTypeCodeRespDto;
import com.kuaike.scrm.system.dto.response.PayGroupInfoRespDto;
import com.kuaike.scrm.system.service.OrgSettingService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgSettingServiceImpl
implements OrgSettingService {
    private static final Logger log = LoggerFactory.getLogger(OrgSettingServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Resource
    private ScrmPayConfigService scrmPayConfigService;

    @Override
    public void addOrModOrgTypeCode(OrgTypeCodeAddOrModeReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("addOrgTypeCode,params:{}, operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        params.validateParams();
        String corpId = currentUserInfo.getCorpId();
        Organization organization = this.organizationMapper.selectByCorpIdAndId(corpId, params.getId());
        if (Objects.isNull(organization)) {
            log.warn("\u6839\u636e\u90e8\u95e8id:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)params.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u90e8\u95e8id\u503c\u4e0d\u5408\u6cd5");
        }
        List organizations = this.organizationMapper.selectByCorpIdAndOrgCode(corpId, params.getOrgCode());
        if (CollectionUtils.isNotEmpty((Collection)organizations)) {
            if (organizations.size() > 1) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u90e8\u95e8\u4ee3\u7801\u91cd\u590d");
            }
            if (organizations.size() == 1 && !((Organization)organizations.get(0)).getId().equals(organization.getId())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u90e8\u95e8\u4ee3\u7801\u91cd\u590d");
            }
        }
        organization.setOrgType(params.getOrgType());
        organization.setOrgCode(params.getOrgCode());
        organization.setUpdateBy(currentUserInfo.getId());
        organization.setUpdateTime(new Date());
        this.organizationMapper.updateByPrimaryKey((Object)organization);
    }

    @Override
    public OrgTypeCodeRespDto getOrgTypeCode(IdDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("getOrgTypeCode,params:{}, operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        Organization organization = this.organizationMapper.selectByCorpIdAndId(currentUserInfo.getCorpId(), params.getId());
        OrgTypeCodeRespDto respDto = new OrgTypeCodeRespDto();
        if (Objects.isNull(organization)) {
            log.warn("\u6839\u636ecorpId:{}, orgId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)currentUserInfo.getCorpId(), (Object)params.getId());
            return respDto;
        }
        respDto.setOrgType(organization.getOrgType());
        respDto.setOrgCode(organization.getOrgCode());
        return respDto;
    }

    @Override
    public List<IdAndNameDto> getBranchSchools(BranchSchoolReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        return this.organizationMapper.selectBranchSchoolByIds(currentUserInfo.getBizId(), reqDto.getBranchSchoolName());
    }

    @Override
    public List<IdAndNameDto> getProvinceOffice(ProvinceOfficeReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        return this.organizationMapper.selectProvinceOffice(currentUserInfo.getBizId(), reqDto.getProvinceName());
    }

    @Override
    public void setPayGroupKey(SetPayGroupKeyReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("org setPayGroupKey,params:{}, operatorId:{}", (Object)reqDto, (Object)currentUserInfo.getId());
        reqDto.validateParams();
        this.organizationMapper.updatePayGroupKeyById(reqDto.getPayGroupKey(), reqDto.getId());
    }

    @Override
    public PayGroupInfoRespDto getPayGroupKeyInfo(IdDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("getPayGroupKeyInfo,params:{}, operatorId:{}", (Object)reqDto, (Object)currentUserInfo.getId());
        reqDto.validateParams();
        Organization organization = (Organization)this.organizationMapper.selectByPrimaryKey((Object)reqDto.getId());
        if (organization == null) {
            log.info("\u6839\u636eorgId:{}\u672a\u67e5\u8be2\u5230organization", (Object)reqDto.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        PayGroupInfoRespDto payGroupInfoRespDto = null;
        if (StringUtils.isNotBlank((CharSequence)organization.getPayGroupKey())) {
            PayConfigGroupQuery payConfigGroupQuery = new PayConfigGroupQuery();
            payConfigGroupQuery.setCorpId(organization.getCorpId());
            payConfigGroupQuery.setGroupKeys(Collections.singletonList(organization.getPayGroupKey()));
            PayConfigGroupDtoResp payConfigGroupDto = this.scrmPayConfigService.queryConfigGroup(payConfigGroupQuery);
            if (Objects.nonNull(payConfigGroupDto) && CollectionUtils.isNotEmpty((Collection)payConfigGroupDto.getList())) {
                payGroupInfoRespDto = new PayGroupInfoRespDto();
                payGroupInfoRespDto.setPayGroupKey(organization.getPayGroupKey());
                payGroupInfoRespDto.setPayGroupName(((PayConfigGroupDto)payConfigGroupDto.getList().get(0)).getGroupName());
            }
        }
        return payGroupInfoRespDto;
    }
}

