/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.google.common.base.Joiner;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.system.entity.OrderFeedback;
import com.kuaike.scrm.dal.system.mapper.OrderFeedbackMapper;
import com.kuaike.scrm.system.dto.request.OrderFbReqDto;
import com.kuaike.scrm.system.service.OrderFbService;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderFbServiceImpl
implements OrderFbService {
    private static final Logger log = LoggerFactory.getLogger(OrderFbServiceImpl.class);
    @Autowired
    private OrderFeedbackMapper feedbackMapper;

    @Override
    public void saveFeedback(OrderFbReqDto reqDto) {
        OrderFeedback feedback;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("save feedback reqDto: {}, operateId: {}, bizId: {}", new Object[]{reqDto, userInfo.getId(), userInfo.getBizId()});
        reqDto.validate();
        String contentIds = "";
        if (CollectionUtils.isNotEmpty(reqDto.getFeedbackContentIds()) && reqDto.getFeedbackContentIds().size() > 0) {
            contentIds = Joiner.on((String)",").join(reqDto.getFeedbackContentIds());
        }
        if (Objects.nonNull(feedback = this.feedbackMapper.getFeedback(userInfo.getId(), userInfo.getBizId()))) {
            this.feedbackMapper.updateFeedback(reqDto.getFeedbackContent(), contentIds, userInfo.getId(), userInfo.getBizId());
        } else {
            feedback = new OrderFeedback();
            feedback.setBizId(userInfo.getBizId());
            feedback.setCorpId(userInfo.getCorpId());
            feedback.setFeedbackStatus(Long.valueOf(1L));
            feedback.setFeedbackContent(reqDto.getFeedbackContent());
            feedback.setContentIds(contentIds);
            feedback.setCreateTime(new Date());
            feedback.setCreateBy(userInfo.getId());
            this.feedbackMapper.insertSelective((Object)feedback);
        }
    }
}

