/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.ConversationArchiveStatusEnum;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.biz.dto.ConArchiveListDto;
import com.kuaike.scrm.dal.biz.dto.ConArchiveModDto;
import com.kuaike.scrm.dal.biz.entity.ConversationArchive;
import com.kuaike.scrm.dal.biz.mapper.ConversationArchiveMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.system.dto.request.ConversationArchiveAddReqDto;
import com.kuaike.scrm.system.dto.request.ConversationArchiveApplyReqDto;
import com.kuaike.scrm.system.dto.request.ConversationArchiveEditReqDto;
import com.kuaike.scrm.system.dto.request.ConversationArchiveListReqDto;
import com.kuaike.scrm.system.service.ConversationArchiveService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConversationArchiveServiceImpl
implements ConversationArchiveService {
    private static final Logger log = LoggerFactory.getLogger(ConversationArchiveServiceImpl.class);
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private ConversationArchiveMapper conversationArchiveMapper;

    @Override
    public void add(ConversationArchiveAddReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        reqDto.validate();
        ConversationArchive archive = new ConversationArchive();
        archive.setBizId(userInfo.getBizId());
        archive.setCorpId(reqDto.getCorpId());
        archive.setCorpName(reqDto.getCorpName());
        archive.setApplyName(reqDto.getApplyName());
        archive.setMobile(reqDto.getMobile());
        archive.setApplyCount(reqDto.getApplyCount());
        archive.setDealAmount(reqDto.getDealAmount());
        archive.setRemark(reqDto.getRemark());
        archive.setStatus(reqDto.getStatus());
        archive.setStatusDesc(ConversationArchiveStatusEnum.getEnumBy((int)reqDto.getStatus()).getName());
        archive.setAttachments(reqDto.getAttachments());
        archive.setRealOpenCount(reqDto.getRealOpenCount());
        archive.setCreatorId(userInfo.getId());
        archive.setCreateTime(new Date());
        archive.setUpdateTime(new Date());
        archive.setUserId(userInfo.getId());
        this.conversationArchiveMapper.insertSelective((Object)archive);
    }

    @Override
    public void apply(ConversationArchiveApplyReqDto reqDto) {
        if (Objects.isNull(reqDto)) {
            log.info(" reqDto body is null");
            return;
        }
        Preconditions.checkArgument((boolean)Objects.nonNull(reqDto.getMobile()), (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)MobileUtils.isPhone((String)reqDto.getMobile()), (Object)"\u624b\u673a\u53f7\u4e0d\u5408\u6cd5");
        log.info("get mobile: {}", (Object)reqDto.getMobile());
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        WeworkCorp corp = this.weworkCorpMapper.getByCorpId(userInfo.getCorpId());
        if (Objects.nonNull(corp)) {
            ConversationArchive archive = new ConversationArchive();
            archive.setBizId(userInfo.getBizId());
            archive.setCorpId(userInfo.getCorpId());
            archive.setCorpName(corp.getCorpName());
            archive.setApplyName(userInfo.getName());
            archive.setMobile(reqDto.getMobile());
            archive.setStatus(Integer.valueOf(ConversationArchiveStatusEnum.CONFIRM.getId()));
            archive.setStatusDesc(ConversationArchiveStatusEnum.CONFIRM.getName());
            archive.setCreatorId(userInfo.getId());
            archive.setCreateTime(new Date());
            archive.setUpdateTime(new Date());
            archive.setUserId(userInfo.getId());
            this.conversationArchiveMapper.insertSelective((Object)archive);
        }
    }

    @Override
    public void edit(ConversationArchiveEditReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("get userID = #{}, and bizId = #{}, and corpId = #{}", new Object[]{userInfo.getId(), userInfo.getBizId(), userInfo.getCorpId()});
        reqDto.validate();
        ConArchiveModDto dto = new ConArchiveModDto(reqDto.getId(), reqDto.getApplyName(), reqDto.getStatus(), ConversationArchiveStatusEnum.getEnumBy((int)reqDto.getStatus()).getName(), reqDto.getApplyCount(), reqDto.getDealAmount(), reqDto.getRemark(), reqDto.getAttachments(), reqDto.getRealOpenCount(), userInfo.getId());
        this.conversationArchiveMapper.updateArchive(dto);
    }

    @Override
    public List<ConversationArchive> getList(ConversationArchiveListReqDto reqDto) {
        reqDto.validate();
        ConArchiveListDto dto = new ConArchiveListDto(reqDto.getCorpName(), reqDto.getMobile(), reqDto.getStatus(), reqDto.getStartTime(), reqDto.getEndTime());
        List archives = this.conversationArchiveMapper.getArchiveList(dto, reqDto.getPageDto());
        if (CollectionUtils.isEmpty((Collection)archives)) {
            log.warn("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)dto);
            return Collections.emptyList();
        }
        Integer count = this.conversationArchiveMapper.getCountByArchiveList(dto);
        reqDto.getPageDto().setCount(count);
        return archives;
    }
}

