/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.utils.EmailUtil;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.system.dto.request.NetSchoolUserModReqDto;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class UserModReqDto {
    private Long id;
    private String name;
    private String mobile;
    private Long nodeId;
    private String email;
    private Integer enable;
    private String identifier;
    private String directLeader;
    private List<Integer> netSchoolOrgIds;

    public void validateModeParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.id), (Object)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.name), (Object)"\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.mobile), (Object)"\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.nodeId), (Object)"\u6240\u5728\u90e8\u95e8\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)MobileUtils.isPhone((String)this.mobile), (Object)"\u624b\u673a\u53f7\u4e0d\u5408\u6cd5");
        if (StringUtils.isNotBlank((CharSequence)this.email)) {
            Preconditions.checkArgument((boolean)EmailUtil.isEmail((String)this.email), (Object)"\u90ae\u7bb1\u4e0d\u5408\u6cd5");
        }
    }

    public void validateEnableOrDisableParams() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.id), (Object)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.enable), (Object)"\u542f\u7528/\u7981\u7528\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((NumberUtils.INTEGER_ZERO.equals(this.enable) || NumberUtils.INTEGER_ONE.equals(this.enable) ? 1 : 0) != 0, (Object)"\u542f\u7528/\u7981\u7528\u53c2\u6570\u4e0d\u5408\u6cd5");
    }

    public NetSchoolUserModReqDto convertToNetSchoolUserModReqDto(Integer netSchoolUserId, Integer operatorId) {
        NetSchoolUserModReqDto modReqDto = new NetSchoolUserModReqDto();
        modReqDto.setNickname(this.name);
        modReqDto.setMobile(this.mobile);
        modReqDto.setId(netSchoolUserId);
        modReqDto.setUserId(operatorId);
        if (CollectionUtils.isNotEmpty(this.netSchoolOrgIds)) {
            String netSchoolOrgIdStr = String.join((CharSequence)",", (CharSequence[])this.netSchoolOrgIds.stream().map(Object::toString).toArray(String[]::new));
            modReqDto.setOrgs(netSchoolOrgIdStr);
        }
        return modReqDto;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getMobile() {
        return this.mobile;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public String getEmail() {
        return this.email;
    }

    public Integer getEnable() {
        return this.enable;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDirectLeader() {
        return this.directLeader;
    }

    public List<Integer> getNetSchoolOrgIds() {
        return this.netSchoolOrgIds;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setEnable(Integer enable) {
        this.enable = enable;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setDirectLeader(String directLeader) {
        this.directLeader = directLeader;
    }

    public void setNetSchoolOrgIds(List<Integer> netSchoolOrgIds) {
        this.netSchoolOrgIds = netSchoolOrgIds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserModReqDto)) {
            return false;
        }
        UserModReqDto other = (UserModReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$nodeId = this.getNodeId();
        Long other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
            return false;
        }
        Integer this$enable = this.getEnable();
        Integer other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$directLeader = this.getDirectLeader();
        String other$directLeader = other.getDirectLeader();
        if (this$directLeader == null ? other$directLeader != null : !this$directLeader.equals(other$directLeader)) {
            return false;
        }
        List<Integer> this$netSchoolOrgIds = this.getNetSchoolOrgIds();
        List<Integer> other$netSchoolOrgIds = other.getNetSchoolOrgIds();
        return !(this$netSchoolOrgIds == null ? other$netSchoolOrgIds != null : !((Object)this$netSchoolOrgIds).equals(other$netSchoolOrgIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserModReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        Integer $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $directLeader = this.getDirectLeader();
        result = result * 59 + ($directLeader == null ? 43 : $directLeader.hashCode());
        List<Integer> $netSchoolOrgIds = this.getNetSchoolOrgIds();
        result = result * 59 + ($netSchoolOrgIds == null ? 43 : ((Object)$netSchoolOrgIds).hashCode());
        return result;
    }

    public String toString() {
        return "UserModReqDto(id=" + this.getId() + ", name=" + this.getName() + ", mobile=" + this.getMobile() + ", nodeId=" + this.getNodeId() + ", email=" + this.getEmail() + ", enable=" + this.getEnable() + ", identifier=" + this.getIdentifier() + ", directLeader=" + this.getDirectLeader() + ", netSchoolOrgIds=" + this.getNetSchoolOrgIds() + ")";
    }
}

