/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.dto.BDataValueDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StrIdAndNameDto;
import com.kuaike.scrm.common.dto.UserRoleRespDto;
import com.kuaike.scrm.common.enums.HandleQyAccountType;
import com.kuaike.scrm.common.enums.WeworkActiveStatusEnum;
import com.kuaike.scrm.common.enums.WeworkAuthEnum;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.service.PersonQuickReplyCommonService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.dto.RoleQueryParams;
import com.kuaike.scrm.dal.permission.dto.UserQueryParams;
import com.kuaike.scrm.dal.permission.entity.Role;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.entity.UserCriteria;
import com.kuaike.scrm.dal.permission.entity.UserRole;
import com.kuaike.scrm.dal.permission.mapper.RoleMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartmentUser;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.system.dto.UserLeaderResp;
import com.kuaike.scrm.system.dto.request.HandleQyAccountReqDto;
import com.kuaike.scrm.system.dto.request.OpenQyAccountReqDto;
import com.kuaike.scrm.system.dto.request.RoleNodeReqDto;
import com.kuaike.scrm.system.dto.request.UserAddReqDto;
import com.kuaike.scrm.system.dto.request.UserListQuery;
import com.kuaike.scrm.system.dto.request.UserListReqDto;
import com.kuaike.scrm.system.dto.request.UserModReqDto;
import com.kuaike.scrm.system.dto.request.UserRoleReqDto;
import com.kuaike.scrm.system.dto.response.BizAccountRespDto;
import com.kuaike.scrm.system.dto.response.PersonalInfoRespDto;
import com.kuaike.scrm.system.dto.response.UserDto;
import com.kuaike.scrm.system.dto.response.UserRespDto;
import com.kuaike.scrm.system.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger log = LoggerFactory.getLogger(UserServiceImpl.class);
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private OrgService orgService;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private PersonQuickReplyCommonService personQuickReplyCommonService;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private ScrmBizService scrmBizService;
    @Resource
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;

    @Override
    public List<UserRespDto> list(UserListReqDto reqDto) {
        List weworkUsers;
        UserQueryParams userQueryParams;
        List users;
        Set posterityIds;
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("userList,reqDto:{}, bizId:{}, corpId:{}", new Object[]{reqDto, currentUserInfo.getBizId(), currentUserInfo.getCorpId()});
        reqDto.validateParams();
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        if (Objects.nonNull(reqDto.getRoleId())) {
            Set userIds = this.userRoleMapper.selectUserIdsByRoleIdAndBizId(reqDto.getRoleId(), currentUserInfo.getBizId());
            if (CollectionUtils.isEmpty((Collection)userIds)) {
                log.info("\u6839\u636e\u89d2\u8272id:{}\u672a\u67e5\u8be2\u5230\u7528\u6237", (Object)reqDto.getRoleId());
                return Collections.emptyList();
            }
            manageUserIds = Sets.intersection((Set)manageUserIds, (Set)userIds);
        }
        HashSet nodeIds = Sets.newHashSet();
        if (Objects.nonNull(reqDto.getNodeId())) {
            nodeIds.add(reqDto.getNodeId());
            posterityIds = this.nodeService.getPosterityIds(reqDto.getNodeId(), currentUserInfo.getBizId());
            if (CollectionUtils.isNotEmpty((Collection)posterityIds)) {
                nodeIds.addAll(posterityIds);
            }
        }
        if (CollectionUtils.isNotEmpty(reqDto.getNodeIds())) {
            nodeIds.addAll(reqDto.getNodeIds());
            posterityIds = this.nodeService.getPosterityIds(reqDto.getNodeIds(), currentUserInfo.getBizId());
            if (CollectionUtils.isNotEmpty((Collection)posterityIds)) {
                nodeIds.addAll(posterityIds);
            }
        }
        if (CollectionUtils.isNotEmpty(reqDto.getNodeNums())) {
            Map nodeMap = this.nodeService.getIdByNums(currentUserInfo.getBizId(), reqDto.getNodeNums());
            nodeIds.addAll(nodeMap.values());
        }
        if (CollectionUtils.isEmpty((Collection)(users = this.userMapper.queryUserByQueryParams(userQueryParams = this.buildUserQueryParams(reqDto, manageUserIds, nodeIds, currentUserInfo.getBizId()))))) {
            return Collections.emptyList();
        }
        int count = this.userMapper.getCountByQueryParams(userQueryParams);
        if (reqDto.getPageDto() != null) {
            reqDto.getPageDto().setCount(Integer.valueOf(count));
        }
        Set pagedUserIds = users.stream().map(User::getId).collect(Collectors.toSet());
        List roles = this.userRoleMapper.selectRolesByUserIdsAndBizId(pagedUserIds, currentUserInfo.getBizId());
        Map<Long, List<Role>> userId2RolesMap = null;
        if (CollectionUtils.isNotEmpty((Collection)roles)) {
            userId2RolesMap = roles.stream().collect(Collectors.groupingBy(Role::getUserId));
        }
        Set weworkUserIds = users.stream().map(User::getWeworkUserId).collect(Collectors.toSet());
        Map weworkUserId2ObjMap = null;
        if (CollectionUtils.isNotEmpty(weworkUserIds) && CollectionUtils.isNotEmpty((Collection)(weworkUsers = this.weworkUserMapper.selectByWeworkUserIdsAndCorpId(weworkUserIds, currentUserInfo.getCorpId())))) {
            weworkUserId2ObjMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, Functions.identity()));
        }
        Map nodeMap = this.nodeService.getNodeMap(currentUserInfo.getBizId());
        return this.buildUserList(users, userId2RolesMap, weworkUserId2ObjMap, nodeMap, currentUserInfo.getBizId());
    }

    @Override
    public void add(UserAddReqDto reqDto) {
        WeworkUser weworkUser;
        int count;
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("addUser,reqDto:{}, operatorId:{}", (Object)reqDto, (Object)currentUserInfo.getId());
        reqDto.validateParams();
        String corpId = currentUserInfo.getCorpId();
        String mobile = reqDto.getMobile();
        User oldUser = this.userMapper.selectUserByMobileAndCorpId(mobile, corpId);
        log.info("\u6839\u636ecorpId:{}, mobile:{}\u83b7\u53d6\u5230\u7684oldUser:{}", new Object[]{corpId, mobile, oldUser});
        boolean isOldUserIdentifier = false;
        if (Objects.nonNull(oldUser)) {
            if (NumberUtils.INTEGER_ONE.equals(oldUser.getIsDeleted())) {
                oldUser.setIsDeleted(NumberUtils.INTEGER_ZERO);
                oldUser.setName(reqDto.getName());
                oldUser.setEmail(reqDto.getEmail());
                oldUser.setNodeId(reqDto.getNodeId());
                if (StringUtils.isNotBlank((CharSequence)reqDto.getIdentifier())) {
                    if (oldUser.getIdentifier().equals(reqDto.getIdentifier())) {
                        isOldUserIdentifier = true;
                    }
                    oldUser.setIdentifier(reqDto.getIdentifier());
                }
            } else {
                log.info("\u624b\u673a\u53f7:{}\u5df2\u88ab\u7528\u6237:{}\u4f7f\u7528", (Object)mobile, (Object)oldUser.getId());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u624b\u673a\u53f7\u91cd\u590d,\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4");
            }
        }
        if (!isOldUserIdentifier && StringUtils.isNotBlank((CharSequence)reqDto.getIdentifier()) && (count = this.userMapper.userIdentifierCount(currentUserInfo.getBizId(), reqDto.getIdentifier()).intValue()) > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7528\u6237\u552f\u4e00\u6807\u8bc6\u5df2\u88ab\u4f7f\u7528");
        }
        boolean isExist = this.organizationMapper.checkNodeIsExist(reqDto.getNodeId(), corpId);
        if (!isExist) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u9009\u62e9\u7684\u90e8\u95e8\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDirectLeader()) && Objects.isNull(weworkUser = this.weworkUserMapper.queryWeworkUserByNum(reqDto.getDirectLeader()))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u9009\u62e9\u7684\u90e8\u95e8\u9886\u5bfc\u4eba\u4e0d\u662f\u4f01\u5fae\u6210\u5458");
        }
        try {
            if (Objects.nonNull(oldUser)) {
                this.userMapper.updateByPrimaryKey((Object)oldUser);
            } else {
                User user = this.buildUser(reqDto, currentUserInfo);
                this.userMapper.insert((Object)user);
            }
            this.personQuickReplyCommonService.initDefaultPersonQuickReply(currentUserInfo.getBizId(), currentUserInfo.getCorpId(), currentUserInfo.getId());
        }
        catch (Exception ex) {
            log.error("\u65b0\u589e\u7528\u6237\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65b0\u589e\u7528\u6237\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public void mod(UserModReqDto reqDto) {
        int count;
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("modUser,reqDto:{}, operatorId:{}, bizId:{}, corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), currentUserInfo.getBizId(), currentUserInfo.getCorpId()});
        reqDto.validateModeParams();
        User user = this.userMapper.selectUserByIdAndCorpId(reqDto.getId(), currentUserInfo.getCorpId());
        if (Objects.isNull(user)) {
            log.warn("\u6839\u636euserId:{},corpId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)reqDto.getId(), (Object)currentUserInfo.getCorpId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7528\u6237id\u4e0d\u5408\u6cd5");
        }
        User us = this.userMapper.selectUserByMobileAndCorpId(reqDto.getMobile(), currentUserInfo.getCorpId());
        if (Objects.nonNull(us) && !us.getId().equals(user.getId())) {
            log.warn("\u624b\u673a\u53f7:{}\u5728\u7cfb\u7edf\u4e2d\u5df2\u88ab\u7528\u6237:{}\u4f7f\u7528", (Object)reqDto.getMobile(), (Object)us.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4fee\u6539\u540e\u7684\u624b\u673a\u53f7\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728");
        }
        boolean isExist = this.organizationMapper.checkNodeIsExist(reqDto.getNodeId(), currentUserInfo.getCorpId());
        if (!isExist) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u9009\u62e9\u7684\u90e8\u95e8\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getIdentifier()) && !user.getIdentifier().equals(reqDto.getIdentifier()) && (count = this.userMapper.userIdentifierCount(currentUserInfo.getBizId(), reqDto.getIdentifier()).intValue()) > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7528\u6237\u552f\u4e00\u6807\u8bc6\u5df2\u88ab\u4f7f\u7528");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDirectLeader())) {
            WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(reqDto.getDirectLeader());
            if (Objects.isNull(weworkUser)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u60a8\u9009\u62e9\u7684\u76f4\u63a5\u9886\u5bfc\u4eba\u4e0d\u662f\u4f01\u5fae\u6210\u5458");
            }
            user.setDirectLeader(reqDto.getDirectLeader());
        }
        user.setName(reqDto.getName());
        user.setMobile(reqDto.getMobile());
        user.setNodeId(reqDto.getNodeId());
        user.setEmail(reqDto.getEmail());
        user.setUpdateBy(currentUserInfo.getId());
        user.setUpdateTime(new Date());
        if (StringUtils.isNotBlank((CharSequence)reqDto.getIdentifier())) {
            user.setIdentifier(reqDto.getIdentifier());
        }
        this.userMapper.updateByPrimaryKey((Object)user);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setRoles(UserRoleReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("setRoles,reqDto:{}, operatorId:{}", (Object)reqDto, (Object)currentUserInfo.getId());
        reqDto.validate();
        User user = (User)this.userMapper.selectByPrimaryKey((Object)reqDto.getUserId());
        this.validateUser(user, currentUserInfo, reqDto.getUserId());
        Set<Long> roleIds = reqDto.getRoles().stream().map(RoleNodeReqDto::getRoleId).collect(Collectors.toSet());
        List roles = this.roleMapper.selectByIds(roleIds, currentUserInfo.getBizId(), currentUserInfo.getCorpId());
        this.validateRoles(roleIds, roles);
        this.userRoleMapper.deleteByUserId(reqDto.getUserId(), currentUserInfo.getBizId(), currentUserInfo.getCorpId());
        List<UserRole> userRoleList = reqDto.to(currentUserInfo);
        if (CollectionUtils.isNotEmpty(userRoleList)) {
            this.userRoleMapper.insertBatch(userRoleList);
        }
    }

    @Override
    public List<UserRoleRespDto> userRoleDetail(UserRoleReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("userRoleDetail,reqDto:{}, operatorId:{}, bizId:{}, corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), currentUserInfo.getBizId(), currentUserInfo.getCorpId()});
        Preconditions.checkArgument((boolean)Objects.nonNull(reqDto.getUserId()), (Object)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        UserRole userRole = new UserRole();
        userRole.setUserId(reqDto.getUserId());
        userRole.setIsDeleted(NumberUtils.INTEGER_ZERO);
        List userRoles = this.userRoleMapper.select((Object)userRole);
        if (CollectionUtils.isEmpty((Collection)userRoles)) {
            return Lists.newArrayList();
        }
        Map roleNodeMap = userRoles.stream().filter(a -> a.getManageNodeId() != null).collect(Collectors.groupingBy(UserRole::getRoleId, Collectors.mapping(UserRole::getManageNodeId, Collectors.toSet())));
        List roleIds = userRoles.stream().map(UserRole::getRoleId).collect(Collectors.toList());
        RoleQueryParams queryParam = new RoleQueryParams();
        queryParam.setIds(roleIds);
        queryParam.setCorpId(currentUserInfo.getCorpId());
        queryParam.setBizId(currentUserInfo.getBizId());
        Map roleMap = this.roleMapper.queryList(queryParam).stream().collect(Collectors.toMap(Role::getId, Function.identity()));
        ArrayList result = Lists.newArrayList();
        for (Map.Entry entry : roleMap.entrySet()) {
            List nodes;
            Role role = (Role)entry.getValue();
            if (role == null) continue;
            UserRoleRespDto dto = new UserRoleRespDto();
            dto.setRoleId(role.getId());
            dto.setRoleName(role.getName());
            dto.setRoleType(role.getType());
            Set manageNodeIds = (Set)MapUtils.getObject(roleNodeMap, (Object)role.getId());
            ArrayList manageNodes = new ArrayList();
            if (CollectionUtils.isNotEmpty((Collection)manageNodeIds) && CollectionUtils.isNotEmpty((Collection)(nodes = this.orgService.getNodeWithoutChildren(currentUserInfo.getBizId(), (Collection)manageNodeIds)))) {
                manageNodes.addAll(nodes);
            }
            dto.setManageNodes(manageNodes);
            dto.setManageNodeIds(manageNodeIds);
            result.add(dto);
        }
        return result;
    }

    @Override
    public Map<Long, String> getUserIdAndNameByUserIds(Set<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            log.warn("userIds\u4e3a\u7a7a");
            return Maps.newHashMap();
        }
        List users = this.userMapper.getUserInfoByIds(userIds);
        if (CollectionUtils.isEmpty((Collection)users)) {
            log.warn("\u6839\u636euserIds:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", userIds);
            return Maps.newHashMap();
        }
        HashMap id2NameMap = Maps.newHashMap();
        for (User user : users) {
            id2NameMap.put(user.getId(), user.getName());
        }
        return id2NameMap;
    }

    @Override
    public void enableOrDisable(UserModReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("enableOrDisable,reqDto:{},operatorId:{}", (Object)reqDto, (Object)currentUserInfo.getId());
        reqDto.validateEnableOrDisableParams();
        User user = this.userMapper.selectUserByIdAndCorpId(reqDto.getId(), currentUserInfo.getCorpId());
        if (Objects.isNull(user)) {
            log.warn("enableOrDisable,\u5165\u53c2userId:{}\u4e0d\u5408\u6cd5", (Object)reqDto.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7528\u6237id\u4e0d\u5408\u6cd5");
        }
        user.setEnabled(reqDto.getEnable());
        user.setUpdateBy(currentUserInfo.getId());
        user.setUpdateTime(new Date());
        this.userMapper.updateByPrimaryKey((Object)user);
    }

    @Override
    public PersonalInfoRespDto personalInfo() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        User user = (User)this.userMapper.selectByPrimaryKey((Object)currentUserInfo.getId());
        WeworkUser weworkUser = null;
        WeworkCorp weworkCorp = this.weworkCorpMapper.getByCorpId(user.getCorpId());
        if (StringUtils.isNotBlank((CharSequence)user.getWeworkUserId())) {
            weworkUser = this.weworkUserMapper.selectByWeworkUserIdAndCorpId(user.getWeworkUserId(), user.getCorpId());
        }
        PersonalInfoRespDto personalInfoRespDto = new PersonalInfoRespDto();
        if (Objects.nonNull(weworkUser) && StringUtils.isNotBlank((CharSequence)weworkUser.getName())) {
            personalInfoRespDto.setName(weworkUser.getName());
        } else {
            personalInfoRespDto.setName(user.getName());
        }
        personalInfoRespDto.setLastLoginDate(user.getLastLoginDate());
        if (Objects.nonNull(weworkUser)) {
            personalInfoRespDto.setAvatar(weworkUser.getAvatar());
        }
        if (Objects.nonNull(weworkCorp)) {
            personalInfoRespDto.setCorpName(weworkCorp.getCorpName());
            personalInfoRespDto.setCorpFullName(weworkCorp.getCorpFullName());
            personalInfoRespDto.setLocation(weworkCorp.getLocation());
            String corpIndustry = weworkCorp.getCorpIndustry();
            corpIndustry = StringUtils.isNotBlank((CharSequence)corpIndustry) ? corpIndustry + "-" + weworkCorp.getCorpSubIndustry() : weworkCorp.getCorpSubIndustry();
            personalInfoRespDto.setCorpIndustry(corpIndustry);
            personalInfoRespDto.setCorpScale(weworkCorp.getCorpScale());
            personalInfoRespDto.setCorpId(weworkCorp.getCorpId());
            personalInfoRespDto.setCreateTime(weworkCorp.getAuthTime());
        }
        return personalInfoRespDto;
    }

    private UserQueryParams buildUserQueryParams(UserListReqDto reqDto, Set<Long> manageUserIds, Set<Long> nodeIds, Long bizId) {
        UserQueryParams userQueryParams = new UserQueryParams();
        userQueryParams.setNodeIds(nodeIds);
        userQueryParams.setUserIds(manageUserIds);
        userQueryParams.setBizId(bizId);
        userQueryParams.setQuery(reqDto.getQuery());
        if (reqDto.getPageDto() != null) {
            userQueryParams.setOffset(Integer.valueOf((reqDto.getPageDto().getPageNum() - 1) * reqDto.getPageDto().getPageSize()));
            userQueryParams.setPageSize(reqDto.getPageDto().getPageSize());
        }
        userQueryParams.setIsOpen(reqDto.getIsOpen());
        userQueryParams.setIsCallMember(reqDto.getIsCallMember());
        return userQueryParams;
    }

    private List<UserRespDto> buildUserList(List<User> users, Map<Long, List<Role>> userId2RolesMap, Map<String, WeworkUser> weworkUserId2ObjMap, Map<Long, Node> nodeMap, Long bizId) {
        ArrayList userRespDtos = Lists.newArrayListWithExpectedSize((int)users.size());
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(businessCustomer.getId());
        int isOpenTrade = 0;
        if (Objects.nonNull(bizSimpleDto)) {
            isOpenTrade = bizSimpleDto.getIsOpenTrade();
        }
        for (User user : users) {
            UserRespDto userRespDto = new UserRespDto();
            userRespDtos.add(userRespDto);
            userRespDto.setId(user.getId());
            userRespDto.setNum(user.getNum());
            userRespDto.setName(user.getName());
            userRespDto.setMobile(user.getMobile());
            userRespDto.setEmail(user.getEmail());
            userRespDto.setEnable(user.getEnabled());
            userRespDto.setIdentifier(user.getIdentifier());
            if (MapUtils.isNotEmpty(userId2RolesMap) && userId2RolesMap.containsKey(user.getId())) {
                userRespDto.setRoleNames(userId2RolesMap.get(user.getId()).stream().map(Role::getName).collect(Collectors.toSet()));
            }
            if (MapUtils.isNotEmpty(weworkUserId2ObjMap) && weworkUserId2ObjMap.containsKey(user.getWeworkUserId())) {
                WeworkUser weworkUser = weworkUserId2ObjMap.get(user.getWeworkUserId());
                userRespDto.setWeworkUserId(weworkUser.getWeworkUserId());
                userRespDto.setName(weworkUser.getName());
                userRespDto.setAvatar(weworkUser.getAvatar());
                if (Objects.nonNull(weworkUser.getStatus())) {
                    userRespDto.setActiveStatus(weworkUser.getStatus());
                    userRespDto.setActiveStatusDesc(WeworkActiveStatusEnum.get((Integer)weworkUser.getStatus()) == null ? "" : WeworkActiveStatusEnum.get((Integer)weworkUser.getStatus()).getDesc());
                }
                if (Objects.nonNull(weworkUser.getIsAgentAuth())) {
                    userRespDto.setAuthStatus(weworkUser.getIsAgentAuth());
                    userRespDto.setAuthStatusDesc(WeworkAuthEnum.get((int)weworkUser.getIsAgentAuth()) == null ? "" : WeworkAuthEnum.get((int)weworkUser.getIsAgentAuth()).getDesc());
                }
            }
            ArrayList nodes = Lists.newArrayList();
            this.getAllNode(nodes, nodeMap, user.getNodeId());
            Collections.reverse(nodes);
            if (CollectionUtils.isNotEmpty((Collection)nodes)) {
                userRespDto.setNodes(nodes);
            }
            if (Objects.nonNull(user.getWeworkUserId()) && user.getWeworkUserId().equals(businessCustomer.getApplyWeworkUserId())) {
                userRespDto.setIsApplyUser(NumberUtils.INTEGER_ONE);
            }
            userRespDto.setIsOpen(user.getIsOpen());
            userRespDto.setIsOpenTrade(isOpenTrade);
            userRespDto.setIsDeptLeader(null);
            userRespDto.setDirectLeader(user.getDirectLeader());
        }
        return userRespDtos;
    }

    private User buildUser(UserAddReqDto reqDto, CurrentUserInfo currentUserInfo) {
        User user = new User();
        user.setBizId(currentUserInfo.getBizId());
        user.setName(reqDto.getName());
        user.setMobile(reqDto.getMobile());
        user.setNodeId(reqDto.getNodeId());
        user.setIsDeleted(NumberUtils.INTEGER_ZERO);
        user.setCreateBy(currentUserInfo.getId());
        user.setUpdateBy(currentUserInfo.getId());
        user.setCreateTime(new Date());
        user.setUpdateTime(new Date());
        user.setIsSystem(NumberUtils.INTEGER_ZERO);
        user.setNum(this.idGen.getNum());
        user.setCorpId(currentUserInfo.getCorpId());
        user.setEmail(reqDto.getEmail());
        user.setEnabled(NumberUtils.INTEGER_ONE);
        user.setIsOpen(NumberUtils.INTEGER_ZERO);
        user.setDirectLeader(reqDto.getDirectLeader());
        if (StringUtils.isBlank((CharSequence)reqDto.getIdentifier())) {
            user.setIdentifier(reqDto.getMobile());
        } else {
            user.setIdentifier(reqDto.getIdentifier());
        }
        return user;
    }

    private CurrentUserInfo baseValidate() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u5546\u6237id\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u7a7a");
        return currentUserInfo;
    }

    private void validateUser(User user, CurrentUserInfo currentUserInfo, Long userId) {
        if (Objects.isNull(user)) {
            log.warn("\u6839\u636e\u7528\u6237id:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)userId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7528\u6237id\u4e0d\u5408\u6cd5");
        }
        if (!user.getBizId().equals(currentUserInfo.getBizId()) || !user.getCorpId().equals(currentUserInfo.getCorpId())) {
            log.warn("\u8981\u914d\u7f6e\u89d2\u8272\u7684\u7528\u6237\u8ddf\u5f53\u524d\u64cd\u4f5c\u4eba\u4e0d\u662f\u540c\u4e00\u4e2a\u5546\u6237");
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7528\u6237id\u4e0d\u5408\u6cd5");
        }
    }

    private void validateRoles(Set<Long> roleIds, List<Role> roles) {
        if (CollectionUtils.isEmpty(roles) && CollectionUtils.isNotEmpty(roleIds)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u89d2\u8272id\u4e0d\u5408\u6cd5");
        }
        Set backendRoleIds = roles.stream().map(Role::getId).collect(Collectors.toSet());
        if (!roleIds.equals(backendRoleIds)) {
            log.warn("\u4f20\u5165\u7684\u89d2\u8272ids:{},\u8868\u4e2d\u8bb0\u5f55\u7684\u89d2\u8272ids:{}\u4e0d\u4e00\u81f4", roleIds, backendRoleIds);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u89d2\u8272id\u4e0d\u5408\u6cd5");
        }
    }

    private void getAllNode(List<IdAndNameDto> nodes, Map<Long, Node> nodeMap, Long nodeId) {
        if (MapUtils.isNotEmpty(nodeMap) && nodeMap.containsKey(nodeId)) {
            IdAndNameDto idAndNameDto = new IdAndNameDto();
            nodes.add(idAndNameDto);
            Node node = nodeMap.get(nodeId);
            idAndNameDto.setId(Long.valueOf(node.getId()));
            idAndNameDto.setName(node.getName());
            this.getAllNode(nodes, nodeMap, node.getPid());
        }
    }

    @Override
    public Map<Long, User> queryUserMap(Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Maps.newHashMap();
        }
        UserCriteria criteria = new UserCriteria();
        criteria.createCriteria().andIdIn((List)Lists.newArrayList(userIds));
        List users = this.userMapper.selectByExample((Object)criteria);
        return users.stream().collect(Collectors.toMap(User::getId, Function.identity()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public User insertUser(WeworkUser weworkUser, boolean isOpen) {
        User user = null;
        if (StringUtils.isNotBlank((CharSequence)weworkUser.getMobile()) && (user = this.userMapper.selectUserByMobileAndCorpId(weworkUser.getMobile(), weworkUser.getCorpId())) != null) {
            log.info("find user by corpId={}, mobile={}", (Object)user.getCorpId(), (Object)user.getMobile());
        }
        if (user == null && (user = this.userMapper.selectUserByWeworkUserIdAndCorpId(weworkUser.getWeworkUserId(), weworkUser.getCorpId())) != null) {
            log.info("find user by corpId={}, weworkUserId={}", (Object)user.getCorpId(), (Object)user.getWeworkUserId());
        }
        if (Objects.nonNull(user)) {
            if (StringUtils.isBlank((CharSequence)user.getWeworkUserId())) {
                user.setUpdateTime(new Date());
                user.setWeworkUserId(weworkUser.getWeworkUserId());
                user.setIdentifier(weworkUser.getWeworkUserId());
                user.setIsDeleted(NumberUtils.INTEGER_ZERO);
                this.userMapper.updateByPrimaryKey((Object)user);
                return user;
            }
            if (weworkUser.getWeworkUserId().equals(user.getWeworkUserId())) {
                if (NumberUtils.INTEGER_ONE.equals(user.getIsDeleted())) {
                    user.setIsDeleted(NumberUtils.INTEGER_ZERO);
                    user.setUpdateTime(new Date());
                    this.userMapper.updateByPrimaryKey((Object)user);
                }
            } else {
                user.setIsDeleted(NumberUtils.INTEGER_ZERO);
                user.setUpdateTime(new Date());
                user.setWeworkUserId(weworkUser.getWeworkUserId());
                user.setIdentifier(weworkUser.getWeworkUserId());
                this.userMapper.updateByPrimaryKey((Object)user);
            }
            return user;
        }
        String num = this.idGen.getNum();
        Date now = new Date();
        User user1 = new User();
        user1.setNum(num);
        user1.setBizId(weworkUser.getBizId());
        user1.setCorpId(weworkUser.getCorpId());
        user1.setWeworkUserId(weworkUser.getWeworkUserId());
        user1.setName(weworkUser.getName());
        user1.setAvatar(weworkUser.getAvatar());
        if (StringUtils.isNotBlank((CharSequence)weworkUser.getMobile())) {
            user1.setMobile(weworkUser.getMobile());
        }
        if (StringUtils.isNotBlank((CharSequence)weworkUser.getEmail())) {
            user1.setEmail(weworkUser.getEmail());
        }
        user1.setEnabled(Integer.valueOf(1));
        user1.setIsSystem(Integer.valueOf(0));
        user1.setCreateBy(Long.valueOf(-1L));
        user1.setCreateTime(now);
        user1.setUpdateBy(Long.valueOf(-1L));
        user1.setUpdateTime(now);
        user1.setIdentifier(weworkUser.getWeworkUserId());
        Long rootNodeId = this.organizationMapper.selectRootNodeIdByBizIdAndCorpId(weworkUser.getBizId(), weworkUser.getCorpId());
        if (Objects.isNull(weworkUser.getMainDepartment())) {
            user1.setNodeId(rootNodeId);
        } else {
            Long mainNodeId = this.organizationMapper.selectNodeIdByCorpIdAndWeworkDepartmentId(weworkUser.getCorpId(), weworkUser.getMainDepartment());
            if (Objects.nonNull(mainNodeId)) {
                user1.setNodeId(mainNodeId);
            } else {
                user1.setNodeId(rootNodeId);
            }
        }
        user1.setIsOpen(NumberUtils.INTEGER_ZERO);
        BusinessCustomer biz = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)weworkUser.getBizId());
        boolean isAdmin = biz.getApplyWeworkUserId().equals(weworkUser.getAuthUserId());
        log.info("insertUser: biz:{}, isOpen:{},isAdmin:{}", new Object[]{biz, isOpen, isAdmin});
        if (isOpen || isAdmin) {
            user1.setIsOpen(NumberUtils.INTEGER_ONE);
        }
        this.userMapper.insertSelective((Object)user1);
        return user1;
    }

    @Override
    public BizAccountRespDto queryBizAccount() {
        CurrentUserInfo currentUserInfo = this.baseValidate();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("queryBizAccount: bizId:{}, corpId:{}", (Object)bizId, (Object)corpId);
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        List openIds = this.userMapper.queryOpenUserIdList(bizId);
        BizAccountRespDto respDto = new BizAccountRespDto();
        respDto.setOpenTotalCount(businessCustomer.getNumCount());
        respDto.setOpenAccounts(openIds);
        return respDto;
    }

    @Override
    public void openQyAccount(OpenQyAccountReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.baseValidate();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        Long userInfoId = currentUserInfo.getId();
        String weworkUserId = currentUserInfo.getWeworkUserId();
        log.info("openQyAccount, reqDto:{}, bizId:{}, corpId:{}, userInfoId:{}, weworkUserId:{}", new Object[]{reqDto, bizId, corpId, userInfoId, weworkUserId});
        reqDto.validate();
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        List<Long> userIds = reqDto.getIds();
        Integer openTotalCount = businessCustomer.getNumCount();
        int size = userIds.size();
        log.info("openQyAccount: openTotalCount:{}, size:{} ", (Object)openTotalCount, (Object)size);
        if (Objects.nonNull(openTotalCount)) {
            Preconditions.checkArgument((openTotalCount >= size ? 1 : 0) != 0, (Object)"\u60a8\u5f53\u524d\u52fe\u9009\u7684\u7528\u6237\u6570\u8d85\u51fa\u4f01\u4e1a\u7684\u6700\u5927\u5141\u8bb8\u4e0a\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
        }
        List existUserIds = this.userMapper.queryUserIdByBizId(bizId);
        if (CollectionUtils.isNotEmpty(userIds) && CollectionUtils.isNotEmpty((Collection)existUserIds)) {
            for (Long userId : userIds) {
                existUserIds.remove(userId);
            }
        }
        log.info("openQyAccount: bizId:{}, userIds:{}, existUserIds:{}", new Object[]{bizId, userIds, existUserIds});
        if (CollectionUtils.isNotEmpty(userIds)) {
            this.userMapper.updateAccountOpen(corpId, userInfoId, userIds);
        }
        if (CollectionUtils.isNotEmpty((Collection)existUserIds)) {
            this.userMapper.updateAccountClose(corpId, userInfoId, (Collection)existUserIds);
        }
    }

    @Override
    public void handleQyAccount(HandleQyAccountReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.baseValidate();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        Long userInfoId = currentUserInfo.getId();
        String weworkUserId = currentUserInfo.getWeworkUserId();
        log.info("handleQyAccount, reqDto:{}, bizId:{}, corpId:{}, userInfoId:{}, weworkUserId:{}", new Object[]{reqDto, bizId, corpId, userInfoId, weworkUserId});
        reqDto.validate();
        List<Long> userIds = reqDto.getIds();
        HandleQyAccountType accountType = HandleQyAccountType.get((int)reqDto.getType());
        if (HandleQyAccountType.OPEN.equals((Object)accountType)) {
            BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
            Integer openTotalCount = businessCustomer.getNumCount();
            List openIds = this.userMapper.queryOpenUserIdList(bizId);
            HashSet<Long> unionIds = new HashSet<Long>();
            unionIds.addAll(userIds);
            unionIds.addAll(openIds);
            int size = unionIds.size();
            log.info("handleQyAccount: openTotalCount:{}, size:{}, userIds.size:{}, openIds.size:{} ", new Object[]{openTotalCount, size, userIds.size(), openIds.size()});
            if (Objects.nonNull(openTotalCount)) {
                Preconditions.checkArgument((openTotalCount >= size ? 1 : 0) != 0, (Object)"\u60a8\u5f53\u524d\u52fe\u9009\u7684\u7528\u6237\u6570\u8d85\u51fa\u4f01\u4e1a\u7684\u6700\u5927\u5141\u8bb8\u4e0a\u9650\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01");
            }
        }
        switch (accountType) {
            case CLOSE: {
                this.userMapper.updateAccountClose(corpId, userInfoId, userIds);
                break;
            }
            case OPEN: {
                this.userMapper.updateAccountOpen(corpId, userInfoId, userIds);
                break;
            }
        }
    }

    @Override
    public List<UserDto> getUserList(UserListQuery reqDto) {
        List weworkUsers;
        CurrentUserInfo userInfo = this.baseValidate();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        log.info("getUserList,reqDto:{}, bizId:{}, corpId:{}", new Object[]{reqDto, bizId, corpId});
        UserListReqDto params = new UserListReqDto();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getNodeId())) {
            Long orgId = this.organizationMapper.getIdByNum(bizId, reqDto.getNodeId());
            params.setNodeId(orgId);
        }
        params.setRoleId(reqDto.getRoleId());
        params.setIsOpen(reqDto.getIsOpen());
        params.setIsCallMember(reqDto.getIsCallMember());
        params.setQuery(reqDto.getQuery());
        params.setPageDto(reqDto.getPageDto());
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        if (Objects.nonNull(reqDto.getRoleId())) {
            Set userIds = this.userRoleMapper.selectUserIdsByRoleIdAndBizId(reqDto.getRoleId(), bizId);
            if (CollectionUtils.isEmpty((Collection)userIds)) {
                log.info("\u6839\u636e\u89d2\u8272id:{}\u672a\u67e5\u8be2\u5230\u7528\u6237", (Object)reqDto.getRoleId());
                return Collections.emptyList();
            }
            manageUserIds = Sets.intersection((Set)manageUserIds, (Set)userIds);
        }
        HashSet nodeIds = null;
        if (Objects.nonNull(reqDto.getNodeId())) {
            nodeIds = Sets.newHashSet();
            nodeIds.add(params.getNodeId());
        }
        UserQueryParams userQueryParams = this.buildUserQueryParams(params, manageUserIds, nodeIds, bizId);
        userQueryParams.setNeedPermissionControl(reqDto.getNeedPermissionControl());
        List users = this.userMapper.queryUserByQueryParams(userQueryParams);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return Collections.emptyList();
        }
        int count = this.userMapper.getCountByQueryParams(userQueryParams);
        if (reqDto.getPageDto() != null) {
            reqDto.getPageDto().setCount(Integer.valueOf(count));
        }
        Set pagedUserIds = users.stream().map(User::getId).collect(Collectors.toSet());
        List roles = this.userRoleMapper.selectRolesByUserIdsAndBizId(pagedUserIds, bizId);
        Map<Long, List<Role>> userId2RolesMap = null;
        if (CollectionUtils.isNotEmpty((Collection)roles)) {
            userId2RolesMap = roles.stream().collect(Collectors.groupingBy(Role::getUserId));
        }
        Set weworkUserIds = users.stream().map(User::getWeworkUserId).collect(Collectors.toSet());
        Map weworkUserId2ObjMap = null;
        if (CollectionUtils.isNotEmpty(weworkUserIds) && CollectionUtils.isNotEmpty((Collection)(weworkUsers = this.weworkUserMapper.selectByWeworkUserIdsAndCorpId(weworkUserIds, corpId)))) {
            weworkUserId2ObjMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getWeworkUserId, Functions.identity()));
        }
        Map nodeMap = this.nodeService.getNodeMap(bizId);
        List<UserRespDto> list = this.buildUserList(users, userId2RolesMap, weworkUserId2ObjMap, nodeMap, bizId);
        HashSet nodeSetIds = Sets.newHashSet();
        for (UserRespDto userRespDto : list) {
            if (!CollectionUtils.isNotEmpty(userRespDto.getNodes())) continue;
            nodeSetIds.addAll(userRespDto.getNodes().stream().map(it -> it.getId()).collect(Collectors.toSet()));
        }
        Map nodeIdNumMap = this.nodeService.getNumByIds(bizId, (Collection)nodeSetIds);
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (UserRespDto userRespDto : list) {
            UserDto userDto = (UserDto)BeanUtil.convert((Object)userRespDto, UserDto.class, (String[])new String[]{"id", "nodes"});
            userDto.setId(userRespDto.getNum());
            if (!CollectionUtils.isNotEmpty(userRespDto.getNodes())) continue;
            ArrayList nodes = Lists.newArrayListWithCapacity((int)userRespDto.getNodes().size());
            for (IdAndNameDto idAndNameDto : userRespDto.getNodes()) {
                StrIdAndNameDto dto = new StrIdAndNameDto();
                dto.setName(idAndNameDto.getName());
                dto.setId((String)nodeIdNumMap.get(idAndNameDto.getId()));
                nodes.add(dto);
            }
            userDto.setNodes(nodes);
            result.add(userDto);
        }
        return result;
    }

    public List<BDataValueDto> getBDataOption(String query, PageDto pageDto) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("query user list, bizId={}, userId={}, query={}, pageDto={}", new Object[]{bizId, userId, query, pageDto});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList result = Lists.newArrayList();
        Set manageUserIds = this.userRoleCommonService.getManageUserIds();
        UserQueryParams userQueryParams = new UserQueryParams();
        userQueryParams.setUserIds(manageUserIds);
        userQueryParams.setBizId(bizId);
        userQueryParams.setQuery(query);
        if (pageDto != null) {
            userQueryParams.setOffset(Integer.valueOf(pageDto.getOffset()));
            userQueryParams.setPageSize(pageDto.getPageSize());
        }
        List list = this.userMapper.queryUserByQueryParams(userQueryParams);
        if (pageDto != null) {
            int count = this.userMapper.getCountByQueryParams(userQueryParams);
            pageDto.setCount(Integer.valueOf(count));
            pageDto.setCurPageCount(Integer.valueOf(list.size()));
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (User it : list) {
                BDataValueDto dto = new BDataValueDto();
                dto.setValue(it.getNum());
                dto.setLabel(it.getName());
                result.add(dto);
            }
        }
        return result;
    }

    public List<BDataValueDto> getBDataValues(String values) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("query user list, bizId={}, userId={}, values={}", new Object[]{bizId, userId, values});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList result = Lists.newArrayList();
        String[] args = StringUtils.split((String)values, (String)",");
        HashSet nums = Sets.newHashSet();
        for (String it : args) {
            if (!StringUtils.isNotBlank((CharSequence)it)) continue;
            nums.add(it.trim());
        }
        List list = this.userMapper.getUserInfoByNums((Collection)nums);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (User it : list) {
                BDataValueDto dto = new BDataValueDto();
                dto.setValue(it.getNum());
                dto.setLabel(it.getName());
                result.add(dto);
            }
        }
        return result;
    }

    public UserLeaderResp queryUserLeader(String corpId, Long userId, String weworkUserNum) {
        log.info("\u901a\u8fc7\u7528\u6237\u67e5\u8be2\u9886\u5bfc\uff1a:corpId\uff1a{},userId:{};weworkUserId:{}", new Object[]{corpId, userId, weworkUserNum});
        if (Objects.nonNull(userId)) {
            User user = this.userMapper.selectUserByIdAndCorpId(userId, corpId);
            if (Objects.isNull(user)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u7528\u6237" + weworkUserNum + "\u672a\u627e\u5230");
            }
            UserLeaderResp resp = new UserLeaderResp();
            resp.setUserId(userId);
            resp.setUserDirectLeader(user.getDirectLeader());
            List weworkDepartmentUsers = this.weworkDepartmentUserMapper.queryDeptLeader(corpId, user.getWeworkUserId());
            List<String> leaderUserId = weworkDepartmentUsers.stream().map(WeworkDepartmentUser::getWeworkUserId).collect(Collectors.toList());
            resp.setUserDeptLeaders(leaderUserId);
            return resp;
        }
        if (StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
            WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(weworkUserNum);
            if (Objects.isNull(weworkUser)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u4f01\u5fae\u6210\u5458" + weworkUserNum + "\u672a\u627e\u5230");
            }
            User user = this.userMapper.selectUserByWeworkUserIdAndCorpId(corpId, weworkUser.getWeworkUserId());
            if (Objects.isNull(user)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5f53\u524d\u7528\u6237" + weworkUserNum + "\u672a\u627e\u5230");
            }
            UserLeaderResp resp = new UserLeaderResp();
            resp.setUserId(userId);
            resp.setUserDirectLeader(user.getDirectLeader());
            List weworkDepartmentUsers = this.weworkDepartmentUserMapper.queryDeptLeader(corpId, user.getWeworkUserId());
            List<String> leaderUserId = weworkDepartmentUsers.stream().map(WeworkDepartmentUser::getWeworkUserId).collect(Collectors.toList());
            resp.setUserDeptLeaders(leaderUserId);
            return resp;
        }
        return null;
    }
}

