/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.TagAutoType;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.system.entity.TagAutoSetting;
import com.kuaike.scrm.dal.system.mapper.TagAutoSettingMapper;
import com.kuaike.scrm.system.dto.request.TagAutoSettingReqDto;
import com.kuaike.scrm.system.dto.response.TagAutoSettingDetailRespDto;
import com.kuaike.scrm.system.service.TagAutoSettingService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TagAutoSettingServiceImpl
implements TagAutoSettingService {
    private static final Logger log = LoggerFactory.getLogger(TagAutoSettingServiceImpl.class);
    @Resource
    private TagAutoSettingMapper tagAutoSettingMapper;

    @Override
    public List<TagAutoSettingDetailRespDto> detail() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        List tagAutoSettings = this.tagAutoSettingMapper.selectByBizId(userInfo.getBizId());
        Map<Object, Object> type2SettingMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)tagAutoSettings)) {
            type2SettingMap = tagAutoSettings.stream().collect(Collectors.toMap(TagAutoSetting::getType, Functions.identity()));
        }
        TagAutoType[] tagAutoTypes = TagAutoType.values();
        ArrayList resps = Lists.newArrayList();
        for (TagAutoType autoType : tagAutoTypes) {
            TagAutoSettingDetailRespDto resp = new TagAutoSettingDetailRespDto();
            resps.add(resp);
            resp.setType(autoType.getValue());
            resp.setIsEnable(NumberUtils.INTEGER_ZERO);
            if (!type2SettingMap.containsKey(autoType.getValue())) continue;
            TagAutoSetting tagAutoSetting = (TagAutoSetting)type2SettingMap.get(autoType.getValue());
            resp.setId(tagAutoSetting.getId());
            resp.setIsEnable(tagAutoSetting.getIsEnable());
        }
        return resps;
    }

    @Override
    public void setting(List<TagAutoSettingReqDto> reqDtoList) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("setting params:{}, operatorId:{}", reqDtoList, (Object)userInfo.getId());
        reqDtoList.forEach(TagAutoSettingReqDto::validateParams);
        Date curTime = new Date();
        ArrayList autoSettings = Lists.newArrayList();
        for (TagAutoSettingReqDto reqDto : reqDtoList) {
            TagAutoSetting tagAutoSetting = new TagAutoSetting();
            autoSettings.add(tagAutoSetting);
            tagAutoSetting.setBizId(userInfo.getBizId());
            tagAutoSetting.setType(reqDto.getType());
            tagAutoSetting.setIsEnable(reqDto.getIsEnable());
            tagAutoSetting.setCreateBy(userInfo.getId());
            tagAutoSetting.setUpdateBy(userInfo.getId());
            tagAutoSetting.setCreateTime(curTime);
            tagAutoSetting.setUpdateTime(curTime);
        }
        this.tagAutoSettingMapper.saveOrUpdate((List)autoSettings);
    }
}

