/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.IdDto;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.system.entity.Organization;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.system.dto.request.BranchSchoolReqDto;
import com.kuaike.scrm.system.dto.request.OrgTypeCodeAddOrModeReqDto;
import com.kuaike.scrm.system.dto.response.OrgTypeCodeRespDto;
import com.kuaike.scrm.system.service.OrgSettingService;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgSettingServiceImpl
implements OrgSettingService {
    private static final Logger log = LoggerFactory.getLogger(OrgSettingServiceImpl.class);
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private UserRoleCommonService userRoleCommonService;

    @Override
    public void addOrModOrgTypeCode(OrgTypeCodeAddOrModeReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("addOrgTypeCode,params:{}, operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        params.validateParams();
        String corpId = currentUserInfo.getCorpId();
        Organization organization = this.organizationMapper.selectByCorpIdAndId(corpId, params.getId());
        if (Objects.isNull(organization)) {
            log.warn("\u6839\u636e\u90e8\u95e8id:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)params.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u90e8\u95e8id\u503c\u4e0d\u5408\u6cd5");
        }
        List organizations = this.organizationMapper.selectByCorpIdAndOrgCode(corpId, params.getOrgCode());
        if (CollectionUtils.isNotEmpty((Collection)organizations)) {
            if (organizations.size() > 1) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u90e8\u95e8\u4ee3\u7801\u91cd\u590d");
            }
            if (organizations.size() == 1 && !((Organization)organizations.get(0)).getId().equals(organization.getId())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u90e8\u95e8\u4ee3\u7801\u91cd\u590d");
            }
        }
        organization.setOrgType(params.getOrgType());
        organization.setOrgCode(params.getOrgCode());
        organization.setUpdateBy(currentUserInfo.getId());
        organization.setUpdateTime(new Date());
        this.organizationMapper.updateByPrimaryKey((Object)organization);
    }

    @Override
    public OrgTypeCodeRespDto getOrgTypeCode(IdDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("getOrgTypeCode,params:{}, operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        Organization organization = this.organizationMapper.selectByCorpIdAndId(currentUserInfo.getCorpId(), params.getId());
        OrgTypeCodeRespDto respDto = new OrgTypeCodeRespDto();
        if (Objects.isNull(organization)) {
            log.warn("\u6839\u636ecorpId:{}, orgId:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)currentUserInfo.getCorpId(), (Object)params.getId());
            return respDto;
        }
        respDto.setOrgType(organization.getOrgType());
        respDto.setOrgCode(organization.getOrgCode());
        return respDto;
    }

    @Override
    public List<IdAndNameDto> getBranchSchools(BranchSchoolReqDto reqDto) {
        Set manageNodeIds = this.userRoleCommonService.getManageNodeIds();
        if (CollectionUtils.isEmpty((Collection)manageNodeIds)) {
            return Collections.emptyList();
        }
        return this.organizationMapper.selectBranchSchoolByIds((Collection)manageNodeIds, reqDto.getBranchSchoolName());
    }
}

